/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.algorithms;

import TimGraph.EdgeValue;
import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;

public class Projections {
    public static timgraph ontoVertexPartition(String string, timgraph timgraph2, int[] nArray, int n, boolean bl, boolean bl2) {
        int n2;
        timgraph timgraph3 = new timgraph();
        timgraph3.infoLevel = timgraph2.infoLevel;
        timgraph3.setVertexEdgeList(true);
        timgraph3.setDirectedGraph(timgraph2.isDirected());
        if (bl) {
            timgraph3.setDirectedGraph(false);
        }
        timgraph3.setWeightedEdges(!bl2);
        timgraph3.setVertexlabels(false);
        timgraph3.inputName = new FileNameSequence(timgraph2.inputName);
        timgraph3.outputName = new FileNameSequence(timgraph2.outputName);
        timgraph3.setNameRoot(string);
        int n3 = n;
        int n4 = 0;
        n4 = timgraph3.isDirected() ? n3 * n3 * 2 : n3 * (n3 + 1);
        timgraph3.setMaximumVertices(n3);
        timgraph3.setMaximumStubs(n4);
        timgraph3.setNetwork();
        for (n2 = 0; n2 < n; ++n2) {
            timgraph3.addVertex();
        }
        n2 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        double d = 1.0;
        boolean bl3 = timgraph2.isWeighted();
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            n2 = timgraph2.getVertexFromEdge(i++);
            n5 = timgraph2.getVertexFromEdge(i);
            n6 = nArray[n2];
            n7 = nArray[n5];
            if (timgraph3.isWeighted()) {
                double d2 = d = bl3 ? timgraph2.getEdgeWeight(i) : 1.0;
                if (!timgraph2.isDirected() && n6 == n7 && n2 != n5) {
                    d += d;
                }
                timgraph3.increaseEdgeWeight(n6, n7, d);
                continue;
            }
            timgraph3.addEdgeUnique(n6, n7);
        }
        return timgraph3;
    }

    public static timgraph makeConsolidated(timgraph timgraph2, boolean bl, boolean bl2, boolean bl3) {
        int n;
        timgraph timgraph3 = new timgraph();
        timgraph3.infoLevel = timgraph2.infoLevel;
        timgraph3.setVertexEdgeList(bl3);
        timgraph3.setDirectedGraph(timgraph2.isDirected());
        if (bl) {
            timgraph3.setDirectedGraph(false);
        }
        timgraph3.setWeightedEdges(true);
        timgraph3.setVertexlabels(bl2);
        timgraph3.inputName = new FileNameSequence(timgraph2.inputName);
        timgraph3.outputName = new FileNameSequence(timgraph2.outputName);
        timgraph3.setMaximumVertices(timgraph2.getNumberVertices());
        timgraph3.setMaximumStubs(timgraph2.getNumberStubs());
        timgraph3.setNetwork();
        for (n = 0; n < timgraph3.getMaximumVertices(); ++n) {
            if (timgraph3.isVertexLabelled()) {
                if (timgraph2.isVertexLabelled()) {
                    timgraph3.addVertex(timgraph2.getVertexLabel(n));
                    continue;
                }
                timgraph3.addVertex("v" + n, n);
                continue;
            }
            timgraph3.addVertex();
        }
        n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        double d = -1.0;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            d = timgraph2.isWeighted() ? timgraph2.getEdgeWeight(i) : 1.0;
            n = timgraph2.getVertexFromEdge(i++);
            n2 = timgraph2.getVertexFromEdge(i);
            if (bl && n > n2) {
                timgraph3.increaseEdgeWeight(n2, n, d);
                continue;
            }
            timgraph3.increaseEdgeWeight(n, n2, d);
        }
        return timgraph3;
    }

    public static timgraph makeConsolidated(timgraph timgraph2, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        timgraph timgraph3 = Projections.makeConsolidated(timgraph2, bl, bl2, bl4);
        if (bl3) {
            return timgraph3;
        }
        return timgraph3.makeUnweighted(d, bl, bl2, bl4);
    }

    public static timgraph minimumEdgeWeight(timgraph timgraph2, double d, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (!timgraph2.isWeighted()) {
            System.err.println("*** Projections.minimumEdgeWeight requires input graph to be weighted but is wasn't.");
            return null;
        }
        timgraph timgraph3 = new timgraph();
        timgraph3.infoLevel = timgraph2.infoLevel;
        timgraph3.setVertexEdgeList(bl3);
        timgraph3.setDirectedGraph(timgraph2.isDirected());
        timgraph3.setWeightedEdges(bl2);
        timgraph3.setVertexlabels(bl);
        timgraph3.inputName = new FileNameSequence(timgraph2.inputName);
        timgraph3.outputName = new FileNameSequence(timgraph2.outputName);
        timgraph3.setMaximumVertices(timgraph2.getNumberVertices());
        timgraph3.setMaximumStubs(timgraph2.getNumberStubs());
        timgraph3.setNetwork();
        for (n = 0; n < timgraph3.getMaximumVertices(); ++n) {
            if (timgraph3.isVertexLabelled()) {
                if (timgraph2.isVertexLabelled()) {
                    timgraph3.addVertex(timgraph2.getVertexLabel(n));
                    continue;
                }
                timgraph3.addVertex("v" + n, n);
                continue;
            }
            timgraph3.addVertex();
        }
        n = -1;
        int n2 = -1;
        for (int i = 0; i < timgraph2.getNumberStubs(); ++i) {
            EdgeValue edgeValue = timgraph2.getEdgeWeightAll(i);
            if (edgeValue.getWeight() < d) continue;
            n = timgraph2.getVertexFromEdge(i++);
            n2 = timgraph2.getVertexFromEdge(i);
            if (bl2) {
                timgraph3.addEdge(n, n2, edgeValue);
                continue;
            }
            timgraph3.addEdge(n, n2);
        }
        return timgraph3;
    }
}

