/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.algorithms;

import TimGraph.timgraph;
import TimUtilities.FileUtilities.FileNameSequence;
import TimUtilities.TimCounting;
import TimUtilities.TimMemory;
import TimUtilities.TimTiming;

public class LineGraphProjector {
    public static final String[] lgExtensionList = new String[]{"LG", "LGsl", "DWLG", "DWLGsl", "SWLG", "SWLGsl"};
    public static final String[] lgExtensionDescription = new String[]{"Line Graph L(G)=C(G)", "Line Graph with self-loops, Ctilde", "Degree Weighted Line Graph, D(G)", "Degree Weighted Line Graph with self-loops, Dtilde(G)", "Strength Weighted Line Graph, E(G)", "Strength Weighted Line Graph with self-loops, Etilde(G)"};

    public static timgraph makeLineGraph(timgraph timgraph2, int n, boolean bl) {
        int n2;
        int n3;
        if (!timgraph2.isVertexEdgeListOn()) {
            System.err.println("!!! WARNING LineGraphProjector is creating the vertexEdgeList it needs.");
            timgraph2.createVertexGlobalEdgeList();
        }
        int n4 = 2;
        if (n < 0 || n >= lgExtensionList.length) {
            throw new RuntimeException("*** LineGraphProjector needs type to be between 0 and " + (lgExtensionList.length - 1) + ", was given " + n4);
        }
        n4 = n;
        TimTiming timTiming = new TimTiming();
        TimMemory timMemory = new TimMemory();
        System.out.println("--- makeLineGraph Initial Memory: " + timMemory.StringAllValues());
        timgraph timgraph3 = new timgraph();
        timgraph3.infoLevel = timgraph2.infoLevel;
        timgraph3.setVertexEdgeList(true);
        timgraph3.setDirectedGraph(timgraph2.isDirected() || timgraph2.isWeighted());
        timgraph3.setWeightedEdges(timgraph2.isWeighted() || n4 > 1);
        timgraph3.setVertexlabels(false);
        timgraph3.inputName = new FileNameSequence(timgraph2.inputName);
        timgraph3.outputName = new FileNameSequence(timgraph2.outputName);
        timgraph3.inputName.appendToNameRoot("_" + lgExtensionList[n4]);
        timgraph3.outputName.appendToNameRoot("_" + lgExtensionList[n4]);
        timgraph3.setInitialGraphExternalAlgorithm();
        int n5 = 1;
        boolean bl2 = false;
        int n6 = -1;
        if (n4 == 1 || n4 == 3 || n4 == 5) {
            n6 = 1;
            n5 = 0;
            bl2 = true;
        }
        boolean bl3 = true;
        if (n4 > 1) {
            bl3 = false;
        }
        boolean bl4 = false;
        if (n4 > 3 && timgraph2.isWeighted()) {
            bl4 = true;
        }
        timgraph3.setMaximumVertices(timgraph2.getNumberStubs() / 2);
        int n7 = 0;
        if (timgraph2.isDirected()) {
            for (n3 = 0; n3 < timgraph2.getNumberVertices(); ++n3) {
                n7 += timgraph2.getVertexInDegree(n3) * timgraph2.getVertexOutDegree(n3);
            }
            n7 *= 2;
        } else {
            for (n3 = 0; n3 < timgraph2.getNumberVertices(); ++n3) {
                n2 = timgraph2.getVertexDegree(n3);
                n7 += n2 * (n2 + n6);
            }
            if (timgraph3.isDirected()) {
                n7 += n7;
            }
        }
        timgraph3.setMaximumStubs(n7);
        if (bl) {
            System.out.println("Predicting " + timgraph3.getMaximumVertices() + " vertices and " + timgraph3.getMaximumStubs() + " stubs in line graph ");
            System.out.println("Line graph will be " + timgraph3.graphTypeString(" "));
        }
        System.out.println("--- makeLineGraph\n    Time: " + timTiming.elapsedTimeString() + ". Memory: " + timMemory.StringAllValues());
        timgraph3.setNetwork();
        for (n3 = 0; n3 < timgraph3.getMaximumVertices(); ++n3) {
            timgraph3.addVertex();
        }
        System.out.println("--- makeLineGraph, vertices added.\n    Time: " + timTiming.elapsedTimeString() + ". Memory: " + timMemory.StringAllValues());
        TimCounting timCounting = new TimCounting(timgraph2.getNumberVertices(), true);
        n2 = -1;
        int n8 = -1;
        double d = timgraph2.getNumberVertices();
        if (timgraph2.isDirected()) {
            int n9 = -1;
            int n10 = -1;
            double d2 = 1.0;
            double d3 = -1.0;
            for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
                if (bl && timCounting.increment()) {
                    System.out.println(" : " + timTiming.elapsedTimeString() + ": " + timTiming.estimateRemainingTimeString((double)i / d));
                    System.out.println("           : " + timMemory.StringAllValues());
                }
                if ((n9 = timgraph2.getVertexDegree(i)) < 1 || (n10 = timgraph2.getVertexDegree(i)) < 1) continue;
                if (timgraph3.isWeighted()) {
                    double d4 = bl3 ? 1.0 : (d3 = bl4 ? timgraph2.getVertexOutStrength(i) : (double)n10);
                    if (d3 < 1.0E-20) continue;
                }
                for (int j = 0; j < timgraph2.getVertexInDegree(i); ++j) {
                    n2 = timgraph2.getInEdge(i, j);
                    for (int k = 0; k < timgraph2.getVertexOutDegree(i); ++k) {
                        n8 = timgraph2.getEdge(i, k);
                        if (timgraph3.isWeighted()) {
                            timgraph3.increaseEdgeWeight(n2 / 2, n8 / 2, timgraph2.getEdgeWeight(n8) / d3);
                            continue;
                        }
                        timgraph3.addEdgeUnique(n2 / 2, n8 / 2);
                    }
                }
            }
            if (bl && timCounting.increment()) {
                System.out.println("\nFinished makeLineGraph.\n    Time: " + timTiming.elapsedTimeString() + ". Memory: " + timMemory.StringAllValues());
            }
            return timgraph3;
        }
        if (!timgraph2.isDirected() && !timgraph3.isDirected()) {
            if (timgraph2.isWeighted()) {
                throw new RuntimeException(" Input graph must be unweighted in this case");
            }
            int n11 = -1;
            double d5 = 1.0;
            double d6 = 1.0;
            double d7 = -1.0;
            boolean bl5 = timgraph3.isWeighted();
            for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
                if (bl && timCounting.increment()) {
                    System.out.println(" : " + timTiming.elapsedTimeString() + ": " + timTiming.estimateRemainingTimeString((double)i / d));
                    System.out.println("           : " + timMemory.StringAllValues());
                }
                if ((n11 = timgraph2.getVertexDegree(i)) <= n5) continue;
                d6 = 1.0;
                if (!bl3) {
                    double d8 = d7 = bl4 ? timgraph2.getVertexOutStrength(i) : (double)n11;
                    if (d7 < 1.0E-20) continue;
                    d6 = d7;
                }
                for (int j = 0; j < timgraph2.getVertexDegree(i); ++j) {
                    n2 = timgraph2.getEdge(i, j);
                    if (!bl3 && !bl2) {
                        d6 = d7 - (bl4 ? timgraph2.getEdgeWeight(n2) : 1.0);
                    }
                    if (d6 < 1.0E-20) continue;
                    for (int k = j + n5; k < timgraph2.getVertexDegree(i); ++k) {
                        n8 = timgraph2.getEdge(i, k);
                        if (bl5) {
                            timgraph3.increaseEdgeWeight(n2 / 2, n8 / 2, timgraph2.getEdgeWeight(n8) / d6);
                            continue;
                        }
                        timgraph3.addEdgeUnique(n2 / 2, n8 / 2);
                    }
                }
            }
            if (bl && timCounting.increment()) {
                System.out.println("\nFinished makeLineGraph.\n    Time: " + timTiming.elapsedTimeString() + ". Memory: " + timMemory.StringAllValues());
            }
            return timgraph3;
        }
        if (timgraph3.isDirected() && !timgraph2.isDirected()) {
            if (!timgraph3.isWeighted()) {
                throw new RuntimeException(" LG must be weighted in this case");
            }
            if (!timgraph2.isWeighted()) {
                throw new RuntimeException(" Input graph must be weighted in this case");
            }
            int n12 = -1;
            double d9 = -1.0;
            double d10 = -1.0;
            for (int i = 0; i < timgraph2.getNumberVertices(); ++i) {
                if (bl && timCounting.increment()) {
                    System.out.println(" : " + timTiming.elapsedTimeString() + ": " + timTiming.estimateRemainingTimeString((double)i / d));
                    System.out.println("           : " + timMemory.StringAllValues());
                }
                if ((n12 = timgraph2.getVertexDegree(i)) <= n5) continue;
                double d11 = bl3 ? 1.0 : (d9 = bl4 ? timgraph2.getVertexOutStrength(i) : (double)timgraph2.getVertexOutDegree(i));
                if (d9 < 1.0E-20) continue;
                d10 = d9;
                for (int j = 0; j < timgraph2.getVertexDegree(i); ++j) {
                    n2 = timgraph2.getEdge(i, j);
                    if (!bl3 && !bl2) {
                        d10 = d9 - (bl4 ? timgraph2.getEdgeWeight(n2) : 1.0);
                    }
                    if (d10 < 1.0E-20) continue;
                    for (int k = 0; k < timgraph2.getVertexDegree(i); ++k) {
                        if (j == k && !bl2) continue;
                        n8 = timgraph2.getEdge(i, k);
                        timgraph3.increaseEdgeWeight(n2 / 2, n8 / 2, timgraph2.getEdgeWeight(n8) / d10);
                    }
                }
            }
            if (bl && timCounting.increment()) {
                System.out.println("\nFinished makeLineGraph.\n    Time: " + timTiming.elapsedTimeString() + ". Memory: " + timMemory.StringAllValues());
            }
            return timgraph3;
        }
        return null;
    }
}

