/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.Coordinate;
import TimGraph.Rank;

public class VertexLabel {
    static final String DEFAULTNAME = "";
    static final String SUNSET = "UNSET";
    static final int IUNSET = -918273645;
    static final double DUNSET = -9.182736E45;
    private String name = "";
    private Integer number;
    private Double strength;
    Coordinate position;
    Rank rank;

    public VertexLabel() {
    }

    public VertexLabel(Integer n) {
        this.setName(n.toString());
        this.setNumber(n);
    }

    public VertexLabel(String string, Integer n) {
        this.setName(string);
        this.setNumber(n);
    }

    public VertexLabel(double d, Coordinate coordinate) {
        this.setStrength(d);
        this.position = coordinate;
    }

    public VertexLabel(String string, Coordinate coordinate) {
        this.setName(string);
        this.position = coordinate;
    }

    public VertexLabel(Integer n, String string, Coordinate coordinate) {
        this.setName(string);
        this.position = coordinate;
    }

    public VertexLabel(String string, double d, Coordinate coordinate) {
        this.setName(string);
        this.setStrength(d);
        this.position = coordinate;
    }

    public VertexLabel(VertexLabel vertexLabel) {
        if (vertexLabel.hasNumber()) {
            this.setNumber(vertexLabel.getNumber());
        }
        if (vertexLabel.hasName()) {
            this.setName(vertexLabel.getName());
        }
        if (vertexLabel.hasStrength()) {
            this.setStrength(vertexLabel.getStrength());
        }
        if (vertexLabel.hasPosition()) {
            this.position = new Coordinate(vertexLabel.position);
        }
        if (vertexLabel.hasRank()) {
            this.rank = new Rank(vertexLabel.rank);
        }
    }

    public void setValues(String string, int n, double d, Coordinate coordinate, Rank rank) {
        this.setName(this.name);
        this.setNumber(this.number);
        this.setStrength(d);
        this.position = new Coordinate(coordinate);
        this.rank = new Rank(rank);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void removeName() {
        this.name = DEFAULTNAME;
    }

    public String getName() {
        if (this.name.equals(SUNSET)) {
            return DEFAULTNAME;
        }
        return this.name;
    }

    public boolean hasName() {
        return this.name.length() >= 1 && !this.name.equals(SUNSET);
    }

    public boolean hasNumber() {
        return this.number != null;
    }

    public void setNumber(int n) {
        this.number = this.number == null ? new Integer(n) : Integer.valueOf(n);
    }

    public void setPosition(Coordinate coordinate) {
        if (this.position == null) {
            this.position = new Coordinate();
        }
        this.position = new Coordinate(coordinate);
    }

    public void setPosition(double d, double d2) {
        this.setPosition(new Coordinate(d, d2));
    }

    public void setRank(Rank rank) {
        if (this.rank == null) {
            this.rank = new Rank();
        }
        this.rank = new Rank(rank);
    }

    public int getNumber() {
        if (this.number == null) {
            return -918273645;
        }
        return this.number;
    }

    public boolean hasStrength() {
        return this.strength != null;
    }

    public void setStrength(double d) {
        this.strength = this.strength == null ? new Double(d) : Double.valueOf(d);
    }

    public double getStrength() {
        if (this.strength == null) {
            return -9.182736E45;
        }
        return this.strength;
    }

    public Coordinate getPosition() {
        return this.position;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void addStrength(double d) {
        this.strength = this.strength == null ? new Double(d) : Double.valueOf(this.strength + d);
    }

    public boolean hasRank() {
        return this.rank != null;
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public void setMinimum(VertexLabel vertexLabel) {
        if (vertexLabel == null) {
            vertexLabel = new VertexLabel(this);
            return;
        }
        if (this.hasName() && this.getName().compareToIgnoreCase(vertexLabel.getName()) < 0) {
            vertexLabel.setName(this.getName());
        }
        if (this.hasNumber() && this.getNumber() < vertexLabel.getNumber()) {
            vertexLabel.setNumber(this.getNumber());
        }
        if (this.hasStrength() && this.getStrength() < vertexLabel.getStrength()) {
            vertexLabel.setStrength(this.getStrength());
        }
        if (this.hasPosition()) {
            if (vertexLabel.hasPosition()) {
                vertexLabel.getPosition().setToMinimum(this.getPosition());
            } else {
                vertexLabel.setPosition(this.getPosition());
            }
        }
        if (this.hasRank()) {
            if (vertexLabel.hasRank()) {
                vertexLabel.getRank().setMinimum(this.getRank());
            } else {
                vertexLabel.setRank(this.getRank());
            }
        }
    }

    public void setMaximum(VertexLabel vertexLabel) {
        if (vertexLabel == null) {
            vertexLabel = new VertexLabel(this);
            return;
        }
        if (this.hasName() && this.getName().compareToIgnoreCase(vertexLabel.getName()) > 0) {
            vertexLabel.setName(this.getName());
        }
        if (this.hasNumber() && this.getNumber() > vertexLabel.getNumber()) {
            vertexLabel.setNumber(this.getNumber());
        }
        if (this.hasStrength() && this.getStrength() > vertexLabel.getStrength()) {
            vertexLabel.setStrength(this.getStrength());
        }
        if (this.hasPosition()) {
            if (vertexLabel.hasPosition()) {
                vertexLabel.getPosition().setToMaximum(this.getPosition());
            } else {
                vertexLabel.setPosition(this.getPosition());
            }
        }
        if (this.hasRank()) {
            if (vertexLabel.hasRank()) {
                vertexLabel.getRank().setMaximum(this.getRank());
            } else {
                vertexLabel.setRank(this.getRank());
            }
        }
    }

    public String pajekString() {
        String string = (this.hasName() ? this.quotedNameString() : DEFAULTNAME) + "  " + (this.hasPosition() ? this.position.toString2D(" ") + " 0" : DEFAULTNAME);
        return string;
    }

    public String pajekString(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        String string = DEFAULTNAME;
        string = d5 == 0.0 || d6 == 0.0 ? this.pajekString() : " " + (this.hasName() ? this.quotedNameString() : DEFAULTNAME) + "  " + (this.hasPosition() ? (this.position.x - d) / d5 + " " + (this.position.y - d2) / d6 + " 0" : DEFAULTNAME);
        return string;
    }

    public String quotedNameString() {
        return "\"" + this.name + "\"";
    }

    public String pajekString(Coordinate coordinate, Coordinate coordinate2) {
        return this.pajekString(coordinate.x, coordinate.y, coordinate2.x, coordinate2.y);
    }

    public String printString(String string) {
        String string2 = DEFAULTNAME;
        if (this.hasName()) {
            string2 = string2 + this.name + string;
        }
        if (this.hasNumber()) {
            string2 = string2 + this.valueString(this.number) + string;
        }
        if (this.hasPosition()) {
            string2 = string2 + this.position.toString(string) + string;
        }
        if (this.hasStrength()) {
            string2 = string2 + this.valueString(this.strength) + string;
        }
        if (this.hasRank()) {
            string2 = string2 + this.rank.printString(5, string) + string;
        }
        if (string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public String printString(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string2 = DEFAULTNAME;
        if (bl) {
            string2 = string2 + this.name + string;
        }
        if (bl2) {
            string2 = string2 + this.valueString(this.number) + string;
        }
        if (bl3) {
            string2 = string2 + Coordinate.toString(this.position, string) + string;
        }
        if (bl4) {
            string2 = string2 + this.valueString(this.strength) + string;
        }
        if (bl5) {
            string2 = string2 + Rank.toString(this.rank, 5, string) + string;
        }
        if (string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public String labelString(String string) {
        return VertexLabel.labelString(string, this.hasName(), this.hasNumber(), this.hasPosition(), this.hasStrength(), this.hasRank());
    }

    public static String labelString(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string2 = DEFAULTNAME;
        if (bl) {
            string2 = string2 + "name" + string;
        }
        if (bl2) {
            string2 = string2 + "number" + string;
        }
        if (bl3) {
            string2 = string2 + Coordinate.labelString(string) + string;
        }
        if (bl4) {
            string2 = string2 + "strength" + string;
        }
        if (bl5) {
            string2 = string2 + Rank.labelString(string) + string;
        }
        if (string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    private String valueString(int n) {
        String string = n == -918273645 ? "Unset" : Integer.toString(n);
        return string;
    }

    private String valueString(double d) {
        String string = d == -9.182736E45 ? "Unset" : Double.toString(d);
        return string;
    }

    private String valueString(Integer n) {
        String string = n == null ? "Unset" : n.toString();
        return string;
    }

    private String valueString(Double d) {
        String string = d == null ? "Unset" : d.toString();
        return string;
    }
}

