/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.timgraph;
import java.io.PrintStream;
import java.util.Random;

public class RandomWalk {
    String SEP = "\t";
    private timgraph graph;
    private int numberVertices;
    private int numberEdges;
    public int randomWalkMode = 1;
    private boolean StartWalkWithVertex;
    private boolean always_new_walk_start;
    private boolean markov_walk;
    private boolean StartWalkWithFixedVertex;
    private boolean binomialDistribution;
    private double averageWalkLength;
    private double walkprob;
    private double maximumWalkLength;
    private int intAverageWalkLength;
    private int startVertex;
    private int stepOnWalk;
    int walkvertex;
    int degree;
    private boolean rankingOn;
    private double diffuseValue;
    private double rankingProbability;
    int numberWalks;
    int totalStepLength;
    int longestWalk;
    private Random Rnd;
    public int infoLevel = -2;

    public RandomWalk(timgraph timgraph2) {
        this.initialise(timgraph2, timgraph2.randomWalkMode, timgraph2.averageWalkLength, timgraph2.maxWalkLength);
    }

    public RandomWalk(timgraph timgraph2, int n, double d, double d2) {
        this.initialise(timgraph2, n, d, d2);
    }

    public void initialise(timgraph timgraph2, int n, double d, double d2) {
        this.graph = timgraph2;
        this.numberVertices = this.graph.getNumberVertices();
        this.numberEdges = this.graph.getNumberStubs();
        this.Rnd = timgraph2.Rnd;
        this.infoLevel = this.graph.infoLevel;
        this.setStartVertex(-1);
        this.StartWalkWithVertex = (n & 1) > 0;
        this.always_new_walk_start = (n & 2) > 0;
        this.markov_walk = (n & 4) > 0;
        this.binomialDistribution = (n & 0x10) > 0;
        this.averageWalkLength = d;
        this.walkprob = this.averageWalkLength / (1.0 + this.averageWalkLength);
        d2 = (int)(this.averageWalkLength + 0.5) * 4;
        this.intAverageWalkLength = (int)(this.averageWalkLength + 0.5);
        this.maximumWalkLength = d2;
        this.startVertex = -1;
        this.walkvertex = -1;
        this.degree = -1;
        this.longestWalk = -1;
        this.totalStepLength = 0;
        this.numberWalks = 0;
        this.rankingOn = false;
        this.diffuseValue = -1.0;
        if (this.infoLevel > 2) {
            System.out.println("StartWalkWithVertex, always_new_walk_start, markov_walk, random_connectivity " + this.StartWalkWithVertex + this.SEP + this.markov_walk);
        }
    }

    public void setRankingOn(double d) {
        this.rankingOn = true;
        this.rankingProbability = d / (1.0 + d);
    }

    public int setStartVertex(int n) {
        this.startVertex = n;
        if (this.startVertex >= this.graph.getNumberVertices()) {
            System.out.println("*** Error startVertex " + this.startVertex + ">=" + this.graph.getNumberVertices() + " TotalNumberVertices");
            return -1;
        }
        this.StartWalkWithFixedVertex = this.startVertex >= 0;
        return this.startVertex;
    }

    public int doOneWalk(int n) {
        this.stepOnWalk = -1;
        int n2 = -1;
        if (this.markov_walk) {
            this.stepOnWalk = this.binomialDistribution ? this.getRandomBinomial(this.averageWalkLength, n) : this.getRandomMarkov(this.walkprob, n);
            if (this.maximumWalkLength < (double)this.stepOnWalk) {
                this.stepOnWalk = (int)this.maximumWalkLength;
            }
        } else {
            this.stepOnWalk = this.intAverageWalkLength;
        }
        if (this.longestWalk < this.stepOnWalk) {
            this.longestWalk = this.stepOnWalk;
        }
        this.diffuseValue = 1.0;
        if (this.always_new_walk_start || this.walkvertex < 0) {
            if (this.StartWalkWithVertex) {
                this.walkvertex = this.StartWalkWithFixedVertex ? (this.walkvertex = this.startVertex) : this.Rnd.nextInt(this.numberVertices);
            } else {
                n2 = this.graph.directedGraph ? this.graph.makeEven(this.Rnd.nextInt(this.numberEdges)) : this.Rnd.nextInt(this.numberEdges);
                this.walkvertex = this.graph.getVertexFromEdge(n2);
            }
            this.degree = this.graph.vertexList[this.walkvertex].size();
        }
        if (this.rankingOn && this.graph.vertexlabels) {
            this.updateRanking();
        }
        while (this.stepOnWalk > 0 && this.degree > 0) {
            --this.stepOnWalk;
            ++this.totalStepLength;
            this.walkvertex = this.graph.vertexList[this.walkvertex].getQuick(this.Rnd.nextInt(this.degree));
            this.degree = this.graph.vertexList[this.walkvertex].size();
            if (!this.rankingOn || !this.graph.vertexlabels) continue;
            this.updateRanking();
        }
        ++this.numberWalks;
        return this.walkvertex;
    }

    public void updateRanking() {
        this.graph.vertexLabelList[this.walkvertex].rank.updateRanking(this.stepOnWalk, this.diffuseValue);
        this.diffuseValue *= this.rankingProbability;
    }

    public void printrandomWalkMode() {
        this.printRandomWalkMode(System.out, "");
    }

    public int getRandomBinomial(double d, int n) {
        if (n < 1) {
            return (int)(d + 1.0E-6);
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += this.Rnd.nextDouble();
        }
        return (int)(d2 * d / (double)n);
    }

    public int getRandomMarkov(double d, int n) {
        if (n < 0) {
            return -n;
        }
        int n2 = 0;
        for (n2 = 0; n2 < n && !(this.Rnd.nextDouble() > d); ++n2) {
        }
        return n2;
    }

    public void printRandomWalkMode() {
        this.printRandomWalkMode(System.out, "");
    }

    public void printRandomWalkMode(PrintStream printStream, String string) {
        this.printRandomWalkMode(printStream, string, this.randomWalkMode);
    }

    public void printRandomWalkMode(PrintStream printStream, String string, int n) {
        if ((n & 1) > 0) {
            printStream.println(string + "   Start every walk from random vertex");
        } else {
            printStream.println(string + "   Start every walk from random end of random edge");
        }
        if ((n & 2) > 0) {
            printStream.println(string + "   Jump to new vertex when walk length reached (every new edge)");
        } else {
            printStream.println(string + "   Do not jump to new vertex when walk length reached (unless new event in walk graph creation or no exits in random walk");
        }
        if ((n & 4) > 0) {
            printStream.println(string + "   Walk length variable, average fixed");
        } else {
            printStream.println(string + "   Walk length fixed");
        }
        if ((n & 8) > 0) {
            printStream.println(string + "   No. of edges added to each new vertex variable, average fixed");
        } else {
            printStream.println(string + "   No. of edges added to each new vertex fixed");
        }
        if ((n & 0x10) > 0) {
            printStream.println(string + "   Binomial distributed walk lengths");
        } else {
            printStream.println(string + "   Markovian walk lengths");
        }
    }

    public void printAllModes(PrintStream printStream, String string) {
        for (int i = 1; i < 32; i <<= 1) {
            this.printRandomWalkMode(printStream, string + "(rwm & " + i + "): ", i);
        }
    }
}

