/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import java.io.PrintStream;

public class OutputMode {
    static final int maxNumber = 511;
    private int number;
    String modeString;
    public boolean degreeDistributionOn;
    public boolean distancesOn;
    public boolean clusteringOn;
    public boolean pajekFileOn;
    public boolean componentsOn;
    public boolean rankingOn;
    public boolean unusedOn;
    public boolean graphMLFileOn;
    public boolean adjacencyFileOn;

    public OutputMode(double d) {
        this.set(d);
    }

    public OutputMode(OutputMode outputMode) {
        this.set(outputMode.number);
    }

    public int getNumber() {
        return this.number;
    }

    public void set(double d) {
        this.number = (int)(d + 0.5);
        this.setModeString();
        this.degreeDistributionOn = (this.number & 1) > 0;
        this.distancesOn = (this.number & 2) > 0;
        this.clusteringOn = (this.number & 4) > 0;
        this.pajekFileOn = (this.number & 8) > 0;
        this.componentsOn = (this.number & 0x10) > 0;
        this.rankingOn = (this.number & 0x20) > 0;
        this.unusedOn = (this.number & 0x40) > 0;
        this.graphMLFileOn = (this.number & 0x80) > 0;
        this.adjacencyFileOn = (this.number & 0x100) > 0;
    }

    public void set(String string) {
        this.set(Double.parseDouble(string));
    }

    public void printMode(PrintStream printStream, String string) {
        printStream.println("Output control method is " + this.modeString);
        if (this.degreeDistributionOn) {
            printStream.println("   Degree distribution calculation ON");
        } else {
            printStream.println("   Degree distribution calculation OFF");
        }
        if (this.distancesOn) {
            printStream.println("   Distance calculation ON");
        } else {
            printStream.println("   Distance calculation OFF");
        }
        if (this.clusteringOn) {
            printStream.println("   Clustering calculation ON");
        } else {
            printStream.println("   Clustering calculation OFF");
        }
        if (this.pajekFileOn) {
            printStream.println("   PAJEK file output  ON");
        } else {
            printStream.println("   PAJEK file output  OFF");
        }
        if (this.componentsOn) {
            printStream.println("  Component calculations ON");
        } else {
            printStream.println("   Component calculations OFF");
        }
        printStream.println("   Ranking calculations " + (this.rankingOn ? "ON" : "OFF"));
        printStream.println("   Adjacency matrix output " + (this.adjacencyFileOn ? "ON" : "OFF"));
        printStream.println("   GraphML output " + (this.graphMLFileOn ? "ON" : "OFF"));
    }

    public void printUsage(PrintStream printStream, String string) {
        printStream.println(string + "(OutputMode &  1)  Degree distribution calculation ON/OFF");
        printStream.println(string + "(OutputMode &  2)  Distance calculation ON/OFF");
        printStream.println(string + "(OutputMode &  4)  Clustering calculation ON/OFF");
        printStream.println(string + "(OutputMode &  8)  PAJEK file output  ON/OFF");
        printStream.println(string + "(OutputMode & 16)  Component calculations ON/OFF");
        printStream.println(string + "(OutputMode & 32)  Ranking calculations ON/OFF");
        printStream.println(string + "(OutputMode & 64)  not used");
        printStream.println(string + "(OutputMode & 128) GraphML output ON/OFF");
        printStream.println(string + "(OutputMode & 256) Adjacency matrix output ON/OFF");
    }

    public String getModeString(String string) {
        String string2 = "unknown";
        if (this.degreeDistributionOn) {
            string2 = string2 + "DD" + string;
        }
        if (this.distancesOn) {
            string2 = string2 + "dist" + string;
        }
        if (this.clusteringOn) {
            string2 = string2 + "clust" + string;
        }
        if (this.pajekFileOn) {
            string2 = string2 + "pajek" + string;
        }
        if (this.componentsOn) {
            string2 = string2 + "comp" + string;
        }
        if (this.rankingOn) {
            string2 = string2 + "rank" + string;
        }
        if (this.graphMLFileOn) {
            string2 = string2 + "graphML" + string;
        }
        if (this.adjacencyFileOn) {
            string2 = string2 + "adj" + string;
        }
        return string2;
    }

    public String getModeString() {
        if (this.modeString == null) {
            this.setModeString();
        }
        return this.modeString;
    }

    private void setModeString() {
        this.modeString = this.getModeString(" ");
    }
}

