/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import JavaNotes.TextReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class NetworkReader {
    int[][] intMatrix;
    int maximumDimension;
    String filename;

    public NetworkReader() {
        this.maximumDimension = 1010;
        this.filename = "/PRG/networks/timgraph/input/ERn100k4.0r0tgadjmat.dat";
    }

    public NetworkReader(String string, int n) {
        this.maximumDimension = n;
        this.filename = string;
    }

    public static void main(String[] stringArray) {
        NetworkReader networkReader = new NetworkReader();
        int n = networkReader.readSquareIntegerMatrix();
        if (n < 0) {
            System.out.println("*** ERROR readSquareIntegerMatrix returned " + n);
            return;
        }
        networkReader.printOutStatistics();
    }

    public void printOutStatistics() {
        int n = 0;
        double d = 0.0;
        int n2 = this.intMatrix.length;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                n3 = this.intMatrix[i][j];
                if (n3 == 0) continue;
                n += n3;
                d += (double)(n3 * n3);
            }
        }
        System.out.println(" Network in file " + this.filename + " has " + n2 + " vertices, " + n + " edges");
        double d2 = (double)n / (double)n2;
        System.out.println("     average degree " + d2 + ", second moment " + (d /= (double)n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSquareIntegerMatrix() {
        TextReader textReader;
        System.out.println("Starting to read double matrix data from " + this.filename);
        int[] nArray = new int[this.maximumDimension];
        int n = 1;
        try {
            textReader = new TextReader(new FileReader(this.filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + this.filename);
            return -1;
        }
        try {
            int n2;
            int n3 = 0;
            while (!textReader.eoln()) {
                if (n3 == this.maximumDimension) {
                    System.out.println("*** ERROR more than " + this.maximumDimension + " numbers of first line of file " + this.filename);
                    int n4 = -2;
                    return n4;
                }
                nArray[n3++] = textReader.getInt();
            }
            this.intMatrix = new int[n3][n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.intMatrix[0][n2] = nArray[n2];
            }
            while (!textReader.eof()) {
                if (n == n3) {
                    System.out.println("*** ERROR more than " + n3 + " lines of data in file " + this.filename);
                    n2 = -3;
                    return n2;
                }
                n2 = 0;
                while (!textReader.eoln()) {
                    if (n2 == n3) {
                        System.out.println("*** ERROR more than " + n3 + " numbers on line " + (n + 1) + " of file " + this.filename);
                        int n5 = -4;
                        return n5;
                    }
                    this.intMatrix[n][n2++] = textReader.getInt();
                }
                ++n;
            }
            System.out.println("Finished reading from " + this.filename);
        }
        catch (TextReader.Error error) {
            System.out.println("*** Input Error: " + error.getMessage());
            int n6 = -5;
            return n6;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("*** Too many numbers in data file" + this.filename);
            System.out.println("    Processing has been aborted.");
            int n7 = -6;
            return n7;
        }
        finally {
            textReader.close();
        }
        return 0;
    }
}

