/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import DistributionAnalysis.DistributionAnalysis;
import TimGraph.timgraph;
import java.io.File;
import java.io.PrintStream;

public class NetworkGenerator {
    final String NGVERSION = "NG070202";
    String SEP = "\t";
    int repeat = 2;
    int type = 0;
    int numberVertices = 100;
    double averageDegree = 2.0;
    timgraph tg;
    String fileName = "NetGenDefault";
    String directoryName = "";
    int outputcontrol = 1;
    int infoLevel = -2;
    DistributionAnalysis ddAnalysis;

    public NetworkGenerator() {
    }

    public NetworkGenerator(int n, int n2, double d, int n3, String string, String string2) {
        this.type = n;
        this.numberVertices = n2;
        this.averageDegree = d;
        this.outputcontrol = n3;
        this.fileName = string;
        this.directoryName = string2;
    }

    public static void main(String[] stringArray) {
        NetworkGenerator networkGenerator = new NetworkGenerator();
        networkGenerator.parseParam(stringArray);
        networkGenerator.printParameters();
        String string = networkGenerator.fileName;
        networkGenerator.ddAnalysis = new DistributionAnalysis(string, networkGenerator.directoryName, 1.1);
        networkGenerator.ddAnalysis.infolevel = 2;
        for (int i = 0; i < networkGenerator.repeat; ++i) {
            if (networkGenerator.infoLevel > -2) {
                System.out.println("\n *** NetworkGenerator run " + i);
            }
            networkGenerator.fileName = string + "r" + i;
            networkGenerator.makeNetwork();
        }
        networkGenerator.outputAverageDegreeDistribution();
    }

    public void makeNetwork() {
        if (this.infoLevel > -2) {
            System.out.println("*** Making " + this.typeString());
        }
        switch (this.type) {
            case 5: {
                this.make3DTorus();
                break;
            }
            case 4: {
                this.make2DTorus();
                break;
            }
            case 3: {
                this.makeCircle();
                break;
            }
            case 2: {
                this.makeBA();
                break;
            }
            case 1: {
                this.makeRandomExponential();
                break;
            }
            case 0: {
                this.makeER();
                break;
            }
            default: {
                System.out.println(" *** Error - no network of type " + this.type);
            }
        }
        if (this.numberVertices < 30 && this.infoLevel > 0) {
            System.out.println("--- Network ---");
            this.printNetwork();
        }
    }

    public String typeString() {
        String string = "UNKNOWN";
        switch (this.type) {
            case 5: {
                string = "3D Torus ";
                break;
            }
            case 4: {
                string = "2D Torus ";
                break;
            }
            case 3: {
                string = "Circle ";
                break;
            }
            case 2: {
                string = "Scale Free";
                break;
            }
            case 1: {
                string = "Random Exponential ";
                break;
            }
            case 0: {
                string = "Random Erdos-Reyni";
                break;
            }
        }
        return string;
    }

    public void makeER() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-e" + this.numberVertices;
        stringArray[n++] = "-m" + this.averageDegree / 2.0;
        stringArray[n++] = "-ve1";
        stringArray[n++] = "-gn1";
        stringArray[n++] = "-lw0";
        stringArray[n++] = "-vw3";
        stringArray[n++] = "-p1.0";
        this.makeNetwork(stringArray);
    }

    public void makeRandomExponential() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-e" + this.numberVertices;
        stringArray[n++] = "-m" + this.averageDegree / 2.0;
        stringArray[n++] = "-gn2";
        stringArray[n++] = "-ve0";
        stringArray[n++] = "-lw0";
        stringArray[n++] = "-vw2";
        stringArray[n++] = "-p1.0";
        this.makeNetwork(stringArray);
    }

    public void makeBA() {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "-e" + this.numberVertices;
        stringArray[n++] = "-m" + this.averageDegree / 2.0;
        stringArray[n++] = "-gn2";
        stringArray[n++] = "-ve0";
        stringArray[n++] = "-lw0";
        stringArray[n++] = "-vw3";
        stringArray[n++] = "-p1.0";
        this.makeNetwork(stringArray);
    }

    public void makeCircle() {
        String[] stringArray = new String[6];
        int n = (int)(0.5 + this.averageDegree / 2.0);
        int n2 = 0;
        stringArray[n2++] = "-e" + this.numberVertices;
        stringArray[n2++] = "-m" + n;
        stringArray[n2++] = "-gn-2";
        stringArray[n2++] = "-gv" + this.numberVertices;
        stringArray[n2++] = "-gm" + n;
        stringArray[n2++] = "-p1.0";
        this.makeNetwork(stringArray);
    }

    public void make2DTorus() {
        String[] stringArray = new String[7];
        int n = (int)(0.5 + this.averageDegree / 2.0);
        int n2 = 0;
        stringArray[n2++] = "-e" + this.numberVertices;
        stringArray[n2++] = "-m" + n;
        stringArray[n2++] = "-gn-4";
        stringArray[n2++] = "-gv" + this.numberVertices;
        stringArray[n2++] = "-gx-1";
        stringArray[n2++] = "-gm" + n;
        stringArray[n2++] = "-p1.0";
        this.makeNetwork(stringArray);
    }

    public void make3DTorus() {
        String[] stringArray = new String[7];
        int n = (int)(0.5 + this.averageDegree / 2.0);
        int n2 = 0;
        stringArray[n2++] = "-e" + this.numberVertices;
        stringArray[n2++] = "-m" + n;
        stringArray[n2++] = "-gn-6";
        stringArray[n2++] = "-gv" + this.numberVertices;
        stringArray[n2++] = "-gx-1";
        stringArray[n2++] = "-gm" + n;
        stringArray[n2++] = "-p1.0";
        this.makeNetwork(stringArray);
    }

    private void makeNetwork(String[] stringArray) {
        this.tg = new timgraph(this.fileName + "tg", this.directoryName, this.infoLevel, this.outputcontrol);
        this.tg.setNumberEvents(this.numberVertices);
        this.tg.parseParam(stringArray);
        if (this.tg.getInitialVertices() > this.numberVertices) {
            this.tg.setInitialVertices(this.numberVertices);
        }
        this.tg.doOneRun(1);
        this.ddAnalysis.addOneDD(this.tg.DDtotal.ddarr, this.fileName + "tg", "#", "dd.dat", "lbdd.dat", true);
    }

    private void outputAverageDegreeDistribution() {
        this.ddAnalysis.FileOutputTotDD(this.fileName + "tot.DD.dat", "");
    }

    public void printNetwork() {
        this.tg.printNetwork(true);
    }

    public int parseParam(String[] stringArray) {
        int n;
        if (this.infoLevel > -1) {
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("NG Argument " + n + " = " + stringArray[n]);
            }
        }
        block11: for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() < 3) {
                System.out.println("\n*** NF Argument " + n + " is too short");
                this.printUsage();
                return 3;
            }
            if (stringArray[n].charAt(0) != '-') {
                System.out.println("\n*** NG Argument " + n + " does not start with -, use -? for usage");
                return 4;
            }
            switch (stringArray[n].charAt(1)) {
                case 'f': {
                    if (stringArray[n].charAt(2) == 'n') {
                        this.fileName = stringArray[n].substring(3);
                    }
                    if (stringArray[n].charAt(2) != 'd') continue block11;
                    this.directoryName = stringArray[n].substring(3);
                    continue block11;
                }
                case 'k': {
                    this.averageDegree = Double.parseDouble(stringArray[n].substring(2));
                    continue block11;
                }
                case 'n': {
                    this.numberVertices = Integer.parseInt(stringArray[n].substring(2));
                    continue block11;
                }
                case 'o': {
                    this.outputcontrol = Integer.parseInt(stringArray[n].substring(2));
                    continue block11;
                }
                case 'r': {
                    this.repeat = Integer.parseInt(stringArray[n].substring(2));
                    continue block11;
                }
                case 't': {
                    this.type = Integer.parseInt(stringArray[n].substring(2));
                    continue block11;
                }
                case 'x': {
                    if (stringArray[n].charAt(2) != 'i') continue block11;
                    this.infoLevel = Integer.parseInt(stringArray[n].substring(3));
                    continue block11;
                }
                case '?': {
                    this.printUsage();
                    return 1;
                }
                default: {
                    System.out.println("\n*** NG Argument " + n + " " + stringArray[n] + " not known, usage:");
                    this.printUsage();
                    return 2;
                }
            }
        }
        File file = new File(this.directoryName);
        if (!file.isDirectory()) {
            System.out.println("*** Error " + this.directoryName + " is not a directory");
            return 1;
        }
        return 0;
    }

    public void printUsage() {
        NetworkGenerator networkGenerator = new NetworkGenerator();
        System.out.println("OPTIONS for NetworkGenerator version NG070202\n");
        System.out.println(" -fn<filenameroot> root of filename, default " + networkGenerator.fileName);
        System.out.println(" -fd<dirname>      directory using forward slashes, default " + networkGenerator.directoryName);
        System.out.println(" -k<float> average degree, default " + networkGenerator.averageDegree);
        System.out.println(" -n<int> number of vertices, default " + networkGenerator.numberVertices);
        System.out.println(" -o<int> output modes (see timgraph), default " + networkGenerator.outputcontrol);
        System.out.println(" -r<int> number of times to repeat, default " + networkGenerator.repeat);
        System.out.println(" -t<int> type of network, default " + networkGenerator.type + " = " + networkGenerator.typeString());
        System.out.println(" -xi<int> information level, -2 very quiet, 0 normal, >0 debugging, default " + networkGenerator.infoLevel + " = " + networkGenerator.typeString());
        System.out.println(" -?      this help screen");
        System.out.println("Network Types:-");
        for (int i = 0; i < 6; ++i) {
            networkGenerator.type = i;
            System.out.println("       " + i + " = " + networkGenerator.typeString());
        }
    }

    void printParameters() {
        this.printParameters(System.out);
    }

    void printParameters(PrintStream printStream) {
        printStream.println("NetworkGenerator version NG070202");
        printStream.println("   Type of Network " + this.SEP + this.type + this.SEP + this.typeString());
        printStream.println("Number of Vertices " + this.SEP + this.numberVertices);
        printStream.println("    Average Degree " + this.SEP + this.averageDegree);
        printStream.println("      Output Modes " + this.SEP + this.outputcontrol);
        printStream.println("         File Name " + this.SEP + this.fileName);
        printStream.println("    Directory Name " + this.SEP + this.directoryName);
        printStream.println("    No. of repeats " + this.SEP + this.repeat);
    }
}

