/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Coordinate;
import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.Random;

public class TriangleGridCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameTGCG = "Triangle Grid Community Graph";
    static final String shortNameTGCG = "TGCG";
    int dimX = -135798642;
    int dimY = -135798642;
    int dimN = -135798642;
    protected int edgeTestType;
    double avTriangleSourceNumber;
    protected int nTrianglesMax;
    protected int nTrianglesCurrent;
    int typeX = 0;
    int typeY = 0;
    int typeN = 0;
    private int[] distN;
    private int[] distX;
    private int[] distY;
    boolean firstSystematic = true;
    boolean systematic = false;

    public TriangleGridCommunityGraph() {
    }

    public TriangleGridCommunityGraph(int n, int n2, int n3, int n4, int n5, int n6, int n7, double d, double d2, boolean bl, boolean bl2, double d3, String[] stringArray) {
        this.graphName = nameTGCG;
        this.shortGraphName = shortNameTGCG;
        this.tg = new timgraph(stringArray);
        this.tg.setVertexEdgeList(true);
        this.setName();
        this.dimX = n;
        this.dimY = n2;
        this.dimN = n3;
        this.typeX = n4;
        this.typeY = n5;
        this.typeN = n6;
        this.setRandomDistribution(this.typeN, this.dimN, this.distN);
        this.setRandomDistribution(this.typeX, this.dimX, this.distX);
        this.setRandomDistribution(this.typeY, this.dimY, this.distY);
        this.nVertices = this.dimX * this.dimY * this.dimN;
        this.edgeTestType = n7;
        switch (this.edgeTestType) {
            case 1: {
                this.nStubsMax = (int)Math.round(d * (double)this.nVertices) + 6;
                this.nTrianglesMax = this.nStubsMax / 6;
                this.avTriangleSourceNumber = this.nTrianglesMax / this.nVertices;
                break;
            }
            default: {
                this.avTriangleSourceNumber = d;
                this.nTrianglesMax = (int)Math.round((double)this.nVertices * this.avTriangleSourceNumber);
                this.nStubsMax = this.nTrianglesMax * 6;
            }
        }
        this.nTrianglesCurrent = 0;
        this.avDegree = this.nStubsMax / this.nVertices;
        this.probability = d2;
        this.nCommunities = this.dimX + this.dimY;
        System.out.println("Maximum vertices, triangles, stubs " + this.nVertices + ", " + this.nTrianglesMax + ", " + this.nStubsMax);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        this.rnd = new Random();
        this.create(bl, bl2, d3);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 2;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n3 = 2;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n4 = 32;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n5 = 1;
        int n6 = 107;
        double d = 16.0;
        if (stringArray.length > ++n) {
            n6 = stringArray[n].charAt(1);
            if (timgraph.isOtherArgument(stringArray[n])) {
                d = Double.parseDouble(stringArray[n].substring(2, stringArray[n].length()));
            }
        }
        switch (n6) {
            case 107: {
                n5 = 1;
                System.out.println("Limit on average degree is " + d);
                break;
            }
            default: {
                n5 = 0;
                System.out.println("Limit on average number triangles is " + d);
            }
        }
        double d2 = 0.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl = true;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl2 = false;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n7 = 0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n7 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n8 = n7 & true ? 1 : 0;
        int n9 = (n7 & 2) == 2 ? 1 : 0;
        int n10 = (n7 & 4) == 4 ? 1 : 0;
        double d3 = 200.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d3 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        String[] stringArray2 = new String[]{"-o255"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        TriangleGridCommunityGraph triangleGridCommunityGraph = new TriangleGridCommunityGraph(n2, n3, n4, n8, n9, n10, n5, d, d2, bl, bl2, d3, stringArray2);
        System.out.println("--- Created " + triangleGridCommunityGraph.desciption("\n"));
        triangleGridCommunityGraph.setName();
        triangleGridCommunityGraph.information();
    }

    public void create(boolean bl, boolean bl2, double d) {
        this.createVertices(d);
        this.createTriangles(bl, bl2);
    }

    public void createVertices(double d) {
        this.tg.initialiseVertexLabels();
        VertexGridCoordinates vertexGridCoordinates = new VertexGridCoordinates();
        double d2 = this.dimN < 2 ? d : d * (double)this.dimN / (Math.PI * 2);
        for (int i = 0; i < this.nVertices; ++i) {
            vertexGridCoordinates.set(i);
            Coordinate coordinate = vertexGridCoordinates.getCoordinate(d2, 3.5);
            VertexLabel vertexLabel = new VertexLabel(i, vertexGridCoordinates.vectorString(), vertexGridCoordinates.getCoordinate(d2, 3.5));
            vertexLabel.setNumber(i / this.dimN);
            this.tg.addVertex(vertexLabel);
        }
    }

    public void createTriangles(boolean bl, boolean bl2) {
        this.firstSystematic = bl;
        this.systematic = bl2;
        this.nTrianglesCurrent = 0;
        double d = 1.0 - this.probability;
        double d2 = d / 2.0;
        int n = 0;
        int n2 = 0;
        for (n = 0; n < this.tg.getNumberVertices(); ++n) {
            if (this.firstSystematic) {
                this.addTriangleFirstCommunityOnly(n);
                n2 = this.addTriangleSecondCommunityOnly(n);
            } else {
                this.addTriangle(n, d2, d);
                n2 = this.addTriangle(n, d2, d);
            }
            if (n2 < 0) break;
        }
        while (this.moreEdgesNeeded()) {
            if (this.systematic) {
                if (++n >= this.tg.getNumberVertices()) {
                    n = 0;
                }
            } else {
                n = this.rnd.nextInt(this.tg.getNumberVertices());
            }
            this.addTriangle(n, d2, d);
        }
    }

    private boolean moreEdgesNeeded() {
        switch (this.edgeTestType) {
            case 1: {
                return this.tg.getMaximumStubs() - this.tg.getNumberStubs() > 8;
            }
        }
        return this.nTrianglesCurrent < this.nTrianglesMax;
    }

    private int addTriangleFirstCommunityOnly(int n) {
        return this.addTriangle(n, 2.0, 3.0);
    }

    private int addTriangleSecondCommunityOnly(int n) {
        return this.addTriangle(n, -1.0, 3.0);
    }

    private int addTriangle(int n, double d, double d2) {
        if (this.edgeTestType == 0 && this.nTrianglesCurrent >= this.nTrianglesMax) {
            System.err.println("*** In addTriangle, current number of triangles is too large, nothing added. current, max= " + this.nTrianglesCurrent + ", " + this.nTrianglesMax);
            return -1;
        }
        if (this.edgeTestType == 1 && this.tg.getMaximumStubs() - this.tg.getNumberStubs() < 6) {
            System.err.println("*** In addTriangle, current number of stubs is within 6 of maximum, nothing added. current, max= " + this.tg.getNumberStubs() + ", " + this.tg.getMaximumStubs());
            return -2;
        }
        VertexGridCoordinates vertexGridCoordinates = new VertexGridCoordinates(n);
        double d3 = this.rnd.nextDouble();
        int n2 = n;
        int n3 = n;
        if (d3 < d) {
            while (n2 == n) {
                n2 = this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), vertexGridCoordinates.y);
            }
            while (n3 == n || n3 == n2) {
                n3 = this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), vertexGridCoordinates.y);
            }
        } else if (d3 < d2) {
            while (n2 == n) {
                n2 = this.getIndex(this.rnd.nextInt(this.dimN), vertexGridCoordinates.x, this.rnd.nextInt(this.dimY));
            }
            while (n3 == n || n3 == n2) {
                n3 = this.getIndex(this.rnd.nextInt(this.dimN), vertexGridCoordinates.x, this.rnd.nextInt(this.dimY));
            }
        } else {
            while (n2 == n) {
                n2 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
            while (n3 == n || n3 == n2) {
                n3 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
        }
        this.tg.increaseEdgeWeight(n, n2, 1.0);
        this.tg.increaseEdgeWeight(n2, n3, 1.0);
        this.tg.increaseEdgeWeight(n3, n, 1.0);
        System.out.println("T" + this.nTrianglesCurrent + "=(" + n + "," + n2 + "," + n3 + ")");
        return ++this.nTrianglesCurrent;
    }

    private int findTarget(VertexGridCoordinates vertexGridCoordinates, double d, double d2) {
        double d3 = this.rnd.nextDouble();
        int n = -1;
        n = d3 < d ? this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), vertexGridCoordinates.y) : (d3 < d2 ? this.getIndex(this.rnd.nextInt(this.dimN), vertexGridCoordinates.x, this.rnd.nextInt(this.dimY)) : this.rnd.nextInt(this.tg.getNumberVertices()));
        return n;
    }

    private void setRandomDistribution(int n, int n2, int[] nArray) {
        switch (n) {
            case 1: {
                int n3 = (n2 + 1) * n2 / 2;
                nArray = new int[n3];
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < i + 1; ++j) {
                        nArray[n4++] = i;
                    }
                }
                return;
            }
        }
        nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
    }

    private int getRandomN() {
        if (this.distN.length > 0) {
            return this.distN[this.rnd.nextInt(this.distN.length)];
        }
        return this.rnd.nextInt(this.dimN);
    }

    private int getRandomX() {
        if (this.distX.length > 0) {
            return this.distX[this.rnd.nextInt(this.distX.length)];
        }
        return this.rnd.nextInt(this.dimX);
    }

    private int getRandomY() {
        if (this.distY.length > 0) {
            return this.distY[this.rnd.nextInt(this.distY.length)];
        }
        return this.rnd.nextInt(this.dimY);
    }

    public String desciption(String string) {
        return this.basicDescription(string) + ", " + string + " grid " + this.dimX + " by " + this.dimY + string + " number vertices per grid point " + this.dimN + string + " limit average degree " + String.format("%6.3f", this.avDegree) + string + " actual average degree " + String.format("%6.3f", this.tg.getAverageDegree()) + string + " number stubs " + this.tg.getNumberStubs() + string + " average number time vertices are source vertex for triangles " + String.format("%6.3f", this.avTriangleSourceNumber) + string + " actual value " + this.nTrianglesCurrent / this.tg.getNumberVertices() + string + " actual number triangles added " + this.nTrianglesCurrent + string + " actual number of triangles in graph " + this.tg.getNumberTriangles() + string + " limit on " + (this.edgeTestType == 1 ? "degree" : "triangles");
    }

    public String shortName() {
        String string = "m";
        string = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? string + (int)(this.avDegree + 1.0E-6) : string + this.avDegree;
        return this.shortGraphName + "n" + this.typeChar(this.typeN) + this.dimN + "x" + this.typeChar(this.typeX) + this.dimX + "y" + this.typeChar(this.typeY) + this.dimY + (this.firstSystematic ? "s" : "r") + (this.systematic ? "s" : "r") + (this.edgeTestType == 0 ? "t" + this.nTrianglesMax : "s" + this.nStubsMax) + "p" + (int)(1000.0 * this.probability);
    }

    private char typeChar(int n) {
        switch (n) {
            case 1: {
                return 'p';
            }
        }
        return 'u';
    }

    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }

    int getIndex(int n, int n2, int n3) {
        return n + this.dimN * (n2 + this.dimX * n3);
    }

    class VertexGridCoordinates {
        public int n = -1;
        public int x = -1;
        public int y = -1;

        VertexGridCoordinates() {
        }

        VertexGridCoordinates(int n) {
            this.set(n);
        }

        void set(int n) {
            this.n = n % TriangleGridCommunityGraph.this.dimN;
            int n2 = n / TriangleGridCommunityGraph.this.dimN;
            this.x = n2 % TriangleGridCommunityGraph.this.dimX;
            this.y = n2 / TriangleGridCommunityGraph.this.dimX;
        }

        Coordinate getCoordinate(double d, double d2) {
            if (TriangleGridCommunityGraph.this.dimN < 2) {
                return new Coordinate((double)this.x * d, (double)this.y * d);
            }
            return new Coordinate((Math.cos((double)this.n * Math.PI * 2.0 / (double)TriangleGridCommunityGraph.this.dimN) + (double)this.x * d2) * d, (Math.sin((double)this.n * Math.PI * 2.0 / (double)TriangleGridCommunityGraph.this.dimN) + (double)this.y * d2) * d);
        }

        String vectorString() {
            return "(" + (TriangleGridCommunityGraph.this.dimN > 1 ? this.n + "," : "") + this.x + "," + this.y + ")";
        }
    }
}

