/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Generators.TriangleGridCommunityGraph;
import TimGraph.timgraph;
import java.util.Random;

public class SimpleTriangleGridCommunityGraph
extends TriangleGridCommunityGraph {
    static final String nameSTGCG = "Simple Triangle Grid Community Graph";
    static final String shortNameSTGCG = "STGCG";

    public SimpleTriangleGridCommunityGraph(int n, int n2, double d, String[] stringArray) {
        this.graphName = nameSTGCG;
        this.shortGraphName = shortNameSTGCG;
        this.tg = new timgraph(stringArray);
        this.tg.setVertexEdgeList(true);
        this.setName();
        this.dimX = n;
        this.dimY = n2;
        this.dimN = 1;
        this.typeX = -1;
        this.typeY = -1;
        this.typeN = -1;
        this.nVertices = this.dimX * this.dimY * this.dimN;
        this.avTriangleSourceNumber = 2.0;
        this.nTrianglesMax = (int)Math.round((double)this.nVertices * this.avTriangleSourceNumber);
        this.nTrianglesCurrent = 0;
        this.nStubsMax = this.nTrianglesMax * 6;
        this.avDegree = this.nStubsMax / this.nVertices;
        this.probability = -1.0;
        this.nCommunities = this.dimX + this.dimY;
        System.out.println("nVertices, nTriangles, nStubs " + this.nVertices + ", " + this.nTrianglesMax + ", " + this.nStubsMax);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        this.rnd = new Random();
        this.createSimple(d);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 6;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n3 = 6;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        String[] stringArray2 = new String[]{"-o255"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        double d = 200.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        SimpleTriangleGridCommunityGraph simpleTriangleGridCommunityGraph = new SimpleTriangleGridCommunityGraph(n2, n3, d, stringArray2);
        System.out.println("--- Created " + simpleTriangleGridCommunityGraph.desciption("\n"));
        simpleTriangleGridCommunityGraph.setName();
        simpleTriangleGridCommunityGraph.information();
    }

    public void createSimple(double d) {
        this.createVertices(d);
        this.createTrianglesSimply();
    }

    public void createTrianglesSimply() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.nTrianglesCurrent = 0;
        for (n5 = 0; n5 < this.dimX; ++n5) {
            n4 = 0;
            for (int i = 2; i < this.dimY; ++i) {
                int n6 = i == 2 ? 1 : this.rnd.nextInt(i - 1) + 1;
                n3 = this.getIndex(0, n5, n4);
                n2 = this.getIndex(0, n5, i);
                n = this.getIndex(0, n5, n6);
                this.tg.increaseEdgeWeight(n3, n2, 1.0);
                this.tg.increaseEdgeWeight(n2, n, 1.0);
                this.tg.increaseEdgeWeight(n, n3, 1.0);
            }
        }
        for (n4 = 0; n4 < this.dimY; ++n4) {
            n5 = 0;
            for (int i = 2; i < this.dimX; ++i) {
                int n7 = i == 2 ? 1 : this.rnd.nextInt(i - 1) + 1;
                n3 = this.getIndex(0, n5, n4);
                n2 = this.getIndex(0, i, n4);
                n = this.getIndex(0, n7, n4);
                this.tg.increaseEdgeWeight(n3, n2, 1.0);
                this.tg.increaseEdgeWeight(n2, n, 1.0);
                this.tg.increaseEdgeWeight(n, n3, 1.0);
            }
        }
    }

    public String desciption(String string) {
        return this.basicDescription(string) + ", " + string + " grid " + this.dimX + " by " + this.dimY + string + " average number time vertices are source vertex for triangles " + this.avTriangleSourceNumber;
    }

    public String shortName() {
        String string = "m";
        string = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? string + (int)(this.avDegree + 1.0E-6) : string + this.avDegree;
        return this.shortGraphName + "x" + this.dimX + "y" + this.dimY;
    }

    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }
}

