/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;

public class SimpleTriangleCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameSTCG = "Simple Triangle Community Graph";
    static final String shortNameSTCG = "STCG";
    double avTriangleSourceNumber;
    int nTriangles;

    public SimpleTriangleCommunityGraph(int n, int n2, double d, double d2, String[] stringArray) {
        this.graphName = nameSTCG;
        this.shortGraphName = shortNameSTCG;
        this.tg = new timgraph(stringArray);
        this.tg.setVertexEdgeList(true);
        this.nCommunities = n;
        this.nVertices = this.nCommunities * n2;
        this.avTriangleSourceNumber = d;
        this.nTriangles = (int)Math.round((double)this.nVertices * this.avTriangleSourceNumber);
        this.nStubsMax = this.nTriangles * 6;
        this.avDegree = this.nStubsMax / this.nVertices;
        this.probability = d2;
        System.out.println("nVertices, nTriangles, nStubs " + this.nVertices + ", " + this.nTriangles + ", " + this.nStubsMax);
        this.tg.setNetworkWithVertices(this.nVertices, this.nStubsMax);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 4;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n3 = 32;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d = 1.5;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d2 = 0.085786438;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl = true;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        String[] stringArray2 = new String[]{"-o255"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        SimpleTriangleCommunityGraph simpleTriangleCommunityGraph = new SimpleTriangleCommunityGraph(n2, n3, d, d2, stringArray2);
        System.out.println("--- Created " + simpleTriangleCommunityGraph.desciption("\n"));
        simpleTriangleCommunityGraph.initialise();
        simpleTriangleCommunityGraph.setName();
        simpleTriangleCommunityGraph.create(bl);
        simpleTriangleCommunityGraph.labelVertices();
        simpleTriangleCommunityGraph.information();
    }

    public void create(boolean bl) {
        int n = this.nVertices / this.nCommunities;
        this.createCommunityStructure(n);
        this.createTriangleCommunities(bl);
    }

    public void createTriangleCommunities(boolean bl) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.nCommunities; ++i) {
            n4 = this.firstVinC[i + 1] - this.firstVinC[i];
            int n5 = (int)(this.avTriangleSourceNumber * (double)n4);
            for (int j = 0; j < n5; ++j) {
                n = this.firstVinC[i] + (bl ? j : this.rnd.nextInt(n4));
                n2 = this.findTarget(this.probability, n, i, n4);
                n3 = n;
                while (n3 == n || n3 == n2) {
                    n3 = this.findTarget(this.probability, n, i, n4);
                }
                this.tg.increaseEdgeWeight(n, n2, 1.0);
                this.tg.increaseEdgeWeight(n2, n3, 1.0);
                this.tg.increaseEdgeWeight(n3, n, 1.0);
            }
        }
    }

    public String desciption(String string) {
        return this.basicDescription(string) + ", " + string + this.nTriangles + " triangles, " + string + this.avTriangleSourceNumber * 3.0 + " average triangles per vertex";
    }
}

