/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Community.VertexPartition;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import cern.colt.list.IntArrayList;
import java.util.Random;

public class SimpleERCommunityGraph {
    static final String nameSERCG = "Simple ER Community Graph";
    static final String shortNameSERCG = "SERCG";
    String graphName = "Simple ER Community Graph";
    String shortGraphName = "SERCG";
    timgraph tg;
    int[] v2c;
    int[] firstVinC;
    IntArrayList[] c2v;
    int nVertices;
    int nStubsMax;
    double avDegree;
    int nCommunities;
    double probability;
    Random rnd;

    public SimpleERCommunityGraph() {
    }

    public SimpleERCommunityGraph(int n, int n2, double d, double d2, String[] stringArray) {
        this.graphName = nameSERCG;
        this.shortGraphName = shortNameSERCG;
        this.tg = new timgraph(stringArray);
        this.tg.setVertexEdgeList(true);
        this.nCommunities = n;
        this.nVertices = this.nCommunities * n2;
        this.avDegree = d;
        this.nStubsMax = (int)Math.round((double)this.nVertices * d);
        this.probability = d2;
        System.out.println("nVertices, nStubs " + this.nVertices + ", " + this.nStubsMax);
        this.tg.setNetworkWithVertices(this.nVertices, this.nStubsMax);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 4;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n3 = 32;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n4 = 9;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d = 1.0 / (double)n4;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        String[] stringArray2 = new String[]{"-o255"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        SimpleERCommunityGraph simpleERCommunityGraph = new SimpleERCommunityGraph(n2, n3, n4, d, stringArray2);
        System.out.println("--- Created " + simpleERCommunityGraph.desciption(""));
        simpleERCommunityGraph.initialise();
        simpleERCommunityGraph.setName();
        simpleERCommunityGraph.create();
        simpleERCommunityGraph.labelVertices();
        simpleERCommunityGraph.information();
    }

    public void information() {
        this.tg.printParametersBasic();
        FileOutput fileOutput = new FileOutput(this.tg);
        fileOutput.informationGeneral("", "\t");
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        fileOutput.printEdges(bl, bl2, bl3, bl4, bl5);
        fileOutput.informationNetworkBasic("#", "\t ");
        fileOutput.edgeListSimple(true);
    }

    public void initialise() {
        this.rnd = new Random();
        this.v2c = new int[this.nVertices];
        this.firstVinC = new int[this.nCommunities + 1];
        this.c2v = new IntArrayList[this.nCommunities];
        for (int i = 0; i < this.nCommunities; ++i) {
            this.c2v[i] = new IntArrayList();
        }
    }

    public void create() {
        int n = this.nVertices / this.nCommunities;
        this.createCommunityStructure(n);
        this.createERCommunities();
    }

    public void createCommunityStructure(int n) {
        int n2 = -1;
        for (int i = 0; i < this.nVertices; ++i) {
            this.v2c[i] = n2 = i / n;
            this.c2v[n2].add(i);
        }
        for (n2 = 0; n2 <= this.nCommunities; ++n2) {
            this.firstVinC[n2] = n2 * n;
        }
    }

    public void labelVertices() {
        if (!this.tg.isVertexLabelled()) {
            this.tg.initialiseVertexLabels();
        }
        for (int i = 0; i < this.tg.getNumberVertices(); ++i) {
            this.tg.setVertexNumber(i, this.v2c[i]);
        }
    }

    public VertexPartition createVertexPartition() {
        double d = -9.7531E86;
        return new VertexPartition(d, this.nVertices, this.nStubsMax / 2, this.v2c);
    }

    public void createERCommunities() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.nCommunities; ++i) {
            n3 = this.firstVinC[i + 1] - this.firstVinC[i];
            int n4 = (int)(this.avDegree * (double)n3) / 2;
            for (int j = 0; j < n4; ++j) {
                n = this.firstVinC[i] + this.rnd.nextInt(n3);
                n2 = this.findTarget(this.probability, n, i, n3);
                this.tg.increaseEdgeWeight(n, n2, 1.0);
            }
        }
    }

    public void createSimpleCommunities1() {
        int n = (int)this.avDegree / 2;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.tg.getNumberVertices(); ++i) {
            n3 = this.v2c[i];
            n4 = this.firstVinC[n3 + 1] - this.firstVinC[n3];
            for (int j = 0; j < n; ++j) {
                n2 = this.findTarget(this.probability, i, n3, n4);
                this.tg.addEdge(i, n2);
            }
        }
    }

    public int findTarget(double d, int n, int n2, int n3) {
        int n4 = -1;
        if (this.rnd.nextDouble() < d) {
            n4 = this.firstVinC[n2 + 1] + this.rnd.nextInt(this.nVertices - n3);
            if (n4 >= this.nVertices) {
                n4 -= this.nVertices;
            }
        } else {
            n4 = this.firstVinC[n2] + this.rnd.nextInt(n3);
            while (n4 == n) {
                n4 = this.firstVinC[n2] + this.rnd.nextInt(n3);
            }
        }
        return n4;
    }

    public String basicDescription(String string) {
        return this.graphName + string + " with " + this.nCommunities + " communities, " + string + this.nVertices / this.nCommunities + " average vertices each, " + string + this.nVertices + " vertices in total, " + string + this.avDegree + " average degree, " + string + this.probability + " probability ";
    }

    public String desciption(String string) {
        return this.basicDescription(string);
    }

    public String shortName() {
        String string = "m";
        string = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? string + (int)(this.avDegree + 1.0E-6) : string + this.avDegree;
        return this.shortGraphName + "v" + this.nVertices + string + "c" + this.nCommunities + "p" + (int)(1000.0 * this.probability);
    }

    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }
}

