/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Coordinate;
import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.VertexLabel;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.Random;

public class GridCommunityGraph
extends SimpleERCommunityGraph {
    static final String nameGCG = "Grid Community Graph";
    static final String shortNameGCG = "GCG";
    int dimX = -135798642;
    int dimY = -135798642;
    int dimN = -135798642;
    int typeX = 0;
    int typeY = 0;
    int typeN = 0;
    private int[] distN;
    private int[] distX;
    private int[] distY;
    boolean firstSystematic = true;
    boolean systematic = false;

    public GridCommunityGraph() {
    }

    public GridCommunityGraph(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, boolean bl, boolean bl2, double d3, String[] stringArray) {
        this.graphName = nameGCG;
        this.shortGraphName = shortNameGCG;
        this.tg = new timgraph(stringArray);
        this.tg.setVertexEdgeList(true);
        this.setName();
        this.dimX = n;
        this.dimY = n2;
        this.dimN = n3;
        this.typeX = n4;
        this.typeY = n5;
        this.typeN = n6;
        this.setRandomDistribution(this.typeN, this.dimN, this.distN);
        this.setRandomDistribution(this.typeX, this.dimX, this.distX);
        this.setRandomDistribution(this.typeY, this.dimY, this.distY);
        this.nVertices = this.dimX * this.dimY * this.dimN;
        this.avDegree = d;
        this.nStubsMax = (int)Math.round((double)this.nVertices * d);
        this.probability = d2;
        this.nCommunities = this.dimX + this.dimY;
        System.out.println("nVertices, avDegree, nStubs " + this.nVertices + ", " + this.avDegree + ", " + this.nStubsMax);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        this.rnd = new Random();
        this.create(bl, bl2, d3);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 11;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n3 = 11;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n4 = 1;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d = 8.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d2 = 0.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d2 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl = true;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl2 = false;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n5 = 0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n5 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n6 = n5 & true ? 1 : 0;
        int n7 = (n5 & 2) == 2 ? 1 : 0;
        int n8 = (n5 & 4) == 4 ? 1 : 0;
        double d3 = 200.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d3 = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        String[] stringArray2 = new String[]{"-o255"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        GridCommunityGraph gridCommunityGraph = new GridCommunityGraph(n2, n3, n4, n6, n7, n8, d, d2, bl, bl2, d3, stringArray2);
        System.out.println("--- Created " + gridCommunityGraph.desciption("\n"));
        gridCommunityGraph.setName();
        gridCommunityGraph.information();
    }

    public void create(boolean bl, boolean bl2, double d) {
        this.createVertices(d);
        this.createEdges(bl, bl2);
    }

    public void createVertices(double d) {
        this.tg.initialiseVertexLabels();
        VertexGridCoordinates vertexGridCoordinates = new VertexGridCoordinates();
        double d2 = this.dimN < 2 ? d : d * (double)this.dimN / (Math.PI * 2);
        for (int i = 0; i < this.nVertices; ++i) {
            vertexGridCoordinates.set(i);
            VertexLabel vertexLabel = new VertexLabel(i, vertexGridCoordinates.vectorString(), vertexGridCoordinates.getCoordinate(d2, 3.5));
            vertexLabel.setNumber(i / this.dimN);
            this.tg.addVertex(vertexLabel);
        }
    }

    public void createEdges(boolean bl, boolean bl2) {
        this.firstSystematic = bl;
        this.systematic = bl2;
        double d = 1.0 - this.probability;
        double d2 = d / 2.0;
        int n = 0;
        for (n = 0; n < this.tg.getNumberVertices(); ++n) {
            if (this.firstSystematic) {
                this.addEdgeFirstCommunityOnly(n);
                this.addEdgeSecondCommunityOnly(n);
                continue;
            }
            this.addEdge(n, d2, d);
            this.addEdge(n, d2, d);
        }
        while (this.tg.getNumberStubs() < this.nStubsMax) {
            if (this.systematic) {
                if (++n >= this.tg.getNumberVertices()) {
                    n = 0;
                }
            } else {
                n = this.rnd.nextInt(this.tg.getNumberVertices());
            }
            this.addEdge(n, d2, d);
        }
    }

    private int addEdgeFirstCommunityOnly(int n) {
        return this.addEdge(n, 2.0, 3.0);
    }

    private int addEdgeSecondCommunityOnly(int n) {
        return this.addEdge(n, -1.0, 3.0);
    }

    private int addEdge(int n, double d, double d2) {
        if (this.tg.getNumberStubs() >= this.nStubsMax) {
            System.err.println("*** In addEdge, current number of stubs is too large, nothing added. current, max= " + this.tg.getNumberStubs() + ", " + this.nStubsMax);
            return -1;
        }
        VertexGridCoordinates vertexGridCoordinates = new VertexGridCoordinates(n);
        double d3 = this.rnd.nextDouble();
        int n2 = n;
        if (d3 < d) {
            while (n2 == n) {
                n2 = this.getIndex(this.rnd.nextInt(this.dimN), this.rnd.nextInt(this.dimX), vertexGridCoordinates.y);
            }
        } else if (d3 < d2) {
            while (n2 == n) {
                n2 = this.getIndex(this.rnd.nextInt(this.dimN), vertexGridCoordinates.x, this.rnd.nextInt(this.dimY));
            }
        } else {
            while (n2 == n) {
                n2 = this.rnd.nextInt(this.tg.getNumberVertices());
            }
        }
        this.tg.increaseEdgeWeight(n, n2, 1.0);
        System.out.println("S" + this.tg.getNumberStubs() + "=(" + n + "," + n2 + ")");
        return this.tg.getNumberStubs();
    }

    private int findTarget(VertexGridCoordinates vertexGridCoordinates, double d, double d2) {
        double d3 = this.rnd.nextDouble();
        int n = -1;
        n = d3 < d ? this.getIndex(this.dimN < 2 ? 0 : this.rnd.nextInt(this.dimN), this.dimX < 2 ? 0 : this.rnd.nextInt(this.dimX), vertexGridCoordinates.y) : (d3 < d2 ? this.getIndex(this.dimN < 2 ? 0 : this.rnd.nextInt(this.dimN), vertexGridCoordinates.x, this.dimY < 2 ? 0 : this.rnd.nextInt(this.dimY)) : this.rnd.nextInt(this.tg.getNumberVertices()));
        return n;
    }

    private void setRandomDistribution(int n, int n2, int[] nArray) {
        switch (n) {
            case 1: {
                int n3 = (n2 + 1) * n2 / 2;
                nArray = new int[n3];
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < i + 1; ++j) {
                        nArray[n4++] = i;
                    }
                }
                return;
            }
        }
        nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
    }

    private int getRandomN() {
        if (this.distN.length > 0) {
            return this.distN[this.rnd.nextInt(this.distN.length)];
        }
        return this.rnd.nextInt(this.dimN);
    }

    private int getRandomX() {
        if (this.distX.length > 0) {
            return this.distX[this.rnd.nextInt(this.distX.length)];
        }
        return this.rnd.nextInt(this.dimX);
    }

    private int getRandomY() {
        if (this.distY.length > 0) {
            return this.distY[this.rnd.nextInt(this.distY.length)];
        }
        return this.rnd.nextInt(this.dimY);
    }

    public String desciption(String string) {
        return this.basicDescription(string) + ", " + string + " grid " + this.dimX + " by " + this.dimY + string + " number vertices per grid point " + this.dimN + string + " number stubs added " + this.nStubsMax;
    }

    public String shortName() {
        String string = "m";
        string = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? string + (int)(this.avDegree + 1.0E-6) : string + this.avDegree;
        return this.shortGraphName + "n" + this.typeChar(this.typeN) + this.dimN + "x" + this.typeChar(this.typeX) + this.dimX + "y" + this.typeChar(this.typeY) + this.dimY + (this.firstSystematic ? "s" : "r") + (this.systematic ? "s" : "r") + "s" + this.nStubsMax + "p" + (int)(1000.0 * this.probability);
    }

    private char typeChar(int n) {
        switch (n) {
            case 1: {
                return 'p';
            }
        }
        return 'u';
    }

    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }

    int getIndex(int n, int n2, int n3) {
        return n + this.dimN * (n2 + this.dimX * n3);
    }

    class VertexGridCoordinates {
        public int n = -1;
        public int x = -1;
        public int y = -1;

        VertexGridCoordinates() {
        }

        VertexGridCoordinates(int n) {
            this.set(n);
        }

        void set(int n) {
            this.n = n % GridCommunityGraph.this.dimN;
            int n2 = n / GridCommunityGraph.this.dimN;
            this.x = n2 % GridCommunityGraph.this.dimX;
            this.y = n2 / GridCommunityGraph.this.dimX;
        }

        Coordinate getCoordinate(double d, double d2) {
            if (GridCommunityGraph.this.dimN < 2) {
                return new Coordinate((double)this.x * d, (double)this.y * d);
            }
            return new Coordinate((Math.cos((double)this.n * Math.PI * 2.0 / (double)GridCommunityGraph.this.dimN) + (double)this.x * d2) * d, (Math.sin((double)this.n * Math.PI * 2.0 / (double)GridCommunityGraph.this.dimN) + (double)this.y * d2) * d);
        }

        String vectorString() {
            return "(" + (GridCommunityGraph.this.dimN > 1 ? this.n + "," : "") + this.x + "," + this.y + ")";
        }
    }
}

