/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Generators;

import TimGraph.Coordinate;
import TimGraph.Generators.SimpleERCommunityGraph;
import TimGraph.OutputMode;
import TimGraph.VertexLabel;
import TimGraph.algorithms.BipartiteTransformations;
import TimGraph.io.FileOutput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import java.util.Random;

public class BipartiteGridCommunityGraphSimple
extends SimpleERCommunityGraph {
    static final String nameBGCG = "Bipartite Grid Community Graph";
    static final String shortNameBGCG = "BGCG";
    int dimX = -135798642;
    int dimY = -135798642;
    int nPerC2 = -135798642;

    public BipartiteGridCommunityGraphSimple(int n, int n2, int n3, int n4, double d, boolean bl, boolean bl2, double d2, String[] stringArray) {
        this.graphName = nameBGCG;
        this.shortGraphName = shortNameBGCG;
        this.tg = new timgraph(stringArray);
        this.setName();
        this.dimX = n;
        this.dimY = n2;
        this.nPerC2 = n3;
        this.probability = d;
        this.nCommunities = this.dimX + this.dimY;
        this.tg.setBipartite(this.dimX * this.dimY, this.nPerC2 * this.nCommunities, "Grid", "RowColumn");
        this.nStubsMax = n4;
        this.nVertices = this.tg.getNumberVerticesType1() + this.tg.getNumberVerticesType2();
        this.tg.setVertexEdgeList(true);
        this.tg.setNetwork(this.nVertices, this.nStubsMax);
        System.out.println("BipartiteGridCommunityGraph grid " + this.dimX + " by " + this.dimY);
        this.rnd = new Random();
        this.create(bl, bl2, d2);
        this.project();
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 10;
        if (stringArray.length > n && timgraph.isOtherArgument(stringArray[n])) {
            n2 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n3 = 10;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n3 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n4 = (n2 + n3) / 3;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        int n5 = n2 * n3 * (2 + n4 * 2);
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            n4 = Integer.parseInt(stringArray[n].substring(1, stringArray[n].length()));
        }
        double d = 0.0;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            d = Double.parseDouble(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl = true;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        boolean bl2 = false;
        if (stringArray.length > ++n && timgraph.isOtherArgument(stringArray[n])) {
            bl = StringFilter.trueString(stringArray[n].substring(1, stringArray[n].length()));
        }
        String[] stringArray2 = new String[]{"-o255"};
        if (stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        double d2 = 200.0;
        BipartiteGridCommunityGraphSimple bipartiteGridCommunityGraphSimple = new BipartiteGridCommunityGraphSimple(n2, n3, n4, n5, d, bl, bl2, d2, stringArray2);
        System.out.println("--- Created " + bipartiteGridCommunityGraphSimple.desciption("\n"));
        bipartiteGridCommunityGraphSimple.setName();
        bipartiteGridCommunityGraphSimple.information();
    }

    public void create(boolean bl, boolean bl2, double d) {
        this.createVertices(d);
        this.createEdges(bl, bl2);
    }

    public void createVertices(double d) {
        VertexLabel vertexLabel;
        int n;
        this.tg.initialiseVertexLabels();
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.tg.getNumberVerticesType1(); ++n) {
            n2 = n % this.dimX;
            n3 = n / this.dimY;
            vertexLabel = new VertexLabel(n, "(" + n2 + "," + n3 + ")", new Coordinate((double)n2 * d, (double)n3 * d));
            this.tg.addVertex(vertexLabel);
        }
        n = -1;
        int n4 = -1;
        for (int i = 0; i < this.tg.getNumberVerticesType2(); ++i) {
            n = i / this.nPerC2;
            n4 = i % this.nPerC2;
            vertexLabel = n < this.dimY ? new VertexLabel(i + this.tg.getNumberVerticesType1(), "y" + n + "." + n4, new Coordinate((double)(this.dimX + n4) * d, (double)n * d)) : new VertexLabel(i + this.tg.getNumberVerticesType1(), "x" + (n - this.dimY) + "." + n4, new Coordinate((double)(n - this.dimY) * d, (double)(this.dimY + n4) * d));
            this.tg.addVertex(vertexLabel);
        }
    }

    public String desciption(String string) {
        return this.basicDescription(string) + ", " + string + " grid " + this.dimX + " by " + this.dimY + string + " number type 2 vertices per community " + this.nPerC2;
    }

    public void createEdges(boolean bl, boolean bl2) {
        double d = 1.0 - this.probability;
        double d2 = d / 2.0;
        int n = 0;
        for (n = 0; n < this.tg.getNumberVerticesType1(); ++n) {
            if (bl) {
                this.addEdge(n, 2.0, 3.0);
                this.addEdge(n, -1.0, 3.0);
                continue;
            }
            this.addEdge(n, d2, d);
            this.addEdge(n, d2, d);
        }
        while (this.tg.getNumberStubs() < this.nStubsMax) {
            if (bl2) {
                if (++n >= this.tg.getNumberVerticesType1()) {
                    n = 0;
                }
            } else {
                n = this.rnd.nextInt(this.tg.getNumberVerticesType1());
            }
            this.addEdge(n, d2, d);
        }
    }

    private int addEdge(int n, double d, double d2) {
        int n2 = n % this.dimX;
        int n3 = n / this.dimX;
        double d3 = this.rnd.nextDouble();
        int n4 = -1;
        n4 = d3 < d ? this.tg.getNumberVerticesType1() + n3 * this.nPerC2 + this.rnd.nextInt(this.nPerC2) : (d3 < d2 ? this.tg.getNumberVerticesType1() + (this.dimY + n2) * this.nPerC2 + this.rnd.nextInt(this.nPerC2) : this.tg.getNumberVerticesType1() + this.rnd.nextInt(this.tg.getNumberVerticesType2()));
        return this.tg.addEdgeUnique(n, n4);
    }

    public void project() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        timgraph timgraph2 = BipartiteTransformations.project(this.tg, bl, bl2, bl3, bl4, bl5);
        for (int i = 0; i < this.tg.getNumberVerticesType1(); ++i) {
            VertexLabel vertexLabel = new VertexLabel(this.tg.getVertexLabel(i));
            timgraph2.setVertexLabelQuick(i, vertexLabel);
        }
        timgraph2.setNameRoot(this.shortName() + "proj");
        FileOutput fileOutput = new FileOutput(timgraph2);
        String string = "#";
        String string2 = "\t ";
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = true;
        boolean bl9 = true;
        boolean bl10 = true;
        OutputMode outputMode = null;
        fileOutput.informationGeneral(string, string2, bl6, bl7, bl8, bl9, bl10, outputMode);
    }

    public String shortName() {
        String string = "m";
        string = Math.abs((double)Math.round(this.avDegree) - this.avDegree) < 1.0E-6 ? string + (int)(this.avDegree + 1.0E-6) : string + this.avDegree;
        return this.shortGraphName + "x" + this.dimX + "y" + this.dimY + "c" + this.nPerC2 + "s" + this.nStubsMax + "p" + (int)(1000.0 * this.probability);
    }

    public void setName() {
        this.tg.setNameRoot(this.shortName());
    }
}

