/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import DataAnalysis.LogBin;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class DegreeDistribution {
    String name = "unspecified";
    IntArrayList ddarr;
    int minimum = 9999999;
    int maximum;
    int continuous = this.maximum = -1;
    int totalvertices = 0;
    int totaledges = 0;
    double average = 0.0;
    double secondmoment = 0.0;
    public int infoLevel = 0;

    public DegreeDistribution(String string) {
        this.ddarr = new IntArrayList();
        this.name = string;
    }

    public DegreeDistribution(String string, int n) {
        this.ddarr = new IntArrayList(n);
        this.name = string;
    }

    void calcDegreeDistribution(IntArrayList[] intArrayListArray, int n) {
        this.maximum = -1;
        this.ddarr.add(0);
        for (int i = 0; i < n; ++i) {
            if (intArrayListArray[i] == null) {
                this.ddarr.set(0, this.ddarr.get(0) + 1);
                break;
            }
            int n2 = intArrayListArray[i].size();
            if (n2 < this.ddarr.size()) {
                this.ddarr.setQuick(n2, this.ddarr.get(n2) + 1);
                continue;
            }
            while (this.ddarr.size() < n2) {
                this.ddarr.add(0);
            }
            this.ddarr.add(1);
        }
        this.calcValues();
    }

    void calcDegreeDistribution(IntArrayList[] intArrayListArray, int n, int n2) {
        this.maximum = -1;
        this.ddarr.add(0);
        n = 0;
        int n3 = 0;
        if (n < 0) {
            n3 = 0;
            System.err.println("*** ERROR in calcDegreeDistribution firstVertex=" + n + " less than one");
        }
        int n4 = n2;
        if (n2 > intArrayListArray.length) {
            n2 = intArrayListArray.length;
            System.err.println("*** ERROR in calcDegreeDistribution lastVertexPlusOne=" + n2 + " larger than length of vertex array = " + intArrayListArray.length);
        }
        for (int i = n; i < n2; ++i) {
            if (intArrayListArray[i] == null) {
                this.ddarr.set(0, this.ddarr.get(0) + 1);
                break;
            }
            int n5 = intArrayListArray[i].size();
            if (n5 < this.ddarr.size()) {
                this.ddarr.setQuick(n5, this.ddarr.get(n5) + 1);
                continue;
            }
            while (this.ddarr.size() < n5) {
                this.ddarr.add(0);
            }
            this.ddarr.add(1);
        }
        this.calcValues();
    }

    void calcDegreeDistribution(IntArrayList[] intArrayListArray, IntArrayList[] intArrayListArray2, int n) {
        this.calcDegreeDistribution(intArrayListArray, 0, n);
    }

    void calcValues() {
        this.totalvertices = 0;
        this.totaledges = 0;
        int n = 0;
        double d = 0.0;
        this.continuous = this.maximum + 1;
        this.minimum = 0;
        while (this.ddarr.get(this.minimum) == 0) {
            ++this.minimum;
        }
        for (int i = this.minimum; i < this.ddarr.size(); ++i) {
            n = this.ddarr.get(i);
            this.totalvertices += n;
            this.totaledges += n * i;
            d += (double)(n * i * i);
            if (n == 0 && i < this.continuous) {
                this.continuous = i;
            }
            if (n <= 0) continue;
            this.maximum = i;
        }
        this.average = (double)this.totaledges / (double)this.totalvertices;
        this.secondmoment = d / (double)this.totalvertices;
    }

    void FileOutputDegreeDistribution(String string, String string2, String string3, boolean bl, boolean bl2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.print(printStream, string2, string3, bl, bl2);
            if (this.infoLevel > -2) {
                System.out.println("Finished writing " + this.name + " degree distribution to " + string);
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("File Error with " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + string);
            return;
        }
    }

    void FileOutputLogBinnedDegreeDistribution(String string, String string2, String string3, double d, boolean bl, boolean bl2) {
        if (this.maximum < 0) {
            this.calcValues();
        }
        LogBin logBin = new LogBin();
        logBin.calcLogBinAny(this.ddarr, this.minimum, this.maximum, 1, d);
        logBin.FileOutputLogBinnedFreqData(string, string2, string3, bl, bl2);
    }

    void print(String string, String string2, boolean bl) {
        this.print(System.out, string, string2, bl, true);
    }

    void print(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        double d = 0.0;
        int n = 0;
        if (this.totalvertices < 1) {
            return;
        }
        if (bl2) {
            printStream.print(string + " k " + string2 + (bl ? "p(k)" + string2 + "Normalised " : "n(k)" + string2 + "Unnormalised ") + this.name + " Degree Distribution  (not reduced = strength)");
            printStream.println(string2 + this.infoString(string2));
        }
        for (int i = 0; i < this.ddarr.size(); ++i) {
            if (bl) {
                d = (double)this.ddarr.get(i) / (double)this.totalvertices;
                if (!(d > 0.0)) continue;
                printStream.println(i + string2 + d);
                continue;
            }
            n = (int)((double)this.ddarr.get(i) + 0.5);
            if (n <= 0) continue;
            printStream.println(i + string2 + n);
        }
    }

    public String infoString(String string) {
        String string2 = "Min k" + string + this.minimum;
        string2 = string2 + string + "Continuum k1" + string + this.continuous;
        string2 = string2 + string + "Max k" + string + this.maximum;
        string2 = string2 + string + "<k>" + string + this.average;
        string2 = string2 + string + "<k^2>" + string + this.secondmoment;
        string2 = string2 + string + "N vertices" + string + this.totalvertices;
        string2 = string2 + string + "S Stubs" + string + this.totaledges;
        return string2;
    }

    public void outputInformation(PrintStream printStream, String string, String string2, int n) {
        String string3 = "%12." + n + "6g";
        printStream.println(string + "Degree" + string2 + "distribution" + string2 + this.name);
        printStream.println(string + string2 + "Total Vertices" + string2 + this.totalvertices + string2 + "Total Edges" + string2 + this.totaledges);
        printStream.println(string + string2 + "k_min" + string2 + "k_cont" + string2 + "k_max" + string2 + "<k>" + string2 + "<k^2>");
        printStream.println(string + string2 + this.minimum + string2 + this.continuous + string2 + this.maximum + string2 + String.format(string3, this.average) + string2 + String.format(string3, this.secondmoment));
    }
}

