/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

public class Coordinate {
    double x;
    double y;
    double z;

    public Coordinate() {
        this.set(0.0, 0.0, 0.0);
    }

    public Coordinate(int n, int n2) {
        this.set(n, n2, 0.0);
    }

    public Coordinate(double d, double d2) {
        this.set(d, d2, 0.0);
    }

    public Coordinate(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Coordinate(Coordinate coordinate) {
        this.set(coordinate);
    }

    public void set(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    public void set(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.z = 0.0;
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void setToMinimum(Coordinate coordinate) {
        this.x = Math.min(this.x, coordinate.x);
        this.y = Math.min(this.y, coordinate.y);
        this.z = Math.min(this.z, coordinate.z);
    }

    public void setToMaximum(Coordinate coordinate) {
        this.x = Math.max(this.x, coordinate.x);
        this.y = Math.max(this.y, coordinate.y);
        this.z = Math.max(this.z, coordinate.z);
    }

    public void min(Coordinate coordinate, Coordinate coordinate2) {
        this.x = Math.min(coordinate2.x, coordinate.x);
        this.y = Math.min(coordinate2.y, coordinate.y);
        this.z = Math.min(coordinate2.z, coordinate.z);
    }

    public void max(Coordinate coordinate, Coordinate coordinate2) {
        this.x = Math.max(coordinate2.x, coordinate.x);
        this.y = Math.max(coordinate2.y, coordinate.y);
        this.z = Math.max(coordinate2.z, coordinate.z);
    }

    public boolean equals(Coordinate coordinate) {
        return this.x == coordinate.x && this.y == coordinate.y && this.z == coordinate.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double distance(Coordinate coordinate) {
        return Math.sqrt((this.x - coordinate.x) * (this.x - coordinate.x) + (this.y - coordinate.y) * (this.y - coordinate.y) + (this.z - coordinate.z) * (this.z - coordinate.z));
    }

    public double distance2D(Coordinate coordinate) {
        return Math.sqrt((this.x - coordinate.x) * (this.x - coordinate.x) + (this.y - coordinate.y) * (this.y - coordinate.y));
    }

    public String toString2D(String string) {
        return this.x + string + this.y;
    }

    public String toString(String string) {
        return this.x + string + this.y + string + this.z;
    }

    public static String toString(Coordinate coordinate, String string) {
        if (coordinate == null) {
            return "." + string + "." + string + ".";
        }
        return coordinate.toString(string);
    }

    public String print2DString(String string) {
        String string2 = this.x + string + this.y;
        return string2;
    }

    public String printString(String string) {
        String string2 = this.x + string + this.y + string + this.z;
        return string2;
    }

    public static String labelString2D(String string) {
        return "x" + string + "y";
    }

    public static String labelString(String string) {
        return "x" + string + "y" + string + "z";
    }

    public static Coordinate calcArc2DCoordinate(Coordinate coordinate, Coordinate coordinate2, double d) {
        double d2 = d / Coordinate.calcLength(coordinate, coordinate2);
        return new Coordinate((coordinate.x + coordinate2.x) / 2.0 + (coordinate2.y - coordinate.y) * d2, (coordinate.y + coordinate2.y) / 2.0 + (coordinate.x - coordinate2.x) * d2, (coordinate.z + coordinate2.z) / 2.0);
    }

    public static Coordinate calcMidPoint(Coordinate coordinate, Coordinate coordinate2) {
        return new Coordinate((coordinate.x + coordinate2.x) / 2.0, (coordinate.y + coordinate2.y) / 2.0, (coordinate.z + coordinate2.z) / 2.0);
    }

    public static double calcLength(Coordinate coordinate, Coordinate coordinate2) {
        return Math.sqrt((coordinate.x - coordinate2.x) * (coordinate.x - coordinate2.x) + (coordinate.y - coordinate2.y) * (coordinate.y - coordinate2.y) + (coordinate.z - coordinate2.z) * (coordinate.z + coordinate2.z));
    }
}

