/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.EdgePartition;
import TimGraph.Community.LouvainVertexPartition;
import TimGraph.Community.Partition;
import TimGraph.Community.SimulatedAnnealingvertexPartition;
import TimGraph.VertexLabel;
import TimGraph.algorithms.Projections;
import TimGraph.timgraph;
import TimUtilities.Permutation;
import TimUtilities.TimMemory;
import TimUtilities.TimTiming;
import TimUtilities.UpdateRecord;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;

public class VertexPartition
extends Partition {
    private Random Rnd = new Random();
    protected int numberEdges = -987123456;
    int edgesInVP = -1;
    private Permutation perm;
    protected UpdateRecord greedyUpdateRecord;
    int[] degreeArray;
    int[] degreeInCArray;
    double[] strengthArray;
    double[] strengthInCArray;
    double[] qualityArray;

    public VertexPartition() {
        this.setDefaultNames();
    }

    public VertexPartition(timgraph timgraph2) {
        this.name = "generalVP";
        this.initialise(timgraph2);
    }

    public VertexPartition(int n) {
        this.name = "generalVP";
        this.setNumberElements(n);
    }

    public VertexPartition(String string, int n) {
        this.setDefaultNames();
        this.setNumberElements(n);
    }

    public VertexPartition(double d, int n, int n2, int[] nArray) {
        this.setDefaultNames();
        this.name = this.name + this.quality.QdefinitionShortString();
        this.Q = d;
        this.setNumberElements(n);
        this.numberEdges = n2;
        this.setCommunity(nArray);
    }

    public VertexPartition(timgraph timgraph2, VertexPartition vertexPartition) {
        this.setDefaultNames();
        this.name = vertexPartition.getName() + "ep2vp";
        this.initialiseFromLineGraphVertexPartition(timgraph2, vertexPartition);
    }

    private void setDefaultNames() {
        this.name = "generalVP";
        this.nameOfElements = "vertices";
    }

    public void initialise(timgraph timgraph2) {
        this.initialise(timgraph2, 0, 1, true);
    }

    public void initialise(timgraph timgraph2, int n, int n2, boolean bl) {
        this.initialise(timgraph2, n, n2, 1.0, bl ? 0 : -1);
    }

    public void initialise(timgraph timgraph2, int n, int n2, int n3) {
        this.initialise(timgraph2, n, n2, 1.0, n3);
    }

    public void initialise(timgraph timgraph2, int n, int n2, double d, int n3) {
        this.initialiseGraph(timgraph2, n, n2, d);
        this.numberElements = this.graph.getNumberVertices();
        this.numberEdges = this.graph.getNumberStubs();
        if (this.infoLevel > 1 && this.numberElements < 21) {
            this.quality.printMatrix(System.out, " ", true);
        }
        this.setCommunity(n3);
        this.Q = -9.87123456E8;
    }

    private void initialiseFromLineGraphVertexPartition(timgraph timgraph2, VertexPartition vertexPartition) {
        this.initialiseFromLineGraphVertexPartition(timgraph2, vertexPartition, -9.7531E86, false);
    }

    private void initialiseFromLineGraphVertexPartition(timgraph timgraph2, VertexPartition vertexPartition, double d, boolean bl) {
        this.initialise(timgraph2, 0, 2, false);
        int n = vertexPartition.getNumberOfCommunities();
        double[] dArray = new double[n];
        for (int i = 0; i < this.numberElements; ++i) {
            double d2;
            int n2;
            for (int j = 0; j < n; ++j) {
                dArray[j] = 0.0;
            }
            double d3 = 0.0;
            for (int j = 0; j < timgraph2.getVertexOutDegree(i); ++j) {
                int n3 = timgraph2.getEdge(i, j);
                n2 = vertexPartition.getCommunity(n3 / 2);
                d2 = timgraph2.isWeighted() ? timgraph2.getEdgeWeight(n3) : 1.0;
                d3 += d2;
                int n4 = n2;
                dArray[n4] = dArray[n4] + d2;
            }
            double d4 = d;
            n2 = -789456123;
            if (d3 < 1.0E-6) {
                this.communityOfElement[i] = -789456123;
                continue;
            }
            if (!bl) {
                d3 = 1.0;
            }
            d2 = d4 * d3;
            for (int j = 0; j < n; ++j) {
                if (d2 > dArray[j] || d2 == dArray[j] && this.Rnd.nextDouble() < 0.5) continue;
                d2 = dArray[j];
                n2 = j;
            }
            this.communityOfElement[i] = n2;
        }
        this.recalculateCommunityLabels();
    }

    public int getNumberVertices() {
        return this.numberElements;
    }

    public int getNumberVerticesInCommunityFast(int n) {
        return this.getNumberElementsInCommunity(n);
    }

    public int getNumberVerticesInCommunity(int n) {
        if (this.numberElementsArray == null) {
            this.analyse();
        }
        return this.numberElementsArray[n];
    }

    public int getDegreeOfCommunity(int n) {
        return this.degreeArray[n];
    }

    public int getDegreeInCommunity(int n) {
        return this.degreeInCArray[n];
    }

    public double getStrengthOfCommunity(int n) {
        return this.strengthArray[n];
    }

    public double getStrengthInCommunity(int n) {
        return this.strengthInCArray[n];
    }

    public double getQualityOfCommunity(int n) {
        return this.qualityArray[n];
    }

    public timgraph getVertexPartitionGraph() {
        return Projections.ontoVertexPartition(this.graph.inputName.getNameRoot() + "proj" + this.name, this.graph, this.communityOfElement, this.numberCommunities, false, false);
    }

    public int compareEPtoVP(EdgePartition edgePartition) {
        this.edgesInVP = 0;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.graph.getNumberStubs(); ++i) {
            n2 = this.graph.getVertexFromEdge(i++);
            n3 = this.graph.getVertexFromEdge(i);
            n5 = this.communityOfElement[n3];
            if (n5 != (n4 = this.communityOfElement[n2])) continue;
            ++this.edgesInVP;
            ++n;
        }
        return n;
    }

    public int getNumberOfEdgesInVP() {
        return this.edgesInVP;
    }

    public int calculateBestGreedyCommunity(int n) {
        return this.calculateBestGreedyCommunity(n, 5.0);
    }

    public int calculateBestGreedyCommunity(int n, double d) {
        this.perm = new Permutation(this.numberElements);
        this.greedyUpdateRecord = new UpdateRecord();
        boolean bl = this.infoLevel > 0 && d > 0.0;
        TimTiming timTiming = new TimTiming();
        TimMemory timMemory = new TimMemory();
        if (bl) {
            System.out.println("\n\nInitial Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
            System.out.println("                    initial memory " + timMemory.StringAllValues());
        }
        timTiming.setIntervalTimeMinutes(d);
        for (int i = 0; i < n; ++i) {
            double d2 = this.oneGreedySweep(d);
            if (timTiming.testIntervalTime()) {
                this.recalculateCommunityLabels();
                System.out.println("\nGreedy Sweep " + i + ", quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", Quality change " + d2 + ", " + this.greedyUpdateRecord.toString() + ".");
                System.out.println("                    time ellapsed " + timTiming.runTimeString() + ", memory " + timMemory.StringAllValues());
            }
            if (this.greedyUpdateRecord.getMade() == 0) break;
        }
        if (bl) {
            System.out.println("Final Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
            System.out.println("                    initial memory " + timMemory.StringAllValues() + "\n\n");
        }
        return this.greedyUpdateRecord.getMade();
    }

    private double oneGreedySweep(double d) {
        TimTiming timTiming = new TimTiming();
        TimMemory timMemory = new TimMemory();
        timTiming.setIntervalTimeMinutes(d);
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        double d3 = 0.0;
        int n3 = -1;
        this.perm.newPermutation();
        int n4 = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = -1;
        double d6 = this.graph.getNumberVertices();
        for (int i = 0; i < this.graph.getNumberVertices(); ++i) {
            int n6;
            if (timTiming.testIntervalTime()) {
                this.recalculateCommunityLabels();
                double d7 = (double)i / d6;
                System.out.println("Completed " + Math.round(d7 * 100.0) + "%, time ellapsed/left " + timTiming.runTimeString() + "  " + timTiming.estimateRemainingTimeString(d7));
                System.out.println("                  memory " + timMemory.StringAllValues());
            }
            if ((d3 = -this.quality.delta(n4 = this.perm.next(), n3 = this.communityOfElement[n4], this.communityOfElement)) > 0.0) {
                n5 = -86421357;
                d5 = d3;
            } else {
                d5 = 0.0;
                n5 = n3;
            }
            int n7 = this.graph.getVertexOutDegree(n4);
            if (n7 == 0) continue;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (int j = 0; j < n7; ++j) {
                n6 = this.graph.getNeighbour(n4, j);
                int n8 = this.communityOfElement[n6];
                treeSet.add(n8);
            }
            Iterator iterator = treeSet.iterator();
            n6 = -1;
            while (iterator.hasNext()) {
                n6 = (Integer)iterator.next();
                if (n6 == n3 || (d4 = this.quality.delta(n4, n6, this.communityOfElement) + d3) < d5) continue;
                n5 = n6;
                d5 = d4;
            }
            ++n;
            if (n5 == n3) continue;
            d2 += d5;
            if (n5 == -86421357) {
                n5 = this.getEmptyCommunity();
            }
            this.communityOfElement[n4] = n5;
            ++n2;
        }
        this.greedyUpdateRecord.update(n, n2);
        return d2;
    }

    public void printVertices(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        if (this.graph == null) {
            throw new RuntimeException("vertexPartition.printVertices need graph to be defined");
        }
        if (this.graph.getNumberVertices() != this.numberElements) {
            throw new RuntimeException("vertexPartition.printAnalysis graph has " + this.graph.getNumberVertices() + " while partition has " + this.numberElements + " " + this.nameOfElements);
        }
        int n = -1;
        int n2 = -1;
        double d = -1.0;
        int n3 = -1;
        double d2 = -1.0;
        int n4 = -1;
        double d3 = -1.0;
        double d4 = -1.0;
        int n5 = -1;
        boolean bl3 = false;
        boolean bl4 = this.graph.isWeighted();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        if (this.graph.isVertexLabelled()) {
            VertexLabel vertexLabel = this.graph.getVertexLabel(0);
            bl7 = vertexLabel.hasName();
            bl8 = vertexLabel.hasNumber();
            bl9 = vertexLabel.hasPosition();
            bl10 = vertexLabel.hasStrength();
            bl11 = vertexLabel.hasRank();
        }
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
        }
        if (bl2) {
            printStream.print(this.graph.getVertexStringLabel(string, string2, bl5, bl6, true, bl7, bl8, bl9, bl10, bl11, bl3));
            printStream.print(string2 + "k_C" + string2 + "k_C/k");
            if (bl4) {
                printStream.print(string2 + "str_C" + string2 + "str_C/str");
            }
            printStream.println();
        }
        for (int i = 0; i < this.graph.getNumberVertices(); ++i) {
            n2 = this.communityOfElement[i];
            printStream.print(this.graph.getVertexString(string, string2, i, n2, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl3));
            d = 0.0;
            if (bl4) {
                d3 = 0.0;
            }
            n3 = this.graph.getVertexOutDegree(i);
            if (bl4) {
                d2 = this.graph.getVertexOutStrength(i);
            }
            n4 = 0;
            for (int j = 0; j < n3; ++j) {
                n5 = this.graph.getNeighbourQuick(i, j);
                d += this.quality.get(i, n5);
                n = this.graph.getEdge(i, j);
                d4 = this.graph.getEdgeWeight(n);
                if (this.communityOfElement[n5] != n2) continue;
                ++n4;
                if (!bl4) continue;
                d3 += d4;
            }
            printStream.print(string2 + n4 + string2 + (double)n4 / (double)n3);
            if (bl4) {
                printStream.print(string2 + d3 + string2 + d3 / d2);
            }
            printStream.println();
        }
    }

    public void printSimpleVertexCommunityList(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        if (this.graph == null) {
            throw new RuntimeException("vertexPartition.printVertices need graph to be defined");
        }
        if (this.graph.getNumberVertices() != this.numberElements) {
            throw new RuntimeException("vertexPartition.printAnalysis graph has " + this.graph.getNumberVertices() + " while partition has " + this.numberElements + " " + this.nameOfElements);
        }
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
        }
        if (bl2) {
            printStream.println(string + "Vertex" + string2 + "Community");
        }
        for (int i = 0; i < this.graph.getNumberVertices(); ++i) {
            printStream.println(this.graph.getVertexName(i) + string2 + this.communityOfElement[i]);
        }
    }

    public void printStatistics(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        if (this.graph == null) {
            throw new RuntimeException("vertexPartition.printCommunities need graph to be defined");
        }
        if (this.graph.getNumberVertices() != this.numberElements) {
            throw new RuntimeException("vertexPartition.printAnalysis graph has " + this.graph.getNumberVertices() + " while partition has " + this.numberElements + " " + this.nameOfElements);
        }
        boolean bl3 = this.graph.isWeighted();
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
            if (this.communityStatistics == null) {
                this.calculateCommunityStatistics();
            }
            printStream.println(this.communityStatistics.labelString(string2));
            printStream.println(this.communityStatistics.toString(string2));
        }
        if (bl2) {
            printStream.print(string + "Community" + string2 + "N_C" + string2 + "k_C" + string2 + "k_C" + string2 + "k_C/k");
            if (bl3) {
                printStream.print(string2 + "str" + string2 + "str_C" + string2 + "str_C/str");
            }
            printStream.println(string2 + "quality");
        }
        this.analyse();
        for (int i = 0; i < this.numberCommunities; ++i) {
            printStream.print(i + string2 + this.numberElementsArray[i] + string2 + this.degreeArray[i] + string2 + this.degreeInCArray[i]);
            if (this.degreeArray[i] > 0) {
                printStream.print(string2 + (double)this.degreeInCArray[i] / (double)this.degreeArray[i]);
            } else {
                printStream.print(string2 + "0");
            }
            if (bl3) {
                printStream.print(string2 + this.strengthArray[i] + string2 + this.strengthInCArray[i]);
                if (this.strengthArray[i] > 0.0) {
                    printStream.print(string2 + this.strengthInCArray[i] / this.strengthArray[i]);
                } else {
                    printStream.print(string2 + "0");
                }
            }
            printStream.println(string2 + this.qualityArray[i]);
        }
    }

    public void analyse(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, double[] dArray2, double[] dArray3) {
    }

    public void analyse() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = 1.0;
        int n4 = -1;
        boolean bl = false;
        boolean bl2 = this.graph.isWeighted();
        this.numberElementsArray = new int[this.numberCommunities];
        this.degreeArray = new int[this.numberCommunities];
        this.degreeInCArray = new int[this.numberCommunities];
        if (bl2) {
            this.strengthArray = new double[this.numberCommunities];
            this.strengthInCArray = new double[this.numberCommunities];
        } else {
            this.strengthArray = null;
        }
        this.qualityArray = new double[this.numberCommunities];
        for (int i = 0; i < this.graph.getNumberVertices(); ++i) {
            int n5 = n2 = this.communityOfElement[i];
            this.numberElementsArray[n5] = this.numberElementsArray[n5] + 1;
            n3 = this.graph.getVertexOutDegree(i);
            int n6 = n2;
            this.degreeArray[n6] = this.degreeArray[n6] + n3;
            for (int j = 0; j < n3; ++j) {
                n4 = this.graph.getNeighbourQuick(i, j);
                int n7 = n2;
                this.qualityArray[n7] = this.qualityArray[n7] + this.quality.get(i, n4);
                n = this.graph.getEdge(i, j);
                if (bl2) {
                    d = this.graph.getEdgeWeight(n);
                    int n8 = n2;
                    this.strengthArray[n8] = this.strengthArray[n8] + d;
                }
                if (this.communityOfElement[n4] != n2) continue;
                int n9 = n2;
                this.degreeInCArray[n9] = this.degreeInCArray[n9] + 1;
                if (!bl2) continue;
                int n10 = n2;
                this.strengthInCArray[n10] = this.strengthInCArray[n10] + d;
            }
        }
        d = 0.0;
        n = 1;
    }

    public static VertexPartition calculate(timgraph timgraph2, int n, int n2, int n3) {
        return VertexPartition.calculate(timgraph2, n, 1, 1.0, n2, n3);
    }

    public static VertexPartition calculate(timgraph timgraph2, int n, int n2, double d, int n3, int n4) {
        VertexPartition vertexPartition;
        switch (n3) {
            default: {
                LouvainVertexPartition louvainVertexPartition = new LouvainVertexPartition(timgraph2, n, n2, d, n4, -1);
                louvainVertexPartition.calculate();
                vertexPartition = louvainVertexPartition;
                break;
            }
            case 1: {
                SimulatedAnnealingvertexPartition simulatedAnnealingvertexPartition = new SimulatedAnnealingvertexPartition(timgraph2, n, n2, d, n4, -1);
                simulatedAnnealingvertexPartition.calculateRecursively(1000, 0.5, false);
                vertexPartition = simulatedAnnealingvertexPartition;
            }
        }
        vertexPartition.recalculateCommunityLabels();
        if (n4 > 0) {
            System.out.println("*** Best community:-");
            vertexPartition.printInformation(System.out, "", " ");
        }
        return vertexPartition;
    }
}

