/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.Community;
import TimGraph.Community.Partition;
import TimGraph.io.FileInput;
import TimGraph.timgraph;
import TimUtilities.StringUtilities.Filters.StringFilter;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexCommunity
extends Community {
    public VertexCommunity() {
        this.setDefaultNames();
    }

    public VertexCommunity(String string) {
        this.name = string;
        this.nameOfElements = "vertices";
    }

    public VertexCommunity(timgraph timgraph2) {
        this.nameOfElements = "vertices";
        this.initialiseFromGraph(timgraph2);
    }

    public VertexCommunity(timgraph timgraph2, ArrayList<ArrayList<Integer>> arrayList) {
        this.nameOfElements = "vertices";
        this.initialiseFromGraph(timgraph2);
        this.setUp(arrayList);
    }

    public void initialiseFromGraph(timgraph timgraph2) {
        this.name = timgraph2.inputName.getNameRoot();
        this.nameOfElements = "vertices";
        this.graph = timgraph2;
    }

    public VertexCommunity(timgraph timgraph2, Partition partition, int n, int n2, double d) {
        this.setDefaultNames();
        this.initialiseGraph(timgraph2, n, n2, d);
        if (timgraph2.getNumberVertices() == partition.getNumberElements()) {
            this.initialiseFromVertexPartition(partition);
        } else if (timgraph2.getNumberStubs() / 2 == partition.getNumberElements()) {
            this.initialiseFromEdgePartition(timgraph2, partition);
        } else {
            throw new RuntimeException("*** Community constructor: Neither number of vertices " + timgraph2.getNumberVertices() + " nor the number of edges " + timgraph2.getNumberStubs() / 2 + " matches number of elements in partition " + partition.getNumberElements());
        }
    }

    private void setDefaultNames() {
        this.name = "generalVP";
        this.nameOfElements = "vertices";
    }

    private void initialiseFromVertexPartition(Partition partition) {
        this.name = partition.getName() + "vp";
        this.numberCommunities = partition.getNumberOfCommunities();
        this.numberElements = partition.getNumberElements();
        this.communityMatrix = new SparseDoubleMatrix2D(this.numberElements, this.numberCommunities);
        for (int i = 0; i < this.numberElements; ++i) {
            this.communityMatrix.set(i, partition.getCommunity(i), 1.0);
        }
    }

    private void initialiseFromEdgePartition(timgraph timgraph2, Partition partition) {
        this.name = partition.getName() + "ep2vc";
        this.graph = timgraph2;
        this.numberCommunities = partition.getNumberOfCommunities();
        this.numberElements = timgraph2.getNumberVertices();
        this.communityMatrix = new SparseDoubleMatrix2D(this.numberElements, this.numberCommunities);
        double d = -1.0;
        int n = -1;
        int n2 = -1;
        double d2 = -1.0;
        for (int i = 0; i < this.numberElements; ++i) {
            d = timgraph2.isWeighted() ? timgraph2.getVertexOutStrength(i) : (double)timgraph2.getVertexOutDegree(i);
            for (int j = 0; j < timgraph2.getVertexOutDegree(i); ++j) {
                n = timgraph2.getEdge(i, j);
                n2 = partition.getCommunity(n / 2);
                d2 = this.communityMatrix.get(i, n2) + (timgraph2.isWeighted() ? timgraph2.getEdgeWeight(n) : 1.0) / d;
                this.communityMatrix.set(i, n2, d2);
            }
        }
    }

    public int getNumberVertices() {
        return this.numberElements;
    }

    public void readVertexCommunity(String string, TreeMap<String, Integer> treeMap, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 1;
        if (string.endsWith("BVNLS.dat")) {
            this.readStringVertexCommunitiesFile(treeMap, string, bl3, bl4, n, bl, bl2);
        }
        if (string.endsWith("vcis")) {
            int n2 = 1;
            int n3 = 2;
            int n4 = 8;
            boolean bl5 = true;
            this.readVertexCommunityListFile(treeMap, string, n2, n3, n4, bl, bl2, bl5);
        }
    }

    public void readStringVertexCommunitiesFile(TreeMap<String, Integer> treeMap, String string, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4) {
        System.out.println("Starting to read vertex community using a vertex communities list with string vertex labels from " + string);
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        StringFilter stringFilter = null;
        StringFilter stringFilter2 = null;
        TreeSet<String> treeSet3 = null;
        FileInput.readStringVertexNeighbourFile(string, treeSet, treeSet2, arrayList, doubleArrayList, bl, bl2, n, stringFilter, stringFilter2, treeSet3, this.infoLevel > 1);
        this.setUp(treeMap, treeSet, treeSet2, arrayList, doubleArrayList, bl3, bl4);
    }

    public void readVertexCommunityListFile(TreeMap<String, Integer> treeMap, String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        boolean bl3 = false;
        this.readVertexCommunityListFile(treeMap, string, n, n2, n3, bl, bl2, bl3);
    }

    public void readVertexCommunityListFile(TreeMap<String, Integer> treeMap, String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        System.out.println("Starting to read vertex community using a vertex-community edge listlist with string vertex labels from " + string);
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        FileInput fileInput = new FileInput(this.infoLevel);
        int n4 = -1;
        fileInput.readStringEdgeFile(string, n, n2, n3, n4, treeSet, treeSet2, arrayList, doubleArrayList, null, bl3);
        this.setUp(treeMap, treeSet, treeSet2, arrayList, doubleArrayList, bl, bl2);
    }

    public void setUp(TreeMap<String, Integer> treeMap, Set<String> set, Set<String> set2, ArrayList<String> arrayList, DoubleArrayList doubleArrayList, boolean bl, boolean bl2) {
        int n;
        String string2;
        if (treeMap == null) {
            treeMap = new TreeMap();
            int n2 = 0;
            for (String object : set) {
                treeMap.put(object, n2++);
            }
        }
        TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
        int n3 = 0;
        for (String string2 : set2) {
            treeMap2.put(string2, n3++);
        }
        string2 = "";
        String string3 = "";
        this.initialiseEmptyCommunity(set.size(), set2.size());
        int n2 = 0;
        int n4 = 0;
        double d = -1.0;
        double d2 = -1.0;
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = arrayList.get(n++);
            Integer n5 = treeMap.get(string2);
            ++n4;
            if (n5 == null) continue;
            ++n2;
            this.setElementName(n5, string2);
            string3 = arrayList.get(n);
            n3 = (Integer)treeMap2.get(string3);
            d = doubleArrayList.getQuick(n / 2);
            d2 = this.communityMatrix.get(n5.intValue(), n3) + d;
            this.communityMatrix.set(n5.intValue(), n3, d2);
            this.setCommunityName(n3, string3);
        }
        if (n2 == n4) {
            System.out.println("  Found " + n4 + " and all were included");
        } else {
            System.out.println("*** Found " + n4 + " vertex stubs, but only included " + n2);
        }
        if (bl && (n = this.normaliseMatrix(1.0E-6)) >= 0) {
            throw new RuntimeException("Forcing community matrix normalisation failure for vertex " + n);
        }
        if (bl2 && (n = this.checkMatrixNormalisation(1.0E-6)) >= 0) {
            throw new RuntimeException("Matrix normalisation failure for vertex " + n);
        }
    }

    public void setUp(int n, ArrayList<ArrayList<Integer>> arrayList, int[] nArray, boolean bl, boolean bl2) {
        int n2;
        int n3;
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(new ArrayList());
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            ArrayList<Integer> arrayList3 = arrayList.get(n3);
            treeSet2.add(nArray[n3]);
            for (Integer serializable2 : arrayList3) {
                treeSet.add(serializable2);
            }
        }
        n3 = n - treeSet.size();
        int n4 = treeSet2.size();
        int n5 = n3 + n4;
        this.initialiseEmptyCommunity(n, n5);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n6 = 0;
        for (Integer n7 : treeSet2) {
            treeMap.put(n7, n6++);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            ArrayList<Integer> arrayList3 = arrayList.get(n2);
            n6 = (Integer)treeMap.get(nArray[n2]);
            for (Integer n8 : arrayList3) {
                this.increaseCommunityMembership(n8, n6, 1.0);
            }
        }
        for (n2 = 0; n2 < this.getNumberVertices(); ++n2) {
            if (treeSet.contains(n2)) continue;
            this.setCommunityMembership(n2, n4++, 1.0);
        }
        if (bl && (n2 = this.normaliseMatrix(1.0E-6)) >= 0) {
            throw new RuntimeException("Forcing community matrix normalisation failure for vertex " + n2);
        }
        if (bl2 && (n2 = this.checkMatrixNormalisation(1.0E-6)) >= 0) {
            throw new RuntimeException("Matrix normalisation failure for vertex " + n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUp(ArrayList<ArrayList<Integer>> arrayList) {
        void var7_10;
        ArrayList<Integer> arrayList2;
        int n;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = this.getNumberVertices();
        for (n = 0; n < n2; ++n) {
            arrayList2 = arrayList.get(n);
            if (arrayList2.size() > 0) {
                for (Integer object : arrayList2) {
                    treeSet.add(object);
                }
                continue;
            }
            treeSet.add(n + n2);
        }
        n = 0;
        TreeMap treeMap = new TreeMap();
        for (Integer n3 : treeSet) {
            treeMap.put(n3, n++);
        }
        this.communityMatrix = new SparseDoubleMatrix2D(n2, treeSet.size());
        boolean bl = false;
        while (var7_10 < n2) {
            arrayList2 = arrayList.get((int)var7_10);
            double d = 1.0 / (double)arrayList2.size();
            for (Integer n4 : arrayList2) {
                int n5 = (Integer)treeMap.get(n4);
                double d2 = this.communityMatrix.get((int)var7_10, n5) + d;
                this.communityMatrix.set((int)var7_10, n5, d2);
            }
            ++var7_10;
        }
    }
}

