/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.VertexPartition;
import TimGraph.timgraph;
import TimUtilities.Permutation;
import TimUtilities.UpdateRecord;
import java.util.Random;

public class SimulatedAnnealingvertexPartition
extends VertexPartition {
    private static int MAXSWEEPS = 5;
    public static final String SIMANNAME = "SimAn";
    private Permutation edgePerm;
    private Permutation vertexPerm;
    private UpdateRecord updateRecord;
    private Random Rnd;
    private double bestQuality = -9876543.21;
    private int[] bestcommunityOfElement;
    private int maxCommunities;
    private int level = -987123456;

    public SimulatedAnnealingvertexPartition(timgraph timgraph2) {
        this.name = SIMANNAME;
        this.initialise(timgraph2);
        this.maxCommunities = timgraph2.getNumberVertices();
        this.Rnd = new Random();
    }

    public SimulatedAnnealingvertexPartition(timgraph timgraph2, int n) {
        this.initialise(timgraph2, 0, 1, 1.0, n);
        this.maxCommunities = n < 2 ? this.numberElements : n;
        this.Rnd = new Random();
    }

    public SimulatedAnnealingvertexPartition(timgraph timgraph2, int n, int n2, int n3, int n4, int n5, double d) {
        this.initialise(timgraph2, n, n2, d, n4);
        this.name = SIMANNAME + this.quality.QdefinitionShortString();
        this.maxCommunities = Math.max(n5, this.getNumberCommunities());
        this.infoLevel = n3;
        this.Rnd = new Random();
    }

    public SimulatedAnnealingvertexPartition(timgraph timgraph2, int n, int n2, double d, int n3, int n4) {
        this.initialise(timgraph2, n, n2, d, n4);
        this.name = SIMANNAME + this.quality.QdefinitionShortString();
        this.maxCommunities = n4 < 2 ? this.numberElements : n4;
        this.infoLevel = n3;
        this.Rnd = new Random();
    }

    public void calculateRecursively(int n, double d, boolean bl) {
        this.calcQuality();
        this.calculateRecursively(0, n, d, bl);
    }

    private void calculateRecursively(int n, int n2, double d, boolean bl) {
        this.level = n;
        if (this.infoLevel > 0) {
            System.out.println("--- recursion level " + this.level);
        }
        if (this.infoLevel > 2) {
            this.graph.printVertices(System.out, false, false, true);
        }
        if (this.infoLevel > 1) {
            this.graph.printEdges();
        }
        this.calculateBestGreedyCommunity(MAXSWEEPS);
        boolean bl2 = true;
        this.relabelCommunities(bl2);
        this.calcQuality();
        if (this.infoLevel > 0) {
            System.out.println("Number vertices = " + this.graph.getNumberVertices() + ", number communities = " + this.getNumberOfCommunities() + ", quality = " + this.getQuality());
        }
        if (this.infoLevel > 1) {
            this.printCommunityMatrix(System.out, " ", " , ");
        }
        if (this.graph.getNumberVertices() > this.getNumberOfCommunities()) {
            timgraph timgraph2 = new timgraph(this.graph, this.communityOfElement, this.numberCommunities, false, false);
            SimulatedAnnealingvertexPartition simulatedAnnealingvertexPartition = new SimulatedAnnealingvertexPartition(timgraph2, this.quality.Qdefinition, this.quality.getQualityTypeNumber(), this.quality.lambda, this.infoLevel, -1);
            simulatedAnnealingvertexPartition.calculateRecursively(n + 1, n2, d, bl);
            if (simulatedAnnealingvertexPartition.getQuality() > this.getQuality()) {
                this.setQuality(simulatedAnnealingvertexPartition.getQuality());
                for (int i = 0; i < this.numberElements; ++i) {
                    this.communityOfElement[i] = simulatedAnnealingvertexPartition.getCommunity(this.communityOfElement[i]);
                }
            }
        }
    }

    public void calc(int n, double d) {
        this.calc(n, d, false);
    }

    public void calc(int n, double d, boolean bl) {
        int n2;
        this.bestcommunityOfElement = new int[this.numberElements];
        this.updateBestCommunity();
        this.bestQuality = this.quality.calc(this.bestcommunityOfElement);
        double d2 = d;
        this.edgePerm = new Permutation(this.numberEdges);
        this.vertexPerm = new Permutation(this.numberElements);
        double d3 = 0.0;
        double d4 = 1.0 / (double)this.numberElements;
        double d5 = d4 / 1.8;
        double d6 = 1.0 + 1.0 / (double)this.numberElements;
        boolean bl2 = true;
        double d7 = -9.7531E86;
        int n3 = 10;
        System.out.println("Initial Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
        for (n2 = 0; n2 < n; ++n2) {
            this.updateRecord = new UpdateRecord();
            d3 = this.oneEdgeSweep(d2, 10);
            double d8 = this.updateRecord.getTotalFractionMade();
            if (this.bestQuality != d7) {
                d7 = this.bestQuality;
                n3 = 10;
            }
            if (this.infoLevel > 0) {
                System.out.println("beta = " + d2 + " Sweep " + n2 + " count to stop " + n3 + " Best Quality " + this.bestQuality + ", Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", Quality change " + d3 + ", % changed = " + d8);
            }
            if (--n3 < 0) {
                if (!bl2) break;
                bl2 = false;
            } else {
                bl2 = true;
            }
            d2 = d8 > 0.5 ? (d2 *= 2.0) : (d2 *= d6);
            if (!bl) continue;
            this.selectBestCommunity();
            this.calculateBestGreedyCommunity(5);
        }
        if (!bl) {
            this.selectBestCommunity();
            this.calculateBestGreedyCommunity(5);
        }
        n2 = 1;
        this.relabelCommunities(n2 != 0);
        System.out.println("Final Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", greedy improvements " + this.greedyUpdateRecord.toString());
    }

    private double oneEdgeSweep(double d, int n) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        double d4 = 0.0;
        int n7 = -1;
        int n8 = -1;
        for (int i = 0; i < n; ++i) {
            n3 = 0;
            n4 = 0;
            this.edgePerm.newPermutation();
            while (this.edgePerm.hasMore()) {
                ++n3;
                n8 = this.edgePerm.next();
                n5 = this.graph.getVertexFromEdge(n8);
                n2 = this.communityOfElement[n5];
                while ((n7 = this.Rnd.nextInt(this.maxCommunities)) == n2) {
                }
                d4 = this.quality.delta(n5, n7, this.communityOfElement) - this.quality.delta(n5, n2, this.communityOfElement);
                if (!(d4 > 0.0) && !(Math.exp(d * d4) > this.Rnd.nextDouble())) continue;
                d2 += d4;
                this.communityOfElement[n5] = n7;
                if (d2 > d3) {
                    this.updateBestCommunity();
                    d3 = d2;
                }
                ++n4;
            }
            if (n3 >= n4 * 2) continue;
        }
        this.updateRecord.update(n3, n4);
        this.selectBestCurrentCommunity();
        return d2;
    }

    private double oneVertexSweep(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        this.vertexPerm.newPermutation();
        int n4 = -1;
        double d4 = 0.0;
        while (this.vertexPerm.hasMore()) {
            ++n;
            n4 = this.vertexPerm.next();
            d4 = -this.quality.delta(n4, n3 = this.communityOfElement[n4], this.communityOfElement);
            if (!(d4 > 0.0) && !(Math.exp(d * d4) > this.Rnd.nextDouble())) continue;
            d2 += d4;
            this.communityOfElement[n4] = this.getEmptyCommunity();
            if (d2 > d3) {
                this.updateBestCommunity();
                d3 = d2;
            }
            ++n2;
        }
        this.updateRecord.update(n, n2);
        this.selectBestCurrentCommunity();
        return d2;
    }

    private void selectBestCurrentCommunity() {
        this.recalculateCommunityLabels();
        double d = this.quality.calc(this.communityOfElement);
        if (this.bestQuality > d) {
            d = this.bestQuality;
            for (int i = 0; i < this.numberElements; ++i) {
                this.communityOfElement[i] = this.bestcommunityOfElement[i];
            }
        } else {
            this.bestQuality = d;
            this.updateBestCommunity();
        }
    }

    private void selectBestCommunity() {
        this.recalculateCommunityLabels();
        double d = this.quality.calc(this.communityOfElement);
        if (this.bestQuality > d) {
            for (int i = 0; i < this.numberElements; ++i) {
                this.bestcommunityOfElement[i] = this.communityOfElement[i];
            }
        }
    }

    private void updateBestCommunity() {
        for (int i = 0; i < this.numberElements; ++i) {
            this.bestcommunityOfElement[i] = this.communityOfElement[i];
        }
    }
}

