/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;
import java.io.PrintStream;

public class QualityLineGraph {
    static final QualityType basicType = new QualityType("DM");
    protected double[][] QMatrix;
    protected int numberVertices;
    protected int Qdefinition = -124578;
    protected QualityType qualityType;
    protected double lambda = -985421.0;
    public static final String[] QdefinitionString = new String[]{"Basic Newman", "(A^2-A)"};
    public static final String[] QdefinitionShortString = new String[]{"QS", "QA2mA"};
    public static final int QSindex = 0;
    public static final int QA2mAindex = 1;
    public int infoLevel = 0;

    public QualityLineGraph() {
        this.setQualityType();
    }

    public QualityLineGraph(timgraph timgraph2, int n, double d, int n2) {
        this.infoLevel = n2;
        this.setQualityType();
        this.Qdefinition = n;
        this.setNullModelScaling(d);
        this.initialiseAdjacencyMatrix(timgraph2);
    }

    public void initialiseAdjacencyMatrix(timgraph timgraph2) {
        AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(timgraph2, this.Qdefinition);
        this.numberVertices = adjacencyMatrix.dimension();
        adjacencyMatrix.calculateInOutVectors();
        this.QMatrix = new double[this.numberVertices][this.numberVertices];
        if (this.infoLevel > 0) {
            System.out.println("Total Weight = " + adjacencyMatrix.totalWeight());
        }
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                this.QMatrix[i][j] = (adjacencyMatrix.get(i, j) - this.lambda * adjacencyMatrix.getInStrength(i) * adjacencyMatrix.getOutStrength(j) / adjacencyMatrix.totalWeight()) / adjacencyMatrix.totalWeight();
            }
        }
    }

    public double check() {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                d += this.get(i, j);
            }
        }
        return d;
    }

    public double get(int n, int n2) {
        return this.QMatrix[n][n2];
    }

    public double delta(int n, int n2, int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            if (nArray[i] != n2 || n == i) continue;
            d += this.get(n, i) + this.get(i, n);
        }
        return d;
    }

    public double calc(double[][] dArray, int n) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                for (int k = 0; k < n; ++k) {
                    d += this.get(i, j) * dArray[i][k] * dArray[j][k];
                }
            }
        }
        return d;
    }

    public double calc(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            int n = nArray[i];
            for (int j = 0; j < this.numberVertices; ++j) {
                if (nArray[j] != n) continue;
                d += this.get(i, j);
            }
        }
        return d;
    }

    public double calcNoTadpoles(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            int n = nArray[i];
            for (int j = 0; j < this.numberVertices; ++j) {
                if (nArray[j] != n || i == j) continue;
                d += this.get(i, j);
            }
        }
        return d;
    }

    public double calcTrace() {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            d += this.get(i, i);
        }
        return d;
    }

    public double getNullModelScaling() {
        return this.lambda;
    }

    public void setNullModelScaling(double d) {
        this.lambda = d;
    }

    protected void setQualityType() {
        this.qualityType = basicType;
    }

    public String getQualityTypeDescription() {
        return this.qualityType.toLongString();
    }

    public int getQualityTypeNumber() {
        return this.qualityType.getNumber();
    }

    public String Qdefinition(String string) {
        if (this.lambda == 1.0) {
            return QualitySparse.QdefinitionString[this.Qdefinition];
        }
        return QualitySparse.QdefinitionString[this.Qdefinition] + string + "lambda=" + this.lambda;
    }

    public String Qdefinition() {
        return this.Qdefinition("_");
    }

    public String QdefinitionShortString() {
        if (this.lambda == 1.0) {
            return QualitySparse.QdefinitionShortString[this.Qdefinition];
        }
        int n = (int)(this.lambda * 1000.0);
        return QualitySparse.QdefinitionShortString[this.Qdefinition] + n;
    }

    public void printMatrix(PrintStream printStream, String string, boolean bl) {
        int n;
        if (bl) {
            printStream.print("[s]/[t]");
            for (n = 0; n < this.numberVertices; ++n) {
                printStream.print(string + n);
            }
            printStream.println();
        }
        for (n = 0; n < this.numberVertices; ++n) {
            if (bl) {
                printStream.print(n);
            }
            for (int i = 0; i < this.numberVertices; ++i) {
                printStream.print(string + this.get(n, i));
            }
            printStream.println();
        }
    }
}

