/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.Quality;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;

public class QualityEquilibrium
extends Quality {
    static final QualityType sparseType = new QualityType("SM");
    AdjacencyMatrix AMatrix;

    public QualityEquilibrium(timgraph timgraph2, int n, double d, int n2) {
        this.infoLevel = n2;
        this.setQualityType();
        this.Qdefinition = n;
        this.setNullModelScaling(d);
        this.initialiseAdjacencyMatrix(timgraph2);
        if (this.infoLevel > 0) {
            this.AMatrix.check();
        }
        if (this.infoLevel > 0) {
            this.AMatrix.printMatrix(" ", true);
        }
        if (this.infoLevel > 0) {
            System.out.println("Check Quality Matrix = " + this.check());
        }
    }

    public void initialiseAdjacencyMatrix(timgraph timgraph2) {
        this.AMatrix = new AdjacencyMatrix(timgraph2, this.Qdefinition);
        this.numberVertices = this.AMatrix.dimension();
        this.AMatrix.calculateInOutVectors();
        if (this.infoLevel > 0) {
            System.out.println("Total Weight = " + this.AMatrix.totalWeight());
        }
    }

    public double get(int n, int n2) {
        double d = -1.0;
        double d2 = this.nullModelSwitch == 4 ? 1.0 : this.AMatrix.totalWeight() * this.AMatrix.totalWeight();
        switch (this.nullModelSwitch) {
            case 4: {
                d = this.AMatrix.getNormalisedPi(n) * this.AMatrix.getNormalisedPi(n2);
                break;
            }
            case 3: {
                d = this.AMatrix.getInStrength(n) * this.AMatrix.getInStrength(n2) / d2;
                break;
            }
            case 2: {
                d = this.AMatrix.getOutStrength(n) * this.AMatrix.getInStrength(n2) / d2;
                break;
            }
            case 1: {
                d = this.AMatrix.getInStrength(n) * this.AMatrix.getOutStrength(n2) / d2;
                break;
            }
            default: {
                d = this.AMatrix.getOutStrength(n) * this.AMatrix.getOutStrength(n2) / d2;
            }
        }
        return (this.AMatrix.get(n, n2) / this.AMatrix.totalWeight() - this.lambda * d) / this.AMatrix.totalWeight();
    }

    protected void setQualityType() {
        this.qualityType = sparseType;
    }
}

