/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.AdjacencyMatrix;
import TimGraph.Community.QualitySparse;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.io.PrintStream;

public class Quality {
    static final QualityType basicType = new QualityType("DM");
    protected DoubleMatrix2D QMatrix;
    protected int numberVertices;
    protected int Qdefinition = -124578;
    protected QualityType qualityType;
    protected boolean equilibrium = true;
    protected int nullModelSwitch = 0;
    public static final String[] nullModelString = new String[]{"in-in", "in-out", "out-in", "out-out", "Pi-Pi"};
    protected double lambda = -985421.0;
    public static final String[] QdefinitionString = new String[]{"Basic Newman", "(A^2-A)"};
    public static final String[] QdefinitionShortString = new String[]{"QS", "QA2mA"};
    public static final int QSindex = 0;
    public static final int QA2mAindex = 1;
    public int infoLevel = 0;

    public Quality() {
        this.setQualityType();
    }

    public Quality(timgraph timgraph2, int n, double d, int n2) {
        this.initialisePreAdjacencyMatrix(timgraph2, n, d, n2);
        this.initialiseAdjacencyMatrix(timgraph2);
        if (this.infoLevel > 0) {
            System.out.println("Check Quality Matrix = " + this.check());
        }
    }

    public void initialisePreAdjacencyMatrix(timgraph timgraph2, int n, double d, int n2) {
        this.infoLevel = n2;
        this.setQualityType();
        this.Qdefinition = n;
        this.setNullModelScaling(d);
        this.nullModelSwitch = timgraph2.isDirected() ? 4 : 0;
    }

    public void initialiseAdjacencyMatrix(timgraph timgraph2) {
        AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(timgraph2, this.Qdefinition);
        this.numberVertices = adjacencyMatrix.dimension();
        adjacencyMatrix.calculateInOutVectors();
        if (this.nullModelSwitch == 4) {
            adjacencyMatrix.calculatePiVector();
        }
        this.QMatrix = new SparseDoubleMatrix2D(this.numberVertices, this.numberVertices);
        if (this.infoLevel > 0) {
            System.out.println("Total Weight = " + adjacencyMatrix.totalWeight());
        }
        double d = -1.0;
        double d2 = -1.0;
        double d3 = this.nullModelSwitch == 4 ? 1.0 : adjacencyMatrix.totalWeight() * adjacencyMatrix.totalWeight();
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                switch (this.nullModelSwitch) {
                    case 4: {
                        d = adjacencyMatrix.getNormalisedPi(i) * adjacencyMatrix.getNormalisedPi(j);
                        break;
                    }
                    case 3: {
                        d = adjacencyMatrix.getInStrength(i) * adjacencyMatrix.getInStrength(j) / d3;
                        break;
                    }
                    case 2: {
                        d = adjacencyMatrix.getOutStrength(i) * adjacencyMatrix.getInStrength(j) / d3;
                        break;
                    }
                    case 1: {
                        d = adjacencyMatrix.getInStrength(i) * adjacencyMatrix.getOutStrength(j) / d3;
                        break;
                    }
                    default: {
                        d = adjacencyMatrix.getOutStrength(i) * adjacencyMatrix.getOutStrength(j) / d3;
                    }
                }
                d2 = adjacencyMatrix.get(i, j) / adjacencyMatrix.totalWeight() - this.lambda * d;
                this.QMatrix.set(i, j, d2);
            }
        }
    }

    public double check() {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                d += this.get(i, j);
            }
        }
        return d;
    }

    public double get(int n, int n2) {
        return this.QMatrix.get(n, n2);
    }

    public double getLambda() {
        return this.lambda;
    }

    public double delta(int n, int n2, int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            if (nArray[i] != n2 || n == i) continue;
            d += this.get(n, i) + this.get(i, n);
        }
        return d;
    }

    public double calc(double[][] dArray, int n) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                for (int k = 0; k < n; ++k) {
                    d += this.get(i, j) * dArray[i][k] * dArray[j][k];
                }
            }
        }
        return d;
    }

    public double calc(DoubleMatrix2D doubleMatrix2D, int n) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            for (int j = 0; j < this.numberVertices; ++j) {
                for (int k = 0; k < n; ++k) {
                    d += this.get(i, j) * doubleMatrix2D.get(i, k) * doubleMatrix2D.get(j, k);
                }
            }
        }
        return d;
    }

    public double calc(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            int n = nArray[i];
            for (int j = 0; j < this.numberVertices; ++j) {
                if (nArray[j] != n) continue;
                d += this.get(i, j);
            }
        }
        return d;
    }

    public double calcNoTadpoles(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            int n = nArray[i];
            for (int j = 0; j < this.numberVertices; ++j) {
                if (nArray[j] != n || i == j) continue;
                d += this.get(i, j);
            }
        }
        return d;
    }

    public double calcTrace() {
        double d = 0.0;
        for (int i = 0; i < this.numberVertices; ++i) {
            d += this.get(i, i);
        }
        return d;
    }

    public double getNullModelScaling() {
        return this.lambda;
    }

    public void setNullModelScaling(double d) {
        this.lambda = d;
    }

    public void setNullModelSwitch(int n) {
        if (n < 0 || n >= nullModelString.length) {
            System.err.println("!!! null model unchanged, model number " + n + " invalid, must be between 0 and " + nullModelString.length);
        }
        this.nullModelSwitch = n;
    }

    public int getNullModelSwitch() {
        return this.nullModelSwitch;
    }

    public String getNullModelDescription() {
        return nullModelString[this.nullModelSwitch];
    }

    protected void setQualityType() {
        this.qualityType = basicType;
    }

    public String getQualityTypeDescription() {
        return this.qualityType.toLongString();
    }

    public int getQualityTypeNumber() {
        return this.qualityType.getNumber();
    }

    public String Qdefinition(String string) {
        if (this.lambda == 1.0) {
            return QualitySparse.QdefinitionString[this.Qdefinition];
        }
        return QualitySparse.QdefinitionString[this.Qdefinition] + string + this.getNullModelDescription() + string + "lambda=" + this.lambda;
    }

    public String Qdefinition() {
        return this.Qdefinition("_");
    }

    public String QdefinitionShortString() {
        long l = Math.round(this.lambda * 1000.0);
        return QualitySparse.QdefinitionShortString[this.Qdefinition] + this.getNullModelDescription() + l;
    }

    public void printMatrixOLD(PrintStream printStream, String string, boolean bl) {
        int n;
        if (bl) {
            printStream.print("[s]/[t]");
            for (n = 0; n < this.numberVertices; ++n) {
                printStream.print(string + n);
            }
            printStream.println();
        }
        for (n = 0; n < this.numberVertices; ++n) {
            if (bl) {
                printStream.print(n);
            }
            for (int i = 0; i < this.numberVertices; ++i) {
                printStream.print(string + this.get(n, i));
            }
            printStream.println();
        }
    }

    public void printMatrix(PrintStream printStream, String string, boolean bl) {
        int n;
        String string2 = "%6.3f";
        String string3 = "%6d";
        if (bl) {
            printStream.print("      " + string);
            for (n = 0; n < this.numberVertices; ++n) {
                printStream.print(String.format(string3, n) + string);
            }
            printStream.println();
        }
        for (n = 0; n < this.numberVertices; ++n) {
            if (bl) {
                printStream.print(String.format(string3, n) + string);
            }
            for (int i = 0; i < this.numberVertices; ++i) {
                printStream.print(String.format(string2, this.get(n, i)) + string);
            }
            printStream.println();
        }
    }
}

