/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import DataAnalysis.IntegerSequence;
import TimGraph.Community.Community;
import TimGraph.io.FileInput;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;

public class Partition
extends Community {
    private Random Rnd = new Random();
    protected int[] communityOfElement;
    protected int nextCommunityLabel = -987123456;
    protected TreeSet<Integer> communityLabels;
    int[] localLabel;
    boolean statisticsCalculated = false;
    protected int[] numberElementsArray;
    protected IntegerSequence communityStatistics;

    public Partition() {
        this.name = "generalP";
    }

    public Partition(int n) {
        this.name = "generalP";
        this.numberElements = n;
        this.communityOfElement = new int[this.numberElements];
    }

    public Partition(String string, int n) {
        this.name = string;
        this.numberElements = n;
        this.communityOfElement = new int[this.numberElements];
    }

    public Partition(double d, int n, int[] nArray) {
        this.name = "generalP" + this.quality.QdefinitionShortString();
        this.Q = d;
        this.numberElements = n;
        this.communityOfElement = new int[this.numberElements];
        this.setCommunity(nArray);
    }

    protected void setNumberElements(int n) {
        this.numberElements = n;
        this.communityOfElement = new int[this.numberElements];
    }

    public void individualCommunity() {
        this.communityLabels = new TreeSet();
        this.communityOfElement = new int[this.numberElements];
        for (int i = 0; i < this.numberElements; ++i) {
            this.communityOfElement[i] = i;
            this.communityLabels.add(i);
        }
        this.nextCommunityLabel = this.numberElements;
        this.statisticsCalculated = false;
        this.numberCommunities = this.numberElements;
    }

    public void setCommunity(int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (n < 0) {
            bl = true;
        } else if (n > 1) {
            bl2 = true;
        }
        this.communityLabels = new TreeSet();
        this.communityOfElement = new int[this.numberElements];
        int n2 = 0;
        for (int i = 0; i < this.numberElements; ++i) {
            if (bl2) {
                n2 = this.Rnd.nextInt(n);
            }
            if (bl) {
                n2 = i;
            }
            this.communityOfElement[i] = n2;
            this.communityLabels.add(n2);
        }
        this.nextCommunityLabel = this.communityLabels.last() + 1;
        this.statisticsCalculated = false;
        this.numberCommunities = this.communityLabels.size();
    }

    public void oneCommunity() {
        this.communityLabels = new TreeSet();
        this.communityOfElement = new int[this.numberElements];
        this.communityLabels.add(0);
        for (int i = 0; i < this.numberElements; ++i) {
            this.communityOfElement[i] = 0;
        }
        this.nextCommunityLabel = this.numberElements;
        this.statisticsCalculated = false;
        this.numberCommunities = 0;
    }

    public int hasNegativeCommunityLabels() {
        for (int i = 0; i < this.numberElements; ++i) {
            if (this.communityOfElement[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    public void relabelCommunities(boolean bl) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        this.communityLabels = new TreeSet();
        int n = -1;
        Integer n2 = n;
        int n3 = 0;
        for (int i = 0; i < this.numberElements; ++i) {
            n = this.communityOfElement[i];
            if (bl && n < 0) continue;
            n2 = (Integer)treeMap.get(n);
            if (n2 == null) {
                n2 = n3++;
                treeMap.put(n, n2);
                this.communityLabels.add(n2);
            }
            this.communityOfElement[i] = n2;
        }
        this.numberCommunities = n3;
    }

    public int recalculateCommunityLabels() {
        this.communityLabels = new TreeSet();
        for (int i = 0; i < this.numberElements; ++i) {
            int n = this.communityOfElement[i];
            if (n < 0) continue;
            this.communityLabels.add(n);
        }
        this.numberCommunities = this.communityLabels.size();
        return this.numberCommunities;
    }

    public double calcQuality() {
        this.Q = this.quality.calc(this.communityOfElement);
        return this.Q;
    }

    public double delta(int n, int n2) {
        return this.quality.delta(n, n2, this.communityOfElement);
    }

    public int getNumberElementsInCommunityFast(int n) {
        return this.numberElementsArray[n];
    }

    public int getNumberElementsInCommunity(int n) {
        if (this.numberElementsArray == null) {
            this.analyse();
        }
        return this.numberElementsArray[n];
    }

    public int getNumberOfCommunities() {
        if (this.numberCommunities < 1) {
            this.recalculateCommunityLabels();
        }
        return this.numberCommunities;
    }

    public int getEmptyCommunity() {
        return this.nextCommunityLabel++;
    }

    public int[] getCommunity() {
        return this.communityOfElement;
    }

    public int getCommunity(int n) {
        return this.communityOfElement[n];
    }

    public int getCommunitySize(int n) {
        return this.getNumberElementsInCommunity(this.communityOfElement[n]);
    }

    public double getCommunityMembership(int n, int n2) {
        return this.communityOfElement[n] == n2 ? 1 : 0;
    }

    public void setCommunity(int[] nArray) {
        for (int i = 0; i < this.numberElements; ++i) {
            this.communityOfElement[i] = nArray[i];
        }
    }

    public void setCommunity(int n, int n2) {
        this.communityOfElement[n] = n2;
    }

    public void setCommunityLocalLabel() {
        int[] nArray = new int[this.numberCommunities];
        this.localLabel = new int[this.numberElements];
        for (int i = 0; i < this.numberElements; ++i) {
            int n;
            int n2 = n = this.communityOfElement[i];
            nArray[n2] = nArray[n2] + 1;
        }
    }

    public int getCommunityLocalLabel(int n) {
        return this.localLabel[n];
    }

    public IntegerSequence calculateCommunityStatistics() {
        int n = 3;
        int n2 = 3;
        int n3 = 7;
        if (this.numberElementsArray == null) {
            this.analyse();
        }
        this.communityStatistics = new IntegerSequence(n, n2, n3);
        this.communityStatistics.calcStats(this.numberElementsArray);
        return this.communityStatistics;
    }

    public IntegerSequence getCommunityStatistics() {
        return this.communityStatistics;
    }

    public double getEntropy() {
        if (this.communityStatistics == null) {
            this.calculateCommunityStatistics();
        }
        return this.communityStatistics.getEntropy();
    }

    public double getF2() {
        if (this.communityStatistics == null) {
            this.calculateCommunityStatistics();
        }
        return this.communityStatistics.getF(2);
    }

    public boolean setNumberCommunities() {
        this.numberCommunities = -1;
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < this.numberElements; ++i) {
            n = this.communityOfElement[i];
            if (this.numberCommunities < n) {
                this.numberCommunities = n;
            }
            if (n >= 0) continue;
            bl = true;
        }
        ++this.numberCommunities;
        return bl;
    }

    public void analyse() {
        int n = -1;
        this.numberElementsArray = new int[this.numberCommunities];
        for (int i = 0; i < this.numberElements; ++i) {
            int n2 = n = this.communityOfElement[i];
            this.numberElementsArray[n2] = this.numberElementsArray[n2] + 1;
        }
    }

    public void printStatistics(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        this.analyse();
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
            if (this.communityStatistics == null) {
                this.calculateCommunityStatistics();
            }
            printStream.println(this.communityStatistics.labelString(string2));
            printStream.println(this.communityStatistics.toString(string2));
        }
        if (bl2) {
            printStream.print(string + "Community" + string2 + "N_C");
        }
        for (int i = 0; i < this.numberCommunities; ++i) {
            printStream.println(i + string2 + this.numberElementsArray[i]);
        }
    }

    public int readPajekPartition(String string, boolean bl) {
        String string2 = "*";
        int n = -1;
        int n2 = 1;
        boolean bl2 = true;
        return this.readIntPartition(string, n, n2, bl2, string2, bl);
    }

    public int readIntPartition(String string, int n, int n2, boolean bl, boolean bl2) {
        String string2 = "";
        return this.readIntPartition(string, n, n2, bl, string2, bl2);
    }

    public int readIntPartition(String string, int n, int n2, boolean bl, String string2, boolean bl2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        FileInput.readIntIndexLabelList(string, n, n2, arrayList, arrayList2, bl, string2, this.infoLevel);
        if (arrayList.size() != arrayList2.size()) {
            System.err.println("Two lists have different sizes");
            return -1;
        }
        if (this.communityOfElement == null || this.communityOfElement.length != arrayList.size()) {
            System.out.println("!!! Number of elements is being reset to number found " + arrayList.size());
            this.numberElements = arrayList.size();
            this.communityOfElement = new int[this.numberElements];
        }
        Iterator<Integer> iterator = arrayList.iterator();
        Iterator<Integer> iterator2 = arrayList2.iterator();
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        while (iterator.hasNext()) {
            n3 = iterator.next();
            if (n3 < 0 || n3 >= this.communityOfElement.length) {
                throw new RuntimeException("In index of element incorrect, value was " + n3);
            }
            n4 = iterator2.next();
            this.setCommunity(n3, n4);
            if (n4 <= n5) continue;
            n5 = n4;
        }
        this.numberCommunities = n5 + 1;
        boolean bl3 = false;
        if (bl2) {
            this.relabelCommunities(bl3);
        }
        return arrayList.size();
    }

    public int readStringPartition(String string, int n, int n2, boolean bl) {
        FileInput fileInput = new FileInput(this.infoLevel);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        fileInput.readStringIndexLabelList(string, n, n2, arrayList, arrayList2, true);
        if (arrayList.size() != arrayList2.size()) {
            System.err.println("Two lists have different sizes");
            return -1;
        }
        Iterator<String> iterator = arrayList.iterator();
        Iterator<String> iterator2 = arrayList2.iterator();
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        this.communityLabels = new TreeSet();
        int n3 = -1;
        String string2 = "";
        Integer n4 = -1;
        int n5 = 0;
        while (iterator.hasNext()) {
            n3 = Integer.parseInt(iterator.next());
            if (n3 < 0 || n3 >= this.communityOfElement.length) {
                throw new RuntimeException("In index of element incorrect, value was " + n3);
            }
            string2 = iterator2.next();
            n4 = (Integer)treeMap.get(string2);
            if (n4 == null) {
                n4 = n5++;
                treeMap.put(string2, n4);
                this.communityLabels.add(n4);
            }
            this.communityOfElement[n3] = n4;
        }
        this.numberCommunities = n5;
        return arrayList.size();
    }

    public void printCommunityBipartiteGraph(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
            printStream.print(string);
            if (bl2) {
                printStream.print(this.nameOfElements + string2);
            }
            printStream.println("Label");
        }
        for (int i = 0; i < this.numberElements; ++i) {
            printStream.print(string);
            if (bl2) {
                printStream.print(i + string2);
            }
            printStream.println(this.communityOfElement[i]);
        }
    }
}

