/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.VertexPartition;
import TimGraph.algorithms.Projections;
import TimGraph.timgraph;

public class LouvainVertexPartition
extends VertexPartition {
    private static int MAXSWEEPS = 100;
    private int level = -987123456;

    public LouvainVertexPartition(timgraph timgraph2, int n, int n2, int n3) {
        this.initialise(timgraph2, n, n2, true);
        this.infoLevel = n3;
        this.name = "Louvain" + this.quality.QdefinitionShortString();
    }

    public LouvainVertexPartition(timgraph timgraph2, int n, int n2, double d, int n3, int n4) {
        this.infoLevel = n3;
        this.initialise(timgraph2, n, n2, d, n4);
        this.name = "Louvain" + this.quality.QdefinitionShortString();
    }

    public void calculate() {
        this.calcQuality();
        this.calculate(0);
    }

    private void calculate(int n) {
        this.level = n;
        if (this.infoLevel > 0) {
            System.out.println("--- recursion level " + this.level);
        }
        if (this.infoLevel > 2) {
            this.graph.printVertices(System.out, true, true, true);
        }
        if (this.infoLevel > 1) {
            this.graph.printEdges();
        }
        this.calculateBestGreedyCommunity(MAXSWEEPS);
        boolean bl = false;
        this.relabelCommunities(bl);
        this.calcQuality();
        if (this.infoLevel > 0) {
            System.out.println("Number vertices = " + this.graph.getNumberVertices() + ", number communities = " + this.getNumberOfCommunities() + ", quality = " + this.getQuality());
        }
        if (this.infoLevel > 1) {
            this.printCommunityMatrix(System.out, " ", " , ");
        }
        if (this.graph.getNumberVertices() > this.getNumberOfCommunities()) {
            timgraph timgraph2 = Projections.ontoVertexPartition(this.graph.inputName.getNameRoot() + "!", this.graph, this.communityOfElement, this.numberCommunities, false, false);
            LouvainVertexPartition louvainVertexPartition = new LouvainVertexPartition(timgraph2, this.quality.Qdefinition, this.quality.getQualityTypeNumber(), this.quality.lambda, this.infoLevel, -1);
            louvainVertexPartition.calculate(n + 1);
            if (louvainVertexPartition.getQuality() > this.getQuality()) {
                this.setQuality(louvainVertexPartition.getQuality());
                for (int i = 0; i < this.numberElements; ++i) {
                    this.communityOfElement[i] = louvainVertexPartition.getCommunity(this.communityOfElement[i]);
                }
            }
        }
    }
}

