/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import TimGraph.Community.Partition;
import TimGraph.timgraph;
import TimUtilities.Permutation;
import TimUtilities.UpdateRecord;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;

public class EdgePartition
extends Partition {
    private Random Rnd = new Random();
    int verticessInEP = -1;
    private Permutation perm;
    protected UpdateRecord greedyUpdateRecord;

    public EdgePartition() {
        this.name = "generalEP";
    }

    public EdgePartition(timgraph timgraph2) {
        this.name = "general";
        this.initialise(timgraph2);
    }

    public EdgePartition(int n) {
        this.setDefaultNames();
        this.setNumberElements(n);
    }

    public EdgePartition(String string, int n) {
        this.setDefaultNames();
        this.setNumberElements(n);
    }

    public EdgePartition(double d, int n, int n2, int[] nArray) {
        this.setDefaultNames();
        this.name = this.name + this.quality.QdefinitionShortString();
        this.Q = d;
        this.setNumberElements(n2);
        this.setCommunity(nArray);
    }

    private void setDefaultNames() {
        this.name = "generalEP";
        this.nameOfElements = "edges";
    }

    public void initialise(timgraph timgraph2) {
        this.initialise(timgraph2, 0, 1, true);
    }

    public void initialise(timgraph timgraph2, int n, int n2, boolean bl) {
        this.initialise(timgraph2, n, n2, 1.0, bl ? 0 : -1);
    }

    public void initialise(timgraph timgraph2, int n, int n2, int n3) {
        this.initialise(timgraph2, n, n2, 1.0, n3);
    }

    public void initialise(timgraph timgraph2, int n, int n2, double d, int n3) {
        this.initialiseGraph(timgraph2, n, n2, d);
        this.numberElements = this.graph.getNumberDistinctEdges();
        if (this.infoLevel > 1 && this.numberElements < 21) {
            this.quality.printMatrix(System.out, " ", true);
        }
        this.setCommunity(n3);
        this.Q = -9.87123456E8;
    }

    public int calculateBestGreedyCommunity(int n) {
        this.perm = new Permutation(this.numberElements);
        if (!this.graph.isVertexEdgeListOn()) {
            this.graph.createVertexGlobalEdgeList();
        }
        this.greedyUpdateRecord = new UpdateRecord();
        if (this.infoLevel > 1) {
            System.out.println("Initial Quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities());
        }
        for (int i = 0; i < n; ++i) {
            double d = this.oneGreedySweep();
            if (this.infoLevel > 1) {
                this.recalculateCommunityLabels();
                System.out.println("Greedy Sweep " + i + ", quality " + this.calcQuality() + ", number of communities " + this.getNumberOfCommunities() + ", Quality change " + d + ", " + this.greedyUpdateRecord.toString());
            }
            if (this.greedyUpdateRecord.getMade() == 0) break;
        }
        return this.greedyUpdateRecord.getMade();
    }

    private double oneGreedySweep() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        double d2 = 0.0;
        int n3 = -1;
        this.perm.newPermutation();
        int n4 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n5 = -1;
        for (int i = 0; i < this.graph.getNumberStubs(); ++i) {
            int n6;
            n4 = this.perm.next();
            int n7 = this.graph.isDirected() ? n4 : n4 << 1;
            n3 = this.communityOfElement[n4];
            d2 = -this.quality.delta(n4, n3, this.communityOfElement);
            if (d2 > 0.0) {
                n5 = -86421357;
                d4 = d2;
            } else {
                d4 = 0.0;
                n5 = n3;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            int n8 = this.graph.isDirected() ? n7 + 1 : n7 + 2;
            for (int j = n7; j < n8; ++j) {
                n6 = this.graph.getVertexFromEdge(j);
                int n9 = this.graph.getVertexOutDegree(n6);
                for (int k = 0; k < n9; ++k) {
                    int n10 = this.graph.getEdge(n6, k);
                    if (n10 == k) continue;
                    int n11 = this.communityOfElement[n10];
                    treeSet.add(n11);
                }
            }
            if (treeSet.size() == 0) continue;
            Iterator iterator = treeSet.iterator();
            n6 = -1;
            while (iterator.hasNext()) {
                n6 = (Integer)iterator.next();
                if (n6 == n3) continue;
                System.out.println("*** THIS NEEDS TO BE CHANGED ***");
                throw new RuntimeException("*** THIS NEEDS TO BE CHANGED ***");
            }
            ++n;
            if (n5 == n3) continue;
            d += d4;
            if (n5 == -86421357) {
                n5 = this.getEmptyCommunity();
            }
            this.communityOfElement[n4] = n5;
            ++n2;
        }
        this.greedyUpdateRecord.update(n, n2);
        return d;
    }
}

