/*
 * Decompiled with CFR 0.152.
 */
package TimGraph.Community;

import DataAnalysis.MutualInformation;
import TimGraph.Community.Partition;
import TimGraph.Community.Quality;
import TimGraph.Community.QualityType;
import TimGraph.timgraph;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import java.io.PrintStream;

public class Community {
    public static final int UNSET = -987123456;
    public static final double DUNSET = -9.7531E86;
    public static final int NEWCOMMUNITYLABEL = -86421357;
    public static final int NOCOMMUNITYLABEL = -789456123;
    public static final double TOLERANCE = 1.0E-6;
    protected String name = "general";
    protected int numberElements = -987123456;
    protected String nameOfElements = "elements";
    protected String[] elementName;
    public static final String verticesName = "vertices";
    public static final String edgesName = "edges";
    protected int numberCommunities = -987123456;
    protected String[] communityName;
    protected SparseDoubleMatrix2D communityMatrix;
    protected Quality quality;
    protected double Q = -9.87123456E8;
    protected timgraph graph;
    public int infoLevel = -2;

    public Community() {
    }

    public Community(timgraph timgraph2, int n, double d, int n2, int n3) {
        this.infoLevel = n3;
        this.initialiseGraph(timgraph2, n, n2, d);
    }

    public Community(String string) {
        this.name = string;
    }

    public Community(int n) {
        this.numberElements = n;
    }

    public Community(double d, int n, int n2, int[] nArray) {
        this.Q = d;
        this.numberElements = n;
    }

    public Community(Partition partition) {
        this.initialiseFromPartition(partition);
    }

    public Community(timgraph timgraph2, Partition partition, int n, int n2, double d) {
        this.initialiseGraph(timgraph2, n, n2, d);
    }

    public void initialiseGraph(timgraph timgraph2, int n, int n2, double d) {
        this.graph = timgraph2;
        this.quality = QualityType.makeQuality(timgraph2, n, n2, d, this.infoLevel);
        this.Q = -9.87123456E8;
    }

    public String qualityType() {
        return this.quality.getQualityTypeDescription();
    }

    private void initialiseFromPartition(Partition partition) {
        this.name = partition.getName() + "partition";
        this.initialiseEmptyCommunity(partition.getNumberElements(), partition.getNumberOfCommunities());
        for (int i = 0; i < this.numberElements; ++i) {
            this.communityMatrix.set(i, partition.getCommunity(i), 1.0);
        }
    }

    public void initialiseEmptyCommunity(int n, int n2) {
        this.numberElements = n;
        this.numberCommunities = n2;
        this.communityMatrix = new SparseDoubleMatrix2D(this.numberElements, this.numberCommunities);
    }

    public void initialiseElementNameList() {
        this.elementName = new String[this.numberElements];
    }

    public void initialiseCommunityNameList() {
        this.communityName = new String[this.numberCommunities];
    }

    public double calcQuality() {
        this.Q = this.quality.calc((DoubleMatrix2D)this.communityMatrix, this.numberCommunities);
        return this.Q;
    }

    public int getNumberCommunities() {
        return this.numberCommunities;
    }

    public int getNumberElements() {
        return this.numberElements;
    }

    public double getCommunityMembership(int n, int n2) {
        return this.communityMatrix.get(n, n2);
    }

    public void setCommunityMembership(int n, int n2, double d) {
        this.communityMatrix.set(n, n2, d);
    }

    public void increaseCommunityMembership(int n, int n2, double d) {
        this.communityMatrix.set(n, n2, d + this.communityMatrix.get(n, n2));
    }

    public String getElementName(int n) {
        return this.elementName == null ? "e" + n : this.elementName[n];
    }

    public boolean hasElementName() {
        return this.elementName != null;
    }

    public void setElementName(int n, String string) {
        if (this.elementName == null) {
            this.initialiseElementNameList();
        }
        this.elementName[n] = string;
    }

    public String getCommunityName(int n) {
        return this.communityName == null ? "c" + n : this.communityName[n];
    }

    public boolean hasCommunityName() {
        return this.communityName != null;
    }

    public void setCommunityName(int n, String string) {
        if (this.communityName == null) {
            this.initialiseCommunityNameList();
        }
        this.communityName[n] = string;
    }

    public double getQuality() {
        if (this.Q == -9.87123456E8) {
            this.calcQuality();
        }
        return this.Q;
    }

    public void setQuality(double d) {
        this.Q = d;
    }

    public int checkMatrixNormalisation(double d) {
        for (int i = 0; i < this.numberElements; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numberCommunities; ++j) {
                d2 += this.communityMatrix.get(i, j);
            }
            if (!(Math.abs(d2 - 1.0) > d)) continue;
            return i;
        }
        return -1;
    }

    public int normaliseMatrix(double d) {
        double d2 = -1.0;
        for (int i = 0; i < this.numberElements; ++i) {
            int n;
            double d3 = 0.0;
            for (n = 0; n < this.numberCommunities; ++n) {
                d3 += this.communityMatrix.get(i, n);
            }
            if (d3 < -d) {
                return i;
            }
            for (n = 0; n < this.numberCommunities; ++n) {
                d2 = this.communityMatrix.get(i, n);
                if (d2 == 0.0) continue;
                this.communityMatrix.set(i, n, d2 / d3);
            }
        }
        return -1;
    }

    public void printInformation(PrintStream printStream, String string, String string2) {
        printStream.println(string + "Number of " + this.nameOfElements + string2 + this.valueString(this.numberElements) + string2 + "Quality (" + string2 + (this.quality == null ? "???" : this.quality.Qdefinition(string2)) + ") " + string2 + this.valueString(this.Q) + string2 + "Number of Communities" + string2 + this.valueString(this.numberCommunities));
    }

    public void printStats(PrintStream printStream, String string, String string2) {
        int n;
        int n2;
        if (this.graph == null) {
            return;
        }
        System.out.println("VARIOUS STATISTICS");
        int n3 = 5;
        double[] dArray = new double[n3];
        int[] nArray = new int[this.numberElements];
        int[] nArray2 = new int[this.numberCommunities];
        double[] dArray2 = new double[this.numberCommunities];
        double[] dArray3 = new double[this.numberCommunities];
        double[] dArray4 = new double[this.numberElements];
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        int n5 = 0;
        double d3 = 0.0;
        for (n2 = 0; n2 < this.numberElements; ++n2) {
            for (n = 0; n < this.numberCommunities; ++n) {
                double d4 = this.getCommunityMembership(n2, n);
                int n6 = n;
                dArray2[n6] = dArray2[n6] + d4;
                if (d4 < 1.0E-20) continue;
                int n7 = n;
                nArray2[n7] = nArray2[n7] + 1;
                int n8 = n2;
                nArray[n8] = nArray[n8] + 1;
                ++n4;
                ++n5;
                d3 = d4 * Math.log(d4);
                int n9 = n;
                dArray3[n9] = dArray3[n9] + d3;
                int n10 = n2;
                dArray4[n10] = dArray4[n10] + d3;
                d += d3;
                d2 += d3;
            }
        }
        printStream.println(string + "c" + string2 + "No.Elements" + string2 + "Frac.Elements" + string2 + "Entropy");
        for (n2 = 0; n2 < this.numberCommunities; ++n2) {
            printStream.println(n2 + string2 + nArray2[n2] + string2 + dArray2[n2] + string2 + dArray3[n2]);
        }
        int[] nArray3 = new int[dArray.length];
        for (n = 0; n < this.numberElements; ++n) {
            int n11 = nArray[n];
            if (n11 >= nArray3.length) continue;
            int n12 = n11;
            nArray3[n12] = nArray3[n12] + 1;
        }
        printStream.println(string + "n" + string2 + "coverage[n]");
        n = 0;
        dArray[n] = this.numberElements - nArray3[n];
        printStream.println(n + string2 + dArray[n]);
        for (n = 1; n < dArray.length; ++n) {
            dArray[n] = dArray[n - 1] - (double)nArray3[n];
            printStream.println(n + string2 + dArray[n]);
        }
    }

    public String informationNumbers(String string, String string2) {
        return string + this.valueString(this.numberElements) + string2 + this.valueString(this.Q) + string2 + (this.quality == null ? "not set" : this.valueString(this.quality.getLambda())) + string2 + this.valueString(this.numberCommunities);
    }

    public String informationNumbersLabel(String string, String string2) {
        return string + "Number of " + this.nameOfElements + string2 + "Quality (" + string2 + this.quality.Qdefinition(string2) + ") " + string2 + "gamma" + string2 + "Number of Communities";
    }

    public void printCommunityMatrix(PrintStream printStream, String string, String string2) {
        this.printCommunityMatrix(printStream, string, string2, true, true);
    }

    public void printCommunities(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        this.printCommunityMatrix(printStream, string, string2, bl, bl2);
    }

    public void printCommunityMatrixSparse(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        int n;
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
            if (bl2) {
                printStream.print(this.nameOfElements + string2);
                for (n = 0; n < this.numberCommunities; ++n) {
                    printStream.print(this.getCommunityName(n) + string2);
                }
                printStream.println();
            }
        }
        if (this.communityMatrix != null) {
            for (n = 0; n < this.numberElements; ++n) {
                printStream.print(string);
                if (bl2) {
                    printStream.print(this.getElementName(n) + string2);
                }
                for (int i = 0; i < this.numberCommunities; ++i) {
                    printStream.print(this.communityMatrix.get(n, i) + string2);
                }
                printStream.println();
            }
        }
    }

    public void printCommunityMatrix(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        int n;
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
            if (bl2) {
                printStream.print(this.nameOfElements + string2);
                for (n = 0; n < this.numberCommunities; ++n) {
                    printStream.print(this.getCommunityName(n) + string2);
                }
                printStream.println();
            }
        }
        if (this.communityMatrix != null) {
            for (n = 0; n < this.numberElements; ++n) {
                printStream.print(string);
                if (bl2) {
                    printStream.print(this.getElementName(n) + string2);
                }
                for (int i = 0; i < this.numberCommunities; ++i) {
                    printStream.print(this.communityMatrix.get(n, i) + string2);
                }
                printStream.println();
            }
        }
    }

    public void printCommunityBipartiteGraph(PrintStream printStream, String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            printStream.println(string + "Number of " + this.nameOfElements + string2 + this.numberElements + string2 + "Number of Communities" + string2 + this.numberCommunities);
            if (bl2) {
                printStream.println(this.nameOfElements + string2 + "community" + string2 + "weight");
            }
        }
        double d = -1.0;
        for (int i = 0; i < this.numberElements; ++i) {
            printStream.print(string);
            for (int j = 0; j < this.numberCommunities; ++j) {
                d = this.communityMatrix.get(i, j);
                if (!(d > 0.0)) continue;
                printStream.println(this.getElementName(i) + string2 + j + string2 + d);
            }
        }
    }

    public static MutualInformation calcMutualInformation(Community community, Community community2, timgraph timgraph2) {
        boolean bl = false;
        if (community.getNumberElements() != community2.getNumberElements()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of elements: " + community.getNumberElements() + "   " + community2.getNumberElements());
            return null;
        }
        if (!community.elementsAreVertices()) {
            System.err.println("*** In calcMutualInformation first community must have vertices as community , but it has " + community.getNameOfElements());
            return null;
        }
        if (!community2.elementsAreVertices()) {
            System.err.println("*** In calcMutualInformation second community must have vertices as community , but it has " + community2.getNameOfElements());
            return null;
        }
        if (timgraph2 != null && community.getNumberElements() != timgraph2.getNumberVertices()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of vertices from graph: " + community.getNumberElements() + "   " + timgraph2.getNumberVertices());
            return null;
        }
        int n = community.getNumberElements();
        double d = 1.0 / (double)n;
        boolean bl2 = false;
        if (bl && timgraph2 != null && timgraph2.isWeighted()) {
            bl2 = true;
        }
        MutualInformation mutualInformation = new MutualInformation(community.getNumberCommunities(), community2.getNumberCommunities(), community.getName(), community2.getName());
        if (community.communityName != null) {
            mutualInformation.setElementNames1(community.communityName);
        }
        if (community2.communityName != null) {
            mutualInformation.setElementNames2(community2.communityName);
        }
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = n;
        if (bl2) {
            d4 = timgraph2.getTotalWeight();
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            double d5 = 0.0;
            for (int j = 0; j < community.getNumberCommunities(); ++j) {
                d5 += community.getCommunityMembership(i, j);
            }
            if (d5 < 1.0E-6) {
                throw new RuntimeException("*** Normalisation of vertex " + i + " in community 1 found to be zero or negative = " + d5);
            }
            double d6 = 0.0;
            for (n2 = 0; n2 < community2.getNumberCommunities(); ++n2) {
                d6 += community2.getCommunityMembership(i, n2);
            }
            if (d6 < 1.0E-6) {
                throw new RuntimeException("*** Normalisation of vertex " + i + " in community 2 found to be zero or negative = " + d5);
            }
            if (bl2) {
                d = timgraph2.getVertexOutStrength(i) / d4;
            }
            for (n2 = 0; n2 < community.getNumberCommunities(); ++n2) {
                d2 = community.getCommunityMembership(i, n2) / d5;
                if (d2 > 0.0) {
                    mutualInformation.increaseMarginalProbabilityOneQuick(n2, d2 * d);
                } else if (n2 > 0) continue;
                for (int j = 0; j < community2.getNumberCommunities(); ++j) {
                    d3 = community2.getCommunityMembership(i, j) / d6;
                    if (d3 == 0.0) continue;
                    if (d2 > 0.0) {
                        mutualInformation.increaseJointProbabilityQuick(n2, j, d2 * d3 * d);
                    }
                    if (n2 != 0) continue;
                    mutualInformation.increaseMarginalProbabilityTwoQuick(j, d3 * d);
                }
            }
        }
        if (mutualInformation.checkConsistentcy() < 0) {
            throw new RuntimeException("Consistency Problem with Mutual Information");
        }
        return mutualInformation;
    }

    static int calcMutualInformationGeneralTypes(Community community, Community community2, timgraph timgraph2) {
        if (community.getNumberElements() != community2.getNumberElements()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of elements: " + community.getNumberElements() + "   " + community2.getNumberElements());
            return -1;
        }
        if (!community.elementsAreVerticesOrEdges()) {
            System.err.println("*** In calcMutualInformation first community must have vertices or edges as community , but it has " + community.getNameOfElements());
            return -2;
        }
        boolean bl = community.elementsAreVertices();
        if (!community2.elementsAreVerticesOrEdges()) {
            System.err.println("*** In calcMutualInformation second community must have vertices or edges as community , but it has " + community2.getNameOfElements());
            return -3;
        }
        boolean bl2 = community2.elementsAreVertices();
        if (community.getNumberElements() != timgraph2.getMaximumVertices()) {
            System.err.println("*** In calcMutualInformation communities have different numbers of elements from graph: " + community.getNumberElements() + "   " + community2.getNumberElements());
            return -1;
        }
        return 0;
    }

    public boolean elementsAreVertices() {
        return this.getNameOfElements().equals(verticesName);
    }

    public boolean elementsAreEdges() {
        return this.getNameOfElements().equals(edgesName);
    }

    public boolean elementsAreVerticesOrEdges() {
        return this.elementsAreVertices() || this.elementsAreEdges();
    }

    public String getName() {
        return this.name;
    }

    public String getNameOfElements() {
        return this.nameOfElements;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setElementNameVertices() {
        this.nameOfElements = verticesName;
    }

    public void setElementNameEdges() {
        this.nameOfElements = edgesName;
    }

    protected String valueString(int n) {
        return n == -987123456 ? "not set" : Integer.toString(n);
    }

    protected String valueString(double d) {
        return Math.abs(d / -9.7531E86 - 1.0) < 1.0E-6 ? "not set" : Double.toString(d);
    }
}

