/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.AdjacencyMatrix;
import TimGraph.timgraph;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;

public class AdjacencyMatrixSparse
extends AdjacencyMatrix {
    Algebra alg = new Algebra();

    public AdjacencyMatrixSparse(timgraph timgraph2) {
        this.make(timgraph2);
    }

    public AdjacencyMatrixSparse(double[][] dArray, int n) {
        if (n == 1) {
            this.makeA2mA(dArray);
        } else {
            this.make(dArray);
        }
    }

    public AdjacencyMatrixSparse(timgraph timgraph2, int n) {
        if (n == 1) {
            AdjacencyMatrixSparse adjacencyMatrixSparse = new AdjacencyMatrixSparse(timgraph2);
            this.makeA2mA(adjacencyMatrixSparse.matrix());
        } else {
            this.make(timgraph2);
        }
    }

    public AdjacencyMatrixSparse(int n, int n2, int[] nArray, boolean bl) {
        this.dimension = n;
        this.initialiseMatrix();
        this.makeUnweighted(n, n2, nArray, bl);
    }

    private void initialiseMatrix() {
        this.matrix = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    public void make(double[][] dArray) {
        this.dimension = dArray[0].length;
        this.matrix = new SparseDoubleMatrix2D(dArray);
        this.totalWeight = 0.0;
    }

    public void makeA2mA(double[][] dArray) {
        this.dimension = dArray[0].length;
        this.matrix = new SparseDoubleMatrix2D(dArray);
        this.totalWeight = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double d = -dArray[i][j];
                for (int k = 0; k < this.dimension; ++k) {
                    d += dArray[i][k] * dArray[k][j];
                }
                this.totalWeight += d;
                this.matrix.setQuick(i, j, d);
            }
        }
    }

    public void make(timgraph timgraph2) {
        this.make(timgraph2, this.transferMatrix);
    }

    public void make(timgraph timgraph2, boolean bl) {
        if (!timgraph2.isVertexEdgeListOn()) {
            System.err.println("*** in AdjacencyMatrix make, graph " + timgraph2.inputName.getNameRoot() + " needs vertexEdgeList");
        }
        this.transferMatrix = bl;
        boolean bl2 = !timgraph2.isDirected();
        boolean bl3 = timgraph2.isWeighted();
        this.dimension = timgraph2.getNumberVertices();
        int n = timgraph2.getNumberStubs();
        double d = -1.0;
        int n2 = -1;
        double d2 = -1.0;
        this.initialiseMatrix();
        for (int i = 0; i < n; ++i) {
            n2 = timgraph2.getVertexFromEdge(i++);
            if (this.transferMatrix && (d = timgraph2.getVertexOutStrength(n2)) < 1.0E-20) {
                throw new RuntimeException("Out strength is too small for vertex " + n2 + " of value " + d);
            }
            d2 = bl3 ? timgraph2.getEdgeWeight(i) : 1.0;
            if (this.transferMatrix) {
                d2 /= d;
            }
            int n3 = timgraph2.getVertexFromEdge(i);
            this.increaseEdgeWeight(n2, n3, d2, bl2);
        }
    }

    protected void increaseEdgeWeight(int n, int n2, double d, boolean bl) {
        double d2 = d + this.matrix.getQuick(n, n2);
        this.matrix.setQuick(n, n2, d2);
        this.totalWeight += d;
        if (bl) {
            d2 = d + this.matrix.getQuick(n2, n);
            this.matrix.setQuick(n2, n, d2);
            this.totalWeight += d;
        }
    }

    public void make(String[] stringArray) {
        String string = "AMdefault";
        String string2 = "";
        int n = -2;
        int n2 = 31;
        timgraph timgraph2 = new timgraph(string + "tg", string2, n, n2);
        timgraph2.setNumberEvents(this.dimension);
        timgraph2.parseParam(stringArray);
        if (timgraph2.getInitialVertices() > this.dimension) {
            timgraph2.setInitialVertices(this.dimension);
        }
        timgraph2.doOneRun(1);
        this.makeUnweighted(timgraph2.getNumberVertices(), timgraph2.getNumberStubs(), timgraph2.getStubSourceList(), timgraph2.directedGraph);
    }

    private void makeUnweighted(int n, int n2, int[] nArray, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        double d = -1.0;
        for (int i = 0; i < n2; ++i) {
            n3 = nArray[i++];
            n4 = nArray[i];
            d = this.matrix.get(n3, n4) + 1.0;
            this.matrix.set(n3, n4, d);
            if (bl) continue;
            this.matrix.set(n4, n3, d);
        }
    }
}

