/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.AdjacencyMatrix;
import TimGraph.timgraph;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;

public class AdjacencyMatrixDense
extends AdjacencyMatrix {
    public AdjacencyMatrixDense(timgraph timgraph2) {
        this.make(timgraph2);
    }

    public AdjacencyMatrixDense(double[][] dArray, int n) {
        if (n == 1) {
            this.makeA2mA(dArray);
        } else {
            this.make(dArray);
        }
    }

    public AdjacencyMatrixDense(timgraph timgraph2, int n) {
        if (n == 1) {
            AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(timgraph2);
            this.makeA2mA(adjacencyMatrix.matrix());
        } else {
            this.make(timgraph2);
        }
    }

    public AdjacencyMatrixDense(int n, int n2, int[] nArray, boolean bl) {
        this.dimension = n;
        this.initialiseMatrix();
        this.makeUnweighted(n, n2, nArray, bl);
    }

    private void initialiseMatrix() {
        this.matrix = new DenseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    public void make(double[][] dArray) {
        this.dimension = dArray[0].length;
        this.matrix = new DenseDoubleMatrix2D(dArray);
        this.totalWeight = 0.0;
    }

    public void makeA2mA(double[][] dArray) {
        this.dimension = dArray[0].length;
        this.matrix = new DenseDoubleMatrix2D(dArray);
        this.totalWeight = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double d = -dArray[i][j];
                for (int k = 0; k < this.dimension; ++k) {
                    d += dArray[i][k] * dArray[k][j];
                }
                this.totalWeight += d;
                this.matrix.setQuick(i, j, d);
            }
        }
    }

    public void make(String[] stringArray) {
        String string = "AMdefault";
        String string2 = "";
        int n = -2;
        int n2 = 31;
        timgraph timgraph2 = new timgraph(string + "tg", string2, n, n2);
        timgraph2.setNumberEvents(this.dimension);
        timgraph2.parseParam(stringArray);
        if (timgraph2.getInitialVertices() > this.dimension) {
            timgraph2.setInitialVertices(this.dimension);
        }
        timgraph2.doOneRun(1);
        this.makeUnweighted(timgraph2.getNumberVertices(), timgraph2.getNumberStubs(), timgraph2.getStubSourceList(), timgraph2.directedGraph);
    }

    private void makeUnweighted(int n, int n2, int[] nArray, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        double d = -1.0;
        for (int i = 0; i < n2; ++i) {
            n3 = nArray[i++];
            n4 = nArray[i];
            d = this.matrix.get(n3, n4) + 1.0;
            this.matrix.set(n3, n4, d);
            if (bl) continue;
            this.matrix.set(n4, n3, d);
        }
    }
}

