/*
 * Decompiled with CFR 0.152.
 */
package TimGraph;

import TimGraph.timgraph;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import java.io.PrintStream;

public class AdjacencyMatrix {
    protected int dimension = -1;
    protected DoubleMatrix2D matrix;
    protected double[] inVector;
    protected double[] outVector;
    protected DoubleMatrix1D piVector;
    protected double totalWeight = 0.0;
    boolean transferMatrix = false;
    static final double DUNSET = -97531.0;
    static final int IUNSET = -86420;

    public AdjacencyMatrix() {
    }

    public AdjacencyMatrix(timgraph timgraph2) {
        this.make(timgraph2);
    }

    public AdjacencyMatrix(double[][] dArray, int n) {
        if (n == 1) {
            this.makeA2mA(dArray);
        } else {
            this.make(dArray);
        }
    }

    public AdjacencyMatrix(timgraph timgraph2, int n) {
        if (n == 1) {
            AdjacencyMatrix adjacencyMatrix = new AdjacencyMatrix(timgraph2);
            this.makeA2mA(adjacencyMatrix.matrix());
        } else {
            this.make(timgraph2);
        }
    }

    public AdjacencyMatrix(int n, int n2, int[] nArray, boolean bl) {
        this.dimension = n;
        this.initialiseMatrix();
        this.makeUnweighted(n, n2, nArray, bl);
    }

    private void initialiseMatrix() {
        this.matrix = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        this.totalWeight = 0.0;
    }

    public double get(int n, int n2) {
        return this.matrix.get(n, n2);
    }

    public double[][] matrix() {
        return this.matrix.toArray();
    }

    public DoubleMatrix2D doubleMatrix2D() {
        return this.matrix;
    }

    public double getInStrength(int n) {
        return this.inVector[n];
    }

    public double getOutStrength(int n) {
        return this.outVector[n];
    }

    public double getNormalisedPi(int n) {
        return this.piVector.get(n);
    }

    public double totalWeight() {
        return this.totalWeight;
    }

    public int dimension() {
        return this.dimension;
    }

    public void make(double[][] dArray) {
        this.dimension = dArray[0].length;
        this.initialiseMatrix();
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double d = dArray[i][j];
                this.totalWeight += d;
                this.matrix.set(i, j, d);
            }
        }
    }

    public void makeA2mA(double[][] dArray) {
        this.dimension = dArray[0].length;
        this.initialiseMatrix();
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double d = -dArray[i][j];
                for (int k = 0; k < this.dimension; ++k) {
                    d += dArray[i][k] * dArray[k][j];
                }
                this.totalWeight += d;
                this.matrix.set(i, j, d);
            }
        }
    }

    public void make(timgraph timgraph2) {
        if (!timgraph2.isVertexEdgeListOn()) {
            timgraph2.createVertexGlobalEdgeList();
            System.err.println("!!! WARNING in AdjacencyMatrix make, graph " + timgraph2.inputName.getNameRoot() + " needs vertexEdgeList, creating an unsynchronised one");
        }
        this.dimension = timgraph2.getNumberVertices();
        this.inVector = new double[this.dimension];
        this.outVector = new double[this.dimension];
        boolean bl = !timgraph2.isDirected();
        boolean bl2 = timgraph2.isWeighted();
        this.dimension = timgraph2.getNumberVertices();
        int n = timgraph2.getNumberStubs();
        double d = -1.0;
        this.initialiseMatrix();
        for (int i = 0; i < n; ++i) {
            int n2 = timgraph2.getVertexFromEdge(i++);
            d = bl2 ? timgraph2.getEdgeWeight(i) : 1.0;
            int n3 = timgraph2.getVertexFromEdge(i);
            this.increaseEdgeWeight(n2, n3, d, bl);
            int n4 = n3;
            this.inVector[n4] = this.inVector[n4] + d;
            int n5 = n2;
            this.outVector[n5] = this.outVector[n5] + d;
        }
    }

    protected void increaseEdgeWeight(int n, int n2, double d, boolean bl) {
        double d2 = d + this.matrix.get(n, n2);
        this.matrix.set(n, n2, d2);
        this.totalWeight += d;
        if (bl) {
            this.matrix.set(n2, n, d2);
            this.totalWeight += d;
        }
    }

    public void make(String[] stringArray) {
        String string = "AMdefault";
        String string2 = "";
        int n = -2;
        int n2 = 31;
        timgraph timgraph2 = new timgraph(string + "tg", string2, n, n2);
        timgraph2.setNumberEvents(this.dimension);
        timgraph2.parseParam(stringArray);
        if (timgraph2.getInitialVertices() > this.dimension) {
            timgraph2.setInitialVertices(this.dimension);
        }
        timgraph2.doOneRun(1);
        this.makeUnweighted(timgraph2.getNumberVertices(), timgraph2.getNumberStubs(), timgraph2.getStubSourceList(), timgraph2.directedGraph);
    }

    public void calculateInOutVectors() {
        this.inVector = new double[this.dimension];
        this.outVector = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.outVector[i] = 0.0;
            this.inVector[i] = 0.0;
            for (int j = 0; j < this.dimension; ++j) {
                int n = i;
                this.inVector[n] = this.inVector[n] + this.get(j, i);
                int n2 = i;
                this.outVector[n2] = this.outVector[n2] + this.get(i, j);
            }
        }
    }

    public void calculatePageRankVector() {
        int n = 100;
        double d = 0.001;
        double d2 = 1.0;
        this.calculatePiVector(n, d, d2);
    }

    public void calculatePiVector() {
        int n = 10;
        double d = 0.01;
        double d2 = 1.0;
        this.calculatePiVector(n, d, d2);
    }

    public void calculatePiVector(int n, double d, double d2) {
        int n2;
        this.calculateInOutVectors();
        this.piVector = new DenseDoubleMatrix1D(this.dimension);
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.dimension);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            double d3 = this.inVector[i] / this.totalWeight;
            this.piVector.setQuick(i, d3);
            denseDoubleMatrix1D.setQuick(i, d3);
            for (int j = 0; j < this.dimension; ++j) {
                d3 = this.matrix.getQuick(i, j);
                if (d3 == 0.0) continue;
                sparseDoubleMatrix2D.setQuick(j, i, d3 / this.outVector[i]);
            }
        }
        Algebra algebra = new Algebra();
        double d4 = 0.0;
        double d5 = this.piVector.zSum();
        double d6 = 1.0 - d2;
        double d7 = d;
        DenseDoubleMatrix1D denseDoubleMatrix1D3 = new DenseDoubleMatrix1D(this.dimension);
        int n3 = -1;
        for (n3 = 0; n3 < n; ++n3) {
            sparseDoubleMatrix2D.zMult(this.piVector, (DoubleMatrix1D)denseDoubleMatrix1D2, d2 / d5, 0.0, false);
            if (d6 != 0.0) {
                denseDoubleMatrix1D2.assign((DoubleMatrix1D)denseDoubleMatrix1D, Functions.plusMult((double)d6));
            }
            d5 = denseDoubleMatrix1D2.zSum();
            sparseDoubleMatrix2D.zMult((DoubleMatrix1D)denseDoubleMatrix1D2, this.piVector, d2 / d5, d6, false);
            if (d6 != 0.0) {
                this.piVector.assign((DoubleMatrix1D)denseDoubleMatrix1D, Functions.plusMult((double)d6));
            }
            d5 = this.piVector.zSum();
            d4 = 0.0;
            for (n2 = 0; n2 < this.dimension; ++n2) {
                d4 += Math.abs(this.piVector.getQuick(n2) - denseDoubleMatrix1D2.getQuick(n2));
            }
            if (Math.abs(d4 / d5) < d) break;
        }
        d5 = this.piVector.zSum();
        for (n2 = 0; n2 < this.piVector.size(); ++n2) {
            this.piVector.setQuick(n2, this.piVector.getQuick(n2) / d5);
        }
        System.out.println("Convergence in calculatePiVector factor " + String.format("%8.6g", Math.abs(d4 / d5)) + " after " + n3 + " iterations");
    }

    public void calcPiVectorAlternate(int n, double d) {
        this.piVector = new DenseDoubleMatrix1D(this.inVector);
        SparseDoubleMatrix2D sparseDoubleMatrix2D = new SparseDoubleMatrix2D(this.dimension, this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                double d2 = this.matrix.getQuick(i, j);
                if (d2 == 0.0) continue;
                sparseDoubleMatrix2D.setQuick(j, i, d2 / this.outVector[i]);
            }
        }
        double d3 = 1.0;
        double d4 = Math.abs(this.piVector.zSum());
        double d5 = 0.0;
        double d6 = 1.0 - d5;
        while (--n > 0) {
            this.piVector = this.matrix.zMult(this.piVector, this.piVector, d4 * d6, d5 * d4, false);
            d3 = d4;
            d4 = Math.abs(this.piVector.zSum());
            if (!(Math.abs(d4 - d3) < d)) continue;
        }
        d4 = Math.abs(this.piVector.zSum());
        for (int i = 0; i < this.dimension; ++i) {
            this.piVector.set(i, this.piVector.get(i) / d4);
        }
    }

    private void makeUnweighted(int n, int n2, int[] nArray, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            n3 = nArray[i++];
            n4 = nArray[i];
            double d = 1.0 + this.matrix.get(n3, n4);
            this.matrix.set(n3, n4, d);
            if (bl) continue;
            this.matrix.set(n4, n3, d);
        }
    }

    public void check() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            d2 += this.outVector[i];
            d += this.inVector[i];
            for (int j = 0; j < this.dimension; ++j) {
                d3 += this.get(i, j);
            }
        }
        System.out.println("!!! Check in Adjacency Matrix, Totals for Matrix, In, Out " + d3 + ", " + d + ", " + d2);
    }

    public void printVector(PrintStream printStream, String string, String string2, double[] dArray, boolean bl) {
        int n;
        String string3 = "%6.3f";
        String string4 = "%6d";
        System.out.println(string2 + " vector");
        if (bl) {
            for (n = 0; n < this.dimension; ++n) {
                printStream.print(String.format(string4, n) + string);
            }
            printStream.println();
        }
        for (n = 0; n < this.dimension; ++n) {
            printStream.print(String.format(string3, dArray[n]) + string);
        }
        printStream.println();
    }

    public void printVector(PrintStream printStream, String string, String string2, DoubleMatrix1D doubleMatrix1D, boolean bl) {
        this.printVector(printStream, string, string2, doubleMatrix1D.toArray(), bl);
    }

    public void printMatrix(PrintStream printStream, String string, String string2, DoubleMatrix2D doubleMatrix2D, boolean bl) {
        int n;
        String string3 = "%6.3f";
        String string4 = "%6d";
        System.out.println(string2 + " matrix");
        if (bl) {
            printStream.print("      " + string);
            for (n = 0; n < this.dimension; ++n) {
                printStream.print(String.format(string4, n) + string);
            }
            printStream.println();
        }
        for (n = 0; n < this.dimension; ++n) {
            if (bl) {
                printStream.print(String.format(string4, n) + string);
            }
            for (int i = 0; i < this.dimension; ++i) {
                printStream.print(String.format(string3, doubleMatrix2D.get(n, i)) + string);
            }
            printStream.println();
        }
    }

    public void printMatrix(PrintStream printStream, String string, String[] stringArray, boolean bl) {
        int n;
        boolean bl2 = false;
        if (bl) {
            if (stringArray != null && stringArray.length == this.dimension) {
                bl2 = true;
            }
            printStream.print(" " + string);
            for (n = 0; n < this.dimension; ++n) {
                printStream.print((bl2 ? stringArray[n] : Integer.valueOf(n)) + string);
            }
            printStream.println();
        }
        for (n = 0; n < this.dimension; ++n) {
            if (bl) {
                printStream.print((bl2 ? stringArray[n] : Integer.valueOf(n)) + string);
            }
            for (int i = 0; i < this.dimension; ++i) {
                printStream.print(this.get(n, i) + string);
            }
            printStream.println();
        }
    }

    public void printMatrix(PrintStream printStream, String string, boolean bl) {
        this.printMatrix(printStream, string, null, bl);
    }

    public void printMatrix(String string, boolean bl) {
        this.printMatrix(System.out, string, bl);
    }
}

