/*
 * Decompiled with CFR 0.152.
 */
package MatrixCorrelation;

import java.io.PrintStream;

public class CorrelationSimple {
    int dimInd = -1;
    int dimArt = -1;
    final int dimType = 2;
    double[][] valueVector;
    double[][] valueNorm;
    boolean correlationCalculated = false;
    double[][][] correlationVector;

    public CorrelationSimple(int n, int n2, double[][] dArray) {
        this.dimInd = n;
        this.dimArt = n2;
        this.valueVector = new double[this.dimInd][this.dimArt];
        this.correlationVector = new double[this.dimInd][this.dimInd][2];
        this.valueNorm = new double[this.dimInd][2];
        double d = -1.0;
        for (int i = 0; i < this.dimInd; ++i) {
            int n3;
            for (n3 = 0; n3 < this.dimInd; ++n3) {
                this.valueNorm[i][n3] = 0.0;
            }
            for (n3 = 0; n3 < this.dimArt; ++n3) {
                this.valueVector[i][n3] = d = dArray[i][n3];
                double[] dArray2 = this.valueNorm[i];
                dArray2[0] = dArray2[0] + d;
                double[] dArray3 = this.valueNorm[i];
                dArray3[1] = dArray3[1] + d * d;
            }
            this.valueNorm[i][1] = Math.sqrt(this.valueNorm[i][1]);
            for (n3 = 0; n3 < this.dimInd; ++n3) {
                for (int j = 0; j < this.dimInd; ++j) {
                    this.correlationVector[i][n3][j] = i == n3 ? 1.0 : 0.0;
                }
            }
        }
        this.correlationCalculated = false;
    }

    public double getCorrelation(int n, int n2, int n3) {
        if (!this.correlationCalculated) {
            this.calcCorrelations();
        }
        return this.correlationVector[n][n2][n3];
    }

    public void calcCorrelations() {
        double d = -99.0;
        for (int i = 0; i < this.dimInd; ++i) {
            for (int j = 0; j < this.dimInd; ++j) {
                d = this.calcCorrelation(i, j);
                block6: for (int k = 0; k < this.dimInd; ++k) {
                    switch (k) {
                        case 0: {
                            this.correlationVector[i][j][0] = d / (this.valueNorm[i][0] * this.valueNorm[j][0]);
                            continue block6;
                        }
                        case 1: {
                            this.correlationVector[i][j][1] = Math.acos(d / (this.valueNorm[i][1] * this.valueNorm[j][1]));
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    public String correlationTypeString(PrintStream printStream) {
        String string = "Unknown type";
        block4: for (int i = 0; i < this.dimInd; ++i) {
            switch (i) {
                case 0: {
                    string = "Probability style";
                    continue block4;
                }
                case 1: {
                    string = "Angle in artifact space";
                    continue block4;
                }
            }
        }
        return string;
    }

    private double calcCorrelation(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimArt; ++i) {
            d += this.valueVector[n][i] * this.valueVector[n2][i];
        }
        return d;
    }
}

