/*
 * Decompiled with CFR 0.152.
 */
package JavaNotes;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class TextReaderTabSeparated
extends FilterReader {
    private int lookAhead = -1;
    protected boolean errorFlag = false;
    private String errorMessage = "";
    protected boolean EOF = false;
    private boolean throwExceptionOnError = true;
    private boolean possibleLineFeedPending = false;

    public TextReaderTabSeparated(BufferedReader bufferedReader) {
        super(bufferedReader);
    }

    public TextReaderTabSeparated(Reader reader) {
        super(new BufferedReader(reader));
    }

    public TextReaderTabSeparated(InputStream inputStream) {
        super(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public void IOCheck(boolean bl) {
        this.throwExceptionOnError = bl;
    }

    public boolean error() {
        return this.errorFlag;
    }

    public String getErrorMessage() {
        return this.errorFlag ? this.errorMessage : null;
    }

    public char peek() {
        this.errorFlag = false;
        return this.lookChar();
    }

    public char getAnyChar() {
        this.errorFlag = false;
        return this.readChar();
    }

    public char getChar() {
        this.errorFlag = false;
        this.skipWhiteSpace();
        return this.readChar();
    }

    public byte getByte() {
        this.errorFlag = false;
        return (byte)this.readInteger(-128L, 127L);
    }

    public short getShort() {
        this.errorFlag = false;
        return (short)this.readInteger(-32768L, 32767L);
    }

    public int getInt() {
        this.errorFlag = false;
        return (int)this.readInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public long getLong() {
        this.errorFlag = false;
        return this.readInteger(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public float getFloat() {
        this.errorFlag = false;
        return this.readFloat();
    }

    public double getDouble() {
        this.errorFlag = false;
        return this.readDouble();
    }

    public boolean getBoolean() {
        this.errorFlag = false;
        return this.readBoolean();
    }

    public String getWordWithSpaces() {
        this.errorFlag = false;
        return this.readWordWithSpaces();
    }

    public String getWordIncludingSpaces() {
        this.errorFlag = false;
        return this.readWordIncludingSpaces();
    }

    public String getWord() {
        this.errorFlag = false;
        return this.readWord();
    }

    public String getAlpha() {
        this.errorFlag = false;
        return this.readAlpha();
    }

    public String getln() {
        this.errorFlag = false;
        return this.readLine();
    }

    public char getlnChar() {
        char c = this.getChar();
        this.dropLine();
        return c;
    }

    public byte getlnByte() {
        byte by = this.getByte();
        this.dropLine();
        return by;
    }

    public short getlnShort() {
        short s = this.getShort();
        this.dropLine();
        return s;
    }

    public int getlnInt() {
        int n = this.getInt();
        this.dropLine();
        return n;
    }

    public long getlnLong() {
        long l = this.getLong();
        this.dropLine();
        return l;
    }

    public float getlnFloat() {
        float f = this.getFloat();
        this.dropLine();
        return f;
    }

    public double getlnDouble() {
        double d = this.getDouble();
        this.dropLine();
        return d;
    }

    public boolean getlnBoolean() {
        boolean bl = this.getBoolean();
        this.dropLine();
        return bl;
    }

    public String getlnWord() {
        String string = this.getWord();
        this.dropLine();
        return string;
    }

    public String getlnAlpha() {
        String string = this.getAlpha();
        this.dropLine();
        return string;
    }

    public boolean eoln() {
        char c = this.lookChar();
        while (!this.EOF && !this.errorFlag && c == ' ') {
            this.readChar();
            c = this.lookChar();
        }
        return c == '\n' || this.EOF;
    }

    public boolean eof() {
        char c = this.lookChar();
        while (!this.EOF && !this.errorFlag && c == '\n') {
            this.readChar();
            c = this.lookChar();
        }
        return this.EOF;
    }

    public void skipWhiteSpaceNotSpaces() {
        char c = this.lookChar();
        while (!(this.errorFlag || c != '\t' && c != '\n')) {
            this.readChar();
            c = this.lookChar();
        }
    }

    public void skipWhiteSpaceNotTabs() {
        char c = this.lookChar();
        while (!(this.errorFlag || c != ' ' && c != '\n')) {
            this.readChar();
            c = this.lookChar();
        }
    }

    public void skipSpaces() {
        char c = this.lookChar();
        while (!this.errorFlag && c == ' ') {
            this.readChar();
            c = this.lookChar();
        }
    }

    public void skipWhiteSpace() {
        char c = this.lookChar();
        while (!(this.errorFlag || c != ' ' && c != '\n' && c != '\t')) {
            this.readChar();
            c = this.lookChar();
        }
    }

    public void skipEndOfLine() {
        char c = this.lookChar();
        while (!this.errorFlag && c == '\n') {
            this.readChar();
            c = this.lookChar();
        }
    }

    public void skipNonLetters() {
        char c = this.lookChar();
        while (!(this.errorFlag || this.EOF || Character.isLetter(c))) {
            this.readChar();
            c = this.lookChar();
        }
    }

    public void close() {
        this.errorFlag = false;
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            this.errorFlag = true;
            this.errorMessage = iOException.toString();
        }
    }

    private void doError(String string) {
        this.errorFlag = true;
        this.errorMessage = string;
        if (this.throwExceptionOnError) {
            throw new Error(string);
        }
    }

    private void doFormatError(String string) {
        this.errorFlag = true;
        this.errorMessage = string;
        if (this.throwExceptionOnError) {
            throw new FormatError(string);
        }
    }

    private void doEOFError(String string) {
        this.errorFlag = true;
        this.errorMessage = string;
        if (this.throwExceptionOnError) {
            throw new FormatError(string);
        }
    }

    protected char readChar() {
        char c = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data in input stream.");
        }
        this.lookAhead = -1;
        return c;
    }

    protected char lookChar() {
        if (this.lookAhead != -1) {
            if (this.lookAhead == 13) {
                return '\n';
            }
            return (char)this.lookAhead;
        }
        if (this.EOF) {
            return '\u0000';
        }
        try {
            int n = this.in.read();
            if (n == 10 && this.possibleLineFeedPending) {
                n = this.in.read();
            }
            this.possibleLineFeedPending = n == 13;
            this.lookAhead = n;
            if (this.lookAhead == -1) {
                this.EOF = true;
                return '\u0000';
            }
        }
        catch (IOException iOException) {
            this.doError(iOException.getMessage());
        }
        if (this.lookAhead == 13) {
            this.lookAhead = 10;
        }
        return (char)this.lookAhead;
    }

    private void dropLine() {
        while (!this.errorFlag) {
            if (this.lookChar() == '\u0000') {
                return;
            }
            if (this.readChar() != '\n') continue;
            return;
        }
    }

    private String readLine() {
        StringBuffer stringBuffer = new StringBuffer(100);
        char c = this.readChar();
        while (!this.errorFlag && c != '\n') {
            stringBuffer.append(c);
            c = this.lookChar();
            if (c == '\u0000') break;
            c = this.readChar();
        }
        return stringBuffer.toString();
    }

    private String readWord() {
        this.skipWhiteSpace();
        if (this.errorFlag) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        char c = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && !this.EOF && c != '\n' && c != '\t') {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
        }
        return stringBuffer.toString();
    }

    private String readWordWithSpaces() {
        this.skipWhiteSpaceNotSpaces();
        if (this.errorFlag) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        char c = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && !this.EOF && c != '\n' && c != '\t') {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
        }
        return stringBuffer.toString();
    }

    private String readWordIncludingSpaces() {
        if (this.errorFlag) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        char c = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && !this.EOF && c != '\n' && c != '\t') {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
        }
        if (c == '\t' || c != '\n') {
            this.readChar();
        }
        return stringBuffer.toString();
    }

    private String readAlpha() {
        this.skipNonLetters();
        if (this.errorFlag) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        char c = this.lookChar();
        if (this.EOF) {
            this.doEOFError("Attempt to read past end-of-data");
            return null;
        }
        while (!this.errorFlag && Character.isLetter(c)) {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
        }
        return stringBuffer.toString();
    }

    public float readFloat() {
        double d = this.readDouble();
        if (this.errorFlag) {
            return Float.NaN;
        }
        if (Math.abs(d) > 3.4028234663852886E38) {
            this.doFormatError("Input number outside of legal range for values of type float");
        }
        return (float)d;
    }

    public double readDouble() {
        double d = Double.NaN;
        StringBuffer stringBuffer = new StringBuffer(50);
        this.skipWhiteSpace();
        char c = this.lookChar();
        if (c == '-' || c == '+') {
            stringBuffer.append(this.readChar());
            this.skipWhiteSpace();
            c = this.lookChar();
        }
        if ((c < '0' || c > '9') && c != '.') {
            if (this.EOF) {
                this.doEOFError("Expecting a floating-point number and found end-of-data");
            } else {
                this.doFormatError("Expecting a floating-point number and found \"" + c + "\"");
            }
            return Double.NaN;
        }
        boolean bl = false;
        while (c >= '0' && c <= '9') {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
            bl = true;
        }
        if (c == '.') {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
            while (c >= '0' && c <= '9') {
                stringBuffer.append(this.readChar());
                c = this.lookChar();
                bl = true;
            }
        }
        if (!bl) {
            this.doFormatError("No digits found in floating-point input.");
            return Double.NaN;
        }
        if (c == 'E' || c == 'e') {
            stringBuffer.append(this.readChar());
            c = this.lookChar();
            if (c == '-' || c == '+') {
                stringBuffer.append(this.readChar());
                c = this.lookChar();
            }
            if ((c < '0' || c > '9') && c != '.') {
                if (this.EOF) {
                    this.doEOFError("Expecting exponent for a floating-point number and found end-of-data");
                } else {
                    this.doFormatError("Expecting exponent for a floating-point number and found \"" + c + "\"");
                }
                return Double.NaN;
            }
            while (c >= '0' && c <= '9') {
                stringBuffer.append(this.readChar());
                c = this.lookChar();
            }
        }
        String string = stringBuffer.toString();
        try {
            Double d2 = new Double(string);
            d = d2;
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.doFormatError("Illegal floating point number");
            return Double.NaN;
        }
        return d;
    }

    public boolean readBoolean() {
        boolean bl = false;
        String string = this.getWord();
        if (this.errorFlag) {
            return false;
        }
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equals("1")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equals("0")) {
            bl = false;
        } else {
            this.doFormatError("Illegal input for value of type boolean: \"" + string + "\"");
        }
        return bl;
    }

    private long readInteger(long l, long l2) {
        this.skipWhiteSpace();
        if (this.errorFlag) {
            return 0L;
        }
        int n = 43;
        if (this.lookChar() == '-' || this.lookChar() == '+') {
            n = this.getChar();
            this.skipWhiteSpace();
        }
        long l3 = 0L;
        char c = this.lookChar();
        if (c < '0' || c > '9') {
            if (this.EOF) {
                this.doEOFError("Expecting an integer and found end-of-data");
            } else {
                this.doFormatError("Expecting an integer and found \"" + c + "\"");
            }
            return 0L;
        }
        while (!this.errorFlag && c >= '0' && c <= '9') {
            this.readChar();
            l3 = 10L * l3 + (long)c - 48L;
            if (l3 < 0L) {
                this.doFormatError("Integer value outside of legal range");
                return 0L;
            }
            c = this.lookChar();
        }
        if (n == 45) {
            l3 = -l3;
        }
        if (l3 < l || l3 > l2) {
            this.doFormatError("Integer value outside of legal range");
            return 0L;
        }
        return l3;
    }

    public int read() throws IOException {
        if (this.lookAhead == -1) {
            return super.read();
        }
        int n = this.lookAhead;
        this.lookAhead = -1;
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.lookAhead == -1 || n2 <= 0) {
            return super.read(cArray, n, n2);
        }
        if (n2 == 1) {
            cArray[n] = (char)this.lookAhead;
            this.lookAhead = -1;
            return 1;
        }
        cArray[n] = (char)this.lookAhead;
        this.lookAhead = -1;
        int n3 = super.read(cArray, n + 1, n2 - 1);
        return n3 + 1;
    }

    public static class EOFError
    extends Error {
        EOFError(String string) {
            super(string);
        }
    }

    public static class FormatError
    extends Error {
        FormatError(String string) {
            super(string);
        }
    }

    public static class Error
    extends RuntimeException {
        Error(String string) {
            super(string);
        }
    }
}

