/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.Dimension;
import java.util.ConcurrentModificationException;
import java.util.Random;

public class KKWeightedLayout
extends AbstractLayout {
    private double EPSILON = 0.1;
    private int currentIteration;
    private int maxIterations = 2000;
    private String status = "KKLayout";
    private double L;
    private double K = 1.0;
    private double[][] dm;
    private boolean adjustForGravity = true;
    private boolean exchangeVertices = true;
    private Vertex[] vertices;
    private Coordinates[] xydata;
    private double length_factor = 0.2;
    private double distance_diameter = -1.0;
    float size;

    public KKWeightedLayout(Graph graph, double[][] dArray, double d) {
        super(graph);
        this.dm = dArray;
        this.setLengthFactor(d);
    }

    public void setLengthFactor(double d) {
        this.length_factor = d;
    }

    public String getStatus() {
        return this.status + this.getCurrentSize();
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return this.currentIteration > this.maxIterations;
    }

    protected void initialize_local() {
        this.currentIteration = 0;
    }

    protected void initializeLocations() {
        super.initializeLocations();
        Dimension dimension = this.getCurrentSize();
        this.size = Math.min(dimension.height, dimension.width);
        float f = this.size * 0.8f;
        float f2 = this.size * 0.1f;
        Random random = new Random();
        double[] dArray = this.getDistanceScales();
        this.distance_diameter = dArray[1];
        int n = this.getGraph().getVertices().size();
        this.vertices = new Vertex[n];
        this.xydata = new Coordinates[n];
        while (true) {
            try {
                int n2 = 0;
                for (Vertex vertex : this.getGraph().getVertices()) {
                    Coordinates coordinates = this.getCoordinates((ArchetypeVertex)vertex);
                    this.vertices[n2] = vertex;
                    this.xydata[n2] = coordinates;
                    this.xydata[n2].x = random.nextFloat() * f + f2;
                    this.xydata[n2].y = random.nextFloat() * f + f2;
                    ++n2;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.L = this.length_factor * (double)this.size / this.distance_diameter;
    }

    protected double[] getDistanceScales() {
        double d = this.dm[0][0];
        double d2 = this.dm[0][0];
        for (int i = 0; i < this.dm[0].length - 1; ++i) {
            for (int j = i + 1; j < this.dm[0].length; ++j) {
                double d3 = this.dm[i][j];
                d = Math.max(d3, d);
                d2 = Math.min(d3, d);
            }
        }
        double[] dArray = new double[]{d2, d};
        return dArray;
    }

    protected double[] getDisplayScales() {
        double d = this.xydata[0].x;
        double d2 = this.xydata[0].x;
        double d3 = this.xydata[0].y;
        double d4 = this.xydata[0].y;
        for (int i = 1; i < this.xydata.length; ++i) {
            d = Math.max((double)this.xydata[i].x, d);
            d3 = Math.max((double)this.xydata[i].y, d3);
            d2 = Math.min((double)this.xydata[i].x, d2);
            d4 = Math.min((double)this.xydata[i].y, d4);
        }
        double[] dArray = new double[]{d2, d, d4, d3};
        return dArray;
    }

    public String getDisplayScaleString(String string) {
        double[] dArray = this.getDisplayScales();
        return dArray[0] + string + dArray[1] + string + dArray[2] + string + dArray[3];
    }

    protected double getDisplayDiameter() {
        double[] dArray = this.getDisplayScales();
        double d = (dArray[1] - dArray[0]) * (dArray[1] - dArray[0]) + (dArray[3] - dArray[2]) * (dArray[3] - dArray[2]);
        return Math.sqrt(d);
    }

    protected void initialize_local_vertex(Vertex vertex) {
    }

    public void advancePositions() {
        double d;
        int n;
        ++this.currentIteration;
        double d2 = this.calcEnergy();
        this.status = "Kamada-Kawai V=" + this.getVisibleVertices().size() + "(" + this.getGraph().numVertices() + ")" + " IT: " + this.currentIteration + " E=" + d2;
        System.out.println(this.status);
        System.out.println("x then y min then max: " + this.getDisplayScaleString(", "));
        int n2 = this.getVisibleGraph().numVertices();
        if (n2 == 0) {
            return;
        }
        double d3 = 0.0;
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            double d4;
            if (this.isLocked(this.vertices[n]) || !(d3 < (d4 = this.calcDeltaM(n)))) continue;
            d3 = d4;
            n3 = n;
        }
        if (n3 == -1) {
            return;
        }
        for (n = 0; n < 100; ++n) {
            double[] dArray = this.calcDeltaXY(n3);
            this.xydata[n3].add(dArray[0], dArray[1]);
            d = this.calcDeltaM(n3);
            if (d < this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity();
        }
        if (this.exchangeVertices && d3 < this.EPSILON) {
            d2 = this.calcEnergy();
            for (n = 0; n < n2 - 1; ++n) {
                if (this.isLocked(this.vertices[n])) continue;
                for (int i = n + 1; i < n2; ++i) {
                    if (this.isLocked(this.vertices[i]) || !(d2 > (d = this.calcEnergyIfExchanged(n, i)))) continue;
                    double d5 = this.xydata[n].getX();
                    double d6 = this.xydata[n].getY();
                    this.xydata[n].setX(this.xydata[i].getX());
                    this.xydata[n].setY(this.xydata[i].getY());
                    this.xydata[i].setX(d5);
                    this.xydata[i].setY(d6);
                    return;
                }
            }
        }
    }

    public void adjustForGravity() {
        Dimension dimension = this.getCurrentSize();
        double d = dimension.getHeight();
        double d2 = dimension.getWidth();
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.xydata.length; ++i) {
            d3 += this.xydata[i].getX();
            d4 += this.xydata[i].getY();
        }
        double d5 = d2 / 2.0 - (d3 /= (double)this.xydata.length);
        double d6 = d / 2.0 - (d4 /= (double)this.xydata.length);
        for (int i = 0; i < this.xydata.length; ++i) {
            this.xydata[i].add(d5, d6);
        }
    }

    public void setAdjustForGravity(boolean bl) {
        this.adjustForGravity = bl;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangeVertices(boolean bl) {
        this.exchangeVertices = bl;
    }

    public boolean getExchangeVertices() {
        return this.exchangeVertices;
    }

    private double[] calcDeltaXY(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == n) continue;
            double d7 = this.dm[n][i];
            double d8 = this.L * d7;
            double d9 = this.K / (d7 * d7);
            double d10 = this.xydata[n].getX() - this.xydata[i].getX();
            double d11 = this.xydata[n].getY() - this.xydata[i].getY();
            double d12 = Math.sqrt(d10 * d10 + d11 * d11);
            double d13 = d12 * d12 * d12;
            d += d9 * (1.0 - d8 / d12) * d10;
            d2 += d9 * (1.0 - d8 / d12) * d11;
            d3 += d9 * (1.0 - d8 * d11 * d11 / d13);
            d4 += d9 * d8 * d10 * d11 / d13;
            d6 += d9 * (1.0 - d8 * d10 * d10 / d13);
        }
        d5 = d4;
        double d14 = d3 * d6 - d4 * d5;
        double d15 = (d4 * d2 - d6 * d) / d14;
        double d16 = (d5 * d - d3 * d2) / d14;
        return new double[]{d15, d16};
    }

    private double calcDeltaM(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == n) continue;
            double d3 = this.dm[n][i];
            double d4 = this.L * d3;
            double d5 = this.K / (d3 * d3);
            double d6 = this.xydata[n].getX() - this.xydata[i].getX();
            double d7 = this.xydata[n].getY() - this.xydata[i].getY();
            double d8 = Math.sqrt(d6 * d6 + d7 * d7);
            double d9 = d5 * (1.0 - d4 / d8);
            d += d9 * d6;
            d2 += d9 * d7;
        }
        return Math.sqrt(d * d + d2 * d2);
    }

    private double calcEnergy() {
        double d = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                double d2 = this.dm[i][j];
                double d3 = this.L * d2;
                double d4 = this.K / (d2 * d2);
                double d5 = this.xydata[i].getX() - this.xydata[j].getX();
                double d6 = this.xydata[i].getY() - this.xydata[j].getY();
                double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                d += d4 / 2.0 * (d5 * d5 + d6 * d6 + d3 * d3 - 2.0 * d3 * d7);
            }
        }
        return d;
    }

    private double calcEnergyIfExchanged(int n, int n2) {
        if (n >= n2) {
            throw new RuntimeException("p should be < q");
        }
        double d = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                int n3 = i;
                int n4 = j;
                if (i == n) {
                    n3 = n2;
                }
                if (j == n2) {
                    n4 = n;
                }
                double d2 = this.dm[i][j];
                double d3 = this.L * d2;
                double d4 = this.K / (d2 * d2);
                double d5 = this.xydata[n3].getX() - this.xydata[n4].getX();
                double d6 = this.xydata[n3].getY() - this.xydata[n4].getY();
                double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                d += d4 / 2.0 * (d5 * d5 + d6 * d6 + d3 * d3 - 2.0 * d3 * d7);
            }
        }
        return d;
    }
}

