/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.utils.TypedVertexGenerator;
import java.util.Set;

public class JungConverter {
    static final String JCVERSION = "JA060825";
    public DirectedSparseGraph g = new DirectedSparseGraph();
    public static final String VID_key = "IN_VIDKey";
    public static final String EID_key = "IN_EIDKey";
    public static final String X_key = "IN_XKey";
    public static final String Y_key = "IN_YKey";
    islandNetwork inet;

    public JungConverter(islandNetwork islandNetwork2) {
        this.inet = islandNetwork2;
        TypedVertexGenerator typedVertexGenerator = new TypedVertexGenerator(this.g.getVertexConstraints());
        StringLabeller stringLabeller = StringLabeller.getLabeller((Graph)this.g);
        UserDatumNumberVertexValue userDatumNumberVertexValue = new UserDatumNumberVertexValue((Object)VID_key);
        UserDatumNumberVertexValue userDatumNumberVertexValue2 = new UserDatumNumberVertexValue((Object)X_key);
        UserDatumNumberVertexValue userDatumNumberVertexValue3 = new UserDatumNumberVertexValue((Object)Y_key);
        int n = this.inet.siteSet.getNumberSites();
        for (int i = 0; i < n; ++i) {
            Vertex vertex = typedVertexGenerator.create();
            userDatumNumberVertexValue.setNumber((ArchetypeVertex)vertex, (Number)i);
            userDatumNumberVertexValue2.setNumber((ArchetypeVertex)vertex, (Number)this.inet.siteSet.getX(i));
            userDatumNumberVertexValue3.setNumber((ArchetypeVertex)vertex, (Number)this.inet.siteSet.getY(i));
            try {
                this.g.addVertex(vertex);
                stringLabeller.setLabel(vertex, this.inet.siteSet.getName(i));
                continue;
            }
            catch (StringLabeller.UniqueLabelException uniqueLabelException) {
                System.out.println("Error in JungConverter: name conflict. Skipping another vertex with name: \"" + this.inet.siteSet.getName(i) + "\"");
            }
        }
        this.addAllEdges();
    }

    private void addAllEdges() {
        UserDatumNumberEdgeValue userDatumNumberEdgeValue = new UserDatumNumberEdgeValue((Object)EID_key);
        for (int i = 0; i < this.inet.siteSet.getNumberSites(); ++i) {
            for (int j = 0; j < this.inet.siteSet.getNumberSites(); ++j) {
                if (this.inet.edgeSet.displayZeroEdgeWeight > this.inet.edgeSet.getDisplayVariable(i, j)) continue;
                Vertex vertex = this.getVertexWithID(i);
                Vertex vertex2 = this.getVertexWithID(j);
                DirectedSparseEdge directedSparseEdge = new DirectedSparseEdge(vertex, vertex2);
                userDatumNumberEdgeValue.setNumber((ArchetypeEdge)directedSparseEdge, (Number)this.inet.edgeSet.getIndex(i, j));
                this.g.addEdge((Edge)directedSparseEdge);
            }
        }
    }

    public void replaceAllEdges() {
        this.g.removeAllEdges();
        this.addAllEdges();
    }

    public int getNumberEdges() {
        return this.g.numEdges();
    }

    public Vertex getVertexWithID(int n) {
        for (Vertex vertex : this.g.getVertices()) {
            if (!vertex.getUserDatum((Object)VID_key).equals(n)) continue;
            return vertex;
        }
        return null;
    }

    public islandNetwork getIslandNetwork() {
        return this.inet;
    }

    public Graph getGraph() {
        return this.g;
    }

    public Set getEdges() {
        return this.g.getEdges();
    }

    public Set getVertices() {
        return this.g.getVertices();
    }

    public String getXCoordKey() {
        return X_key;
    }

    public String getYCoordKey() {
        return Y_key;
    }
}

