/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.Vertex.IslandSiteSet;
import TimUtilities.NumbersToString;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import java.awt.event.MouseEvent;

public class GraphToolTip
implements ToolTipFunction {
    IslandSiteSet sites;
    IslandEdgeSet edges;
    UserDatumNumberVertexValue siteKey;
    UserDatumNumberEdgeValue edgeKey;
    static final NumbersToString num2String = new NumbersToString();

    public GraphToolTip(UserDatumNumberVertexValue userDatumNumberVertexValue, IslandSiteSet islandSiteSet, UserDatumNumberEdgeValue userDatumNumberEdgeValue, IslandEdgeSet islandEdgeSet) {
        this.sites = islandSiteSet;
        this.siteKey = userDatumNumberVertexValue;
        this.edges = islandEdgeSet;
        this.edgeKey = userDatumNumberEdgeValue;
    }

    public String getToolTipText(Vertex vertex) {
        int n = this.siteKey.getNumber((ArchetypeVertex)vertex).intValue();
        return this.sites.getName(n) + " " + NumbersToString.toString(this.sites.getWeight(n), 3);
    }

    public String getToolTipText(Edge edge) {
        int n = this.edgeKey.getNumber((ArchetypeEdge)edge).intValue();
        return this.edges.toGraphToolTipString(n, ": ", ", ", 3);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }
}

