/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.ClusteringWindow;
import IslandNetworks.islandNetwork;
import IslandNetworks.jungInterfaces.JungConverter;
import TimGraph.Coordinate;
import TimGraph.io.GraphMLGenerator;
import TimUtilities.JavaColours;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;

public class GraphML {
    public static void FileOutputGMLNetwork(String string, JungConverter jungConverter, VisualizationViewer visualizationViewer, boolean bl, boolean bl2) {
        if (bl2) {
            System.out.println("Attempting to write general information to " + string);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            GraphML.output(printStream, string, jungConverter, visualizationViewer, bl);
            try {
                fileOutputStream.close();
                if (bl2) {
                    System.out.println("Finished writing to " + string);
                }
            }
            catch (IOException iOException) {
                System.err.println("File Error " + iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error opening output file " + string + ": " + fileNotFoundException);
            return;
        }
    }

    public static void output(PrintStream printStream, String string, JungConverter jungConverter, VisualizationViewer visualizationViewer, boolean bl) {
        Object object;
        Vertex vertex;
        Object object22;
        GraphMLGenerator graphMLGenerator = new GraphMLGenerator();
        graphMLGenerator.printInitialLines(printStream, string, true);
        Layout layout = visualizationViewer.getGraphLayout();
        PluggableRenderer pluggableRenderer = (PluggableRenderer)visualizationViewer.getRenderer();
        VertexPaintFunction vertexPaintFunction = pluggableRenderer.getVertexPaintFunction();
        VertexShapeFunction vertexShapeFunction = pluggableRenderer.getVertexShapeFunction();
        islandNetwork islandNetwork2 = jungConverter.getIslandNetwork();
        String string2 = GraphMLGenerator.DEFAULT_SHAPE;
        Set set = jungConverter.getVertices();
        int n = set.size();
        for (Object object22 : set) {
            vertex = (Vertex)object22;
            Point2D point2D = layout.getLocation((ArchetypeVertex)vertex);
            int n2 = (Integer)vertex.getUserDatum((Object)"IN_VIDKey");
            Color color = (Color)vertexPaintFunction.getFillPaint(vertex);
            object = vertexShapeFunction.getShape(vertex).getBounds();
            double d = ((Rectangle)object).width;
            double d2 = ((Rectangle)object).height;
            String string3 = islandNetwork2.siteSet.getName(n2);
            graphMLGenerator.printNodeColoured(printStream, n2, n, point2D.getX(), point2D.getY(), d, d2, string3, JavaColours.RGB(color), string2);
        }
        Set set2 = jungConverter.getEdges();
        object22 = pluggableRenderer.getEdgePaintFunction();
        vertex = pluggableRenderer.getEdgeStrokeFunction();
        double d = 0.1;
        boolean bl2 = true;
        object = "";
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Edge edge = (Edge)e;
            Color color = (Color)object22.getDrawPaint(edge);
            if (bl && color == ClusteringWindow.PERCREMOVEDCOLOUR) continue;
            int n3 = (Integer)edge.getUserDatum((Object)"IN_EIDKey");
            int n4 = islandNetwork2.edgeSet.getSource(n3);
            int n5 = islandNetwork2.edgeSet.getTarget(n3);
            Coordinate coordinate = new Coordinate(islandNetwork2.siteSet.getSite((int)n5).X, islandNetwork2.siteSet.getSite((int)n5).Y);
            Coordinate coordinate2 = new Coordinate(islandNetwork2.siteSet.getSite((int)n5).X, islandNetwork2.siteSet.getSite((int)n5).Y);
            BasicStroke basicStroke = (BasicStroke)vertex.getStroke(edge);
            float f = basicStroke.getLineWidth();
            graphMLGenerator.printArcEdge(printStream, n3, n4, n5, coordinate, coordinate2, d, (String)object, f, bl2, (String)object);
        }
        graphMLGenerator.printFinalLines(printStream);
    }
}

