/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Decorator;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.List;

public class EdgePercolationRanker
extends AbstractRanker {
    public static final String EDGEWEIGHT = "IN_EWKey";

    public EdgePercolationRanker(Graph graph) {
        this.initialize(graph, true, true);
    }

    public EdgePercolationRanker(Graph graph, boolean bl) {
        this.initialize(graph, bl, true);
    }

    public EdgePercolationRanker(Graph graph, boolean bl, boolean bl2) {
        this.initialize(graph, bl, bl2);
    }

    private void initializeData(Graph graph, BetweennessDataDecorator betweennessDataDecorator) {
        for (Vertex vertex : graph.getVertices()) {
            if (vertex.getUserDatum((Object)EDGEWEIGHT) == null) {
                vertex.addUserDatum((Object)EDGEWEIGHT, (Object)new MutableDouble(), UserData.SHARED);
            }
            betweennessDataDecorator.setData(new BetweennessData(), (Element)vertex);
        }
        for (Vertex vertex : graph.getEdges()) {
            if (vertex.getUserDatum((Object)EDGEWEIGHT) != null) continue;
            vertex.addUserDatum((Object)EDGEWEIGHT, (Object)new MutableDouble(), UserData.SHARED);
        }
    }

    public String getRankScoreKey() {
        return EDGEWEIGHT;
    }

    protected double evaluateIteration() {
        return 0.0;
    }

    class BetweennessData {
        double distance = -1.0;
        double numSPs = 0.0;
        List predecessors = new ArrayList();
        double dependency = 0.0;

        BetweennessData() {
        }
    }

    class BetweennessDataDecorator
    extends Decorator {
        public BetweennessDataDecorator() {
            super((Object)"EDGEWEIGHT.BetwennessData", UserData.REMOVE);
        }

        public BetweennessData data(Element element) {
            return (BetweennessData)element.getUserDatum(this.getKey());
        }

        public void setData(BetweennessData betweennessData, Element element) {
            element.setUserDatum(this.getKey(), (Object)betweennessData, this.getCopyAction());
        }
    }
}

