/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;

public class EdgePercolationClusterer {
    private int mNumEdgesToRemove;
    private ListOrderedSet mEdgesRemoved;
    private Graph graph;
    int edgeVariableIndex = 0;
    IslandEdgeSet edgeSet;

    public EdgePercolationClusterer(ArchetypeGraph archetypeGraph, islandNetwork islandNetwork2) {
        if (!(archetypeGraph instanceof Graph)) {
            throw new IllegalArgumentException("Argument must be of type Graph.");
        }
        this.graph = (Graph)archetypeGraph;
        this.edgeSet = islandNetwork2.edgeSet;
        this.edgeVariableIndex = this.edgeSet.DisplayEdgeType.getValueIndex();
    }

    public ClusterSet extract(double d) {
        Edge edge2;
        UserDatumNumberEdgeValue userDatumNumberEdgeValue = new UserDatumNumberEdgeValue((Object)"IN_EIDKey");
        this.mEdgesRemoved = new ListOrderedSet();
        for (Edge edge2 : this.graph.getEdges()) {
            if (!(this.edgeSet.getVariable(userDatumNumberEdgeValue.getNumber((ArchetypeEdge)edge2).intValue(), this.edgeVariableIndex) < d)) continue;
            this.mEdgesRemoved.add((Object)edge2);
        }
        GraphUtils.removeEdges((Graph)this.graph, (Set)this.mEdgesRemoved);
        WeakComponentClusterer weakComponentClusterer = new WeakComponentClusterer();
        edge2 = weakComponentClusterer.extract((ArchetypeGraph)this.graph);
        GraphUtils.addEdges((Graph)this.graph, (Set)this.mEdgesRemoved);
        return edge2;
    }

    public ClusterSet extractByRank(double d) {
        WeakComponentClusterer weakComponentClusterer = new WeakComponentClusterer();
        ClusterSet clusterSet = weakComponentClusterer.extract((ArchetypeGraph)this.graph);
        return clusterSet;
    }

    public List getEdgesRemoved() {
        return this.mEdgesRemoved.asList();
    }
}

