/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.jungInterfaces;

import IslandNetworks.islandNetwork;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.AbstractVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.VertexSizeFunction;
import java.awt.Shape;

public final class AriadneVertexShapeSizeAspect
extends AbstractVertexShapeFunction
implements VertexSizeFunction,
VertexAspectRatioFunction {
    protected boolean stretch = false;
    protected boolean scale = true;
    protected boolean funny_shapes = false;
    protected double vertexScaling;
    private final islandNetwork INET;

    public AriadneVertexShapeSizeAspect(islandNetwork islandNetwork2, int n) {
        this.INET = islandNetwork2;
        this.setScaling(n);
        this.setSizeFunction(this);
        this.setAspectRatioFunction(this);
    }

    public void setScaling(double d) {
        if (d > 0.0) {
            this.vertexScaling = d;
            this.setScaling(true);
        } else {
            this.setScaling(false);
        }
    }

    public void setStretching(boolean bl) {
        this.stretch = bl;
    }

    public void setScaling(boolean bl) {
        this.scale = bl;
    }

    public void useFunnyShapes(boolean bl) {
        this.funny_shapes = bl;
    }

    public int getSize(Vertex vertex) {
        if (!this.scale) {
            return 8;
        }
        Integer n = (Integer)vertex.getUserDatum((Object)"IN_VIDKey");
        int n2 = (int)(this.INET.siteSet.getDisplaySize(n) + 0.5);
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public float getAspectRatio(Vertex vertex) {
        if (this.stretch) {
            return (float)(vertex.inDegree() + 1) / (float)(vertex.outDegree() + 1);
        }
        return 1.0f;
    }

    public Shape getShape(Vertex vertex) {
        if (this.funny_shapes) {
            if (vertex.degree() < 5) {
                int n = Math.max(vertex.degree(), 3);
                return this.factory.getRegularPolygon(vertex, n);
            }
            return this.factory.getRegularStar(vertex, vertex.degree());
        }
        return this.factory.getEllipse(vertex);
    }
}

