/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.CalculationParameters;
import IslandNetworks.Edge.DistanceMetric;
import IslandNetworks.Edge.EdgeTypeSelection;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.ExecuteMode;
import IslandNetworks.GlobalProperties;
import IslandNetworks.IslandArguments;
import IslandNetworks.IslandCulture;
import IslandNetworks.IslandHamiltonian;
import IslandNetworks.IslandTransferMatrix;
import IslandNetworks.ModelNumber;
import IslandNetworks.MonteCarloHistory;
import IslandNetworks.NetworkGenerator;
import IslandNetworks.NetworkWindow;
import IslandNetworks.OutputMode;
import IslandNetworks.PajekColours;
import IslandNetworks.SiteWindowMode;
import IslandNetworks.UpdateMode;
import IslandNetworks.Vertex.IslandSite;
import IslandNetworks.Vertex.IslandSiteSet;
import IslandNetworks.Vertex.VertexMode;
import IslandNetworks.Vertex.VertexTypeSelection;
import IslandNetworks.io.FileLocation;
import JavaNotes.TextReader;
import TimUtilities.Distances;
import TimUtilities.GeneralMode;
import TimUtilities.JavaColours;
import TimUtilities.KMLGenerator;
import TimUtilities.Permutation;
import TimUtilities.StatisticalQuantity;
import TimUtilities.TimCounting;
import TimUtilities.TimMessage;
import TimUtilities.TimSort;
import TimUtilities.TimTime;
import TimUtilities.UpdateRecord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

public class islandNetwork {
    public static final String iNVERSION = "iN110401";
    static final TimTime timTime = new TimTime();
    static final int MAXSITENUMBER = 200;
    static final String SEPSTRING = "\t";
    static final String GENELABEL = "!";
    static final String COMMENT = "#";
    static final String STARTSECTION = "*";
    public static final String inputFileEnding = "_input";
    public static final String NETWORKDATAFILEEXT = "anf";
    static final double MAXH = 1000000.0;
    static final double MINDOUBLE = 1.0E-10;
    boolean MChistory = false;
    boolean inputGUI = false;
    boolean dataread = false;
    OutputMode outputMode;
    public FileLocation inputFile;
    public FileLocation outputFile;
    boolean autoSetOutputFileName;
    IslandArguments commandLine = new IslandArguments();
    double jiggleScale = 0.0;
    int numberSites = 200;
    public IslandEdgeSet edgeSet;
    public IslandSiteSet siteSet;
    public double betaInitial = 0.001;
    IslandHamiltonian Hamiltonian;
    StatisticalQuantity siteRankStats;
    StatisticalQuantity siteInfluenceStats;
    double[] inSiteStrengthWeight;
    double[] outSiteStrengthWeight;
    double[] inSiteStrengthValue;
    double[] outSiteStrengthValue;
    GlobalProperties globalProperties;
    StatisticalQuantity siteDistanceStats;
    IslandCulture networkCulture;
    double culturePSiteCopy = 0.45;
    double culturePCopy = 0.45;
    double culturePInnovate = 0.05;
    double cultureTimeScale = 10000.0;
    public IslandTransferMatrix transferMatrix;
    double influenceProb = 0.5;
    UpdateRecord edgeUR = new UpdateRecord();
    UpdateRecord vertexUR = new UpdateRecord();
    public TimMessage message = new TimMessage(0);
    CalculationParameters calcParam;
    public ExecuteMode executeMode;
    UpdateMode updateMode;
    VertexMode vertexMode;
    ModelNumber modelNumber;
    final String[] mcsmsh = new String[]{"Hot", "Cold", "Old"};
    final String[] mcsmlg = new String[]{"Hot start, random values", "Cold start, all equal weight", "Old or existing configuration"};
    public GeneralMode monteCarloStartMode = new GeneralMode(this.mcsmsh, this.mcsmlg, 0);
    int MCsweeps = 100;
    int siteWeightFactor = 20;
    int edgeWidthFactor = 10;
    double DisplayMaxVertexScale = 8.0;
    public VertexTypeSelection DisplayVertexType;
    SiteWindowMode siteWindowMode = new SiteWindowMode(1);
    JavaColours javaColour;
    static PajekColours pajekColour = new PajekColours();
    int visualisationWidth = 760;
    int visualisationHeight = 760;
    static Random rnd;
    int generateNumber = -1;
    int generateType = 0;

    public islandNetwork(int n) {
        this.inputGUI = true;
        this.executeMode = new ExecuteMode();
        this.outputMode = new OutputMode(15);
        this.numberSites = n;
        this.initialiseArrays(-1.0);
        this.setColours();
        String string = System.getProperty("user.dir");
        this.inputFile = new FileLocation(string + "/input/", "", "aegean39S1L3a", "", inputFileEnding, "dat");
        this.outputFile = new FileLocation(string + "/output/", "", "aegean39S1L3a", "", 0, "", "dat");
        this.autoSetOutputFileName = true;
        this.Hamiltonian = new IslandHamiltonian();
        this.modelNumber = new ModelNumber(1.3);
        this.updateMode = new UpdateMode("MC");
        this.vertexMode = new VertexMode(5.0);
        this.DisplayVertexType = new VertexTypeSelection();
        rnd = new Random();
    }

    public islandNetwork(islandNetwork islandNetwork2) {
        this.numberSites = islandNetwork2.numberSites;
        this.inputGUI = islandNetwork2.inputGUI;
        this.dataread = islandNetwork2.dataread;
        this.inputFile = new FileLocation(islandNetwork2.inputFile);
        this.outputFile = new FileLocation(islandNetwork2.outputFile);
        if (this.message.getInformationLevel() > -2) {
            System.out.println("Creating new Island Network, input name = " + this.inputFile.getFullFileRoot());
        }
        this.siteSet = new IslandSiteSet(islandNetwork2.siteSet);
        this.edgeSet = new IslandEdgeSet(islandNetwork2.edgeSet);
        this.copyGeneralParameters(islandNetwork2);
        this.Hamiltonian = islandNetwork2.Hamiltonian;
        this.copyDisplayParameters(islandNetwork2);
        this.networkCulture = islandNetwork2.networkCulture == null ? null : new IslandCulture(islandNetwork2.networkCulture);
        this.globalProperties = new GlobalProperties(islandNetwork2.globalProperties);
        this.influenceProb = islandNetwork2.influenceProb;
    }

    public islandNetwork(File file, islandNetwork islandNetwork2) {
        TextReader textReader;
        this.inputFile = islandNetwork2.inputFile;
        this.outputFile = new FileLocation(file);
        this.copyGeneralParameters(islandNetwork2);
        this.Hamiltonian = new IslandHamiltonian(islandNetwork2.Hamiltonian);
        this.copyDisplayParameters(islandNetwork2);
        this.setColours();
        String string = this.outputFile.getFullLocationFileName("", NETWORKDATAFILEEXT);
        System.out.println("Starting to read islandNetwork from " + string);
        String string2 = "";
        String string3 = "Unknown";
        int n = 0;
        int n2 = 0;
        double[] dArray = new double[100];
        String[] stringArray = new String[100];
        String[] stringArray2 = new String[100];
        try {
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Can't find file " + string + ", message " + fileNotFoundException);
        }
        try {
            int n3;
            int n4;
            int n5;
            while (!textReader.eof()) {
                ++n;
                string3 = textReader.getWord();
                if (string3.startsWith(COMMENT)) {
                    string2 = string3 + textReader.getln();
                    System.out.println("Comment: " + string2);
                    continue;
                }
                if (string3.startsWith("*param")) {
                    while (!textReader.eoln()) {
                        stringArray[n2++] = textReader.getWord();
                    }
                    System.out.print("Parameter string: ");
                    for (n5 = 0; n5 < n2; ++n5) {
                        System.out.print(SEPSTRING + stringArray[n5]);
                    }
                    System.out.println();
                    continue;
                }
                if (!string3.startsWith("*sites") && !string3.startsWith("*edges")) continue;
            }
            if (stringArray.length > 0) {
                this.Parse(stringArray);
            }
            if (!string3.startsWith("*sites")) {
                throw new RuntimeException("*** ERROR - next line should start with *sites");
            }
            this.numberSites = Integer.parseInt(textReader.getWord());
            this.initialiseArrays(-1.0);
            ++n;
            n2 = 0;
            do {
                stringArray2[n2++] = textReader.getWord();
            } while (!textReader.eoln());
            for (n5 = 0; n5 < n2 && !stringArray2[n5].startsWith(GENELABEL); ++n5) {
            }
            int[] nArray = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = IslandSite.getIndex(stringArray2[n4]);
            }
            for (n4 = n5; n4 < n2; ++n4) {
                this.siteSet.addGene(stringArray2[n4].substring(GENELABEL.length()));
            }
            for (n4 = 0; n4 < this.numberSites; ++n4) {
                ++n;
                for (n3 = 0; n3 < n5; ++n3) {
                    string2 = textReader.getWord();
                    this.siteSet.setVariable(n4, nArray[n3], string2);
                }
                for (n3 = n5; n3 < n2; ++n3) {
                    string2 = textReader.getWord();
                    this.siteSet.setGeneValue(n4, n3 - n5, string2);
                }
            }
            ++n;
            string3 = textReader.getWord();
            if (string3.startsWith("*edges")) {
                ++n;
                n2 = 0;
                do {
                    stringArray2[n2++] = textReader.getWord();
                } while (!textReader.eoln());
                nArray = new int[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    nArray[n4] = IslandEdge.getIndex(stringArray2[n4]);
                    if (IslandEdge.checkIndex(nArray[n4])) continue;
                    System.err.println("!!! Input Warning: line number " + n + ", column " + (n4 + 1) + " edge variable name " + stringArray2[n4] + " not recognised");
                }
                n4 = 0;
                n3 = 1;
                while (!textReader.eof()) {
                    ++n;
                    int n6 = 0;
                    while (!textReader.eoln()) {
                        if (n6 < nArray.length) {
                            int n7 = nArray[n6++];
                            String string4 = textReader.getWord();
                            if (!IslandEdge.checkIndex(n7)) continue;
                            this.edgeSet.setVariable(n4, n7, Double.parseDouble(string4));
                            continue;
                        }
                        if (n3 == 0) continue;
                        n3 = 0;
                        System.err.println("!!! Input Warning: line number " + n + ", has too many columns, wanted " + nArray.length + " found " + (n6 + 1));
                    }
                    ++n4;
                }
                if (n4 != this.numberSites * this.numberSites) {
                    throw new RuntimeException("Error: line number " + n + " end of file reached but only read " + n4 + " edges");
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Input Error: line number " + n + ".  Error = " + exception.getMessage());
        }
        finally {
            textReader.close();
        }
        System.out.println("Finished reading from " + string + " last line studied was " + n);
    }

    public void copyGeneralParameters(islandNetwork islandNetwork2) {
        this.executeMode = new ExecuteMode(islandNetwork2.executeMode);
        this.updateMode = new UpdateMode(islandNetwork2.updateMode.getNumber());
        this.vertexMode = new VertexMode(islandNetwork2.vertexMode);
        this.modelNumber = new ModelNumber(islandNetwork2.modelNumber);
        this.outputMode = new OutputMode(islandNetwork2.outputMode);
        this.monteCarloStartMode = new GeneralMode(islandNetwork2.monteCarloStartMode);
    }

    public void copyDisplayParameters(islandNetwork islandNetwork2) {
        this.siteWeightFactor = islandNetwork2.siteWeightFactor;
        this.edgeWidthFactor = islandNetwork2.edgeWidthFactor;
        this.DisplayMaxVertexScale = islandNetwork2.DisplayMaxVertexScale;
        this.DisplayVertexType = new VertexTypeSelection(islandNetwork2.DisplayVertexType);
        this.siteWindowMode = islandNetwork2.siteWindowMode;
    }

    public void initialiseArrays(double d) {
        this.siteSet = new IslandSiteSet(this.numberSites);
        this.edgeSet = new IslandEdgeSet(this.numberSites, d);
        this.globalProperties = new GlobalProperties();
    }

    public int Parse(String[] stringArray) {
        block27: for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            if (stringArray[i].length() < 2) {
                System.out.println("\n*** Argument " + i + ", " + stringArray[i] + ", is too short");
                return 1;
            }
            if (stringArray[i].charAt(0) != '-') {
                System.out.println("\n*** Argument " + i + ", " + stringArray[i] + ", does not start with -");
                return 2;
            }
            switch (stringArray[i].charAt(1)) {
                case 'a': {
                    this.Hamiltonian.alpha = Double.parseDouble(stringArray[i].substring(2));
                    continue block27;
                }
                case 'b': {
                    if (stringArray[i].charAt(2) == 't') {
                        this.betaInitial = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 's') continue block27;
                    this.Hamiltonian.setb(Double.parseDouble(stringArray[i].substring(3)));
                    continue block27;
                }
                case 'c': {
                    if (stringArray[i].charAt(2) == 'c') {
                        this.culturePCopy = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) == 's') {
                        this.culturePSiteCopy = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) == 'i') {
                        this.culturePInnovate = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 't') continue block27;
                    this.cultureTimeScale = Double.parseDouble(stringArray[i].substring(3));
                    continue block27;
                }
                case 'd': {
                    if (stringArray[i].charAt(2) == 'l') {
                        this.Hamiltonian.distanceScale = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) == 'm') {
                        this.edgeSet.metric.set(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 's') continue block27;
                    this.Hamiltonian.shortDistanceScale = Double.parseDouble(stringArray[i].substring(3));
                    continue block27;
                }
                case 'e': {
                    this.edgeSet.edgeMode.setEdgeMode(Double.parseDouble(stringArray[i].substring(2)));
                    continue block27;
                }
                case 'f': {
                    if (stringArray[i].charAt(2) == 'i') {
                        if (stringArray[i].charAt(3) == 'j') {
                            this.jiggleScale = Double.parseDouble(stringArray[i].substring(3));
                        } else {
                            this.inputFile.set(stringArray[i].substring(3));
                        }
                    }
                    if (stringArray[i].charAt(2) != 'o') continue block27;
                    if (stringArray[i].charAt(3) == 'a') {
                        this.autoSetOutputFileName = true;
                        continue block27;
                    }
                    if (stringArray[i].charAt(3) == 'A') {
                        this.autoSetOutputFileName = false;
                        continue block27;
                    }
                    this.outputFile.set(stringArray[i].substring(3));
                    continue block27;
                }
                case 'g': {
                    this.Hamiltonian.gamma = Double.parseDouble(stringArray[i].substring(2));
                    continue block27;
                }
                case 'i': {
                    this.message.setInformationLevel(Integer.parseInt(stringArray[i].substring(2)));
                    continue block27;
                }
                case 'j': {
                    this.Hamiltonian.vertexSource = Double.parseDouble(stringArray[i].substring(2));
                    continue block27;
                }
                case 'k': {
                    this.Hamiltonian.kappa = Double.parseDouble(stringArray[i].substring(2));
                    continue block27;
                }
                case 'l': {
                    this.Hamiltonian.lambda = Double.parseDouble(stringArray[i].substring(2));
                    continue block27;
                }
                case 'm': {
                    this.Hamiltonian.edgeSource = Double.parseDouble(stringArray[i].substring(2));
                    continue block27;
                }
                case 'o': {
                    this.outputMode.set(Integer.parseInt(stringArray[i].substring(2)));
                    continue block27;
                }
                case 'u': {
                    this.updateMode.set(Integer.parseInt(stringArray[i].substring(2)));
                    continue block27;
                }
                case 'v': {
                    this.modelNumber.set(Double.parseDouble(stringArray[i].substring(2)));
                    continue block27;
                }
                case 'w': {
                    this.inputGUI = true;
                    if (!stringArray[i].substring(2, 3).equals("n")) continue block27;
                    this.inputGUI = false;
                    continue block27;
                }
                case 'x': {
                    if (stringArray[i].charAt(2) == 'v') {
                        this.vertexMode.setMaxValueModeOn(Double.parseDouble(stringArray[i].substring(3)));
                    }
                    if (stringArray[i].charAt(2) != 'w') continue block27;
                    this.vertexMode.setConstantWeightModeOn(Double.parseDouble(stringArray[i].substring(3)));
                    continue block27;
                }
                case 'C': {
                    if (stringArray[i].charAt(2) == 'c') {
                        this.monteCarloStartMode.setFromName("Cold");
                    }
                    if (stringArray[i].charAt(2) == 'h') {
                        this.monteCarloStartMode.setFromName("Hot");
                    }
                    if (stringArray[i].charAt(2) != 'o') continue block27;
                    this.monteCarloStartMode.setFromName("Old");
                    continue block27;
                }
                case 'D': {
                    if (stringArray[i].charAt(2) == 'v') {
                        if (stringArray[i].charAt(3) == 's') {
                            this.DisplayMaxVertexScale = Double.parseDouble(stringArray[i].substring(4));
                        }
                        if (stringArray[i].charAt(3) == 't') {
                            this.DisplayVertexType.setValue(Integer.parseInt(stringArray[i].substring(4)));
                        }
                    }
                    if (stringArray[i].charAt(2) == 'e') {
                        if (stringArray[i].charAt(3) == 's') {
                            this.edgeSet.DisplayMaxEdgeScale = Double.parseDouble(stringArray[i].substring(4));
                        }
                        if (stringArray[i].charAt(3) == 't') {
                            this.edgeSet.DisplayEdgeType.setValue(Integer.parseInt(stringArray[i].substring(4)));
                        }
                    }
                    if (stringArray[i].charAt(2) == 'z') {
                        this.edgeSet.zeroColourFrac = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) == 'n') {
                        this.edgeSet.minColourFrac = Double.parseDouble(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) == 'x') {
                        this.visualisationWidth = Integer.parseInt(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 'y') continue block27;
                    this.visualisationHeight = Integer.parseInt(stringArray[i].substring(3));
                    continue block27;
                }
                case 'E': {
                    this.executeMode.setMode(stringArray[i].substring(2));
                    continue block27;
                }
                case 'Z': {
                    if (stringArray[i].charAt(2) == 'n') {
                        this.generateNumber = Integer.parseInt(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 't') continue block27;
                    this.generateType = Integer.parseInt(stringArray[i].substring(3));
                    continue block27;
                }
                case 'X': {
                    System.err.println(" *** ERROR, agrument -X deprecated, use -x?ddd ");
                    return 5;
                }
                case 'F': {
                    if (stringArray[i].charAt(2) == 'i') {
                        this.inputFile.setRootDirectory(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 'o') continue block27;
                    this.outputFile.setRootDirectory(stringArray[i].substring(3));
                    continue block27;
                }
                case 'S': {
                    if (stringArray[i].charAt(2) == 'i') {
                        this.inputFile.setSubDirectory(stringArray[i].substring(3));
                    }
                    if (stringArray[i].charAt(2) != 'o') continue block27;
                    this.outputFile.setSubDirectory(stringArray[i].substring(3));
                    continue block27;
                }
                case '?': {
                    this.Usage();
                    return 4;
                }
                default: {
                    System.out.println("\n*** Argument " + i + ", " + stringArray[i] + ", not known, usage:");
                    this.Usage();
                    return 3;
                }
            }
        }
        this.setOutputFileName();
        if (this.vertexMode.constantWeightOn) {
            this.Hamiltonian.vertexSource = this.vertexMode.totalWeight / (double)this.numberSites;
        }
        return 0;
    }

    public void Usage() {
        int n;
        islandNetwork islandNetwork2 = new islandNetwork(1);
        System.out.println("...............................................................................");
        System.out.println("Ariadne, iNVERSION iN110401 usage: ");
        System.out.println("aegean <options> ");
        System.out.println(" where options are -<char><value> separated by space as follows ");
        System.out.println("  -a<alpha>    Sets alpha, short distance power in edge potential, default " + islandNetwork2.Hamiltonian.alpha);
        System.out.println("  -bs<b>       Sets b, power used for site terms, default " + islandNetwork2.Hamiltonian.getb());
        System.out.println("  -bt<betaInitial>    Sets initial beta, inverse temperature, default " + islandNetwork2.betaInitial);
        System.out.println("                Also number of edges per site in PPA mode");
        System.out.println("  -cc<culturePCopy>     probability that will copy culture of neighbour, default " + islandNetwork2.culturePCopy);
        System.out.println("  -cc<culturePSiteCopy> probability that will copy culture within site, default " + islandNetwork2.culturePSiteCopy);
        System.out.println("  -cc<culturePInnovate> probability that will innovate new culture keeping existing culture, default " + islandNetwork2.culturePInnovate);
        System.out.println("  -cc<cultureTimeScale> time scale in units of tau_2, default " + islandNetwork2.cultureTimeScale);
        System.out.println("  -dl<distanceScale> Sets distance scale, " + islandNetwork2.Hamiltonian.distanceScale);
        System.out.println("  -dm<metricNumber>  Sets metric for Dijkstra calculations, default " + islandNetwork2.Hamiltonian.shortDistanceScale);
        DistanceMetric.listAll(System.out, "                     ", ": ");
        System.out.println("  -ds<shortdistanceScale> Sets short distance scale, default " + islandNetwork2.Hamiltonian.shortDistanceScale);
        System.out.println("  -e<edgeMode>      Sets edge max edge value or binary (0 or 1) if 0,");
        System.out.println("                    Negative indicates maximum strength, default " + islandNetwork2.edgeSet.edgeMode.edgeModeValue());
        System.out.println("  -fa          Sets the output file name to AUTO,");
        System.out.println("                    i.e. automatic format as noted above");
        System.out.println("                            default " + islandNetwork2.inputFile.getFullFileRoot());
        System.out.println("  -fij<jiggleScale>  Sets scale to jiggle input site locations, default " + islandNetwork2.jiggleScale);
        System.out.println("  -fi?<string>  Sets input file names and directories where ? given below");
        System.out.println("  -foa        Sets filename to automatic based on parameters, default " + islandNetwork2.autoSetOutputFileName);
        System.out.println("  -foA        No automatic file name");
        System.out.println("  -fo?<string> Sets input file names and directories where ? given below");
        System.out.println("               ? is a character taken from:-");
        this.inputFile.printSetStrings(System.out, "              ");
        System.out.println("  -g<gamma>         Sets gamma, short distance power in edge potential,");
        System.out.println("                            default " + islandNetwork2.Hamiltonian.gamma);
        System.out.println("  -i<message.getInformationLevel()>     Sets information level, 0 lowest, default " + islandNetwork2.message.getInformationLevel());
        System.out.println("  -j<j>        Sets j, sum over all vertex weights, default " + islandNetwork2.Hamiltonian.vertexSource);
        System.out.println("  -k<kappa>         Sets kappa, coefficient of vertex potential, default " + islandNetwork2.Hamiltonian.lambda);
        System.out.println("  -l<lambda>        Sets lambda, coefficient of edge potential, default " + islandNetwork2.Hamiltonian.lambda);
        System.out.println("  -m<mu>       Sets mu, sum over all edge weights, default " + islandNetwork2.Hamiltonian.edgeSource);
        System.out.println("  -o<outputMode>    Sets output mode by bits 1 (0)= on (off):, default " + islandNetwork2.outputMode.getNumber());
        this.outputMode.listAll(System.out, "                    ", " = ");
        System.out.println("  -u<updateMode>    Sets update mode: " + islandNetwork2.updateMode.listAllShort(" ", ", ") + ". Default " + islandNetwork2.updateMode.getNumber());
        System.out.println("  -v<modelNumber>   Sets model number to use, default " + islandNetwork2.modelNumber.major + "_" + islandNetwork2.modelNumber.minor);
        System.out.println("  -w[y|n]      Sets window mode on -wy or off -wn, default " + islandNetwork2.inputGUI);
        System.out.println("  -xv<vertexMaximum>  Sets vertices to have a maximum value");
        System.out.println("  -xw<constantWeight> Sets total weight of vertices to be constant");
        System.out.println("                      Vertex mode and value defaults are " + islandNetwork2.vertexMode.descriptionValue(", value="));
        System.out.println("  -C<name> sets MC calculation starting configuration");
        for (n = 0; n < this.monteCarloStartMode.getNumberModes(); ++n) {
            System.out.println("  -C" + this.monteCarloStartMode.getString(n) + " = " + this.monteCarloStartMode.getLongString(n));
        }
        System.out.println("  -Des<DisplayMaxEdgeScale> Sets size of edge weight (s[i]v[i]e[i][j]) for maximum");
        System.out.println("                              colour in display (absolute),");
        System.out.println("                              if 0 then largest value actual value used (relative),");
        System.out.println("                               default " + islandNetwork2.edgeSet.DisplayMaxEdgeScale);
        System.out.println("  -Det<DisplayEdgeType> Sets type of edge displayed,");
        for (n = 0; n < EdgeTypeSelection.numberTypes; ++n) {
            System.out.println("                             " + n + " = " + EdgeTypeSelection.name[n]);
        }
        System.out.println("                          default " + islandNetwork2.edgeSet.DisplayEdgeType.getCurrentTypeString());
        System.out.println("  -Dn<minColourFrac> Sets fraction of largest colour which is to be");
        System.out.println("                       represented as colour value 1 (next to minimum),");
        System.out.println("                         default " + islandNetwork2.edgeSet.minColourFrac);
        System.out.println("  -Dvt<DisplayVertexType> Sets type of vertex displayed,");
        for (n = 0; n < VertexTypeSelection.numberTypes; ++n) {
            System.out.println("                             " + n + " = " + VertexTypeSelection.name[n]);
        }
        System.out.println("                          default " + islandNetwork2.DisplayVertexType.getCurrentTypeString());
        System.out.println("  -Dvs<DisplayMaxVertexScale> Sets size of vertex weight (s[i]v[i]) for");
        System.out.println("                              maximum colour in display (absolute),");
        System.out.println("                              if 0 then largest value actual value used (relative),");
        System.out.println("                               default " + islandNetwork2.edgeSet.DisplayMaxEdgeScale);
        System.out.println("  -Dx<visualisationWidth>  Sets preferred width for windows in pixels, default " + islandNetwork2.visualisationWidth);
        System.out.println("  -Dy<visualisationHeight> Sets preferred height for windows in pixels, default " + islandNetwork2.visualisationHeight);
        System.out.println("  -Dz<zeroColourFrac> Sets fraction of largest colour which is to be");
        System.out.println("                       represented as zero colour, default " + islandNetwork2.edgeSet.zeroColourFrac);
        System.out.println("  -E<String> sets operational mode to be that of given name, default " + islandNetwork2.executeMode.toString());
        System.out.println("             Options are: " + islandNetwork2.executeMode.allOptionsString(", ") + ".");
        System.out.println("  -Zn<n> Generates network of n sites");
        System.out.println("  -Zt<t> Generates network of type t");
        NetworkGenerator networkGenerator = new NetworkGenerator();
        for (int i = 0; i < networkGenerator.NUMBERTYPES; ++i) {
            System.out.println("           Type " + i + ":" + networkGenerator.networkName(i));
        }
        System.out.println();
        System.out.println("  -???      This usage screen. Also try ariadne.html for help.");
        System.out.println("...............................................................................");
    }

    public void setUpdateMode(String string) {
        this.updateMode.setFromName(string);
    }

    public void setOutputFileName() {
        if (this.autoSetOutputFileName) {
            this.outputFile.setRootDirectory("output/");
            String string = this.inputFile.getBasicRoot();
            this.outputFile.setBasicRoot(string);
            String string2 = this.getParameterString("");
            this.outputFile.setSubDirectory(string + string2);
            this.outputFile.setParameterName(string2);
            this.outputFile.setEnding("");
            this.outputFile.setExtension(NETWORKDATAFILEEXT);
            this.outputFile.setFirstFreeSequenceNumber();
            if (!this.outputFile.isFullLocationDirectory() && !this.outputFile.mkDirs()) {
                System.err.println("*** ERROR creating directory " + this.outputFile.getFullLocation());
            }
        }
    }

    public String getNameString(String string) {
        return this.inputFile.getBasicRoot() + string + this.getParameterString(string);
    }

    public String getParameterString(String string) {
        String string2 = this.updateMode.toString();
        switch (this.updateMode.getNumber()) {
            case 0: {
                string2 = string2 + string + "beta" + String.format("%06.3g", this.betaInitial);
                break;
            }
            case 1: {
                string2 = string2 + string + "v" + this.modelNumber.major + "_" + this.modelNumber.minor + string + "e" + this.edgeSet.edgeMode.edgeModeValue() + string + this.Hamiltonian.parameterString(string, 3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = string2 + string + "D" + String.format("%06.3f", this.Hamiltonian.distanceScale);
                break;
            }
            case 5: {
                string2 = string2 + string + "D" + String.format("%06.3f", this.Hamiltonian.distanceScale) + string + "beta" + String.format("%06.3g", this.betaInitial);
                break;
            }
            case 6: {
                string2 = string2 + string + "D" + String.format("%06.3f", this.Hamiltonian.distanceScale);
                break;
            }
        }
        return string2;
    }

    public void showDistanceValues(String string, int n) {
        this.showDistanceValues(System.out, string, n);
    }

    public void showDistanceValues(PrintStream printStream, String string, int n) {
        int n2;
        printStream.println(string + "*** Fixed DISTANCE VALUES, scale = " + SEPSTRING + this.Hamiltonian.distanceScale + SEPSTRING + " short scale=" + SEPSTRING + this.Hamiltonian.shortDistanceScale + SEPSTRING + "***************** ");
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(SEPSTRING + this.siteSet.getName(n2));
        }
        printStream.println();
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(this.siteSet.getName(n2));
            for (int i = 0; i < this.numberSites; ++i) {
                printStream.print(SEPSTRING + this.TruncDec(this.edgeSet.getEdgeDistance(n2, i), n));
            }
            printStream.println();
        }
    }

    public void FileOutputDistanceValues(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_distvalues", "dat");
        if (this.message.getInformationLevel() > -2) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            this.showDistanceValues(printStream, string, n);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -2) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void showScaledDistanceValues(PrintStream printStream, String string, int n) {
        double d = 0.0;
        printStream.println(string + "--- SCALED DISTANCES in units of " + this.TruncDec(this.Hamiltonian.distanceScale, n) + " -------------");
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.print(SEPSTRING + this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                d = this.TruncDec(this.edgeSet.getEdgeDistance(i, j) / this.Hamiltonian.distanceScale, n);
                printStream.print(SEPSTRING + d);
            }
            printStream.println();
        }
    }

    public void showScaledDistanceValues(String string, int n) {
        this.showScaledDistanceValues(System.out, string, n);
    }

    public void showPotentialDistanceValues(String string, int n) {
        this.showPotentialDistanceValues(System.out, string, n);
    }

    public void showPotentialDistanceValues(PrintStream printStream, String string, int n) {
        double d = 0.0;
        printStream.println("--- POTENTIAL SCALE (edge value 1.0) ------");
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.print(SEPSTRING + this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                d = this.TruncDec(this.edgeSet.getEdgePotential1(i, j), n);
                printStream.print(SEPSTRING + d);
            }
            printStream.println();
        }
    }

    public void showdHValues(double d) {
        int n = 3;
        double d2 = 0.0;
        System.out.println("--- dH Values for edge value 1.0 ------");
        for (int i = 0; i < this.numberSites; ++i) {
            System.out.print(SEPSTRING + this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                d2 = this.TruncDec(this.deltaEdgeHamiltonian(i, j, d), n);
                System.out.print(SEPSTRING + d2);
            }
            System.out.println();
        }
    }

    public void FileOutputEdgeVariableFullTable(String string, int n, String string2) {
        String string3 = this.outputFile.getFullLocationFileName("_edgetableM" + this.edgeSet.metric.getNumber(), "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string3);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.edgeSet.printEdgeFullTable(string, printStream, SEPSTRING, n, "value", this.siteSet);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string3);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string3);
            return;
        }
    }

    public void showEdgeValueFullTable(String string, int n) {
        this.edgeSet.printEdgeFullTable(string, System.out, SEPSTRING, n, "value", this.siteSet);
    }

    public void FileOutputEdgeValueFullTable(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_edgetableM" + this.edgeSet.metric.getNumber(), "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.edgeSet.printEdgeFullTable(string, printStream, SEPSTRING, n, "value", this.siteSet);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputEdgeList(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_edgelist", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.edgeSet.printList(printStream, string, SEPSTRING, n, true);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputGeneCorrelation(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_edgegenesep", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.edgeSet.printEdgeFullTable(string, printStream, SEPSTRING, n, "geneCorrelation", this.siteSet);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public String breakString(String string, int n, String string2) {
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            string3 = string3 + string + string2;
        }
        return string3;
    }

    public void showEdgeList(String string, PrintStream printStream, int n) {
        this.edgeSet.metric.set(4);
        this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        printStream.println(string + "number" + SEPSTRING + "source" + SEPSTRING + "target" + SEPSTRING + IslandEdge.toStringLabel(SEPSTRING) + " M" + this.edgeSet.metric.getNumber() + SEPSTRING + this.iNVERSIONString(SEPSTRING));
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j) continue;
                printStream.println(i * this.numberSites + j + SEPSTRING + i + SEPSTRING + j + SEPSTRING + this.edgeSet.getEdgeString(i, j, SEPSTRING, n));
            }
        }
    }

    public void showEdgeWeights(String string, PrintStream printStream, int n) {
        double[][] dArray = new double[this.numberSites][this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                dArray[i][j] = this.siteSet.getWeight(i) * this.edgeSet.getEdgeValue(i, j);
            }
        }
        this.showTable("Weights", dArray, string, printStream, n);
    }

    public void showTable(String string, double[][] dArray, String string2, PrintStream printStream, int n) {
        double[] dArray2 = new double[this.numberSites];
        printStream.println(string2 + string + this.breakString("***", this.numberSites, SEPSTRING));
        printStream.print(string2 + "Name");
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.print(SEPSTRING + this.siteSet.getName(i));
            dArray2[i] = 0.0;
        }
        printStream.println("\tTot.OUT." + string);
        double d = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.print(this.siteSet.getName(i));
            for (int j = 0; j < this.numberSites; ++j) {
                d += dArray[i][j];
                printStream.print(SEPSTRING + this.TruncDec(dArray[i][j], n));
            }
            printStream.println(SEPSTRING + this.TruncDec(d, n) + SEPSTRING + this.siteSet.getName(i));
        }
        printStream.println();
        double d2 = 0.0;
        printStream.print("Tot.In " + string);
        for (int i = 0; i < this.numberSites; ++i) {
            d2 += dArray2[i];
            printStream.print(SEPSTRING + this.TruncDec(dArray2[i], n));
        }
        printStream.println(SEPSTRING + d2);
    }

    public void showColourValues(String string, int n) {
        this.showColourValues(string, System.out, n);
    }

    public void FileOutputColourValues(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_colour.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showColourValues(string, printStream, n);
            try {
                fileOutputStream.close();
                System.out.println("Finished writing to " + string2);
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void showColourValues(String string, PrintStream printStream, int n) {
        int n2;
        printStream.println(string + "--- Colour Values ------------------------------");
        printStream.print("From/to");
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(SEPSTRING + this.siteSet.getName(n2));
        }
        printStream.println();
        printStream.print("S.Col.");
        this.siteSet.printDisplaySizes(printStream, SEPSTRING, 3);
        printStream.print("\n\nFrom/to");
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(SEPSTRING + this.siteSet.getName(n2));
        }
        printStream.println();
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(this.siteSet.getName(n2));
            for (int i = 0; i < this.numberSites; ++i) {
                printStream.print(SEPSTRING + this.TruncDec(this.edgeSet.getEdgeColour(n2, i), 3));
            }
            printStream.println();
        }
    }

    public void showFixedSiteVariables(PrintStream printStream, String string, int n) {
        this.siteSet.printFixedSiteVariables(printStream, string, SEPSTRING);
        printStream.println(string + SEPSTRING + "MIN" + SEPSTRING + " " + SEPSTRING + this.siteSet.minX + SEPSTRING + this.siteSet.minY + SEPSTRING + " ");
        printStream.println(string + SEPSTRING + "MAX" + SEPSTRING + " " + SEPSTRING + this.siteSet.maxX + SEPSTRING + this.siteSet.maxY + SEPSTRING + " ");
    }

    public void showFixedSiteVariables(String string, int n) {
        this.showFixedSiteVariables(System.out, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDistanceData() {
        TextReader textReader;
        String string = this.inputFile.getFullFileName("_dist", "dat");
        System.out.println("Starting to read distance data from " + string);
        try {
            textReader = new TextReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + string);
            return 1;
        }
        try {
            int n;
            String[] stringArray = new String[200];
            int n2 = 0;
            while (!textReader.eoln()) {
                stringArray[n2] = textReader.getWord();
                ++n2;
            }
            this.numberSites = n2;
            this.siteSet = new IslandSiteSet(this.numberSites);
            for (n = 0; n < this.numberSites; ++n) {
                this.siteSet.setName(n, stringArray[n]);
            }
            double d = -97531.2468;
            n = 0;
            while (!textReader.eof()) {
                int n3 = 0;
                textReader.getWord();
                while (!textReader.eoln()) {
                    d = textReader.getDouble();
                    this.edgeSet.setEdgeDistance(n, n3, d);
                    if (++n3 == this.numberSites) continue;
                    System.out.println("Wrong number of distances to in site " + n);
                }
                ++n;
            }
            if (n != this.numberSites) {
                System.out.println("Wrong number of distances from in " + string);
            }
            System.out.println("Finished reading from " + string);
        }
        catch (TextReader.Error error) {
            System.out.println("Input Error: " + error.getMessage());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Too many numbers in data file" + string);
            System.out.println("Processing has been aborted.");
        }
        finally {
            textReader.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int getSiteData() {
        var1_1 = this.inputFile.getFullLocationSimpleFileName("_input", "dat");
        System.out.println("getSiteData() Starting to read site values and position data from " + var1_1);
        var4_2 = "RUBBISH";
        var6_3 = new String[200];
        var7_4 = new IslandSite();
        var8_5 = 0;
        var9_6 = new double[200][200];
        try {
            var2_7 = new TextReader(new FileReader(var1_1));
        }
        catch (FileNotFoundException var10_8) {
            System.out.println("Can't find file " + var1_1);
            return -100;
        }
        try {
            var10_9 = true;
            var11_14 = 0;
            this.numberSites = 0;
            while (var10_9 && !var2_7.eof()) {
                ++var11_14;
                var4_2 = var2_7.getWord();
                this.message.println(1, "first word is " + var4_2);
                if (var4_2.startsWith("#")) {
                    var5_16 = var4_2 + var2_7.getln();
                    this.message.println(1, "Line " + var11_14 + ", Comment: " + var5_16);
                    continue;
                }
                if (var4_2.startsWith("*")) {
                    var5_16 = var4_2 + var2_7.getln();
                    if (this.message.testInformationLevel(1)) {
                        System.out.println("Line " + var11_14 + ", Table Start: " + var5_16);
                    }
                    var10_9 = false;
                    continue;
                }
                if (var4_2.startsWith("!")) {
                    if (var4_2.length() < 2) {
                        System.err.println("ERROR line " + var11_14 + ": no Gene name in  - " + var4_2);
                        continue;
                    }
                    var12_17 = this.siteSet.addGene(var4_2.substring(1));
                    this.message.println(1, "Line " + var11_14 + ", Gene: " + var4_2.substring(1));
                    var3_15 = 0;
                    while (!var2_7.eoln()) {
                        var6_3[var3_15++] = var2_7.getWord();
                    }
                    if (this.numberSites <= 0) {
                        this.numberSites = var3_15;
                        this.initialiseArrays(-1.0);
                    } else if (this.numberSites != var3_15) {
                        System.out.println("WARNING line " + var11_14 + ": found  " + var3_15 + " columns expected " + this.numberSites);
                        continue;
                    }
                    if ((var13_18 = -this.siteSet.setGeneValues(var12_17, var6_3)) <= 0) continue;
                    System.out.println("WARNING line " + var11_14 + ": gene number " + var12_17 + ", wrong type of input in column " + var13_18 + " - line ignored");
                    continue;
                }
                var12_17 = var7_4.dataNameNumber(var4_2, 4);
                if (var12_17 < 0) {
                    System.out.println("WARNING line " + var11_14 + ": unknown first word " + var4_2 + " - line ignored");
                    continue;
                }
                this.message.println(1, "Line " + var11_14 + ", General Data Type: " + var4_2);
                var3_15 = 0;
                while (!var2_7.eoln()) {
                    var6_3[var3_15++] = var2_7.getWord();
                }
                if (this.numberSites <= 0) {
                    this.numberSites = var3_15;
                    this.initialiseArrays(-1.0);
                } else if (this.numberSites != var3_15) {
                    System.out.println("WARNING line " + var11_14 + ": found  " + var3_15 + " columns expected " + this.numberSites);
                    continue;
                }
                if ((var13_18 = -this.siteSet.setValues(var12_17, var6_3)) <= 0) continue;
                System.out.println("WARNING line " + var11_14 + ": wrong type of input in column " + var13_18 + ", line ignored");
            }
            if (this.siteSet.isLatLongSet() && !this.siteSet.isXYSet()) {
                this.siteSet.setXYFromLatLong();
            } else {
                this.siteSet.rescaleXY();
            }
            if (var4_2.substring(0, 3).equalsIgnoreCase("*Di")) {
                var8_5 = 1;
            }
            if (var4_2.substring(0, 3).equalsIgnoreCase("*Pe")) {
                var8_5 = 2;
            }
            if (!var2_7.eof()) {
                var12_17 = 0;
                while (!var2_7.eof()) {
                    ++var11_14;
                    var13_18 = 0;
                    var2_7.getWord();
                    while (!var2_7.eoln()) {
                        var9_6[var12_17][var13_18] = var2_7.getDouble();
                        ++var13_18;
                    }
                    if (var13_18 != this.numberSites) {
                        System.out.println("WARNING line " + var11_14 + ": Wrong number (" + var13_18 + ") of distances from site " + var12_17);
                    }
                    if (var13_18 < this.numberSites) {
                        var8_5 = -3;
                    }
                    ++var12_17;
                }
                if (var12_17 != this.numberSites) {
                    System.out.println("WARNING line " + var11_14 + ": Wrong number (" + var12_17 + ") of distance entries in table in " + var1_1);
                }
                if (var12_17 < this.numberSites) {
                    var8_5 = -2;
                }
            }
            switch (var8_5) {
                case 0: {
                    this.message.println(0, "Finished reading from " + var1_1 + " - No table found");
                    ** break;
lbl104:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.message.println(0, "Finished reading from " + var1_1 + " - Distances read");
                    ** break;
lbl108:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.message.println(0, "Finished reading from " + var1_1 + " - Penalties read");
                    ** break;
lbl112:
                    // 1 sources

                    break;
                }
                default: {
                    this.message.printERROR("Finished reading from " + var1_1 + " *** Unknown Table Type or error in reading it");
                    var8_5 = -10 + var8_5;
                    break;
                }
            }
        }
        catch (TextReader.Error var10_10) {
            System.out.println("Problem reading the data from the input file. Error: " + var10_10.getMessage());
            var8_5 = -20 + var8_5;
        }
        catch (IndexOutOfBoundsException var10_11) {
            System.out.println("Too many numbers in data file" + var1_1);
            System.out.println("Processing has been aborted.");
            var8_5 = -30 + var8_5;
        }
        finally {
            var2_7.close();
        }
        if (this.jiggleScale > 0.0) {
            this.jiggleSiteData(this.Hamiltonian.distanceScale * this.jiggleScale);
        }
        this.siteSet.setShortNames();
        if (var8_5 >= 0) {
            var10_13 = -99.753;
            for (var12_17 = 0; var12_17 < this.numberSites; ++var12_17) {
                for (var13_18 = 0; var13_18 < this.numberSites; ++var13_18) {
                    switch (var8_5) {
                        case 0: {
                            if (this.siteSet.isLatLongSet()) {
                                var10_13 = this.siteSet.sphericalDistance(var12_17, var13_18);
                                break;
                            }
                            var10_13 = this.siteSet.euclideanDistance(var12_17, var13_18);
                            break;
                        }
                        case 1: {
                            var10_13 = var9_6[var12_17][var13_18];
                            break;
                        }
                        case 2: {
                            var10_13 = this.siteSet.isLatLongSet() != false ? this.siteSet.sphericalDistance(var12_17, var13_18) : this.siteSet.euclideanDistance(var12_17, var13_18);
                            var10_13 *= var9_6[var12_17][var13_18];
                            break;
                        }
                        default: {
                            System.out.println("*** Unknown Table Type or error in reading it");
                            var8_5 = -40;
                        }
                    }
                    this.edgeSet.setEdgeDistance(var12_17, var13_18, var10_13);
                }
            }
        }
        if (this.siteSet.isGenetic()) {
            this.edgeSet.setGeneCorrelations(this.siteSet);
            if (this.outputMode.isSet(OutputMode.GeneSeparationIndex)) {
                this.FileOutputGeneCorrelation("#", 3);
            }
        }
        this.siteSet.calcAlphabeticalOrder();
        if (this.numberSites > 0) {
            this.edgeSet.zeroColourFrac = 1.0 / (double)this.numberSites;
        }
        return var8_5;
    }

    public void jiggleSiteData(double d) {
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d2 = Math.PI * 2 * rnd.nextDouble();
            d3 = (2.0 * rnd.nextDouble() - 1.0) * d;
            d5 = this.siteSet.getX(i) + d3 * Math.sin(d2);
            d6 = this.siteSet.getY(i) + d3 * Math.cos(d2);
            for (int j = 0; j < this.numberSites; ++j) {
                d4 = this.edgeSet.getEdgeDistance(i, j) / this.siteSet.euclideanDistance(i, j);
                d7 = Distances.euclideanDistance(d5, d6, this.siteSet.getX(j), this.siteSet.getY(j)) * d4;
                this.edgeSet.setEdgeDistance(i, j, d7);
                this.edgeSet.setEdgeDistance(j, i, d7);
            }
            this.siteSet.setXY(i, d5, d6);
        }
        this.siteSet.setMinMaxXY();
    }

    public void FileOutputCultureStatistics(String string, int n) {
        if (this.networkCulture == null) {
            return;
        }
        String string2 = this.outputFile.getFullLocationFileName("_culture.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.networkCulture.print(printStream, string, SEPSTRING, n);
            try {
                fileOutputStream.close();
                System.out.println("Finished writing to " + string2);
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    void FileOutputSiteDistance(String string) {
        String string2 = this.outputFile.getFullLocationFileName("_svpdist", "dat");
        System.out.println("Attempting to write to " + string2);
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print("Name");
            for (n = 0; n < this.numberSites; ++n) {
                printStream.print(SEPSTRING + this.siteSet.getName(n));
            }
            printStream.println();
            printStream.print("Size");
            for (n = 0; n < this.numberSites; ++n) {
                printStream.print(SEPSTRING + this.siteSet.getSize(n));
            }
            printStream.println();
            if (this.siteSet.isXYSet()) {
                printStream.print("XPos");
                for (n = 0; n < this.numberSites; ++n) {
                    printStream.print(this.siteSet.getX(n) + SEPSTRING);
                }
                printStream.println();
                printStream.print("YPos");
                for (n = 0; n < this.numberSites; ++n) {
                    printStream.print(this.siteSet.getY(n) + SEPSTRING);
                }
                printStream.println();
            }
            if (this.siteSet.isLatLongSet()) {
                printStream.print("Lat");
                for (n = 0; n < this.numberSites; ++n) {
                    printStream.print(this.siteSet.getLatitude(n) + SEPSTRING);
                }
                printStream.println();
                printStream.print("Long");
                for (n = 0; n < this.numberSites; ++n) {
                    printStream.print(this.siteSet.getLongitude(n) + SEPSTRING);
                }
                printStream.println();
            }
            for (n = 0; n < this.numberSites; ++n) {
                printStream.print(this.siteSet.getName(n));
                for (int i = 0; i < this.numberSites; ++i) {
                    printStream.print(SEPSTRING + this.edgeSet.getEdgeDistance(n, i));
                }
                printStream.println();
            }
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputNetworkParam(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_param", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println("Number of Sites\t" + this.numberSites);
            this.showHamiltonianParameters(printStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void FileOutputNetworkStatistics(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_info", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println("Number of Sites\t" + this.numberSites);
            this.showHamiltonianParameters(printStream);
            this.showNetworkStatistics(string, printStream, n);
            if (this.edgeSet.isSet(IslandEdge.distanceINDEX, 1)) {
                this.showDistanceValues(printStream, string, n);
            }
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void printiNVERSION(String string) {
        this.printiNVERSION(string, System.out);
    }

    public void printiNVERSION(String string, PrintStream printStream) {
        printStream.println(string + SEPSTRING + " --- ARIADNE" + SEPSTRING + " iNVERSION " + SEPSTRING + this.iNVERSIONString(SEPSTRING) + SEPSTRING + " ---");
    }

    public String iNVERSIONString(String string) {
        return iNVERSION + string + timTime.fullString(string);
    }

    public void showHamiltonianParameters() {
        this.showHamiltonianParameters(System.out);
    }

    public void showHamiltonianParameters(PrintStream printStream) {
        printStream.println("--- Parameters for Hamiltonian Model number\t" + this.modelNumber.major + "_" + this.modelNumber.minor);
        printStream.println("    " + this.modelNumber.majorString + " " + this.modelNumber.minorString);
        this.Hamiltonian.printParameters(printStream, SEPSTRING);
        printStream.println("      metric number \t" + this.edgeSet.metric.getNumber());
        printStream.println("           edgeMode \t" + this.edgeSet.edgeMode.edgeModeValue() + SEPSTRING + this.edgeSet.edgeMode.description());
        printStream.println("         vertexMode \t" + this.vertexMode.descriptionValue(SEPSTRING));
    }

    public void showInputParameters(PrintStream printStream) {
        printStream.println("Model\t" + this.modelNumber.majorString + SEPSTRING + this.modelNumber.minorString);
        this.Hamiltonian.printParameters(printStream, SEPSTRING);
        printStream.println("Metric\t" + this.edgeSet.metric.getNumber());
        printStream.println("edgeMode\t" + this.edgeSet.edgeMode.edgeModeValue());
    }

    public void printNetworkStatistics(String string, int n) {
        this.showNetworkStatistics(string, System.out, n);
    }

    public void FileOutputKMLNetwork(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("", "kml");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.showKMLNetwork(printStream, string, n);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    private void showKMLNetwork(PrintStream printStream, String string, int n) {
        int n2;
        KMLGenerator.printInitialLines(printStream);
        KMLGenerator.printName(printStream, "Ariadne Network " + this.iNVERSIONString(" "));
        KMLGenerator.printDescription(printStream, "-v" + this.modelNumber.number + "-u" + this.updateMode.getNumber() + " " + this.vertexMode.modeString() + "\n" + this.Hamiltonian.inputParametersString(" "));
        KMLGenerator.printLookAt(printStream, this.siteSet.getLatitude(0), this.siteSet.getLongitude(0), 800000.0);
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            KMLGenerator.printPlacemarkPoint(printStream, this.siteSet.getName(n2), this.siteSet.toString(n2, ": ", "\n", 4), this.siteSet.getLatitude(n2), this.siteSet.getLongitude(n2));
        }
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            double d = this.siteSet.getLatitude(n2);
            double d2 = this.siteSet.getLongitude(n2);
            for (int i = 0; i < this.numberSites; ++i) {
                if (this.edgeSet.getEdgeDisplaySize(n2, i) < this.edgeSet.zeroColourFrac) continue;
                double d3 = this.siteSet.getLatitude(i);
                double d4 = this.siteSet.getLongitude(i);
                String string2 = n2 + " - " + i;
                String string3 = "From " + this.siteSet.getName(n2) + " to " + this.siteSet.getName(i) + "\n" + this.edgeSet.toString(n2 * this.numberSites + i, ": ", "\n", 5);
                KMLGenerator.printPlacemarkLine(printStream, false, string2, string3, d, d2, d3, d4);
            }
        }
        KMLGenerator.printFinalLines(printStream);
    }

    public void FileOutputNetworkForData(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("", NETWORKDATAFILEEXT);
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.showNetworkForData(printStream, string, n);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void printNetworkForData(String string, int n) {
        this.showNetworkForData(System.out, string, n);
    }

    private void showNetworkForData(PrintStream printStream, String string, int n) {
        this.printiNVERSION(string, printStream);
        printStream.print("*param");
        printStream.print("\t-v" + this.modelNumber.number);
        printStream.print("\t-u" + this.updateMode.getNumber());
        printStream.println(SEPSTRING + this.vertexMode.modeString());
        printStream.println("*param\t" + this.Hamiltonian.inputParametersString(SEPSTRING));
        printStream.println("*sites\t" + this.numberSites);
        printStream.println(IslandSite.parameterStringNames(SEPSTRING) + this.siteSet.geneNameString("\t!"));
        this.siteSet.printSiteParameters(printStream, string, SEPSTRING);
        printStream.println("*edges");
        this.edgeSet.printParameterList(printStream, "", SEPSTRING, n, true);
    }

    public void showNetworkStatistics(String string, PrintStream printStream, int n) {
        int n2;
        this.globalProperties.print(printStream, SEPSTRING);
        printStream.println(string + " ***" + SEPSTRING + "Site Weights and Values" + this.breakString("***", this.numberSites, SEPSTRING));
        this.siteSet.printSiteVariables(printStream, string, SEPSTRING);
        this.edgeSet.printEdgeFullTable(string, printStream, SEPSTRING, n, "value", this.siteSet);
        this.edgeSet.printEdgeFullTable(string, printStream, SEPSTRING, n, "weight", this.siteSet);
        printStream.println(string + " ***" + SEPSTRING + " Influence");
        printStream.println(string + " Influence Prob. " + this.influenceProb);
        printStream.print(string + "Name");
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(SEPSTRING + this.siteSet.getName(n2));
        }
        printStream.println();
        printStream.print("Infl.Rank");
        this.siteSet.printValues(printStream, string, SEPSTRING, "InfluenceRank");
        printStream.println("\tInfl.Rank");
        this.showInfluenceMatrix(string, printStream, n);
        if (this.networkCulture != null) {
            printStream.println(string + " ***" + SEPSTRING + "Culture" + SEPSTRING + "(column j's culture at site row i) ***** ");
            printStream.print(string + " Culture Probabilities  " + this.networkCulture.eProb.toString(SEPSTRING));
            printStream.print(string + "Name" + SEPSTRING + SEPSTRING);
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(SEPSTRING + this.siteSet.getName(n2));
            }
            printStream.println();
            this.networkCulture.print(printStream, string, SEPSTRING, 3);
        }
        printStream.println(string + "*** SCALES *******************");
        printStream.println(string + "Single Edge Max Value        " + SEPSTRING + this.TruncDec(this.siteSet.siteValueStats.maximum, n) + SEPSTRING + " at vertex " + this.siteSet.maxSiteValueIndex);
        printStream.println(string + "Single Edge Max Weight       " + SEPSTRING + this.TruncDec(this.edgeSet.edgeStats[IslandEdge.weightINDEX].maximum, n) + SEPSTRING + " from vertex " + this.edgeSet.maxEdgeWeightSource + " to " + this.edgeSet.maxEdgeWeightTarget);
        printStream.println(string + "Single Site Max Weight       " + SEPSTRING + this.TruncDec(this.siteSet.siteWeightStats.maximum, n) + SEPSTRING + " at vertex " + this.siteSet.maxSiteWeightIndex);
        printStream.println(string + "Single Site Max out Strength " + SEPSTRING + this.TruncDec(this.siteSet.siteStrengthOutStats.maximum, n) + SEPSTRING + " at vertex " + this.siteSet.maxOutSiteStrengthIndex);
        printStream.println(string + "*** TOTALS *******************");
        printStream.println(string + "Total Vertex Value and Weight " + SEPSTRING + this.TruncDec(this.siteSet.siteValueStats.getTotal(), n) + SEPSTRING + this.TruncDec(this.siteSet.siteWeightStats.getTotal(), n));
        printStream.println(string + "  Total Edge Value and Weight " + SEPSTRING + this.TruncDec(this.edgeSet.edgeStats[IslandEdge.valueINDEX].getTotal(), n) + SEPSTRING + this.TruncDec(this.edgeSet.edgeStats[IslandEdge.weightINDEX].getTotal(), n));
        printStream.println(string + "--- Display Factors --------------------------------");
        printStream.println(string + "Zero, Minimum Fraction for coloured edges = " + SEPSTRING + this.edgeSet.zeroColourFrac + SEPSTRING + this.edgeSet.minColourFrac);
        printStream.println(string + "Max Site and Edge Size = " + SEPSTRING + this.siteWeightFactor + SEPSTRING + this.edgeWidthFactor);
    }

    public void printPajekSiteFiles(String string, PrintStream printStream, int n, int n2) {
        this.siteSet.printValueVector(printStream, n2);
    }

    public void saveFiles(String string, int n) {
        this.setOutputFileName();
        this.calcNetworkStats();
        if (this.outputMode.isSet(OutputMode.KMLIndex)) {
            this.FileOutputKMLNetwork(COMMENT, 5);
        }
        if (this.outputMode.isSet(OutputMode.AriadneNetworkFileIndex)) {
            this.FileOutputNetworkForData(COMMENT, 5);
        }
        if (this.outputMode.isSet(OutputMode.InfoIndex)) {
            this.FileOutputNetworkStatistics(COMMENT, 3);
        }
        if (this.outputMode.isSet(OutputMode.EdgeListIndex)) {
            this.FileOutputEdgeList(COMMENT, 5);
        }
        if (this.outputMode.isSet(OutputMode.PajekIndex)) {
            String[] stringArray = new String[]{"Value", "Weight", "Ranking", "Strength", "StrengthIn", "StrengthOut"};
            for (int i = 0; i < stringArray.length; ++i) {
                this.FileOutputPajekSiteFiles(stringArray[i]);
            }
            this.FileOutputNetwork(COMMENT, this.siteWeightFactor, this.edgeWidthFactor, this.edgeSet.minColourFrac, this.edgeSet.zeroColourFrac, 0);
        }
    }

    public void showNetwork(String string, int n) {
        this.setOutputFileName();
        System.out.println("\n --- Displaying Network --------------------------------------");
        System.out.println("Output mode " + this.outputMode.getNumber() + " " + this.outputMode.toString(SEPSTRING));
        System.out.println("Scale for largest vertices in .net file= " + this.DisplayMaxVertexScale);
        System.out.println("Scale for maximum edges in .net file = " + this.edgeSet.DisplayMaxEdgeScale);
        System.out.println("Minimum Fraction for coloured edge in .net file = " + this.edgeSet.minColourFrac);
        System.out.println("Zero Fraction for coloured edge = " + this.edgeSet.zeroColourFrac);
        this.saveFiles(string, n);
        this.message.println(0, "showNetwork inputFile " + this.inputFile.getFullLocationFileRoot());
        NetworkWindow networkWindow = new NetworkWindow(this);
        this.message.println(0, "showNetwork PW.islnet.inputnameroot " + networkWindow.islnet.inputFile.getFullFileRoot());
        networkWindow.drawNetworkWindow();
        this.message.println(0, "In showNetwork finished call to PW.drawNetworkWindow()");
    }

    public void showDijkstraValues(String string, int n) {
        this.showDijkstraValues(string, System.out, n);
    }

    public void FileOutputDijkstraStatistics(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_dijkdistM" + this.edgeSet.metric.getNumber(), "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showDijkstraValues(string, printStream, n);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void showDijkstraValues(String string, PrintStream printStream, int n) {
        int n2;
        printStream.println("--- Dijkstra Results for metric " + this.edgeSet.metric.toString() + ", metric number" + this.edgeSet.metric.getNumber());
        if (this.edgeSet.DijkstraMaxSep < IslandEdgeSet.MAXSEPARATION) {
            printStream.println("Connected, max distance " + this.TruncDec(this.edgeSet.DijkstraMaxSep, n));
        } else {
            printStream.println("DISCONNECTED");
        }
        double d = 0.0;
        printStream.print("From/To");
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(SEPSTRING + this.siteSet.getName(n2));
        }
        printStream.println();
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.print(this.siteSet.getName(n2));
            for (int i = 0; i < this.numberSites; ++i) {
                if (this.edgeSet.getEdgeSeparation(n2, i) == IslandEdgeSet.MAXSEPARATION) {
                    printStream.print("\t x ");
                    continue;
                }
                d += this.edgeSet.getEdgeSeparation(n2, i);
                printStream.print(SEPSTRING + this.TruncDec(this.edgeSet.getEdgeSeparation(n2, i), n));
            }
            printStream.println();
        }
        printStream.println("\n Total Distance (excl. x) " + d);
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            printStream.println("...\t");
        }
    }

    public void calcNetworkSeparations() {
        this.siteDistanceStats = new StatisticalQuantity(IslandEdgeSet.MAXSEPARATION, -1.0);
        this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                double d = this.edgeSet.getEdgeSeparation(i, j);
                if (!(d < IslandEdgeSet.MAXSEPARATION)) continue;
                this.siteDistanceStats.add(this.edgeSet.getEdgeSeparation(i, j));
            }
        }
    }

    public void calcNetworkStats() {
        this.siteSet.calcBasicStatistics(this.edgeSet);
        this.edgeSet.calcStats(this.siteSet);
        this.message.println(2, "*** in calcNetworkStats about to calculate ranking ");
        this.calcRanking(1);
        this.message.println(2, "*** in calcNetworkStats about to calculate influence ");
        this.calcInfluence(this.influenceProb);
        this.message.println(2, "*** in calcNetworkStats finished calculating influence ");
        double d = -1.0;
        d = this.DisplayMaxVertexScale > 0.0 ? this.DisplayMaxVertexScale : this.siteSet.siteWeightStats.maximum;
        if (this.DisplayVertexType.getValue() == 1) {
            d = 1.0;
        }
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), (double)PajekColours.numberColours / d);
        this.edgeSet.setUpEdgeDisplayValues(this.siteSet, PajekColours.numberColours);
        this.globalProperties.calculateAll(this);
    }

    void calcCulture() {
        int n;
        int n2;
        double[] dArray = new double[this.numberSites];
        double[][] dArray2 = new double[this.numberSites][this.numberSites];
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            dArray[n2] = this.siteSet.getWeight(n2);
            for (n = 0; n < this.numberSites; ++n) {
                dArray2[n2][n] = this.edgeSet.getEdgeValue(n2, n);
            }
        }
        n2 = 20;
        n = this.numberSites * n2;
        double d = 1.0 / (double)n2;
        double d2 = 0.5;
        this.culturePInnovate = d * d2;
        double d3 = 1.0 - 1.0 / (double)this.numberSites;
        this.culturePSiteCopy = (1.0 - d) * d3;
        this.culturePCopy = (1.0 - d) * (1.0 - d3);
        this.networkCulture = new IslandCulture(this.culturePSiteCopy, this.culturePCopy, this.culturePInnovate);
        this.networkCulture.setup(dArray, dArray2, n, 1);
        int n3 = (int)(0.5 - 1.0 / Math.log(1.0 - 2.0 * this.culturePSiteCopy / (double)this.numberSites));
        this.networkCulture.message.setInformationLevel(this.message.getInformationLevel());
        this.networkCulture.evolve((int)((double)n3 * this.cultureTimeScale + 0.5));
        this.networkCulture.calcAllStats();
    }

    void setColours() {
        this.javaColour = new JavaColours(PajekColours.numberColours, true);
    }

    public String getJavaColour(int n) {
        return this.javaColour.RGB(n);
    }

    public void calcTransferMatrix(int n, int n2) {
        this.transferMatrix = new IslandTransferMatrix(n, this.numberSites, this.siteSet, this.edgeSet, n2);
    }

    public void calcRanking(int n) {
        this.message.println(-1, "*** in calcRanking about to calculate TransferMatrix");
        this.transferMatrix = new IslandTransferMatrix(n, this.numberSites, this.siteSet, this.edgeSet, IslandEdge.valueINDEX);
        this.siteSet.calcRanking(this.transferMatrix);
    }

    public void calcInfluence(double d) {
        this.siteSet.calcInfluence(this.transferMatrix, d);
        this.edgeSet.setInfluenceWeight(this.siteSet, this.transferMatrix);
    }

    public void calcInfluence(int n, double d, int n2) {
        this.transferMatrix = new IslandTransferMatrix(n, this.numberSites, this.siteSet, this.edgeSet, n2);
        this.calcInfluence(d);
    }

    public double getInfluenceProbability() {
        return this.transferMatrix.getInfluenceProbability();
    }

    public double getInfluenceMatrix(int n, int n2) {
        return this.transferMatrix.getInfluence(n, n2);
    }

    public void FileOutputTransferMatrix(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_transmat.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showTransferMatrix(string, printStream, n);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void showTransferMatrix(String string, PrintStream printStream, int n) {
        this.transferMatrix.printTransferMatrix(string, SEPSTRING, printStream, n, true);
    }

    public void showTransferMatrix(String string, int n) {
        this.showTransferMatrix(string, System.out, n);
    }

    public void FileOutputInfluenceMatrix(String string, int n) {
        String string2 = this.outputFile.getFullLocationFileName("_inflmat.dat", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write general information to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Number of Sites" + SEPSTRING + this.numberSites);
            this.showInfluenceMatrix(string, printStream, n);
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public void showInfluenceMatrix(String string, PrintStream printStream, int n) {
        this.transferMatrix.printInfluenceMatrix(string, SEPSTRING, printStream, n, true);
    }

    public void showInfluenceMatrix(String string, int n) {
        this.showInfluenceMatrix(string, System.out, n);
    }

    void FileOutputBareNetwork(String string) {
        String string2 = this.outputFile.getFullLocationFileName("_BareNet", "dat");
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write to " + string2);
        }
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printiNVERSION(string, printStream);
            printStream.println(string + "Line 0" + SEPSTRING + "Number Sites," + SEPSTRING + "Line 1" + SEPSTRING + "Site Size," + SEPSTRING + "Line 2" + SEPSTRING + "Vertex Values," + SEPSTRING + "Line >=3" + SEPSTRING + "Edge Values Value");
            printStream.println(this.numberSites);
            for (n = 0; n < this.numberSites; ++n) {
                printStream.print(this.siteSet.getSize(n) + SEPSTRING);
            }
            printStream.println();
            for (n = 0; n < this.numberSites; ++n) {
                printStream.print(this.siteSet.getValue(n) + SEPSTRING);
            }
            printStream.println();
            for (n = 0; n < this.numberSites; ++n) {
                for (int i = 0; i < this.numberSites; ++i) {
                    printStream.print(this.edgeSet.getEdgeValue(n, i) + SEPSTRING);
                }
                printStream.println();
            }
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    void FileOutputNetwork(String string, int n, int n2, double d, double d2, int n3) {
        String string2;
        switch (n3) {
            case 1: {
                string2 = this.outputFile.getFullLocationFileName("BW", "net");
                break;
            }
            case 2: {
                string2 = this.outputFile.getFullLocationFileName("C", "net");
                break;
            }
            case 3: {
                string2 = this.outputFile.getFullLocationFileName("Infl", "net");
                break;
            }
            case 4: {
                string2 = this.outputFile.getFullLocationFileName("CultCorr", "net");
                break;
            }
            default: {
                string2 = this.outputFile.getFullLocationFileName("PLAINV", "net");
            }
        }
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write to " + string2);
        }
        try {
            int n4;
            int n5;
            int n6;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.siteSet.printPajekNetFormat(printStream, d, d2, n3);
            switch (n3) {
                case 3: 
                case 4: {
                    printStream.println("*Arcs    " + this.numberSites * this.numberSites);
                    break;
                }
                default: {
                    n6 = 0;
                    for (n5 = 0; n5 < this.numberSites; ++n5) {
                        for (n4 = 0; n4 < this.numberSites; ++n4) {
                            if (!(this.edgeSet.getEdgeColour(n5, n4) > (double)PajekColours.numberColours * d2)) continue;
                            ++n6;
                        }
                    }
                    printStream.println("*Arcs    " + n6);
                }
            }
            for (n5 = 0; n5 < this.numberSites; ++n5) {
                double d3 = this.siteSet.getWeight(n5);
                block20: for (n4 = 0; n4 < this.numberSites; ++n4) {
                    if (n3 == 3) {
                        printStream.println(n5 + 1 + "  " + (n4 + 1) + "   " + this.transferMatrix.getInfluence(n5, n4) + " w " + d3 * this.edgeSet.getEdgeValue(n5, n4));
                        continue;
                    }
                    if (n3 == 4) {
                        if (n5 == n4 || this.networkCulture == null) continue;
                        printStream.println(n5 + 1 + "  " + (n4 + 1) + "   " + this.networkCulture.cultureCorrelation[n5][n4] + " w " + d3 * this.edgeSet.getEdgeValue(n5, n4));
                        continue;
                    }
                    int n7 = (int)(0.499999 + this.edgeSet.getEdgeColour(n5, n4));
                    if (n5 == n4 || (double)n7 <= d2 * (double)PajekColours.numberColours) continue;
                    if (n7 > PajekColours.numberColours) {
                        n7 = PajekColours.numberColours;
                    }
                    if ((double)n7 < d * (double)PajekColours.numberColours) {
                        n7 = 1;
                    }
                    double d4 = this.updateMode.isPPA() ? (double)n7 / (double)PajekColours.numberColours : d3 * this.edgeSet.getEdgeValue(n5, n4);
                    n6 = n2 * n7 / PajekColours.numberColours;
                    printStream.print(n5 + 1 + "  " + (n4 + 1) + "   " + d4 + " w " + n6);
                    switch (n3) {
                        case 1: {
                            printStream.println("  c " + PajekColours.getGrey(n7));
                            continue block20;
                        }
                        case 2: {
                            printStream.println("  c " + PajekColours.colours[n7]);
                            continue block20;
                        }
                        default: {
                            printStream.println();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public boolean FileOutputPajekSiteFiles(String string) {
        return this.FileOutputPajekSiteFiles(IslandSite.getIndex(string));
    }

    public boolean FileOutputPajekSiteFiles(int n) {
        String string = "No Such File";
        if (IslandSite.isInt(n)) {
            string = "clu";
        } else if (IslandSite.isDouble(n)) {
            string = "vec";
        } else {
            return false;
        }
        String string2 = this.outputFile.getFullLocationFileName(IslandSite.dataName(n), string);
        if (this.message.getInformationLevel() > -1) {
            System.out.println("Attempting to write to " + string2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("*Vertices " + this.numberSites);
            for (int i = 0; i < this.numberSites; ++i) {
                printStream.println(this.siteSet.getVariable(i, n));
            }
            try {
                fileOutputStream.close();
                if (this.message.getInformationLevel() > -1) {
                    System.out.println("Finished writing to " + string2);
                }
            }
            catch (IOException iOException) {
                System.out.println("File Error");
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return false;
        }
        return true;
    }

    public String testDirectory(String string) {
        String string2 = "";
        File file = new File(string);
        if (!file.isDirectory()) {
            string2 = string + " not a directory";
            this.message.printERROR(string2);
        } else {
            string2 = "Looking at directory " + string;
            this.message.println(0, string2);
        }
        return string2;
    }

    public String getFileList(String string, String string2, String[] stringArray) {
        String string3 = "";
        File file = new File(string2);
        if (!file.isDirectory()) {
            string3 = string2 + " not a directory";
            this.message.printERROR(string3);
            return string3;
        }
        this.message.println(0, "Looking at directory " + string2);
        OnlyExtensionSet onlyExtensionSet = new OnlyExtensionSet(string);
        String[] stringArray2 = file.list(onlyExtensionSet);
        string3 = "Found  " + stringArray2.length + " files with extension " + string + " in directory " + string2;
        this.message.println(0, string3);
        stringArray2 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray[i] = this.getFileNameRoot(stringArray2[i], string);
            this.message.println(0, stringArray2[i] + SEPSTRING + stringArray[i]);
        }
        return string3;
    }

    public String getFileNameRoot(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public void calcEntropies() {
        this.globalProperties.calcEntropies(this);
    }

    public void calcEnergy() {
        this.globalProperties.calcEnergy(this);
    }

    public double deltaEdgeHamiltonian(int n, int n2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        switch (this.modelNumber.major) {
            case 5: {
                int n3;
                double d4 = this.edgeSet.getEdgeValue(n, n2);
                d3 = d - d4;
                d2 = this.Hamiltonian.edgeSource * this.siteSet.getSize(n) * d3;
                double d5 = this.edgeSet.getOutEdgeStrength(n);
                double d6 = this.siteSet.getSize(n);
                double d7 = this.siteSet.getValue(n);
                d2 += this.Hamiltonian.vertexPotential5(d6, d7 + d5) - this.Hamiltonian.vertexPotential5(d6, d7 + d5 + d3);
                double d8 = this.modelNumber.bit1 ? this.siteSet.getSize(n2) * (this.siteSet.getValue(n2) + this.edgeSet.getOutEdgeStrength(n2)) : 1.0;
                double d9 = this.edgeSet.getEdgePotential1(n, n2);
                double d10 = this.modelNumber.bit0 ? d6 * (d7 + d5) : 1.0;
                double d11 = this.modelNumber.bit0 ? d6 * (d7 + d5 + d3) : 1.0;
                d2 += d10 * d9 * d4 * d8;
                d2 += -d11 * d9 * d * d8;
                if (this.modelNumber.bit0) {
                    for (n3 = 0; n3 < this.numberSites; ++n3) {
                        if (n3 == n || n3 == n2) continue;
                        d2 += -d6 * d3 * (this.modelNumber.bit1 ? this.siteSet.getSize(n3) * (this.siteSet.getValue(n3) + this.edgeSet.getOutEdgeStrength(n3)) : 1.0) * this.edgeSet.getEdgePotential1(n, n3) * this.edgeSet.getEdgeValue(n, n3);
                    }
                }
                if (!this.modelNumber.bit1) break;
                for (n3 = 0; n3 < this.numberSites; ++n3) {
                    if (n3 == n) continue;
                    d2 += -d6 * d3 * (this.modelNumber.bit0 ? this.siteSet.getSize(n3) * (this.siteSet.getValue(n3) + this.edgeSet.getOutEdgeStrength(n3)) : 1.0) * this.edgeSet.getEdgePotential1(n3, n) * this.edgeSet.getEdgeValue(n3, n);
                }
                break;
            }
            case 4: {
                d3 = d - this.edgeSet.getEdgeValue(n, n2);
                d2 = this.Hamiltonian.edgeSource * this.siteSet.getWeight(n) * d3;
                d2 += this.Hamiltonian.lambda * d3 * this.edgeSet.getEdgeDistance(n, n2);
                double d12 = this.edgeSet.getOutEdgeStrength(n);
                double d13 = d12 + d3;
                if (d12 <= this.Hamiltonian.alpha) {
                    d2 -= (1.0 + this.Hamiltonian.alpha - d12) * 1000000.0;
                }
                if (!(d13 <= this.Hamiltonian.alpha)) break;
                d2 += (1.0 + this.Hamiltonian.alpha - d13) * 1000000.0;
                break;
            }
            case 3: {
                d2 = this.Hamiltonian.edgeSource * (this.modelNumber.bit0 ? this.siteSet.getWeight(n) : 1.0) * (this.modelNumber.bit1 ? this.siteSet.getWeight(n2) : 1.0) * (d - this.edgeSet.getEdgeValue(n, n2));
                d2 += this.edgePotentialTotal3();
                double d14 = this.edgeSet.getEdgeValue(n, n2);
                this.edgeSet.setEdgeValueBounded(n, n2, d);
                d2 -= this.edgePotentialTotal3();
                this.edgeSet.setEdgeValueBounded(n, n2, d14);
                break;
            }
            case 2: {
                double d15 = this.calcConsumption(n);
                double d16 = (d - this.edgeSet.getEdgeValue(n, n2)) * this.siteSet.getValue(n) * this.Hamiltonian.consumptioncoeff;
                double d17 = this.calcConsumption(n2);
                double d18 = this.calcOutput(this.siteSet.getValue(n), this.siteSet.getSize(n));
                double d19 = this.calcOutput(this.siteSet.getValue(n2), this.siteSet.getSize(n2));
                double d20 = this.siteSet.getWeight(n2) * (d19 - d17);
                d2 = -(d18 - d15) * d20 * this.edgeSet.getEdgePotential1(n, n2) * this.siteSet.getValue(n) * this.edgeSet.getEdgeValue(n, n2);
                d2 += (d18 - (d15 + d16)) * d20 * this.edgeSet.getEdgePotential1(n, n2) * this.siteSet.getValue(n) * d;
                d2 += this.Hamiltonian.kappa * d16 + this.Hamiltonian.edgeSource * this.siteSet.getWeight(n) * (d - this.edgeSet.getEdgeValue(n, n2));
                break;
            }
            case 1: {
                d2 = (this.modelNumber.bit0 ? this.siteSet.getWeight(n) : 1.0) * (this.modelNumber.bit1 ? this.siteSet.getWeight(n2) : 1.0) * this.edgeSet.getEdgePotential1(n, n2) * (-d + this.edgeSet.getEdgeValue(n, n2)) + this.Hamiltonian.edgeSource * this.siteSet.getWeight(n) * (d - this.edgeSet.getEdgeValue(n, n2));
                break;
            }
        }
        return d2;
    }

    public double calcOutput(double d, double d2) {
        return (1.0 + this.Hamiltonian.outputcoeff) * d2 * (1.0 - this.Hamiltonian.outputcoeff / (this.Hamiltonian.outputcoeff + d));
    }

    public double calcConsumption(int n) {
        double d = 0.0;
        for (int i = 0; i < this.numberSites; ++i) {
            d += this.edgeSet.getEdgeValue(n, i);
        }
        return (this.siteSet.getValue(n) + d) * this.siteSet.getSize(n) * this.Hamiltonian.consumptioncoeff;
    }

    public double edgePotentialTotal3() {
        double d = 0.0;
        this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        for (int i = 0; i < this.numberSites; ++i) {
            double d2 = this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0;
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j || this.edgeSet.getEdgeSeparation(i, j) == 0.0 || this.edgeSet.getEdgeValue(i, j) == 0.0) continue;
                d += d2 * (this.modelNumber.bit2 ? this.edgeSet.getEdgeSeparation(i, j) : this.edgeSet.getEdgePotentialSeparation1(i, j, this.Hamiltonian)) * (this.modelNumber.bit1 ? this.siteSet.getWeight(j) : 1.0);
            }
        }
        return d;
    }

    public double deltaVertexHamiltonian(int n, double d) {
        double d2 = 0.0;
        switch (this.modelNumber.major) {
            case 4: {
                double d3 = d - this.siteSet.getValue(n);
                d2 = d3 * this.siteSet.getSize(n) * this.Hamiltonian.vertexSource - this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n), d) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n), this.siteSet.getValue(n));
            }
            case 2: {
                double d3 = this.calcConsumption(n);
                double d4 = (d - this.siteSet.getValue(n)) * this.siteSet.getSize(n) * this.Hamiltonian.consumptioncoeff;
                double d5 = this.calcOutput(this.siteSet.getValue(n), this.siteSet.getSize(n));
                double d6 = this.calcOutput(d, this.siteSet.getSize(n)) - d5;
                d2 = this.Hamiltonian.kappa * (d4 - d6);
                d2 += (d - this.siteSet.getValue(n)) * this.siteSet.getSize(n) * this.Hamiltonian.vertexSource;
                for (int i = 0; i < this.numberSites; ++i) {
                    if (n == i) continue;
                    d2 += (d6 - d4) * (this.calcOutput(this.siteSet.getValue(i), this.siteSet.getSize(i)) - this.calcConsumption(i)) * this.edgeSet.getEdgePotential1(n, i) * (this.siteSet.getValue(n) * this.edgeSet.getEdgeValue(n, i) + this.siteSet.getValue(i) * this.edgeSet.getEdgeValue(i, n));
                }
                break;
            }
            case 5: {
                double d7 = this.siteSet.getValue(n);
                double d8 = this.siteSet.getSize(n);
                double d9 = d - d7;
                double d10 = d9 * d8;
                double d11 = this.edgeSet.getOutEdgeStrength(n);
                d2 = this.Hamiltonian.vertexSource * d10;
                d2 += -this.Hamiltonian.vertexPotential5(d8, d + d11) + this.Hamiltonian.vertexPotential5(d8, d7 + d11);
                for (int i = 0; i < this.numberSites; ++i) {
                    if (n == i) continue;
                    if (this.modelNumber.bit0) {
                        d2 += -d10 * this.edgeSet.getEdgePotential1(n, i) * d8 * this.edgeSet.getEdgeValue(n, i) * (this.modelNumber.bit1 ? this.siteSet.getSize(i) * (this.siteSet.getValue(i) + this.edgeSet.getOutEdgeStrength(i)) : 1.0);
                    }
                    if (!this.modelNumber.bit1) continue;
                    d2 += -(this.modelNumber.bit0 ? this.siteSet.getSize(i) * (this.siteSet.getValue(i) + this.edgeSet.getOutEdgeStrength(i)) : 1.0) * this.edgeSet.getEdgePotential1(i, n) * this.siteSet.getSize(i) * this.edgeSet.getEdgeValue(i, n) * d10;
                }
                break;
            }
            case 1: 
            case 3: {
                double d12 = d - this.siteSet.getValue(n);
                double d13 = d12 * this.siteSet.getSize(n);
                d2 = this.Hamiltonian.vertexSource * d13;
                d2 += -this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n), d) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n), this.siteSet.getValue(n));
                for (int i = 0; i < this.numberSites; ++i) {
                    if (n == i) continue;
                    d2 += this.Hamiltonian.edgeSource * d13 * this.edgeSet.getEdgeValue(n, i);
                    if (this.modelNumber.bit0) {
                        d2 += -d13 * (this.modelNumber.bit1 ? this.siteSet.getWeight(i) : 1.0) * this.edgeSet.getEdgePotential1(n, i) * this.edgeSet.getEdgeValue(n, i);
                    }
                    if (!this.modelNumber.bit1) continue;
                    d2 += -d13 * (this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0) * this.edgeSet.getEdgePotential1(i, n) * this.edgeSet.getEdgeValue(i, n);
                }
                break;
            }
        }
        return d2;
    }

    public double deltaVertexHamiltonian(int n, int n2, double d) {
        double d2 = 0.0;
        switch (this.modelNumber.major) {
            case 1: 
            case 3: {
                double d3 = this.siteSet.getValue(n) - d / this.siteSet.getSize(n);
                if (!this.vertexMode.testValue(d3)) {
                    return 9.9E21;
                }
                double d4 = this.siteSet.getValue(n2) + d / this.siteSet.getSize(n2);
                if (!this.vertexMode.testValue(d4)) {
                    return 8.8E21;
                }
                d2 += -this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n), d3) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n), this.siteSet.getValue(n));
                d2 += -this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n2), d4) + this.Hamiltonian.vertexPotential1(this.siteSet.getSize(n2), this.siteSet.getValue(n2));
                d2 -= this.Hamiltonian.edgeSource * d * this.edgeSet.getOutEdgeStrength(n);
                d2 += this.Hamiltonian.edgeSource * d * this.edgeSet.getOutEdgeStrength(n2);
                for (int i = 0; i < this.numberSites; ++i) {
                    if (n2 == i) {
                        d2 += (this.modelNumber.bit0 ? this.siteSet.getWeight(n) : 1.0) * this.edgeSet.getEdgePotential1(n, n2) * this.edgeSet.getEdgeValue(n, n2) * (this.modelNumber.bit1 ? this.siteSet.getWeight(n2) : 1.0) - (this.modelNumber.bit0 ? this.siteSet.getWeight(n) - d : 1.0) * this.edgeSet.getEdgePotential1(n, n2) * this.edgeSet.getEdgeValue(n, n2) * (this.modelNumber.bit1 ? this.siteSet.getWeight(n2) + d : 1.0);
                        continue;
                    }
                    if (n == i) {
                        d2 += (this.modelNumber.bit0 ? this.siteSet.getWeight(n2) : 1.0) * this.edgeSet.getEdgePotential1(n2, n) * this.edgeSet.getEdgeValue(n2, n) * (this.modelNumber.bit1 ? this.siteSet.getWeight(n) : 1.0) - (this.modelNumber.bit0 ? this.siteSet.getWeight(n2) + d : 1.0) * this.edgeSet.getEdgePotential1(n2, n) * this.edgeSet.getEdgeValue(n2, n) * (this.modelNumber.bit1 ? this.siteSet.getWeight(n) - d : 1.0);
                        continue;
                    }
                    if (this.modelNumber.bit0) {
                        d2 += d * this.edgeSet.getEdgePotential1(n, i) * this.edgeSet.getEdgeValue(n, i) * (this.modelNumber.bit1 ? this.siteSet.getWeight(i) : 1.0);
                    }
                    if (this.modelNumber.bit1) {
                        d2 += (this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0) * this.edgeSet.getEdgePotential1(i, n) * this.edgeSet.getEdgeValue(i, n) * d;
                    }
                    if (this.modelNumber.bit0) {
                        d2 -= d * this.edgeSet.getEdgePotential1(n2, i) * this.edgeSet.getEdgeValue(n2, i) * (this.modelNumber.bit1 ? this.siteSet.getWeight(i) : 1.0);
                    }
                    if (!this.modelNumber.bit1) continue;
                    d2 -= (this.modelNumber.bit0 ? this.siteSet.getWeight(i) : 1.0) * this.edgeSet.getEdgePotential1(i, n2) * this.edgeSet.getEdgeValue(i, n2) * d;
                }
                break;
            }
        }
        return d2;
    }

    public void edgeSweep() {
        double d = -9.87654321E7;
        double d2 = 0.0;
        double d3 = -1.0;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        Permutation permutation = new Permutation(this.numberSites);
        double d4 = this.edgeSet.edgeMode.maximumValue * 1.01;
        for (int i = 0; i < this.numberSites; ++i) {
            n = permutation.next();
            Permutation permutation2 = new Permutation(this.numberSites);
            for (int j = 0; j < this.numberSites; ++j) {
                n2 = permutation2.next();
                if (n == n2 || this.edgeSet.getEdgeDistance(n, n2) < this.Hamiltonian.shortDistanceScale) continue;
                ++n3;
                if (this.edgeSet.edgeMode.outStrengthLimitOn) {
                    d3 = this.edgeSet.getOutEdgeStrength(n) - this.edgeSet.getEdgeValue(n, n2);
                    if (d3 + (d2 = (this.edgeSet.edgeMode.maximumValue - d3) * rnd.nextDouble()) > d4) {
                        System.out.println(d3 + d2 + " = newOutStrength >1 ");
                        return;
                    }
                } else if (this.edgeSet.edgeMode.maxValueModeOn) {
                    d2 = rnd.nextDouble() * this.edgeSet.edgeMode.maximumValue;
                } else {
                    double d5 = d2 = rnd.nextBoolean() ? 1.0 : 0.0;
                }
                if (d2 < -1.0E-6) {
                    System.err.println("ERROR: newEdgeValue = " + d2 + " <0 ");
                    return;
                }
                if (d2 < 0.0) {
                    this.message.printWarning(1, " newEdgeValue  -1e-6 < " + d2 + " <0, continuing");
                }
                if (!((d = this.deltaEdgeHamiltonian(n, n2, d2)) < 0.0) && !(rnd.nextDouble() < Math.exp(-this.Hamiltonian.beta * d))) continue;
                this.edgeSet.setEdgeValueBounded(n, n2, d2);
                ++n4;
            }
        }
        this.edgeUR.update(n3, n4);
    }

    public void vertexSweep() {
        int n = 0;
        int n2 = 0;
        Permutation permutation = new Permutation(this.numberSites);
        int n3 = 0;
        if (this.vertexMode.maxValueModeOn) {
            for (n3 = 0; n3 < this.numberSites; ++n3) {
                if (!this.vertexUpdate(permutation.next())) continue;
                ++n2;
            }
        }
        if (this.vertexMode.constantWeightOn) {
            for (n3 = 0; n3 < this.numberSites; ++n3) {
                if (!this.vertexPairUpdate(permutation.next())) continue;
                ++n2;
            }
        }
        this.vertexUR.update(n += n3, n2);
    }

    public boolean vertexUpdate(int n) {
        double d = rnd.nextDouble() * this.vertexMode.maximumValue;
        double d2 = this.deltaVertexHamiltonian(n, d);
        if (d2 < 0.0 || rnd.nextDouble() < Math.exp(-this.Hamiltonian.beta * d2)) {
            this.siteSet.setValue(n, d);
            return true;
        }
        return false;
    }

    public boolean vertexPairUpdate(int n) {
        double d;
        double d2;
        double d3;
        int n2 = rnd.nextInt(this.numberSites - 1);
        if (n2 >= n) {
            ++n2;
        }
        if ((d3 = (d2 = this.siteSet.getWeight(n)) / 10.0) < 0.001) {
            d3 = 0.001;
        }
        if ((d3 *= (double)(1 + rnd.nextInt(10))) > d2) {
            d3 = d2;
        }
        if ((d = this.deltaVertexHamiltonian(n, n2, d3)) > 1.0E20) {
            return false;
        }
        if (d < 0.0 || rnd.nextDouble() < Math.exp(-this.Hamiltonian.beta * d)) {
            this.siteSet.setValue(n, (d2 - d3) / this.siteSet.getSize(n));
            this.siteSet.setValue(n2, (this.siteSet.getWeight(n2) + d3) / this.siteSet.getSize(n2));
            return true;
        }
        return false;
    }

    public void doDP() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.edgeMode.setMaxValueModeOn(this.numberSites);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double d = -1.0;
        double[] dArray = new double[this.numberSites];
        double d2 = -9.87654321;
        for (int i = 0; i < this.numberSites; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < this.numberSites; ++j) {
                d = i == j ? 0.0 : 1.0 / (1.0 + this.edgeSet.getEdgeDistance(i, j) / this.Hamiltonian.distanceScale);
                int n = i;
                dArray[n] = dArray[n] + d;
                this.edgeSet.setEdgeValueBounded(i, j, d);
            }
            if (!(d2 < dArray[i])) continue;
            d2 = dArray[i];
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 1) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doVP() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.edgeMode.setMaxValueModeOn(this.numberSites);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double d = -1.0;
        double[] dArray = new double[this.numberSites];
        double d2 = -9.87654321;
        for (int i = 0; i < this.numberSites; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < this.numberSites; ++j) {
                d = i == j ? 0.0 : this.Hamiltonian.edgePotential1Bare(this.edgeSet.getEdgeDistance(i, j));
                int n = i;
                dArray[n] = dArray[n] + d;
                this.edgeSet.setEdgeValueNoBounds(i, j, d);
            }
            if (!(d2 < dArray[i])) continue;
            d2 = dArray[i];
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 1) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doPPAOld() {
        int n;
        int n2;
        int n3 = (int)(this.betaInitial + 0.5);
        if (n3 < 0) {
            n3 = 3;
        }
        if (n3 >= this.numberSites) {
            n3 = this.numberSites - 1;
        }
        int[] nArray = new int[this.numberSites + 1];
        double[][] dArray = new double[this.numberSites][this.numberSites];
        if (this.modelNumber.major == 3) {
            this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        }
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        this.siteSet.initialiseSet(1.0, 1.0, 1.0);
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            for (n = 0; n < this.numberSites; ++n) {
                this.edgeSet.setEdgeValueBounded(n2, n, 1.0);
                dArray[n2][n] = this.modelNumber.major == 3 ? this.edgeSet.getEdgeSeparation(n2, n) : this.edgeSet.getEdgeDistance(n2, n);
            }
        }
        double d = PajekColours.numberColours;
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            int n4;
            int n5 = 0;
            for (n = 0; n < this.numberSites; ++n) {
                this.edgeSet.setEdgeValueBounded(n2, n, 0.0);
                if (n2 == n) continue;
                for (n4 = 0; n4 < n5 && !(dArray[n2][n] < dArray[n2][nArray[n4]]); ++n4) {
                }
                for (int i = n5; i > n4; --i) {
                    nArray[i] = nArray[i - 1];
                }
                nArray[n4] = n;
                ++n5;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            for (n4 = 0; n4 < n3; ++n4) {
                int n6 = PajekColours.numberColours - n4;
                d3 = n6 > 0 ? (double)n6 : 1.0;
                this.edgeSet.setEdgeColour(n2, nArray[n4], d3);
                d2 = n4 < PajekColours.numberColours ? (double)n6 / d : 1.0 / d;
                this.edgeSet.setEdgeValueBounded(n2, nArray[n4], d2);
            }
        }
        int[] nArray2 = new int[this.numberSites];
        int n7 = 0;
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            int n8;
            nArray2[n2] = n8 = this.edgeSet.getInDegree(n2);
            if (n8 <= n7) continue;
            n7 = n8;
        }
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            int n9 = nArray2[n2];
            int n10 = (int)(0.5 + d * (double)n9 / (double)n7);
            this.siteSet.setValue(n2, (double)n9 / (double)n7);
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 0) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doPPA() {
        int n;
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        double[] dArray = new double[this.numberSites];
        if (this.modelNumber.major == 3) {
            this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        }
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        this.siteSet.initialiseSet(1.0, 1.0, 1.0);
        for (n = 0; n < this.numberSites; ++n) {
            for (int i = 0; i < this.numberSites; ++i) {
                this.edgeSet.setEdgeValueBounded(n, i, 1.0);
            }
        }
        for (n = 0; n < this.numberSites; ++n) {
            for (int i = 0; i < this.numberSites; ++i) {
                dArray[i] = n == i ? 1.2345678E99 : this.edgeSet.getEdgeDistance(n, i);
            }
            TimSort timSort = new TimSort(dArray);
            this.edgeSet.setEdgeValueBounded(n, n, 0.0);
            for (int i = 0; i < this.numberSites; ++i) {
                int n2 = timSort.getIndex(i);
                if (n2 == n) continue;
                double d = 1.0 - (double)i / (double)this.numberSites;
                this.edgeSet.setEdgeValueNoBounds(n, n2, d);
            }
        }
        this.siteSet.setWeights();
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 0) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doSimpleGM() {
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.edgeMode.setMaxValueModeOn(this.numberSites);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        double d = -1.0;
        double[] dArray = new double[this.numberSites];
        double d2 = -9.87654321;
        for (int i = 0; i < this.numberSites; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < this.numberSites; ++j) {
                d = i == j ? 0.0 : this.siteSet.getSize(j) * this.Hamiltonian.edgePotential1Bare(this.edgeSet.getEdgeDistance(i, j));
                int n = i;
                dArray[n] = dArray[n] + d;
                this.edgeSet.setEdgeValueNoBounds(i, j, d);
            }
            if (!(d2 < dArray[i])) continue;
            d2 = dArray[i];
        }
        this.calcNetworkStats();
        this.siteSet.setAllDisplaySizes(this.DisplayVertexType.getValueIndex(), this.DisplayMaxVertexScale);
        if (this.message.getInformationLevel() >= 1) {
            this.printNetworkStatistics(COMMENT, 3);
        }
    }

    public void doGMOLD() {
        double d;
        this.siteSet.setValuesRandom(rnd, 1.0);
        this.siteSet.setInValuesRandom(rnd, 1.0);
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        boolean bl = this.message.testInformationLevel(0);
        TimCounting timCounting = new TimCounting(1000, bl);
        double d2 = 1.0;
        double d3 = 1.0;
        this.message.println(-1, "\n--- Starting Gravity model");
        while (!timCounting.isFinished()) {
            double d4 = 0.0;
            d = 0.0;
            double d5 = 0.0;
            double d6 = 1.0E10;
            for (int i = 0; i < this.numberSites; ++i) {
                double d7 = 0.0;
                for (int j = 0; j < this.numberSites; ++j) {
                    if (i == j) continue;
                    d7 += this.siteSet.getInSize(j) * this.siteSet.getInValue(j) * this.edgeSet.getEdgePotential1(i, j);
                }
                d6 = d7 > 1.0E-10 ? 1.0 / d7 : 1.0E10;
                d4 += d6 * this.siteSet.getValue(i);
                d += this.siteSet.getValue(i) * this.siteSet.getValue(i);
                d5 += d6 * d6;
                this.siteSet.setValue(i, d6);
            }
            d3 = 1.0;
            if (d > 1.0E-6 && d5 > 1.0E-6) {
                d3 = d4 / (Math.sqrt(d) * Math.sqrt(d5));
            }
            d4 = 0.0;
            d5 = 0.0;
            d = 0.0;
            double d8 = 1.0E10;
            for (int i = 0; i < this.numberSites; ++i) {
                double d9 = 0.0;
                for (int j = 0; j < this.numberSites; ++j) {
                    if (j == i) continue;
                    d9 += this.siteSet.getValue(j) * this.siteSet.getSize(j) * this.edgeSet.getEdgePotential1(j, i);
                }
                d8 = d9 > 1.0E-10 ? 1.0 / d9 : 1.0E10;
                d4 += d8 * this.siteSet.getInValue(i);
                d += this.siteSet.getInValue(i) * this.siteSet.getInValue(i);
                d5 += d8 * d8;
                this.siteSet.setInValue(i, d8);
            }
            d2 = 1.0;
            if (d > 1.0E-6 && d5 > 1.0E-6) {
                d2 = d4 / (Math.sqrt(d) * Math.sqrt(d5));
            }
            if (d3 > 0.999999 && d2 > 0.999999) break;
            System.out.println(timCounting.getCount() + ": " + String.format("%12.6g", d3) + " " + String.format("%12.6g", d2));
            this.message.println(-1, "initial cosines " + String.format("%12.6g", d3) + " " + String.format("%12.6g", d2));
            if (bl && timCounting.isEndOfLine()) {
                System.out.println(": " + String.format("%12.6g", d3) + " " + String.format("%12.6g", d2));
            }
            timCounting.increment();
        }
        this.message.println(-1, "\n Finished Gravity model using " + timCounting.getCount() + " iterations, cosines " + String.format("%12.6g", d3) + " " + String.format("%12.6g", d2));
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j) {
                    this.edgeSet.setEdgeValueNoBounds(i, j, 0.0);
                    continue;
                }
                d = this.siteSet.getInValue(j) * this.siteSet.getInSize(j) * this.edgeSet.getEdgePotential1(i, j);
                this.edgeSet.setEdgeValueNoBounds(i, j, d);
            }
        }
        this.setOutputFileName();
        this.siteSet.setWeights();
        this.calcNetworkStats();
    }

    public void doGM() {
        this.doGM(1000, false);
    }

    public void doGM(int n, boolean bl) {
        int n2;
        this.siteSet.setValues(1.0);
        this.siteSet.setWeights();
        this.Hamiltonian.lambda = 1.0;
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        int n3 = n;
        boolean bl2 = this.message.testInformationLevel(1);
        TimCounting timCounting = new TimCounting(n3, bl2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 1.0E10;
        double d5 = 1.0E10;
        double[] dArray = new double[this.numberSites];
        double[] dArray2 = new double[this.numberSites];
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            dArray2[n2] = (bl ? rnd.nextDouble() : 1.0) * this.siteSet.getSize(n2);
        }
        this.message.println(-1, "\n--- Starting Gravity model");
        while (!timCounting.isFinished()) {
            int n4;
            double d6;
            d = 0.0;
            d3 = 0.0;
            d4 = 1.0E10;
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                d6 = 0.0;
                for (n4 = 0; n4 < this.numberSites; ++n4) {
                    if (n2 == n4) continue;
                    d6 += this.siteSet.getSize(n4) * dArray2[n4] * this.edgeSet.getEdgePotential1(n2, n4);
                }
                d4 = d6 > 1.0E-10 ? 1.0 / d6 : 1.0E10;
                d += Math.abs(d4 - dArray[n2]);
                d3 += Math.abs(d4);
                dArray[n2] = d4;
            }
            if (d3 > 1.0E-6) {
                d /= d3;
            }
            d2 = 0.0;
            d3 = 0.0;
            d5 = 1.0E10;
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                d6 = 0.0;
                for (n4 = 0; n4 < this.numberSites; ++n4) {
                    if (n4 == n2) continue;
                    d6 += this.siteSet.getSize(n4) * dArray[n4] * this.edgeSet.getEdgePotential1(n4, n2);
                }
                d5 = d6 > 1.0E-10 ? 1.0 / d6 : 1.0E10;
                d2 += Math.abs(d5 - dArray2[n2]);
                d3 += Math.abs(d5);
                dArray2[n2] = d5;
            }
            if (d3 > 1.0E-6) {
                d2 /= d3;
            }
            if (bl2 && timCounting.isEndOfLine()) {
                System.out.println(": " + String.format("%12.6g", d) + " " + String.format("%12.6g", d2));
            }
            if (d < 1.0E-6 && d2 < 1.0E-6) break;
            timCounting.increment();
        }
        this.message.println(-1, "\n Finished Gravity model using " + timCounting.getCount() + " iterations, convergence factors " + String.format("%12.6g", d) + " " + String.format("%12.6g", d2));
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            for (int i = 0; i < this.numberSites; ++i) {
                if (n2 == i) {
                    this.edgeSet.setEdgeValueNoBounds(n2, i, 0.0);
                    continue;
                }
                double d7 = dArray[n2] * dArray2[i] * this.siteSet.getSize(i) * this.edgeSet.getEdgePotential1(n2, i);
                this.edgeSet.setEdgeValueNoBounds(n2, i, d7);
            }
        }
        this.setOutputFileName();
        this.calcNetworkStats();
    }

    public void doRW() {
        this.doRW(1000, false);
    }

    public void doRW(int n, boolean bl) {
        int n2;
        this.Hamiltonian.lambda = 1.0;
        this.Hamiltonian.beta = this.betaInitial;
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        int n3 = n;
        boolean bl2 = this.message.testInformationLevel(2);
        TimCounting timCounting = new TimCounting(n3, bl2);
        double d = 1.0;
        double d2 = 1.0;
        this.message.println(-1, "\n--- Starting RW Gravity model with " + (bl ? "random" : "fixed") + " initial in flow and max iterations " + n + ", beta = " + this.betaInitial);
        double d3 = 0.0;
        double d4 = 9.8765432E10;
        double d5 = 9.8765432E10;
        double[] dArray = new double[this.numberSites];
        double[] dArray2 = new double[this.numberSites];
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            dArray2[n2] = (bl ? rnd.nextDouble() : 1.0) * this.siteSet.getSize(n2);
        }
        System.out.println();
        while (!timCounting.isFinished()) {
            int n4;
            double d6;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 9.8765432E10;
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                d6 = 0.0;
                for (n4 = 0; n4 < this.numberSites; ++n4) {
                    if (n2 == n4) continue;
                    d6 += Math.pow(dArray2[n4], this.Hamiltonian.beta) * this.edgeSet.getEdgePotential1(n2, n4);
                }
                d4 = d6 > 1.0125000010125E-11 ? 1.0 / d6 : 9.8765432E10;
                d2 += Math.abs(d4 - dArray[n2]);
                d3 += Math.abs(d4);
                dArray[n2] = d4;
            }
            if (d3 > 1.0E-6) {
                d2 /= d3;
            }
            d = 0.0;
            d3 = 0.0;
            d5 = 9.8765432E10;
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                d6 = 0.0;
                for (n4 = 0; n4 < this.numberSites; ++n4) {
                    if (n4 == n2) continue;
                    d6 += this.siteSet.getSize(n4) * dArray[n4] * this.edgeSet.getEdgePotential1(n4, n2);
                }
                d5 = Math.pow(dArray2[n2], this.Hamiltonian.beta) * d6;
                d += Math.abs(d5 - dArray2[n2]);
                d3 += Math.abs(d5);
                dArray2[n2] = d5;
            }
            if (d3 > 1.0E-6) {
                d /= d3;
            }
            if (timCounting.isEndOfLine()) {
                this.message.println(-1, timCounting.getCount() + ": " + String.format("%12.6g", d2) + " " + String.format("%12.6g", d));
            }
            if (bl2 && timCounting.isEndOfLine()) {
                System.out.println(": " + String.format("%12.6g", d2) + " " + String.format("%12.6g", d));
            }
            if (d < 1.0E-6 && d2 < 1.0E-6) break;
            timCounting.increment();
        }
        this.message.println(-1, "\n Finished Rihll-Wilson Gravity model using " + timCounting.getCount() + " iterations, convergence factors " + String.format("%6.3g", d2) + " " + String.format("%6.3g", d));
        this.siteSet.setValues(1.0);
        for (n2 = 0; n2 < this.numberSites; ++n2) {
            for (int i = 0; i < this.numberSites; ++i) {
                if (n2 == i) {
                    this.edgeSet.setEdgeValueNoBounds(n2, i, 0.0);
                    continue;
                }
                double d7 = dArray[n2] * Math.pow(dArray2[i], this.Hamiltonian.beta) * this.edgeSet.getEdgePotential1(n2, i);
                this.edgeSet.setEdgeValueNoBounds(n2, i, d7);
            }
        }
        this.setOutputFileName();
        this.siteSet.setWeights();
        this.calcNetworkStats();
    }

    public void doMC() {
        double d;
        int n;
        int n2;
        MonteCarloHistory monteCarloHistory = new MonteCarloHistory(1000);
        boolean bl = false;
        int n3 = 0;
        double d2 = this.betaInitial;
        double d3 = 1.0E20;
        double d4 = 2.0;
        int n4 = -1;
        if (this.monteCarloStartMode.isMode("Cold")) {
            double d5 = 0.0;
            if (!this.vertexMode.maxValueModeOn) {
                double d6 = 0.0;
                for (int i = 0; i < this.numberSites; ++i) {
                    d6 += this.siteSet.getSize(i);
                }
                d5 = this.vertexMode.totalWeight / d6;
            }
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                this.siteSet.setValue(n2, d5);
            }
            this.edgeSet.setEdgeValues(0.0);
        }
        if (this.monteCarloStartMode.isMode("Hot")) {
            if (this.vertexMode.maxValueModeOn) {
                for (int i = 0; i < this.numberSites; ++i) {
                    this.siteSet.setValue(i, rnd.nextDouble() * this.vertexMode.maximumValue);
                }
            } else {
                for (int i = 0; i < this.numberSites; ++i) {
                    this.siteSet.setValue(i, this.vertexMode.totalWeight / (double)this.numberSites);
                }
                Permutation permutation = new Permutation(this.numberSites);
                for (n = 0; n < this.numberSites; ++n) {
                    int n5 = permutation.next();
                    n2 = rnd.nextInt(this.numberSites - 1);
                    if (n2 >= n5) {
                        ++n2;
                    }
                    double d7 = this.siteSet.getWeight(n5) * rnd.nextDouble();
                    double d8 = this.siteSet.getValue(n2) + d7 / this.siteSet.getSize(n2);
                    if (!this.vertexMode.testValue(d8)) continue;
                    this.siteSet.setValue(n2, d8);
                    this.siteSet.setValue(n5, d7 / this.siteSet.getSize(n5));
                }
            }
            this.edgeSet.setRandomEdgeValues(rnd);
        }
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
        this.siteSet.calcBasicStatistics(this.edgeSet);
        double d9 = this.siteSet.siteStrengthInStats.getAverage();
        double d10 = this.siteSet.siteStrengthOutStats.getAverage();
        this.message.println(0, "Average Strength IN/OUT " + d9 + "  " + d10);
        long l = System.currentTimeMillis();
        if (this.modelNumber.major == 3) {
            this.edgeSet.doDijkstra(this.siteSet.getSiteArray(), this.Hamiltonian.shortDistanceScale);
        }
        StatisticalQuantity statisticalQuantity = new StatisticalQuantity();
        StatisticalQuantity statisticalQuantity2 = null;
        n3 = 0;
        for (d = d2; d <= d3; d *= d4) {
            this.Hamiltonian.beta = d;
            this.vertexUR.reset();
            this.edgeUR.reset();
            for (int i = 0; i < this.MCsweeps; ++i) {
                if (this.vertexUR.getFractionMade() < 0.9) {
                    this.vertexSweep();
                }
                if (this.edgeUR.getFractionMade() < 0.9) {
                    this.edgeSweep();
                }
                if (!bl) continue;
                this.calcEnergy();
                statisticalQuantity.add(this.globalProperties.getEnergy());
            }
            if (bl && statisticalQuantity2 != null) {
                n3 = Math.abs(statisticalQuantity.getAverage() - statisticalQuantity2.getAverage()) < Math.abs(statisticalQuantity.getError()) + Math.abs(statisticalQuantity2.getError()) ? ++n3 : 0;
            }
            if (this.MChistory) {
                this.calcEnergy();
                monteCarloHistory.add(d, this.globalProperties.getEnergy(), this.vertexUR.getMade(), this.edgeUR.getMade());
            }
            if (this.message.testInformationLevel(0)) {
                if (++n4 % 10 == 0) {
                    this.calcEnergy();
                    islandNetwork.printEllapsedTime(l);
                    System.out.println(" beta=" + d + ", energy=" + this.globalProperties.getEnergy() + ",  stable for last " + n3 + " runs. \n  E: " + this.edgeUR.toString() + "\n  V: " + this.vertexUR.toString());
                } else if (this.vertexUR.getFractionMade() > 0.9) {
                    System.out.print(STARTSECTION);
                } else if (this.edgeUR.getFractionMade() > 0.9) {
                    System.out.print(":");
                } else {
                    System.out.print(".");
                }
            }
            if (this.vertexUR.getTotalFractionMade() < 0.01 && this.edgeUR.getTotalFractionMade() < 0.01) break;
            if (!bl) continue;
            statisticalQuantity2 = new StatisticalQuantity(statisticalQuantity);
            statisticalQuantity = new StatisticalQuantity();
        }
        this.calcEnergy();
        String string = "Final beta " + d + ", energy=" + this.globalProperties.getEnergy();
        if (bl) {
            string = string + ",  stable for last " + n3 + " runs.";
        }
        this.message.println(-1, "\n " + string + "\n Edge stats: " + this.edgeUR.toString() + ". Vertex stats: " + this.vertexUR.toString());
        this.setOutputFileName();
        if (this.MChistory) {
            monteCarloHistory.FileOutputMonteCarloHistory(this.outputFile.getFullLocationFileName("_MChistory", "dat"));
        }
        this.siteSet.setWeights();
        this.message.println(-1, "... end of doMC() just before calcNetworkStats");
        this.calcNetworkStats();
        this.message.println(-1, "*** end of doMC() after calcNetworkStats *************************************************************************");
        for (n = 0; n < this.numberSites; ++n) {
            if (!this.testEnergyVertex()) {
                System.err.println("*** ERROR failed vertex test " + n);
            }
            if (this.testEnergyEdge()) continue;
            System.err.println("*** ERROR failed Edge test " + n);
        }
    }

    public void setEdgePotentials() {
        this.edgeSet.setEdgePotential1(this.Hamiltonian);
    }

    public boolean testVertexValues() {
        for (int i = 0; i < this.numberSites; ++i) {
            if (this.vertexMode.testValue(this.siteSet.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public boolean testVertexWeights() {
        for (int i = 0; i < this.numberSites; ++i) {
            double d;
            double d2;
            double d3 = this.siteSet.getSize(i);
            if (!(Math.abs(d3 * (d2 = this.siteSet.getValue(i)) - (d = this.siteSet.getWeight(i))) > 1.0E-10)) continue;
            return false;
        }
        return true;
    }

    public boolean testEnergyVertex() {
        if (this.vertexMode.maxValueModeOn) {
            return this.testEnergyVertexSingle();
        }
        return this.testEnergyVertexPair();
    }

    public boolean testEnergyVertexSingle() {
        int n = rnd.nextInt(this.numberSites);
        double d = rnd.nextDouble() * this.siteSet.siteWeightStats.maximum;
        double d2 = this.siteSet.getValue(n);
        this.calcEnergy();
        double d3 = this.globalProperties.getEnergy();
        double d4 = this.deltaVertexHamiltonian(n, d);
        this.siteSet.setValue(n, d);
        this.calcEnergy();
        double d5 = this.globalProperties.getEnergy();
        this.siteSet.setValue(n, d2);
        if (Math.abs(d5 - d3 - d4) > 1.0E-6) {
            System.err.println("*** ERROR testEnergyVertex(), complete dH=" + (d5 - d3) + ", direct dH=" + d4);
            return false;
        }
        return true;
    }

    public boolean testEnergyVertexPair() {
        int n = rnd.nextInt(this.numberSites);
        double d = this.siteSet.getValue(n);
        double d2 = rnd.nextDouble() * d;
        double d3 = (d - d2) * this.siteSet.getSize(n);
        int n2 = rnd.nextInt(this.numberSites - 1);
        if (n2 >= n) {
            ++n2;
        }
        double d4 = this.siteSet.getValue(n2);
        double d5 = d4 + d3 / this.siteSet.getSize(n2);
        this.calcEnergy();
        double d6 = this.globalProperties.getEnergy();
        double d7 = this.deltaVertexHamiltonian(n, n2, d3);
        this.siteSet.setValue(n, d2);
        this.siteSet.setValue(n2, d5);
        this.calcEnergy();
        double d8 = this.globalProperties.getEnergy();
        this.siteSet.setValue(n, d);
        this.siteSet.setValue(n2, d4);
        if (Math.abs(d8 - d6 - d7) > 1.0E-6) {
            System.err.println("*** ERROR testEnergyVertexPair(), complete dH=" + (d8 - d6) + ", direct dH=" + d7);
            return false;
        }
        return true;
    }

    public boolean testEnergyEdge() {
        double d;
        int n = rnd.nextInt(this.numberSites);
        int n2 = rnd.nextInt(this.numberSites - 1);
        if (n2 >= n) {
            ++n2;
        }
        double d2 = this.edgeSet.edgeMode.maximumValue * 1.01;
        double d3 = this.edgeSet.getEdgeValue(n, n2);
        double d4 = -1.0;
        if (this.edgeSet.edgeMode.outStrengthLimitOn) {
            d = this.edgeSet.getOutEdgeStrength(n) - this.edgeSet.getEdgeValue(n, n2);
            if (d + (d4 = (this.edgeSet.edgeMode.maximumValue - d) * rnd.nextDouble()) > d2) {
                System.out.println(d + d4 + " = newOutStrength >1 ");
                return false;
            }
        } else if (this.edgeSet.edgeMode.maxValueModeOn) {
            d4 = rnd.nextDouble() * this.edgeSet.edgeMode.maximumValue;
        } else {
            double d5 = d4 = rnd.nextBoolean() ? 1.0 : 0.0;
        }
        if (d4 < 0.0) {
            System.out.println(d4 + " = newEdgeValue <0 ");
            return false;
        }
        this.calcEnergy();
        d = this.globalProperties.getEnergy();
        double d6 = this.deltaEdgeHamiltonian(n, n2, d4);
        this.edgeSet.setEdgeValueBounded(n, n2, d4);
        this.calcEnergy();
        double d7 = this.globalProperties.getEnergy();
        this.edgeSet.setEdgeValueBounded(n, n2, d3);
        if (Math.abs(d7 - d - d6) > 1.0E-6) {
            System.err.println("*** ERROR testEnergyEdge(), complete dH=" + (d7 - d) + ", direct dH=" + d6);
            return false;
        }
        return true;
    }

    public int getNumberSites() {
        return this.numberSites;
    }

    public String getMinorModelString() {
        String string = "unknown";
        switch (this.modelNumber.minor & 3) {
            case 0: {
                string = "no site terms in trade term";
                break;
            }
            case 1: {
                string = "Supply Side (source site in trade term)";
                break;
            }
            case 2: {
                string = "Demand Side (target site in trade term)";
                break;
            }
            case 3: {
                string = "Gravity (source and target site in trade term)";
            }
        }
        if (this.modelNumber.major == 3) {
            switch (this.modelNumber.minor & 4) {
                case 0: {
                    string = string + "physical distance used in potential";
                    break;
                }
                case 4: {
                    string = string + "edge potential used in potential";
                }
            }
        }
        return string;
    }

    public int getOutDegree(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numberSites; ++i) {
            if (!(this.edgeSet.getEdgeValue(n, i) > 0.0)) continue;
            ++n2;
        }
        return n2;
    }

    public void setEdgesTest1() {
        for (int i = 0; i < this.numberSites; ++i) {
            for (int j = 0; j < this.numberSites; ++j) {
                if (i == j) continue;
                if (i == j + 1) {
                    this.edgeSet.setEdgeValueBounded(i, j, 1.0);
                    continue;
                }
                this.edgeSet.setEdgeValueBounded(i, j, 0.0);
            }
        }
    }

    public void calcVectorOrder(double[] dArray, int[] nArray) {
        int n;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n < n2; ++n) {
            double d = dArray[nArray[n]];
            for (int i = n + 1; i < n2; ++i) {
                double d2 = dArray[nArray[i]];
                if (!(d < d2)) continue;
                d = d2;
                int n3 = nArray[i];
                nArray[i] = nArray[n];
                nArray[n] = n3;
            }
        }
    }

    public void calcVectorRankOrder(double[] dArray, int[] nArray, int[] nArray2) {
        this.calcVectorOrder(dArray, nArray);
        for (int i = 0; i < dArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
    }

    public void calcSiteOrder(int n, int[] nArray, int n2) {
    }

    public void calcSiteRankOrder(int n, int[] nArray, int n2) {
    }

    public int getInformationLevel() {
        return this.message.getInformationLevel();
    }

    public void setInfomationLevel(int n) {
        this.message.setInformationLevel(n);
    }

    public double TruncDec(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)((int)(d * d2 + 0.5)) / d2;
    }

    public String TruncDecString(double d, int n) {
        double d2 = Math.pow(10.0, n);
        Double d3 = (double)((int)(d * d2 + 0.5)) / d2;
        return d3.toString();
    }

    public String getStartString(String string, int n) {
        if (string.length() < n) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getPaddedStartString(String string, int n) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = i < string.length() ? string2 + string.substring(i, i + 1) : string2 + " ";
        }
        return string2;
    }

    public double euclideanDistance(double d, double d2, double d3, double d4) {
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    private double sphericalDistance(double d, double d2, double d3, double d4) {
        double d5 = d2 - d4;
        double d6 = Math.sin(this.deg2rad(d)) * Math.sin(this.deg2rad(d3)) + Math.cos(this.deg2rad(d)) * Math.cos(this.deg2rad(d3)) * Math.cos(this.deg2rad(d5));
        d6 = Math.acos(d6);
        d6 = this.rad2deg(d6);
        d6 = d6 * 60.0 * 1.1515;
        return d6 *= 1.609344;
    }

    private double deg2rad(double d) {
        return d * Math.PI / 180.0;
    }

    private double rad2deg(double d) {
        return d * 180.0 / Math.PI;
    }

    public static void printEllapsedTime(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        long l4 = l3 % 1000L;
        long l5 = (l3 /= 1000L) % 60L;
        long l6 = (l3 /= 60L) % 60L;
        long l7 = (l3 /= 60L) % 24L;
        long l8 = l3 / 24L;
        if (l8 > 0L) {
            System.out.print(l8 + " day");
        }
        if (l8 > 1L) {
            System.out.print("s ");
        }
        if (l7 > 0L) {
            System.out.print(l7 + " hour");
        }
        if (l7 > 1L) {
            System.out.print("s ");
        }
        if (l6 > 0L) {
            System.out.print(l6 + " minute");
        }
        if (l6 > 1L) {
            System.out.print("s ");
        }
        System.out.print(l5 + " sec");
        if (l5 > 1L) {
            System.out.print("s ");
        }
        System.out.println();
    }

    public class OnlyExtensionSet
    implements FilenameFilter {
        String ext;

        public OnlyExtensionSet(String string) {
            this.ext = string;
        }

        public boolean accept(File file, String string) {
            return string.endsWith(this.ext);
        }
    }
}

