/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Vertex;

import TimUtilities.NumbersToString;

public class VertexMode {
    static final double UNSET = -9753.1;
    public boolean maxValueModeOn;
    public boolean constantWeightOn;
    public double totalWeight = -9753.1;
    public double maximumValue = -9753.1;
    static NumbersToString n2s = new NumbersToString(1);

    public VertexMode(double d) {
        this.setVertexMode(d);
    }

    public VertexMode(VertexMode vertexMode) {
        this.maxValueModeOn = vertexMode.maxValueModeOn;
        this.constantWeightOn = vertexMode.constantWeightOn;
        this.maximumValue = vertexMode.maximumValue;
        this.totalWeight = vertexMode.maximumValue;
    }

    public void setVertexMode(double d) {
        if (d > 0.0) {
            this.setMaxValueModeOn(d);
        } else {
            this.setConstantWeightModeOn(d);
        }
    }

    public void setMaxValueModeOn(double d) {
        this.maxValueModeOn = true;
        this.constantWeightOn = false;
        this.maximumValue = Math.abs(d);
        this.totalWeight = -9753.1;
    }

    public void setConstantWeightModeOn(double d) {
        this.maxValueModeOn = false;
        this.constantWeightOn = true;
        this.totalWeight = Math.abs(d);
        this.maximumValue = -9753.1;
    }

    public String description() {
        String string = "*** UNKNOWN ***";
        if (this.maxValueModeOn) {
            string = "Maximum Vertex Value ";
        }
        if (this.constantWeightOn) {
            string = "Total Weight Constant ";
        }
        return string;
    }

    public String descriptionValue(String string) {
        String string2 = "*** UNKNOWN ***";
        if (this.maxValueModeOn) {
            string2 = this.description() + string + this.maximumValue;
        }
        if (this.constantWeightOn) {
            string2 = this.description() + string + this.totalWeight;
        }
        return string2;
    }

    public String modeString() {
        if (this.maxValueModeOn) {
            return "-xv" + n2s.toString(this.maximumValue);
        }
        if (this.constantWeightOn) {
            return "-xw" + n2s.toString(this.totalWeight);
        }
        return "*** UNKNOWN ***";
    }

    public double getValue() {
        double d = -9753.1;
        if (this.maxValueModeOn) {
            d = this.maximumValue;
        }
        if (this.constantWeightOn) {
            d = this.totalWeight;
        }
        return d;
    }

    public double getModeValue() {
        double d = -9753.1;
        if (this.maxValueModeOn) {
            d = this.maximumValue;
        }
        if (this.constantWeightOn) {
            d = -this.totalWeight;
        }
        return d;
    }

    public boolean testValue(double d) {
        if (this.maxValueModeOn && d > this.maximumValue) {
            return false;
        }
        return !(d < 0.0);
    }
}

