/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Vertex;

import IslandNetworks.Edge.IslandEdgeSet;
import IslandNetworks.IslandTransferMatrix;
import IslandNetworks.PajekColours;
import IslandNetworks.Vertex.IslandSite;
import TimUtilities.Distances;
import TimUtilities.NumbersToString;
import TimUtilities.StatisticalQuantity;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;

public class IslandSiteSet {
    private int numberSites;
    private IslandSite[] siteArray;
    public int[] siteAlphabeticalOrder;
    public int[] siteWeightOrder;
    public StatisticalQuantity siteValueStats;
    public StatisticalQuantity siteWeightStats;
    public StatisticalQuantity siteStrengthOutStats;
    public StatisticalQuantity siteStrengthInStats;
    public int maxSiteValueIndex = -1;
    public int maxSiteWeightIndex = -1;
    public int maxOutSiteStrengthIndex = -1;
    public int maxInSiteStrengthIndex = -1;
    public double minX = -987.0;
    public double maxX = -987.0;
    public double minY = -987.0;
    public double maxY = -987.0;
    public double XYScale = -1.0;
    public double siteSizeNormalisation = -1.0;
    public StatisticalQuantity siteRankStats;
    public StatisticalQuantity siteInfluenceStats;
    static final int[] statisticsList = new int[]{IslandSite.valueIndex, IslandSite.weightIndex, IslandSite.strengthInIndex, IslandSite.strengthOutIndex, IslandSite.rankingIndex, IslandSite.influenceIndex};
    public double siteRankOverWeightMax = -1.0;
    public int[] siteRankOrder;
    public int[] siteRankOverWeightOrder;
    public int[] siteInfluenceOrder;
    int displayIndex = -1;
    NumbersToString n2s = new NumbersToString(3);
    ArrayList<String> geneName;

    public IslandSiteSet(int n) {
        this.numberSites = n;
        this.siteArray = new IslandSite[this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i] = new IslandSite();
        }
        this.initialiseSet(-1.0, -1.0, -1.0);
        this.setMinMaxXY();
        this.geneName = new ArrayList();
        this.siteAlphabeticalOrder = new int[this.numberSites];
        this.siteWeightOrder = new int[this.numberSites];
        this.siteRankOrder = new int[this.numberSites];
        this.siteRankOverWeightOrder = new int[this.numberSites];
        this.siteInfluenceOrder = new int[this.numberSites];
    }

    public IslandSiteSet(IslandSiteSet islandSiteSet) {
        int n;
        this.numberSites = islandSiteSet.numberSites;
        this.siteArray = new IslandSite[this.numberSites];
        for (n = 0; n < this.numberSites; ++n) {
            this.siteArray[n] = new IslandSite(islandSiteSet.siteArray[n]);
        }
        if (islandSiteSet.siteAlphabeticalOrder != null) {
            this.siteAlphabeticalOrder = new int[this.numberSites];
            for (n = 0; n < this.numberSites; ++n) {
                this.siteAlphabeticalOrder[n] = islandSiteSet.siteAlphabeticalOrder[n];
            }
        }
        if (islandSiteSet.siteWeightOrder != null) {
            this.siteWeightOrder = new int[this.numberSites];
            for (n = 0; n < this.numberSites; ++n) {
                this.siteWeightOrder[n] = islandSiteSet.siteWeightOrder[n];
            }
        }
        this.siteValueStats = new StatisticalQuantity(islandSiteSet.siteValueStats);
        this.siteWeightStats = new StatisticalQuantity(islandSiteSet.siteWeightStats);
        this.siteStrengthOutStats = new StatisticalQuantity(islandSiteSet.siteStrengthOutStats);
        this.siteStrengthInStats = new StatisticalQuantity(islandSiteSet.siteStrengthInStats);
        this.maxSiteValueIndex = islandSiteSet.maxSiteValueIndex;
        this.maxSiteWeightIndex = islandSiteSet.maxSiteWeightIndex;
        this.maxOutSiteStrengthIndex = islandSiteSet.maxOutSiteStrengthIndex;
        this.geneName = new ArrayList();
        for (n = 0; n < islandSiteSet.geneName.size(); ++n) {
            this.geneName.add(islandSiteSet.geneName.get(n));
        }
        this.minX = islandSiteSet.minX;
        this.maxX = islandSiteSet.maxX;
        this.minY = islandSiteSet.minY;
        this.maxY = islandSiteSet.maxY;
        this.XYScale = islandSiteSet.XYScale;
        this.siteSizeNormalisation = islandSiteSet.siteSizeNormalisation;
        this.siteRankStats = new StatisticalQuantity(islandSiteSet.siteRankStats);
        this.siteInfluenceStats = new StatisticalQuantity(islandSiteSet.siteInfluenceStats);
        this.siteRankOverWeightMax = islandSiteSet.siteRankOverWeightMax;
        this.siteRankOrder = new int[this.numberSites];
        this.siteRankOverWeightOrder = new int[this.numberSites];
        this.siteInfluenceOrder = new int[this.numberSites];
        for (n = 0; n < this.numberSites; ++n) {
            this.siteRankOrder[n] = islandSiteSet.siteRankOrder[n];
            this.siteRankOverWeightOrder[n] = islandSiteSet.siteRankOverWeightOrder[n];
            this.siteInfluenceOrder[n] = islandSiteSet.siteInfluenceOrder[n];
        }
    }

    public boolean isRegionSet() {
        return this.siteArray[0].isRegionSet();
    }

    public boolean isXYSet() {
        return this.siteArray[0].isXYSet();
    }

    public boolean isLatLongSet() {
        return this.siteArray[0].isLatLongSet();
    }

    public boolean isGenetic() {
        return this.geneName.size() > 0;
    }

    public boolean hasStatistics(int n) {
        for (int i = 0; i < statisticsList.length; ++i) {
            if (n != statisticsList[i]) continue;
            return true;
        }
        return false;
    }

    public int getNumberSites() {
        return this.numberSites;
    }

    public IslandSite[] getSiteArray() {
        return this.siteArray;
    }

    public String getName(int n) {
        return this.siteArray[n].name;
    }

    public String getRegion(int n) {
        return this.siteArray[n].region;
    }

    public double getX(int n) {
        return this.siteArray[n].getX();
    }

    public double getY(int n) {
        return this.siteArray[n].getY();
    }

    public double getLatitude(int n) {
        return this.siteArray[n].latitude;
    }

    public double getLongitude(int n) {
        return this.siteArray[n].longitude;
    }

    public double getValue(int n) {
        return this.siteArray[n].getValue();
    }

    public double getInValue(int n) {
        return this.siteArray[n].getInValue();
    }

    public double getSize(int n) {
        return this.siteArray[n].size;
    }

    public double getInSize(int n) {
        return this.siteArray[n].size;
    }

    public double getWeight(int n) {
        return this.siteArray[n].getWeight();
    }

    public double getInWeight(int n) {
        return this.siteArray[n].getInWeight();
    }

    public double getStrength(int n) {
        return this.siteArray[n].strength;
    }

    public double getStrengthIn(int n) {
        return this.siteArray[n].strengthIn;
    }

    public double getStrengthOut(int n) {
        return this.siteArray[n].strengthOut;
    }

    public double getDisplaySize(int n) {
        return this.siteArray[n].displaySize;
    }

    public double getRanking(int n) {
        return this.siteArray[n].ranking;
    }

    public int getRankingRank(int n) {
        return this.siteArray[n].rankingRank;
    }

    public double getTotalInfluenceWeight(int n) {
        return this.siteArray[n].influence;
    }

    public int getInfluenceRank(int n) {
        return this.siteArray[n].influenceRank;
    }

    public double getVariable(int n, int n2) {
        return this.siteArray[n].getVariable(n2);
    }

    public double getVariable(int n, String string) {
        return this.siteArray[n].getVariable(string);
    }

    public void setValue(int n, double d) {
        this.siteArray[n].value = d;
    }

    public void setInValue(int n, double d) {
        this.siteArray[n].inValue = d;
    }

    public void setSize(int n, double d) {
        this.siteArray[n].size = d;
    }

    public void setName(int n, String string) {
        this.siteArray[n].setName(string);
    }

    private void setDisplaySize(int n, double d) {
        this.siteArray[n].displaySize = d;
    }

    public void setXY(int n, double d, double d2) {
        this.siteArray[n].X = d;
        this.siteArray[n].Y = d2;
    }

    public void setVariable(int n, String string, String string2) {
        this.siteArray[n].setVariable(string, string2);
    }

    public void setVariable(int n, int n2, String string) {
        this.siteArray[n].setVariable(n2, string);
    }

    public void setWeights() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setWeight();
        }
    }

    public void initialiseSet(double d, double d2, double d3) {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].value = d;
            this.siteArray[i].size = d2;
            this.siteArray[i].setWeight();
            this.siteArray[i].displaySize = d3;
        }
    }

    public int addGene(String string) {
        this.geneName.add(string);
        int n = this.geneName.size();
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].addGeneValue();
        }
        return n - 1;
    }

    public int setGeneValues(int n, String[] stringArray) {
        int n2 = 0;
        for (int i = 0; i < this.numberSites; ++i) {
            n2 = Math.min(n2, this.setGeneValue(i, n, stringArray[i]));
        }
        return n2;
    }

    public int setGeneValue(int n, int n2, String string) {
        int n3 = 0;
        try {
            this.siteArray[n].setGeneValue(n2, string);
        }
        catch (RuntimeException runtimeException) {
            return -1 - n;
        }
        return n3;
    }

    public void setGeneLengths() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setGeneLength();
        }
    }

    public double getGeneLength(int n) {
        return this.siteArray[n].getGeneLength();
    }

    public double getGeneValue(int n, int n2) {
        return this.siteArray[n].getGeneValue(n2);
    }

    public double getGeneCorrelation(int n, int n2) {
        double d = 0.0;
        double d2 = this.getGeneLength(n) * this.getGeneLength(n2);
        if (d2 <= 1.0E-6) {
            return 0.0;
        }
        for (int i = 0; i < this.geneName.size(); ++i) {
            d += this.getGeneValue(n, i) * this.getGeneValue(n2, i);
        }
        return d / d2;
    }

    private int setValue(int n, int n2, String string) {
        return this.siteArray[n].setVariable(n2, string);
    }

    public int setValues(int n, String[] stringArray) {
        int n2 = 0;
        for (int i = 0; i < this.numberSites; ++i) {
            if (this.siteArray[i].setVariable(n, stringArray[i]) >= 0) continue;
            n2 = -1 - i;
        }
        return n2;
    }

    public void setValues(double d) {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setValue(d);
        }
    }

    public void setValuesRandom(Random random, double d) {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setValue(d * random.nextDouble());
        }
    }

    public void setInValuesRandom(Random random, double d) {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setInValue(d * random.nextDouble());
        }
    }

    public void setInValues(double d) {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setInValue(d);
        }
    }

    public void setXYFromLatLong() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].Y = -this.siteArray[i].latitude;
            this.siteArray[i].X = this.siteArray[i].longitude;
        }
        this.rescaleXY();
    }

    public void setMinMaxXY() {
        this.minX = this.siteArray[0].X;
        this.maxX = this.siteArray[0].X;
        this.minY = this.siteArray[0].Y;
        this.maxY = this.siteArray[0].Y;
        for (int i = 1; i < this.numberSites; ++i) {
            if (this.siteArray[i].X > this.maxX) {
                this.maxX = this.siteArray[i].X;
            }
            if (this.siteArray[i].X < this.minX) {
                this.minX = this.siteArray[i].X;
            }
            if (this.siteArray[i].Y > this.maxY) {
                this.maxY = this.siteArray[i].Y;
            }
            if (!(this.siteArray[i].Y < this.minY)) continue;
            this.minY = this.siteArray[i].Y;
        }
    }

    public void rescaleXY() {
        this.setMinMaxXY();
        double d = (this.maxX + this.minX) / 2.0;
        double d2 = (this.maxY + this.minY) / 2.0;
        double d3 = (this.maxX - this.minX) / 0.8;
        double d4 = (this.maxY - this.minY) / 0.8;
        this.XYScale = d3 > d4 ? d3 : d4;
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].X = (this.siteArray[i].X - d) / this.XYScale + 0.5;
            this.siteArray[i].Y = (this.siteArray[i].Y - d2) / this.XYScale + 0.5;
        }
    }

    public void normaliseSiteSizes() {
        int n;
        this.siteSizeNormalisation = 0.0;
        for (n = 0; n < this.numberSites; ++n) {
            this.siteSizeNormalisation += this.siteArray[n].size;
        }
        for (n = 0; n < this.numberSites; ++n) {
            this.siteArray[n].size = this.siteArray[n].size * (double)this.numberSites / this.siteSizeNormalisation;
        }
    }

    public void setShortNames() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setShortName();
        }
    }

    public double sphericalDistance(int n, int n2) {
        return Distances.sphericalDistance(this.siteArray[n].latitude, this.siteArray[n].longitude, this.siteArray[n2].latitude, this.siteArray[n2].longitude);
    }

    public double euclideanDistance(int n, int n2) {
        return Distances.euclideanDistance(this.siteArray[n].X, this.siteArray[n].Y, this.siteArray[n2].X, this.siteArray[n2].Y);
    }

    public void calcAlphabeticalOrder() {
        this.calcSiteOrder(1, this.siteAlphabeticalOrder, this.numberSites);
    }

    public void calcBasicStatistics(IslandEdgeSet islandEdgeSet) {
        int n;
        this.siteValueStats = new StatisticalQuantity(1.2345E97, -1.0);
        this.siteWeightStats = new StatisticalQuantity(1.2345E97, -1.0);
        this.siteStrengthOutStats = new StatisticalQuantity(1.2345E97, -1.0);
        this.siteStrengthInStats = new StatisticalQuantity(1.2345E97, -1.0);
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].strength = 0.0;
            this.siteArray[i].strengthIn = 0.0;
            this.siteArray[i].strengthOut = 0.0;
            this.siteArray[i].strengthSquaredIn = 0.0;
            this.siteArray[i].strengthSquaredOut = 0.0;
        }
        for (n = 0; n < this.numberSites; ++n) {
            double d = this.siteArray[n].getValue();
            double d2 = this.siteArray[n].getWeight();
            if (this.siteValueStats.maximum <= d) {
                this.maxSiteValueIndex = n;
            }
            if (this.siteWeightStats.maximum <= d2) {
                this.maxSiteWeightIndex = n;
            }
            this.siteValueStats.add(d);
            this.siteWeightStats.add(d2);
            for (int i = 0; i < this.numberSites; ++i) {
                double d3 = islandEdgeSet.getEdgeValue(n, i);
                double d4 = d3 * d3;
                double d5 = d2 * d3;
                double d6 = d5 * d5;
                this.siteArray[n].strengthOut += d5;
                this.siteArray[n].strengthSquaredOut += d6;
                this.siteArray[i].strengthIn += d5;
                this.siteArray[i].strengthSquaredIn += d6;
                this.siteArray[i].strength += d5;
            }
            if (this.siteStrengthOutStats.maximum <= this.siteArray[n].strengthOut) {
                this.maxOutSiteStrengthIndex = n;
            }
            this.siteStrengthOutStats.add(this.siteArray[n].strengthOut);
        }
        for (n = 0; n < this.numberSites; ++n) {
            double d = this.siteArray[n].strengthIn;
            this.siteStrengthInStats.add(d);
            if (!(this.siteStrengthInStats.maximum <= d)) continue;
            this.maxInSiteStrengthIndex = n;
        }
        this.calcSiteWeightOrder();
        for (n = 0; n < this.numberSites; ++n) {
            if (!(this.siteRankOverWeightMax < this.siteArray[n].rankOverWeight)) continue;
            this.siteRankOverWeightMax = this.siteArray[n].rankOverWeight;
        }
    }

    public void calcRanking(IslandTransferMatrix islandTransferMatrix) {
        int n;
        int n2 = islandTransferMatrix.checkMarkovian(0.001);
        if (n2 >= 0) {
            System.out.println(" !!! transferMatrix failed Markovian test at column " + n2);
        } else {
            System.out.println("... Transfer Matrix is Markovian");
        }
        int n3 = islandTransferMatrix.checkNonNegative();
        if (n3 >= 0) {
            System.err.println("*** Transfer Matrix is negative at row " + (double)n3 / islandTransferMatrix.getDimension() + " column " + (double)n3 % islandTransferMatrix.getDimension());
        } else {
            System.out.println("... Transfer Matrix is non-negative");
        }
        double d = islandTransferMatrix.getAbsEigenValue(0);
        if (d < 0.99) {
            System.out.println("!!! WARNING in calcRanking largest absolute eigenvalue of transfer matrix has value " + d);
        }
        double[] dArray = new double[this.numberSites];
        dArray = islandTransferMatrix.getEigenVector(0);
        double d2 = 0.0;
        for (n = 0; n < this.numberSites; ++n) {
            this.siteArray[n].ranking = Math.abs(dArray[n]);
            d2 += this.siteArray[n].ranking;
        }
        if (d2 > 0.0) {
            for (n = 0; n < this.numberSites; ++n) {
                this.siteArray[n].ranking /= d2;
            }
        }
        for (n = 0; n < this.numberSites; ++n) {
            this.siteArray[n].rankOverWeight = this.siteArray[n].getWeight() > 0.0 ? this.siteArray[n].ranking / this.siteArray[n].getWeight() : 0.0;
        }
        this.calcSiteRankOrder(9, this.siteRankOrder, 10);
        this.calcSiteRankOrder(19, this.siteRankOverWeightOrder, 20);
        this.siteRankStats = new StatisticalQuantity(99999.0, -1.0);
        for (n = 0; n < this.numberSites; ++n) {
            this.siteRankStats.add(this.siteArray[n].ranking);
        }
    }

    public void calcInfluence(IslandTransferMatrix islandTransferMatrix, double d) {
        int n;
        islandTransferMatrix.calcInfluenceMatrix(d);
        double[] dArray = new double[this.numberSites];
        for (n = 0; n < this.numberSites; ++n) {
            dArray[n] = 0.0;
            double d2 = this.siteArray[n].getWeight();
            for (int i = 0; i < this.numberSites; ++i) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.siteArray[i].getWeight() * islandTransferMatrix.getInfluence(i, n) * d2;
            }
        }
        for (n = 0; n < this.numberSites; ++n) {
            this.siteArray[n].influence = dArray[n];
        }
        this.calcSiteRankOrder(11, this.siteInfluenceOrder, 13);
        this.siteInfluenceStats = new StatisticalQuantity(99999.0, -1.0);
        for (n = 0; n < this.numberSites; ++n) {
            this.siteInfluenceStats.add(this.siteArray[n].influence);
        }
    }

    public void setAllDisplaySizes(int n, double d) {
        double d2;
        this.displayIndex = n;
        double d3 = 1.0;
        boolean bl = false;
        if (IslandSite.isIndex(this.displayIndex) && IslandSite.isNumerical(this.displayIndex)) {
            bl = true;
            if (this.hasStatistics(this.displayIndex) && d < 0.0) {
                if (this.displayIndex == IslandSite.valueIndex) {
                    d3 = this.siteValueStats.maximum;
                }
                if (this.displayIndex == IslandSite.weightIndex) {
                    d3 = this.siteWeightStats.maximum;
                }
                if (this.displayIndex == IslandSite.strengthInIndex) {
                    d3 = this.siteStrengthInStats.maximum;
                }
                if (this.displayIndex == IslandSite.strengthOutIndex) {
                    d3 = this.siteStrengthOutStats.maximum;
                }
                if (this.displayIndex == IslandSite.rankingIndex) {
                    d3 = this.siteRankStats.maximum;
                }
                if (this.displayIndex == IslandSite.influenceIndex) {
                    d3 = this.siteInfluenceStats.maximum;
                }
            }
            if (d3 < 1.0E-6) {
                d3 = 1.0;
            }
        }
        double d4 = 0.0;
        double d5 = d2 = Math.abs(d);
        for (int i = 0; i < this.numberSites; ++i) {
            if (bl) {
                d5 = d2 * this.siteArray[i].getVariable(this.displayIndex) / d3;
            }
            d4 += d5;
            this.siteArray[i].displaySize = d5;
            if (this.siteArray[i].displaySize < 0.0) {
                this.siteArray[i].displaySize = 0.0;
            }
            this.siteArray[i].Z = this.siteArray[i].displaySize;
        }
        System.out.println("IslandSite: Site Display of " + IslandSite.dataName(this.displayIndex) + "  scale, scaleSize, average " + d2 + "  " + d3 + "  " + d4 / (double)this.numberSites);
    }

    public void printDisplaySizes(PrintStream printStream, String string, int n) {
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.print(string + NumbersToString.toString(this.siteArray[i].displaySize, n));
        }
    }

    public void printFixedSiteVariables(PrintStream printStream, String string, String string2) {
        printStream.println(string + string2 + this.siteArray[0].fixedDataNameString(string2));
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.println(i + string2 + this.siteArray[i].fixedDataString(string2));
        }
    }

    public void printSiteVariables(PrintStream printStream, String string, String string2) {
        for (int i = 0; i < IslandSite.numberVariables; ++i) {
            this.printValues(printStream, string, string2, i);
        }
        this.printGenes(printStream, string, string2);
    }

    public void printSiteParameters(PrintStream printStream, String string, String string2) {
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.println(this.siteArray[i].parameterStringValues(string2, 5));
        }
    }

    public void printValues(PrintStream printStream, String string, String string2, int n) {
        if (this.siteArray[0].isSet(n)) {
            this.printValuesAlways(printStream, string, string2, n);
        }
    }

    public void printValuesAlways(PrintStream printStream, String string, String string2, int n) {
        printStream.print(string + IslandSite.dataName(n));
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.print(string2 + this.siteArray[i].toString(n));
        }
        printStream.println();
    }

    public void printValues(PrintStream printStream, String string, String string2, String string3) {
        int n = IslandSite.getIndex(string3);
        if (n < 0) {
            printStream.println("Variable " + string3 + " is unknown");
        } else {
            this.printValues(printStream, string, string2, n);
        }
    }

    public void printValueVector(PrintStream printStream, String string) {
        int n = IslandSite.getIndex(string);
        if (n < 0) {
            printStream.println("Variable " + string + " is unknown");
        } else {
            this.printValueVector(printStream, n);
        }
    }

    public void printValueVector(PrintStream printStream, int n) {
        for (int i = 0; i < this.numberSites; ++i) {
            printStream.println(this.siteArray[i].toString(n));
        }
    }

    public void printGenes(PrintStream printStream, String string, String string2) {
        for (int i = 0; i < this.geneName.size(); ++i) {
            printStream.print(this.geneName.get(i));
            for (int j = 0; j < this.numberSites; ++j) {
                printStream.print(string2 + this.siteArray[j].getGeneValue(i));
            }
            printStream.println();
        }
    }

    public String geneNameString(String string) {
        String string2 = "";
        if (this.geneName.size() > 0) {
            for (int i = 0; i < this.geneName.size(); ++i) {
                string2 = string2 + string + this.geneName.get(i);
            }
        }
        return string2;
    }

    public String toString(int n, String string, String string2, int n2) {
        int n3;
        String string3 = "";
        for (n3 = 0; n3 < IslandSite.numberVariables; ++n3) {
            if (!this.siteArray[n].isSet(n3)) continue;
            string3 = string3 + IslandSite.dataName(n3) + string + this.siteArray[n].toShortDoubleString(n3, n2) + string2;
        }
        for (n3 = 0; n3 < this.geneName.size(); ++n3) {
            string3 = string3 + this.geneName.get(n3) + string + this.siteArray[n].geneToShortDoubleString(n3, n2) + string2;
        }
        return string3;
    }

    public IslandSite getSite(int n) {
        return this.siteArray[n];
    }

    public void printPajekNetFormat(PrintStream printStream, double d, double d2, int n) {
        int n2 = PajekColours.numberColours;
        printStream.println("*Vertices      " + this.numberSites);
        block7: for (int i = 0; i < this.numberSites; ++i) {
            int n3 = (int)(0.499999 + this.siteArray[i].displaySize);
            if (n3 > n2) {
                n3 = n2;
            }
            if ((double)n3 < d * (double)n2) {
                n3 = 1;
            }
            if ((double)n3 < d2 * (double)n2) {
                n3 = 0;
            }
            printStream.print(i + 1 + "  \"" + this.getName(i) + "\" " + this.siteArray[i].X + " " + this.siteArray[i].Y + " ");
            switch (n) {
                case 1: 
                case 2: {
                    printStream.print(this.siteArray[i].Z + " s_size 1 " + " x_fact " + this.n2s.TruncDecimal(this.siteArray[i].displaySize, 2) + " y_fact " + this.n2s.TruncDecimal(this.siteArray[i].displaySize, 2));
                    break;
                }
                default: {
                    printStream.print("  " + this.siteArray[i].getWeight());
                }
            }
            switch (n) {
                case 1: {
                    printStream.println(" ic " + PajekColours.getGrey(n3) + "   bc " + PajekColours.getGrey(n3));
                    continue block7;
                }
                case 2: {
                    printStream.println(" ic " + PajekColours.colours[n3] + "   bc " + PajekColours.colours[n2]);
                    continue block7;
                }
                default: {
                    printStream.println();
                }
            }
        }
    }

    public void calcSiteWeightOrder() {
        for (int i = 0; i < this.numberSites; ++i) {
            this.siteArray[i].setWeight();
        }
        this.calcSiteRankOrder(7, this.siteWeightOrder, 8);
    }

    private void calcSiteOrder(int n, int[] nArray, int n2) {
        int n3;
        boolean bl = IslandSite.isAlpha(n);
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = n3;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = nArray[n3];
            for (int i = n3 + 1; i < n2; ++i) {
                int n5 = nArray[i];
                if ((!bl || this.siteArray[n4].toString(n).compareToIgnoreCase(this.siteArray[n5].toString(n)) <= 0) && (bl || !(this.siteArray[n4].getVariable(n) < this.siteArray[n5].getVariable(n)))) continue;
                n4 = n5;
                nArray[i] = nArray[n3];
                nArray[n3] = n4;
            }
        }
    }

    public void calcSiteRankOrder(int n, int[] nArray, int n2) {
        int n3 = nArray.length;
        this.calcSiteOrder(n, nArray, n3);
        for (int i = 0; i < n3; ++i) {
            this.siteArray[nArray[i]].setInt(n2, i);
        }
        n3 = 0;
    }
}

