/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks.Vertex;

import TimUtilities.NumbersToString;
import java.util.ArrayList;

public class IslandSite {
    static final double DUNSET = -76543.2;
    static final int IUNSET = -654321;
    static final double GUNSET = -54321.0987;
    static final String AUNSET = "?!!!!!";
    static final int SSDEFAULTLENGTH = 3;
    static final String SAUNSET = "?!!!!!".substring(0, 3);
    public String name = "?!!!!!";
    public String shortName = SAUNSET;
    public double X = -76543.2;
    public double Y = -76543.2;
    public double Z = -76543.2;
    public double size = -76543.2;
    public double value = -76543.2;
    private double weight = -76543.2;
    public int weightRank = -654321;
    public double ranking = -76543.2;
    public int rankingRank = -654321;
    public double influence = -76543.2;
    private int influenceInt = -654321;
    public int influenceRank = -654321;
    public double displaySize = -654321.0;
    public double strength = -654321.0;
    public double strengthIn = -654321.0;
    public double strengthOut = -654321.0;
    public int number = -654321;
    public double rankOverWeight = 0.0;
    public int rankOverWeightRank = -654321;
    public double cultureMax = -654321.0;
    public int cultureSite = -654321;
    public double strengthSquaredIn = -654321.0;
    public double strengthSquaredOut = -654321.0;
    public double latitude = -76543.2;
    public double longitude = -76543.2;
    public String region = "?!!!!!";
    public double inValue = -76543.2;
    public double inWeight = -76543.2;
    private ArrayList<Double> geneList = new ArrayList();
    double geneLength = -76543.2;
    private static NumbersToString n2s = new NumbersToString(3);
    static final String[] parameterNames = new String[]{"ShortName", "Name", "XPos", "YPos", "ZPos", "Size", "Value", "Weight", "WeightRank", "Ranking", "RankingRank", "Influence", "InfluenceInt", "InfluenceRank", "DisplaySize", "Strength", "StrengthIn", "StrengthOut", "Number", "Ranking/Weight", "Ranking/Weight rank", "CultureMax", "CultureSite", "StrengthInSquared", "StrengthOutSquared", "Latitude", "Longitude", "Region", "ValueIn", "WeightIn"};
    public static final int numberVariables = parameterNames.length;
    public static final int valueIndex = IslandSite.getIndex("Value");
    public static final int weightIndex = IslandSite.getIndex("Weight");
    public static final int strengthInIndex = IslandSite.getIndex("StrengthIn");
    public static final int strengthOutIndex = IslandSite.getIndex("StrengthOut");
    public static final int rankingIndex = IslandSite.getIndex("Ranking");
    public static final int influenceIndex = IslandSite.getIndex("Influence");
    static final char INTCHAR = 'i';
    static final char DOUBLECHAR = 'd';
    static final char ALPHACHAR = 'a';
    static final char DLISTCHAR = 'l';
    static final char[] typeList = new char[]{'a', 'a', 'd', 'd', 'd', 'd', 'd', 'd', 'i', 'd', 'i', 'd', 'i', 'i', 'd', 'd', 'd', 'd', 'i', 'd', 'i', 'd', 'i', 'd', 'd', 'd', 'd', 'a', 'd', 'd'};
    static final int[] parameterFileList = new int[]{18, 1, 27, 2, 3, 4, 25, 26, 5, 6, 28, 29};
    static final int[] fixedParameterList = new int[]{1, 2, 3, 4, 5, 18, 25, 26, 27};

    public IslandSite() {
    }

    public IslandSite(int n) {
        this.number = n;
        this.name = Integer.toString(n);
    }

    public IslandSite(IslandSite islandSite) {
        this.name = islandSite.name;
        this.shortName = islandSite.shortName;
        this.number = islandSite.number;
        this.X = islandSite.X;
        this.Y = islandSite.Y;
        this.Z = islandSite.Z;
        this.size = islandSite.size;
        this.value = islandSite.value;
        this.weight = islandSite.weight;
        this.weightRank = islandSite.weightRank;
        this.ranking = islandSite.ranking;
        this.rankingRank = islandSite.rankingRank;
        this.influence = islandSite.influence;
        this.influenceInt = islandSite.influenceInt;
        this.influenceRank = islandSite.influenceRank;
        this.displaySize = islandSite.displaySize;
        this.strength = islandSite.strength;
        this.strengthIn = islandSite.strengthIn;
        this.strengthOut = islandSite.strengthOut;
        this.rankOverWeight = islandSite.rankOverWeight;
        this.rankOverWeightRank = islandSite.rankOverWeightRank;
        this.cultureMax = islandSite.cultureMax;
        this.cultureSite = islandSite.cultureSite;
        this.strengthSquaredIn = islandSite.strengthSquaredIn;
        this.strengthSquaredOut = islandSite.strengthSquaredOut;
        this.latitude = islandSite.latitude;
        this.longitude = islandSite.longitude;
        this.region = islandSite.region;
        this.inValue = islandSite.inValue;
        this.inWeight = islandSite.inWeight;
        for (int i = 0; i < islandSite.geneList.size(); ++i) {
            this.geneList.add(islandSite.geneList.get(i));
        }
    }

    public String toString(String string) {
        int n;
        String string2 = "";
        for (n = 0; n < numberVariables; ++n) {
            string2 = string2 + this.toString(n) + string;
        }
        for (n = 0; n < this.geneList.size(); ++n) {
            string2 = string2 + this.geneList.get(n).toString() + string;
        }
        return string2;
    }

    public void setWeight() {
        this.weight = this.value * this.size;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void setInValue(double d) {
        this.inValue = d;
    }

    public void setInWeight() {
        this.inWeight = this.inValue * this.size;
    }

    public String setName(String string) {
        int n = 2;
        this.shortName = this.name = string;
        if (this.name.length() < n) {
            return this.name;
        }
        this.shortName = this.name.substring(0, n);
        return this.name;
    }

    public String setName(String string, String string2) {
        this.shortName = string;
        this.name = string2;
        return string2;
    }

    public void setShortName() {
        if (this.shortName.equals(SAUNSET)) {
            this.shortName = this.name.length() > 2 ? this.name.substring(0, 3) : this.name;
        }
    }

    public int setInt(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 8: {
                this.weightRank = n2;
                break;
            }
            case 10: {
                this.rankingRank = n2;
                break;
            }
            case 12: {
                this.influenceInt = n2;
                break;
            }
            case 13: {
                this.influenceRank = n2;
                break;
            }
            case 18: {
                this.number = n2;
                break;
            }
            case 20: {
                this.rankOverWeightRank = n2;
                break;
            }
            case 22: {
                this.cultureSite = n2;
                break;
            }
            default: {
                n3 = -97531;
            }
        }
        return n3;
    }

    public double getWeight() {
        this.setWeight();
        return this.weight;
    }

    public double getOutWeight() {
        this.setWeight();
        return this.weight;
    }

    public double getInWeight() {
        this.setInWeight();
        return this.inWeight;
    }

    public int getNumberVariables() {
        return numberVariables;
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getDisplaySize() {
        return this.displaySize;
    }

    public double getValue() {
        return this.value;
    }

    public double getInValue() {
        return this.inValue;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getGene() {
        return this.geneList;
    }

    public double getGeneLength() {
        return this.geneLength;
    }

    public double setGeneLength() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.geneList.size(); ++i) {
            d = this.geneList.get(i);
            d2 += d * d;
        }
        this.geneLength = Math.sqrt(d2);
        return this.geneLength;
    }

    public Object getObject(int n) {
        switch (n) {
            case 0: {
                return this.shortName;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.X;
            }
            case 3: {
                return this.Y;
            }
            case 4: {
                return this.Z;
            }
            case 5: {
                return this.size;
            }
            case 6: {
                return this.value;
            }
            case 7: {
                return this.weight;
            }
            case 8: {
                return this.weightRank;
            }
            case 9: {
                return this.ranking;
            }
            case 10: {
                return this.rankingRank;
            }
            case 11: {
                return this.influence;
            }
            case 12: {
                return this.influenceInt;
            }
            case 13: {
                return this.influenceRank;
            }
            case 14: {
                return this.displaySize;
            }
            case 15: {
                return this.strength;
            }
            case 16: {
                return this.strengthIn;
            }
            case 17: {
                return this.strengthOut;
            }
            case 18: {
                return this.number;
            }
            case 19: {
                return this.rankOverWeight;
            }
            case 20: {
                return this.rankOverWeightRank;
            }
            case 21: {
                return this.cultureMax;
            }
            case 22: {
                return this.cultureSite;
            }
            case 23: {
                return this.strengthSquaredIn;
            }
            case 24: {
                return this.strengthSquaredOut;
            }
            case 25: {
                return this.latitude;
            }
            case 26: {
                return this.longitude;
            }
            case 27: {
                return this.region;
            }
            case 28: {
                return this.inValue;
            }
            case 29: {
                return this.inWeight;
            }
        }
        return AUNSET;
    }

    public double getVariable(String string) {
        return this.getVariable(IslandSite.getIndex(string));
    }

    public double getVariable(int n) {
        double d = -76543.2;
        switch (n) {
            case 0: {
                d = this.shortName.codePointAt(0);
                break;
            }
            case 1: {
                d = this.name.codePointAt(0);
                break;
            }
            case 2: {
                d = this.X;
                break;
            }
            case 3: {
                d = this.Y;
                break;
            }
            case 4: {
                d = this.Z;
                break;
            }
            case 5: {
                d = this.size;
                break;
            }
            case 6: {
                d = this.value;
                break;
            }
            case 7: {
                d = this.weight;
                break;
            }
            case 8: {
                d = this.weightRank;
                break;
            }
            case 9: {
                d = this.ranking;
                break;
            }
            case 10: {
                d = this.rankingRank;
                break;
            }
            case 11: {
                d = this.influence;
                break;
            }
            case 12: {
                d = this.influenceInt;
                break;
            }
            case 13: {
                d = this.influenceRank;
                break;
            }
            case 14: {
                d = this.displaySize;
                break;
            }
            case 15: {
                d = this.strength;
                break;
            }
            case 16: {
                d = this.strengthIn;
                break;
            }
            case 17: {
                d = this.strengthOut;
                break;
            }
            case 18: {
                d = this.number;
                break;
            }
            case 19: {
                d = this.rankOverWeight;
                break;
            }
            case 20: {
                d = this.rankOverWeightRank;
                break;
            }
            case 21: {
                d = this.cultureMax;
                break;
            }
            case 22: {
                d = this.cultureSite;
                break;
            }
            case 23: {
                d = this.strengthSquaredIn;
                break;
            }
            case 24: {
                d = this.strengthSquaredOut;
                break;
            }
            case 25: {
                d = this.latitude;
                break;
            }
            case 26: {
                d = this.longitude;
                break;
            }
            case 27: {
                d = this.region.codePointAt(0);
                break;
            }
            case 28: {
                d = this.inValue;
                break;
            }
            case 29: {
                d = this.inWeight;
            }
        }
        return d;
    }

    public String parameterStringValues(String string, int n) {
        String string2 = "";
        for (int i = 0; i < parameterFileList.length; ++i) {
            string2 = string2 + (i == 0 ? "" : string);
            int n2 = parameterFileList[i];
            string2 = n2 == 1 ? string2 + this.toString(n2) : string2 + this.toShortString(parameterFileList[i], n);
        }
        return string2 + this.geneStringValues(string, n);
    }

    public String geneStringValues(String string, int n) {
        if (this.geneList.size() == 0) {
            return "";
        }
        String string2 = "";
        for (int i = 0; i < this.geneList.size(); ++i) {
            string2 = string2 + string + n2s.TruncDecimal(this.geneList.get(i), n);
        }
        return string2;
    }

    public static String parameterStringNames(String string) {
        String string2 = "";
        for (int i = 0; i < parameterFileList.length; ++i) {
            string2 = string2 + (i == 0 ? "" : string) + IslandSite.dataName(parameterFileList[i]);
        }
        return string2;
    }

    public String toShortString(int n, int n2) {
        String string = "value unknown";
        if (IslandSite.isAlpha(n)) {
            string = this.toString(n);
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
        } else {
            string = IslandSite.isDouble(n) ? NumbersToString.toString(this.getVariable(n), n2) : this.toString(n);
        }
        return string;
    }

    public String toShortDoubleString(int n, int n2) {
        String string = "index " + n + " unknown";
        string = IslandSite.isAlpha(n) ? this.toString(n) : NumbersToString.toString(this.getVariable(n), n2);
        return string;
    }

    public String geneToShortDoubleString(int n, int n2) {
        String string = NumbersToString.toString(this.getGeneValue(n), n2);
        return string;
    }

    public String toString(int n) {
        String string = "value unknown";
        switch (n) {
            case 0: {
                string = this.shortName;
                break;
            }
            case 1: {
                string = this.name;
                break;
            }
            case 2: {
                string = Double.toString(this.X);
                break;
            }
            case 3: {
                string = Double.toString(this.Y);
                break;
            }
            case 4: {
                string = Double.toString(this.Z);
                break;
            }
            case 5: {
                string = Double.toString(this.size);
                break;
            }
            case 6: {
                string = Double.toString(this.value);
                break;
            }
            case 7: {
                string = Double.toString(this.weight);
                break;
            }
            case 8: {
                string = Integer.toString(this.weightRank);
                break;
            }
            case 9: {
                string = Double.toString(this.ranking);
                break;
            }
            case 10: {
                string = Integer.toString(this.rankingRank);
                break;
            }
            case 11: {
                string = Double.toString(this.influence);
                break;
            }
            case 12: {
                string = Integer.toString(this.influenceInt);
                break;
            }
            case 13: {
                string = Integer.toString(this.influenceRank);
                break;
            }
            case 14: {
                string = Double.toString(this.displaySize);
                break;
            }
            case 15: {
                string = Double.toString(this.strength);
                break;
            }
            case 16: {
                string = Double.toString(this.strengthIn);
                break;
            }
            case 17: {
                string = Double.toString(this.strengthOut);
                break;
            }
            case 18: {
                string = Integer.toString(this.number);
                break;
            }
            case 19: {
                string = Double.toString(this.strengthOut);
                break;
            }
            case 20: {
                string = Integer.toString(this.rankOverWeightRank);
                break;
            }
            case 21: {
                string = Double.toString(this.cultureMax);
                break;
            }
            case 22: {
                string = Integer.toString(this.cultureSite);
                break;
            }
            case 23: {
                string = Double.toString(this.strengthSquaredIn);
                break;
            }
            case 24: {
                string = Double.toString(this.strengthSquaredOut);
                break;
            }
            case 25: {
                string = Double.toString(this.latitude);
                break;
            }
            case 26: {
                string = Double.toString(this.longitude);
                break;
            }
            case 27: {
                string = this.region;
                break;
            }
            case 28: {
                string = Double.toString(this.inValue);
                break;
            }
            case 29: {
                string = Double.toString(this.inWeight);
            }
        }
        return string;
    }

    public int setVariable(String string, String string2) {
        int n = 0;
        try {
            int n2 = IslandSite.getIndex(string);
            this.setVariable(n2, string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Problem in Site.setValue: " + numberFormatException);
            n = -1;
        }
        return n;
    }

    public int setVariable(int n, String string) {
        int n2 = 0;
        try {
            switch (n) {
                case 0: {
                    this.shortName = string;
                    break;
                }
                case 1: {
                    this.name = string;
                    break;
                }
                case 2: {
                    this.X = new Double(string);
                    break;
                }
                case 3: {
                    this.Y = new Double(string);
                    break;
                }
                case 4: {
                    this.Z = new Double(string);
                    break;
                }
                case 5: {
                    this.size = new Double(string);
                    break;
                }
                case 6: {
                    this.value = new Double(string);
                    break;
                }
                case 7: {
                    this.weight = new Double(string);
                    break;
                }
                case 8: {
                    this.weightRank = new Integer(string);
                    break;
                }
                case 9: {
                    this.ranking = new Double(string);
                    break;
                }
                case 10: {
                    this.rankingRank = new Integer(string);
                    break;
                }
                case 11: {
                    this.influence = new Double(string);
                    break;
                }
                case 12: {
                    this.influenceInt = new Integer(string);
                    break;
                }
                case 13: {
                    this.influenceRank = new Integer(string);
                    break;
                }
                case 14: {
                    this.displaySize = new Double(string);
                    break;
                }
                case 15: {
                    this.strength = new Double(string);
                    break;
                }
                case 16: {
                    this.strengthIn = new Double(string);
                    break;
                }
                case 17: {
                    this.strengthOut = new Double(string);
                    break;
                }
                case 18: {
                    this.number = new Integer(string);
                    break;
                }
                case 19: {
                    this.rankOverWeight = new Double(string);
                    break;
                }
                case 20: {
                    this.rankOverWeightRank = new Integer(string);
                    break;
                }
                case 21: {
                    this.cultureMax = new Double(string);
                    break;
                }
                case 22: {
                    this.cultureSite = new Integer(string);
                    break;
                }
                case 23: {
                    this.strengthSquaredIn = new Double(string);
                    break;
                }
                case 24: {
                    this.strengthSquaredOut = new Double(string);
                    break;
                }
                case 25: {
                    this.latitude = new Double(string);
                    break;
                }
                case 26: {
                    this.longitude = new Double(string);
                    break;
                }
                case 27: {
                    this.region = string;
                    break;
                }
                case 28: {
                    this.inValue = new Double(string);
                    break;
                }
                case 29: {
                    this.inWeight = new Double(string);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Problem in Site.setValue: " + numberFormatException);
            n2 = -1;
        }
        return n2;
    }

    public double getGeneValue(int n) {
        return this.geneList.get(n);
    }

    public void addGeneValue() {
        this.geneList.add(-54321.0987);
    }

    public void setGeneValue(int n, String string) {
        this.geneList.set(n, Double.parseDouble(string));
    }

    public void setGeneValue(int n, Double d) {
        this.geneList.set(n, d);
    }

    public String fixedDataNameString(String string) {
        String string2 = IslandSite.dataName(0);
        for (int i = 1; i < fixedParameterList.length; ++i) {
            string2 = string2 + string + IslandSite.dataName(fixedParameterList[i]);
        }
        return string2;
    }

    public String fixedDataString(String string) {
        String string2 = this.toString(0);
        for (int i = 1; i < fixedParameterList.length; ++i) {
            string2 = string2 + string + this.toString(fixedParameterList[i]);
        }
        return string2;
    }

    public static String dataNameString(String string) {
        String string2 = IslandSite.dataName(0);
        for (int i = 1; i < numberVariables; ++i) {
            string2 = string2 + string + IslandSite.dataName(i);
        }
        return string2;
    }

    public static String dataName(int n) {
        if (n < 0 || n >= parameterNames.length) {
            return "value unknown";
        }
        return parameterNames[n];
    }

    public int dataNameNumber(String string, int n) {
        if (string.length() < n) {
            return -2;
        }
        int n2 = -1;
        String string2 = string.substring(0, n);
        for (int i = 0; i < numberVariables; ++i) {
            if (IslandSite.dataName(i).length() < n || !string2.equalsIgnoreCase(IslandSite.dataName(i).substring(0, n))) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static int getIndex(String string) {
        int n = -1;
        for (int i = 0; i < numberVariables; ++i) {
            if (IslandSite.dataName(i).length() < string.length() || !string.equalsIgnoreCase(IslandSite.dataName(i).substring(0, string.length()))) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean isLatLongSet() {
        return this.latitude != -76543.2 && this.longitude != -76543.2;
    }

    public boolean isXYSet() {
        return this.X != -76543.2 && this.Y != -76543.2;
    }

    public boolean isXYZSet() {
        return this.X != -76543.2 && this.Y != -76543.2 && this.Z != -76543.2;
    }

    public boolean isRegionSet() {
        return !this.region.equals(AUNSET);
    }

    public static boolean isIndex(int n) {
        return n >= 0 && n < numberVariables;
    }

    public static boolean isInt(int n) {
        return typeList[n] == 'i';
    }

    public static boolean isDouble(int n) {
        return typeList[n] == 'd';
    }

    public static boolean isNumerical(int n) {
        return typeList[n] == 'd' || typeList[n] == 'i';
    }

    public static boolean isAlpha(int n) {
        return typeList[n] == 'a';
    }

    public boolean isSet(String string) {
        return this.isSet(IslandSite.getIndex(string));
    }

    public boolean isSet(int n) {
        switch (n) {
            case 0: {
                return !this.shortName.equals(SAUNSET);
            }
            case 1: {
                return !this.name.equals(AUNSET);
            }
            case 2: {
                return -76543.2 != this.X;
            }
            case 3: {
                return -76543.2 != this.Y;
            }
            case 4: {
                return -76543.2 != this.Z;
            }
            case 5: {
                return -76543.2 != this.size;
            }
            case 6: {
                return -76543.2 != this.value;
            }
            case 7: {
                return -76543.2 != this.weight;
            }
            case 8: {
                return -654321 != this.weightRank;
            }
            case 9: {
                return -76543.2 != this.ranking;
            }
            case 10: {
                return -654321 != this.rankingRank;
            }
            case 11: {
                return -76543.2 != this.influence;
            }
            case 12: {
                return -654321 != this.influenceInt;
            }
            case 13: {
                return -654321 != this.influenceRank;
            }
            case 14: {
                return -76543.2 != this.displaySize;
            }
            case 15: {
                return -76543.2 != this.strength;
            }
            case 16: {
                return -76543.2 != this.strengthIn;
            }
            case 17: {
                return -76543.2 != this.strengthOut;
            }
            case 18: {
                return -654321 != this.number;
            }
            case 19: {
                return -76543.2 != this.rankOverWeight;
            }
            case 20: {
                return -654321 != this.rankOverWeightRank;
            }
            case 21: {
                return -76543.2 != this.cultureMax;
            }
            case 22: {
                return -654321 != this.cultureSite;
            }
            case 23: {
                return -76543.2 != this.strengthSquaredIn;
            }
            case 24: {
                return -76543.2 != this.strengthSquaredOut;
            }
            case 25: {
                return -76543.2 != this.latitude;
            }
            case 26: {
                return -76543.2 != this.longitude;
            }
            case 27: {
                return !this.region.equals(AUNSET);
            }
            case 28: {
                return -76543.2 != this.inValue;
            }
            case 29: {
                return -76543.2 != this.inValue;
            }
        }
        return false;
    }
}

