/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.LouvainCommunity;
import IslandNetworks.NetworkGenerator;
import IslandNetworks.io.FileLocation;
import IslandNetworks.islandNetwork;
import java.io.File;
import java.util.Date;

public class TestAegean {
    String SEP = "\t";

    public static void main(String[] stringArray) {
        Date date = new Date();
        System.out.println(date);
        islandNetwork islandNetwork2 = new islandNetwork(1);
        islandNetwork2.inputGUI = true;
        String string = "aegean39S1L3a";
        String string2 = System.getProperty("user.dir");
        islandNetwork2.inputFile = new FileLocation(string2 + "/input/", "", string, "", "_input", "dat");
        islandNetwork2.outputFile = new FileLocation(string2 + "/output/", "", string, "", 0, "", "dat");
        int n = islandNetwork2.Parse(stringArray);
        if (n > 0) {
            System.out.println("Command line argument failure - return code " + n);
            return;
        }
        if (islandNetwork2.inputGUI) {
            TestAegean.testGUIDirect(islandNetwork2);
        } else {
            if (islandNetwork2.generateNumber >= 0) {
                NetworkGenerator networkGenerator = new NetworkGenerator(islandNetwork2.generateType, islandNetwork2.generateNumber, islandNetwork2.Hamiltonian.distanceScale);
                networkGenerator.FileOutputSite(2);
                return;
            }
            TestAegean.testLouvain(islandNetwork2, stringArray);
        }
    }

    public static void testLouvain(islandNetwork islandNetwork2, String[] stringArray) {
        File file;
        System.out.println("\n *** testLouvain ***");
        islandNetwork2.inputFile.setAll("input/", "", "testaegean5", "", 0, "_input", "dat");
        if (stringArray.length > 0) {
            islandNetwork2.Parse(stringArray);
            file = new File(islandNetwork2.outputFile.getFullLocationFileName("", "anf"));
        } else {
            islandNetwork2.setOutputFileName();
            islandNetwork2.outputFile.sequenceNumber = 0;
            file = new File(islandNetwork2.outputFile.getFullLocationFileName("", "anf"));
        }
        System.out.println("Trying to read from " + file.getPath());
        islandNetwork islandNetwork3 = new islandNetwork(file, islandNetwork2);
        islandNetwork3.calcNetworkStats();
        islandNetwork3.calcTransferMatrix(0, IslandEdge.valueINDEX);
        LouvainCommunity louvainCommunity = new LouvainCommunity(islandNetwork3);
        louvainCommunity.calcCommunity(0.5);
        louvainCommunity.printCommunities(System.out, "", " | ");
    }

    public static void testGUIDirect(islandNetwork islandNetwork2) {
        islandNetwork2.outputMode.setAllOn();
        islandNetwork2.inputFile.setNameRoot("aegean39S1L3a");
        islandNetwork2.updateMode.setFromName("RW");
        islandNetwork2.betaInitial = 1.04;
        islandNetwork2.Hamiltonian.lambda = 1.0;
        islandNetwork2.Hamiltonian.distanceScale = 100.0;
        islandNetwork2.getSiteData();
        islandNetwork2.dataread = true;
        islandNetwork2.outputFile.setBasicRoot(islandNetwork2.inputFile.getBasicRoot());
        islandNetwork2.setOutputFileName();
        System.out.println("in TestAegean testGUIDirect before doMC");
        islandNetwork2.doRW();
        System.out.println("in TestAegean testGUIDirect before showNetwork");
        islandNetwork2.showNetwork("#", 3);
    }

    public static boolean testFileDecomposition() {
        FileLocation fileLocation = new FileLocation("dirroot/", "subdir/", "nameroot", "paramname", 29, "eee", "ext");
        String string = fileLocation.getFullLocationFileName();
        FileLocation fileLocation2 = new FileLocation(string);
        System.out.println(fileLocation2.getFullLocationFileName());
        return true;
    }

    public static void test5(islandNetwork islandNetwork2) {
        double d;
        double d2 = 0.35;
        double d3 = 0.65;
        int n = 10;
        int n2 = 5;
        islandNetwork2.DisplayMaxVertexScale = 1.0;
        islandNetwork2.edgeSet.DisplayMaxEdgeScale = 1.0;
        System.out.println("--- test5 routine: cooling MC, vertex and edge updates");
        islandNetwork2.showHamiltonianParameters();
        int n3 = 10;
        int n4 = n3 * islandNetwork2.numberSites;
        double d4 = 1000.0;
        double d5 = 1000000.0;
        double d6 = 2.0;
        double d7 = 0.0;
        int n5 = 0;
        long l = System.currentTimeMillis();
        for (d = d4; d <= d5; d *= d6) {
            int n6;
            islandNetwork2.vertexUR.reset();
            for (n6 = 0; n6 < n4; ++n6) {
                islandNetwork2.Hamiltonian.beta = d;
                islandNetwork2.vertexSweep();
            }
            if (islandNetwork2.getInformationLevel() > 1) {
                System.out.println("b=" + d + " : ");
            }
            islandNetwork2.edgeUR.reset();
            for (n6 = 0; n6 < n3; ++n6) {
                islandNetwork2.Hamiltonian.beta = d;
                islandNetwork2.edgeSweep();
            }
            if (++n5 % 10 == 0) {
                TestAegean.printEllapsedTime(l);
                System.out.println(" b=" + d + "\n  E: " + islandNetwork2.edgeUR.toString() + "\n  V: " + islandNetwork2.vertexUR.toString());
            } else {
                System.out.print(".");
            }
            if (islandNetwork2.vertexUR.getTotalFractionMade() < 0.001 && islandNetwork2.edgeUR.getTotalFractionMade() < 0.01) break;
        }
        System.out.println("\nFinal beta " + d);
        System.out.println("**********************************************");
        islandNetwork2.showNetworkStatistics("#", System.out, 3);
        islandNetwork2.edgeSet.minColourFrac = 0.0;
        System.out.println("Minimum Fraction for coloured edge = " + d3);
        islandNetwork2.calcNetworkStats();
        islandNetwork2.showColourValues("#", 3);
        System.out.println("  Edge stats: " + islandNetwork2.edgeUR.toString());
        System.out.println("Vertex stats: " + islandNetwork2.vertexUR.toString());
        islandNetwork2.edgeSet.doDijkstra(islandNetwork2.siteSet.getSiteArray(), islandNetwork2.Hamiltonian.shortDistanceScale);
        islandNetwork2.showDijkstraValues("#", 3);
        islandNetwork2.edgeSet.minColourFrac = 0.0;
        islandNetwork2.edgeSet.zeroColourFrac = 0.1;
        System.out.println("Scale for largest vertices in .net file= " + islandNetwork2.DisplayMaxVertexScale);
        System.out.println("Scale for maximum edges in .net file = " + islandNetwork2.edgeSet.DisplayMaxEdgeScale);
        System.out.println("Minimum Fraction for coloured edge in .net file = " + d3);
        islandNetwork2.calcNetworkStats();
        islandNetwork2.FileOutputNetwork("#", n, n2, d3, d2, 0);
        islandNetwork2.FileOutputNetwork("#", n, n2, d3, d2, 1);
        islandNetwork2.FileOutputNetwork("#", n, n2, d3, d2, 2);
        islandNetwork2.FileOutputBareNetwork("#");
        islandNetwork2.FileOutputNetworkStatistics("#", 3);
    }

    public static void test4(islandNetwork islandNetwork2) {
        double d = 0.1;
        double d2 = 0.5;
        int n = 10;
        int n2 = 10;
        System.out.println("--- test4 routine: cooling MC, vertex updates only");
        islandNetwork2.showHamiltonianParameters();
        int n3 = 1000;
        double d3 = 0.01;
        double d4 = 100000.0;
        double d5 = 1.2;
        double d6 = 0.0;
        for (double d7 = d3; d7 <= d4; d7 *= d5) {
            islandNetwork2.vertexUR.reset();
            for (int i = 0; i < n3; ++i) {
                islandNetwork2.Hamiltonian.beta = d7;
                islandNetwork2.vertexSweep();
            }
            if (islandNetwork2.getInformationLevel() > 1) {
                System.out.println("b=" + d7 + " : " + islandNetwork2.vertexUR.toString());
            }
            if (islandNetwork2.vertexUR.getTotalFractionMade() < 0.001) break;
        }
        System.out.println("**********************************************");
        islandNetwork2.showNetworkStatistics("#", System.out, 3);
        System.out.println("Minimum Fraction for coloured edge = " + d2);
        islandNetwork2.calcNetworkStats();
        islandNetwork2.showColourValues("#", 3);
        System.out.println(islandNetwork2.vertexUR.toString());
        d2 = 0.5;
        System.out.println("Minimum Fraction for coloured edge in .net file = " + d2);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 1);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 2);
    }

    public static void test3(islandNetwork islandNetwork2) {
        double d = 0.1;
        double d2 = 0.0;
        int n = 5;
        int n2 = 5;
        System.out.println("--- test3 routine: cooling MC, edge updates only");
        islandNetwork2.showHamiltonianParameters();
        int n3 = 100;
        double d3 = 0.01;
        double d4 = 100000.0;
        double d5 = 1.2;
        double d6 = 0.0;
        for (double d7 = d3; d7 <= d4; d7 *= d5) {
            islandNetwork2.edgeUR.reset();
            for (int i = 0; i < n3; ++i) {
                islandNetwork2.Hamiltonian.beta = d7;
                islandNetwork2.edgeSweep();
            }
            System.out.println("b=" + d7 + " : " + islandNetwork2.edgeUR.toString());
            if (islandNetwork2.edgeUR.getTotalFractionMade() < 0.01) break;
        }
        System.out.println("**********************************************");
        islandNetwork2.showNetworkStatistics("#", System.out, 3);
        islandNetwork2.edgeSet.minColourFrac = 0.0;
        d2 = 0.0;
        System.out.println("Minimum Fraction for coloured edge = " + d2);
        islandNetwork2.calcNetworkStats();
        islandNetwork2.showColourValues("#", 3);
        System.out.println(islandNetwork2.edgeUR.toString());
        d2 = 0.5;
        System.out.println("Minimum Fraction for coloured edge in .net file = " + d2);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 1);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 2);
    }

    public static void test2(islandNetwork islandNetwork2) {
        double d = 0.1;
        double d2 = 0.0;
        int n = 5;
        int n2 = 5;
        islandNetwork2.showHamiltonianParameters();
        int n3 = 100;
        for (int i = 0; i < n3; ++i) {
            islandNetwork2.edgeSweep();
        }
        System.out.println("Finished " + n3 + " edge sweeps ");
        islandNetwork2.showNetworkStatistics("#", System.out, 3);
        System.out.println(islandNetwork2.edgeUR.toString());
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 1);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 2);
    }

    public static void testPPA(islandNetwork islandNetwork2) {
        double d = 0.1;
        double d2 = 0.0;
        int n = 5;
        int n2 = 5;
        System.out.println("Testing PPA mode");
        islandNetwork2.showHamiltonianParameters();
        islandNetwork2.doPPA();
        System.out.println("Finished PPA");
        islandNetwork2.edgeSet.doDijkstra(islandNetwork2.siteSet.getSiteArray(), islandNetwork2.Hamiltonian.shortDistanceScale);
        islandNetwork2.showDijkstraValues("#", 3);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 1);
        islandNetwork2.FileOutputNetwork("#", n, n2, d2, d, 2);
    }

    public static void testDijkstra(islandNetwork islandNetwork2) {
        System.out.println("Testing Dijkstra");
        islandNetwork2.doPPA();
        islandNetwork2.edgeSet.doDijkstra(islandNetwork2.siteSet.getSiteArray(), islandNetwork2.Hamiltonian.shortDistanceScale);
        islandNetwork2.showDijkstraValues("#", 3);
    }

    public static void testModel4(islandNetwork islandNetwork2) {
        islandNetwork2.setEdgesTest1();
        int n = 0;
        int n2 = 5;
        double d = islandNetwork2.deltaEdgeHamiltonian(n, n2, 1.0);
        System.out.println("i,j,dH = " + n + " , " + n2 + " , " + d);
    }

    public static void test1(islandNetwork islandNetwork2) {
    }

    public static void printEllapsedTime(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        long l4 = l3 % 1000L;
        long l5 = (l3 /= 1000L) % 60L;
        long l6 = (l3 /= 60L) % 60L;
        long l7 = (l3 /= 60L) % 24L;
        long l8 = l3 / 24L;
        if (l8 > 0L) {
            System.out.print(l8 + " day");
        }
        if (l8 > 1L) {
            System.out.print("s ");
        }
        if (l7 > 0L) {
            System.out.print(l7 + " hour");
        }
        if (l7 > 1L) {
            System.out.print("s ");
        }
        if (l6 > 0L) {
            System.out.print(l6 + " minute");
        }
        if (l6 > 1L) {
            System.out.print("s ");
        }
        System.out.print(l5 + " sec");
        if (l5 > 1L) {
            System.out.print("s ");
        }
        System.out.println();
    }
}

