/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.SiteWindowMode;
import IslandNetworks.Vertex.IslandSiteSet;
import IslandNetworks.islandNetwork;
import TimUtilities.NumbersToString;
import TimUtilities.TimMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SitePanel
extends JPanel {
    final String inputFileNameRoot;
    static int smallC = 90;
    static int largeC = 210;
    static Color WEIGHTCOLOR = new Color(largeC, smallC, smallC);
    static Color RANKCOLOR = new Color(smallC, smallC, largeC);
    static Color INFLCOLOR = new Color(smallC, largeC, smallC);
    static NumbersToString n2s = new NumbersToString(3);
    int windowSize = 500;
    TimMessage message = new TimMessage(-2);
    IslandSiteSet siteSet;
    int numberSites;
    SiteWindowMode siteWindowMode;
    JCheckBox weightCB;
    JCheckBox rankCB;
    JCheckBox inflCB;

    public SitePanel(islandNetwork islandNetwork2) {
        this.inputFileNameRoot = islandNetwork2.inputFile.getNameRoot();
        this.numberSites = islandNetwork2.numberSites;
        this.siteSet = islandNetwork2.siteSet;
        this.siteWindowMode = islandNetwork2.siteWindowMode;
        this.message.println(2, "Finished SiteWindow constructor");
    }

    public Component createComponents() {
        SitePicture sitePicture = new SitePicture(this.windowSize);
        sitePicture.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JScrollPane jScrollPane = new JScrollPane(sitePicture, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = this.sitePanelControl();
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private JPanel sitePanelControl() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(100, 200));
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel2.add(new JLabel("Key (On?)", 0));
        this.weightCB = new JCheckBox("Weight", true);
        this.weightCB.setForeground(WEIGHTCOLOR);
        this.weightCB.setToolTipText("Weight Values Displayed");
        jPanel2.add(this.weightCB);
        this.rankCB = new JCheckBox("Rank", true);
        this.rankCB.setForeground(RANKCOLOR);
        this.rankCB.setToolTipText("Weight Values Displayed");
        jPanel2.add(this.rankCB);
        this.inflCB = new JCheckBox("Influence", false);
        this.inflCB.setForeground(INFLCOLOR);
        this.inflCB.setToolTipText("Weight Values Displayed");
        jPanel2.add(this.inflCB);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setToolTipText("Choose Order of Sites");
        for (int i = 0; i < SiteWindowMode.numberTypes; ++i) {
            jComboBox.addItem(this.siteWindowMode.getString(i));
        }
        jComboBox.setSelectedIndex(this.siteWindowMode.value);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SitePanel.this.siteWindowMode.value = jComboBox.getSelectedIndex();
            }
        });
        jPanel.add(jPanel2);
        jPanel.add(jComboBox);
        return jPanel;
    }

    public class SitePicture
    extends JPanel {
        double windowScale;

        public SitePicture() {
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(400, 40 * SitePanel.this.numberSites));
        }

        public SitePicture(int n) {
            this.setOpaque(true);
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(n, 40 * SitePanel.this.numberSites));
        }

        public void init() {
            this.setSize(new Dimension(800, 400));
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            super.paintComponent(graphics2D);
            int n = 50;
            double d = SitePanel.this.numberSites;
            Dimension dimension = this.getSize();
            int n2 = dimension.width / 5;
            double d2 = (double)(dimension.height - n - n) / d;
            double d3 = (double)(dimension.width - n - n - n2) / SitePanel.this.siteSet.siteWeightStats.maximum;
            double d4 = (double)(dimension.width - n - n - n2) / SitePanel.this.siteSet.siteInfluenceStats.maximum;
            double d5 = (double)(dimension.width - n - n - n2) / SitePanel.this.siteSet.siteRankStats.maximum;
            SitePanel.this.message.println(2, "Site Window scales " + d2 + "," + d3 + "," + d5 + ", window = " + dimension.width + "," + dimension.height);
            SitePanel.this.message.println(2, " max site weight =" + SitePanel.this.siteSet.siteWeightStats.maximum + " max site rank=" + SitePanel.this.siteSet.siteRankStats.maximum);
            Font font = graphics2D.getFont();
            SitePanel.this.message.println(2, "Site Window Mode " + SitePanel.this.siteWindowMode.getCurrentTypeString() + ", font " + font.getName() + " " + font.getSize() + " " + font.getStyle());
            double d6 = 0.0;
            if (SitePanel.this.weightCB.isSelected()) {
                d6 += 1.0;
            }
            if (SitePanel.this.rankCB.isSelected()) {
                d6 += 1.0;
            }
            if (SitePanel.this.inflCB.isSelected()) {
                d6 += 1.0;
            }
            if (d6 < 1.0) {
                d6 = 1.0;
            }
            int n3 = (int)(d2 / d6) - 2;
            for (int i = 0; i < SitePanel.this.numberSites; ++i) {
                String string;
                int n4;
                int n5 = i;
                switch (SitePanel.this.siteWindowMode.value) {
                    case 5: {
                        n5 = SitePanel.this.siteSet.siteInfluenceOrder[i];
                        break;
                    }
                    case 4: {
                        n5 = SitePanel.this.siteSet.siteRankOverWeightOrder[i];
                        break;
                    }
                    case 3: {
                        n5 = SitePanel.this.siteSet.siteAlphabeticalOrder[i];
                        break;
                    }
                    case 2: {
                        n5 = SitePanel.this.siteSet.siteRankOrder[i];
                        break;
                    }
                    case 1: {
                        n5 = SitePanel.this.siteSet.siteWeightOrder[i];
                        break;
                    }
                    default: {
                        n5 = i;
                    }
                }
                if (n3 < 1) {
                    n3 = 1;
                }
                int n6 = n + (int)((double)i * d2) + 1;
                int n7 = n + n2;
                int n8 = n3;
                if (SitePanel.this.weightCB.isSelected()) {
                    n4 = (int)(d3 * SitePanel.this.siteSet.getWeight(n5));
                    graphics2D.setColor(WEIGHTCOLOR);
                    graphics2D.fill(new Rectangle2D.Double(n7, n6, n4, n8));
                    string = String.format("%6.3f", SitePanel.this.siteSet.getWeight(n5));
                    graphics2D.drawString(string, n7 + n4, n6 + n3 / 2);
                    SitePanel.this.message.println(2, "Site " + n5 + " Rank " + SitePanel.this.siteSet.getRanking(n5) + ", Rank rank " + SitePanel.this.siteSet.getRankingRank(n5));
                    SitePanel.this.message.println(2, "Site " + n5 + " at (" + n7 + "," + n6 + ") width " + n4 + ", height " + n8 + " ");
                }
                if (SitePanel.this.rankCB.isSelected()) {
                    n4 = (int)(d5 * SitePanel.this.siteSet.getRanking(n5));
                    graphics2D.setColor(RANKCOLOR);
                    graphics2D.fill(new Rectangle2D.Double(n7, n6 += n3, n4, n8));
                    string = String.format("%6.3f", SitePanel.this.siteSet.getRanking(n5));
                    graphics2D.drawString(string, n7 + n4, n6 + n3 / 2);
                    SitePanel.this.message.println(2, "Site " + n5 + "=" + " at (" + n7 + "," + n6 + ") width " + n4 + ", height " + n8 + " ");
                }
                if (SitePanel.this.inflCB.isSelected()) {
                    n4 = (int)(d4 * SitePanel.this.siteSet.getTotalInfluenceWeight(n5));
                    graphics2D.setColor(INFLCOLOR);
                    SitePanel.this.message.println(2, "Site " + n5 + "=" + " at (" + n7 + "," + (n6 += n3) + ") width " + n4 + ", height " + n8 + " ");
                    graphics2D.fill(new Rectangle2D.Double(n7, n6, n4, n8));
                    string = String.format("%6.3f", SitePanel.this.siteSet.getTotalInfluenceWeight(n5));
                    graphics2D.drawString(string, n7 + n4, n6 + n3 / 2);
                }
                graphics2D.setColor(Color.black);
                graphics2D.drawString(String.format("%12s [%4.2f]", SitePanel.this.siteSet.getName(n5), SitePanel.this.siteSet.getSize(n5)), n + 50, n6 + n3);
                if (!SitePanel.this.siteSet.isRegionSet()) continue;
                graphics2D.setColor(Color.black);
                string = SitePanel.this.siteSet.getRegion(n5);
                if (string.length() > 5) {
                    string = string.substring(0, 5);
                }
                graphics2D.drawString(" (" + string + ")", n, n6 + n3);
            }
        }
    }
}

