/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import java.io.PrintStream;

public class OutputMode {
    static final int UNIQUENAME = 3;
    private int number = 0;
    public static final String[] name = new String[]{"info", "pajek", "elist", "ematrix", "gsep", "anf", "KML"};
    static final String[] longName = new String[]{"general information", "pajek files", "edges as vector", "edges as matrix", "gene separation", "ariadne network file", "Google Earth KML network file"};
    static final int KMLIndex = OutputMode.getIndex("KML");
    static final int PajekIndex = OutputMode.getIndex("pajek");
    static final int EdgeListIndex = OutputMode.getIndex("elist");
    static final int EdgeMatrixIndex = OutputMode.getIndex("ematrix");
    static final int InfoIndex = OutputMode.getIndex("info");
    static final int GeneSeparationIndex = OutputMode.getIndex("gsep");
    static final int AriadneNetworkFileIndex = OutputMode.getIndex("anf");
    private int[] bit = new int[name.length];

    public OutputMode() {
        this.setUp(0);
    }

    public OutputMode(int n) {
        this.setUp(n);
    }

    public OutputMode(OutputMode outputMode) {
        this.setUp(outputMode.number);
    }

    private void setUp(int n) {
        this.bit[0] = 1;
        for (int i = 1; i < name.length; ++i) {
            this.bit[i] = this.bit[i - 1] << 1;
        }
        this.set(n);
    }

    public void set(double d) {
        this.set(Math.round(d));
    }

    public void set(int n) {
        this.number = n;
    }

    public void set(String string) {
        this.set(Double.parseDouble(string));
    }

    public void setAllOn() {
        this.number = (1 << name.length) - 1;
    }

    public void setAllOff() {
        this.number = 0;
    }

    public void setModeOn(String string) {
        this.setModeOn(OutputMode.getIndex(string));
    }

    public void setModeOn(int n) {
        if (this.testModeNumber(n)) {
            this.number |= this.bit[n];
        }
    }

    public void setModeOff(String string) {
        this.setModeOff(OutputMode.getIndex(string));
    }

    public void setModeOff(int n) {
        if (this.testModeNumber(n)) {
            this.number -= this.number & this.bit[n];
        }
    }

    private boolean testModeNumber(int n) {
        return n >= 0 && n < name.length;
    }

    public boolean isSet(int n) {
        if (n < 0 || n >= name.length) {
            return false;
        }
        return (this.bit[n] & this.number) > 0;
    }

    public int getNumber() {
        return this.number;
    }

    public static int getIndex(String string) {
        String string2 = string.substring(0, 3);
        for (int i = 0; i < name.length; ++i) {
            if (!name[i].startsWith(string2)) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream printStream, String string) {
        printStream.println(string + " Output mode is " + this.getNumber());
    }

    public String toString(String string) {
        String string2 = "";
        for (int i = 0; i < name.length; ++i) {
            if (!this.isSet(i)) continue;
            string2 = string2 + name[i] + string;
        }
        return string2;
    }

    public void listAll(PrintStream printStream, String string, String string2) {
        for (int i = 0; i < name.length; ++i) {
            printStream.println(string + this.bit[i] + string2 + longName[i] + " (" + name[i] + ")");
        }
    }

    public String longString(int n) {
        return longName[n];
    }
}

