/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.AriadneIcon;
import IslandNetworks.ClusteringWindow;
import IslandNetworks.InputParameterFrame;
import IslandNetworks.IslandParameterWindow;
import IslandNetworks.OutputMode;
import IslandNetworks.SitePanel;
import IslandNetworks.islandNetwork;
import IslandNetworks.licence;
import TimUtilities.FileUtilities.FileUtilities;
import TimUtilities.FileUtilities.GeneralExtensionFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class NetworkWindow {
    private final String CLUSTERBUTTONTYPE = "CB_";
    private final String LAYOUTBUTTONTYPE = "LB_";
    private final String ARIADNENETWORKFILEEXTENSION = "anf";
    FileUtilities fileUtilities = new FileUtilities();
    JFrame frame;
    islandNetwork islnet;
    Dimension windowSize = new Dimension(900, 700);

    public NetworkWindow(islandNetwork islandNetwork2) {
        this.islnet = new islandNetwork(islandNetwork2);
        this.islnet.message.println(2, "Finished NetworkWindow constructor, root of file names " + this.islnet.inputFile.getNameRoot());
    }

    public void drawNetworkWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NetworkWindow.this.createAndShowNetWin();
            }
        });
    }

    private void createAndShowNetWin() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.islnet.message.println(0, " Ariadne Network Display " + this.windowSize);
        Calendar calendar = Calendar.getInstance();
        String string = calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13) + "." + calendar.get(14);
        this.frame = new JFrame("Network " + this.islnet.getNameString(" ") + " " + string);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setIconImage(new AriadneIcon().getPotGreen16());
        this.frame.setSize(new Dimension(this.islnet.visualisationWidth, this.islnet.visualisationHeight));
        this.frame.setJMenuBar(this.createMenuBar());
        JTabbedPane jTabbedPane = new JTabbedPane();
        ClusteringWindow clusteringWindow = new ClusteringWindow(this.islnet, this.frame.getSize());
        jTabbedPane.addTab("Network", NetworkWindow.createImageIcon("images/network.gif"), clusteringWindow, "Shows Network");
        jTabbedPane.setSelectedIndex(0);
        SitePanel sitePanel = new SitePanel(this.islnet);
        jTabbedPane.addTab("Sites", NetworkWindow.createImageIcon("images/rsplat.gif"), sitePanel.createComponents(), "Shows Site Information");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        IslandParameterWindow islandParameterWindow = new IslandParameterWindow(this.islnet);
        jPanel.add(islandParameterWindow.getBasicSettingsPanel());
        jPanel.add(islandParameterWindow.getInputVariablesPanel());
        jPanel.add(islandParameterWindow.getOutputMeasuresPanel(3));
        jTabbedPane.addTab("Parameters", NetworkWindow.createImageIcon("images/ysplat.gif"), jPanel, "Shows Parameters");
        this.frame.getContentPane().add(jTabbedPane);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        MenuListener menuListener = new MenuListener();
        OutputCheckBoxMenuListener outputCheckBoxMenuListener = new OutputCheckBoxMenuListener();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.getAccessibleContext().setAccessibleDescription("Manipulate the network File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open", 79);
        jMenuItem.getAccessibleContext().setAccessibleDescription("Opens a Network File");
        jMenuItem.addActionListener(menuListener);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next", 78);
        jMenuItem2.getAccessibleContext().setAccessibleDescription("Gets next network file in sequence");
        jMenuItem2.addActionListener(menuListener);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JCheckBoxMenuItem[] jCheckBoxMenuItemArray = new JCheckBoxMenuItem[OutputMode.name.length];
        for (int i = 0; i < OutputMode.name.length; ++i) {
            jCheckBoxMenuItemArray[i] = new JCheckBoxMenuItem(OutputMode.name[i], this.islnet.outputMode.isSet(i));
            jCheckBoxMenuItemArray[i].setToolTipText(OutputMode.longName[i]);
            jCheckBoxMenuItemArray[i].addActionListener(outputCheckBoxMenuListener);
            jMenu.add(jCheckBoxMenuItemArray[i]);
        }
        JMenu jMenu2 = new JMenu("Network View");
        jMenu2.getAccessibleContext().setAccessibleDescription("The only menu in this program that has menu items");
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem3 = new JMenuItem("A text-only menu item");
        jMenuItem3.getAccessibleContext().setAccessibleDescription("This doesn't really do anything");
        jMenu2.add(jMenuItem3);
        ImageIcon imageIcon = NetworkWindow.createImageIcon("images/middle.gif");
        jMenuItem3 = new JMenuItem("Both text and icon", imageIcon);
        jMenuItem3.setMnemonic(66);
        jMenu2.add(jMenuItem3);
        jMenuItem3 = new JMenuItem(imageIcon);
        jMenuItem3.setMnemonic(68);
        jMenu2.add(jMenuItem3);
        jMenu2.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("A radio button menu item");
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.setMnemonic(82);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Another one");
        jRadioButtonMenuItem.setMnemonic(79);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jMenu2.addSeparator();
        JMenu jMenu3 = new JMenu("A submenu");
        jMenuItem3 = new JMenuItem("An item in the submenu");
        jMenu3.add(jMenuItem3);
        jMenuItem3 = new JMenuItem("Another item");
        jMenu3.add(jMenuItem3);
        jMenu2.add(jMenu3);
        jMenu2 = new JMenu("Another Menu");
        jMenu2.getAccessibleContext().setAccessibleDescription("This menu does nothing");
        jMenuBar.add(jMenu2);
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic(72);
        jMenu4.getAccessibleContext().setAccessibleDescription("Help on Ariadne");
        jMenuBar.add(jMenu4);
        JMenuItem jMenuItem4 = new JMenuItem("About", 65);
        jMenuItem4.getAccessibleContext().setAccessibleDescription("About Ariadne");
        jMenuItem4.addActionListener(menuListener);
        jMenu4.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Help", 72);
        jMenuItem5.getAccessibleContext().setAccessibleDescription("Help for Ariadne");
        jMenuItem5.addActionListener(menuListener);
        jMenu4.add(jMenuItem5);
        return jMenuBar;
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = NetworkWindow.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    class MenuListener
    implements ActionListener {
        MenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object;
                String string = actionEvent.getActionCommand();
                if (string.equals("Open")) {
                    object = new JFileChooser(".");
                    ((JFileChooser)object).addChoosableFileFilter(new GeneralExtensionFilter("anf"));
                    ((JFileChooser)object).setAcceptAllFileFilterUsed(false);
                    ((JFileChooser)object).setDialogTitle("Open Ariadne Network File");
                    int n = ((JFileChooser)object).showOpenDialog(NetworkWindow.this.frame);
                    if (n == 0) {
                        File file = ((JFileChooser)object).getSelectedFile();
                        NetworkWindow.this.islnet = new islandNetwork(file, NetworkWindow.this.islnet);
                        NetworkWindow.this.islnet.calcNetworkStats();
                        NetworkWindow.this.createAndShowNetWin();
                    }
                }
                if (string.equals("Next")) {
                    NetworkWindow.this.islnet.outputFile.setNextExistingSequenceNumber();
                    NetworkWindow.this.islnet = new islandNetwork(NetworkWindow.this.islnet.outputFile.getFullLocationFile(), NetworkWindow.this.islnet);
                    NetworkWindow.this.islnet.calcNetworkStats();
                    NetworkWindow.this.createAndShowNetWin();
                }
                if (string.equals("New")) {
                    object = new islandNetwork(NetworkWindow.this.islnet);
                    InputParameterFrame inputParameterFrame = new InputParameterFrame((islandNetwork)object);
                }
                if (string.equals("About")) {
                    licence.showCiteMessageDialog(NetworkWindow.this.frame);
                }
                if (string.equals("Help")) {
                    JOptionPane.showMessageDialog(NetworkWindow.this.frame, "<html>Look in the <tt>ariadne/docs</tt> folder.</html>", "Help", 1);
                }
            }
            catch (Exception exception) {
                String string = "Ariadne Error: " + actionEvent;
                JOptionPane.showMessageDialog(NetworkWindow.this.frame, string, "Open File Error", 0);
            }
        }
    }

    class OutputCheckBoxMenuListener
    implements ActionListener {
        OutputCheckBoxMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = actionEvent.getActionCommand();
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    NetworkWindow.this.islnet.outputMode.setModeOn(string);
                } else {
                    NetworkWindow.this.islnet.outputMode.setModeOff(string);
                }
            }
            catch (Exception exception) {
                String string = "Ariadne Error in OutputCheckBoxMenuListener of NetworkWindow: " + actionEvent;
                JOptionPane.showMessageDialog(NetworkWindow.this.frame, string, " some sort of error", 0);
            }
        }
    }
}

