/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class NetworkGenerator {
    String SEP = "\t";
    String dirname = "/PRG/networks/aegean/output/";
    String nameroot = "test";
    int NUMBERTYPES = 5;
    int numberSites;
    double scale;
    double[] Xpos;
    double[] Ypos;
    double[][] dist;
    String[] name;
    String[] shortname;
    int networkType = 0;
    double sizex = 1.0;
    double sizey = 1.0;

    public NetworkGenerator() {
    }

    public NetworkGenerator(islandNetwork islandNetwork2) {
        this.create(islandNetwork2.generateType, islandNetwork2.generateNumber, islandNetwork2.Hamiltonian.distanceScale);
    }

    public NetworkGenerator(int n, int n2, double d) {
        this.create(n, n2, d);
    }

    public void create(int n, int n2, double d) {
        this.networkType = n;
        this.scale = d;
        System.out.println("Generating type " + this.networkName() + ", number of sites " + n2 + ", nearest neighbour distance " + this.scale);
        switch (this.networkType) {
            case 4: {
                this.makeCircleSiteData(n2, this.scale);
                break;
            }
            case 2: 
            case 3: {
                this.makeLineSiteData(n2, this.scale);
                break;
            }
            default: {
                this.makeLatticeSiteData(n2, n2, this.scale);
            }
        }
        this.calcDistanceData();
    }

    public void makeLatticeSiteData(int n, int n2, double d) {
        this.sizex = d * (double)n;
        this.sizey = d * (double)n2;
        int n3 = n * n2;
        this.Xpos = new double[n3];
        this.Ypos = new double[n3];
        this.name = new String[n3];
        this.shortname = new String[n3];
        this.nameroot = this.networkName() + "_" + n + "_" + n2 + "_" + this.TruncDec(d, 2) + "_";
        this.numberSites = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.name[this.numberSites] = "(" + i + "," + j + ")";
                this.shortname[this.numberSites] = Integer.toString(i * n2 + j);
                this.Xpos[this.numberSites] = (double)i * d;
                this.Ypos[this.numberSites] = (double)j * d;
                ++this.numberSites;
            }
        }
    }

    public void makeLineSiteData(int n, double d) {
        this.sizex = d * (double)n;
        int n2 = n;
        this.Xpos = new double[n2];
        this.Ypos = new double[n2];
        this.name = new String[n2];
        this.shortname = new String[n2];
        this.nameroot = this.networkName() + "_" + n + "_" + this.TruncDec(d, 2) + "_";
        this.numberSites = 0;
        for (int i = 0; i < n; ++i) {
            this.name[this.numberSites] = "(" + i + ")";
            this.shortname[this.numberSites] = Integer.toString(i);
            this.Xpos[this.numberSites] = (double)i * d;
            this.Ypos[this.numberSites] = d / 2.0;
            ++this.numberSites;
        }
    }

    public void makeCircleSiteData(int n, double d) {
        int n2 = n;
        this.Xpos = new double[n2];
        this.Ypos = new double[n2];
        this.name = new String[n2];
        this.shortname = new String[n2];
        double d2 = Math.PI * 2 / (double)n;
        double d3 = d / Math.tan(d2 / 2.0);
        this.nameroot = this.networkName() + "_" + n + "_" + this.TruncDec(d, 2);
        this.numberSites = 0;
        for (int i = 0; i < n; ++i) {
            this.name[this.numberSites] = "(" + i + ")";
            this.shortname[this.numberSites] = Integer.toString(i);
            this.Xpos[this.numberSites] = d3 * Math.sin(d2 * (double)i);
            this.Ypos[this.numberSites] = d3 * Math.cos(d2 * (double)i);
            ++this.numberSites;
        }
    }

    public void calcDistanceData() {
        this.dist = new double[this.numberSites][this.numberSites];
        for (int i = 0; i < this.numberSites; ++i) {
            block4: for (int j = 0; j < this.numberSites; ++j) {
                switch (this.networkType) {
                    case 1: 
                    case 3: {
                        this.dist[i][j] = this.torusDistance(this.Xpos[i], this.Ypos[i], this.Xpos[j], this.Ypos[j]);
                        continue block4;
                    }
                    default: {
                        this.dist[i][j] = this.euclideanDistance(this.Xpos[i], this.Ypos[i], this.Xpos[j], this.Ypos[j]);
                    }
                }
            }
        }
    }

    public double euclideanDistance(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public double torusDistance(double d, double d2, double d3, double d4) {
        double d5 = Math.min(Math.abs(d - d3), this.sizex - Math.abs(d - d3));
        double d6 = Math.min(Math.abs(d2 - d4), this.sizey - Math.abs(d2 - d4));
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public void FileOutputSite(int n) {
        String string = "# ";
        String string2 = this.dirname + this.nameroot + "_input.dat";
        System.out.println("Attempting to write general information to " + string2);
        try {
            int n2;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("# " + this.SEP + this.networkName() + this.SEP + "Scale" + this.SEP + this.scale);
            printStream.print("Name");
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(this.SEP + this.name[n2]);
            }
            printStream.println();
            printStream.print("ShortName");
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(this.SEP + this.shortname[n2]);
            }
            printStream.println();
            printStream.print("Size");
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(this.SEP + "1");
            }
            printStream.println();
            printStream.print("XPos");
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(this.SEP + this.Xpos[n2]);
            }
            printStream.println();
            printStream.print("YPos");
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(this.SEP + this.Ypos[n2]);
            }
            printStream.println();
            printStream.println("*Distances");
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                printStream.print(this.name[n2]);
                for (int i = 0; i < this.numberSites; ++i) {
                    printStream.print(this.SEP + this.dist[n2][i]);
                }
                printStream.println();
            }
            try {
                fileOutputStream.close();
                System.out.println("Finished writing to " + string2);
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string2);
            return;
        }
    }

    public String networkName() {
        return this.networkName(this.networkType);
    }

    public String networkName(int n) {
        String string = "Unknown";
        switch (n) {
            case 4: {
                string = "circle";
                break;
            }
            case 3: {
                string = "torus1D";
                break;
            }
            case 2: {
                string = "line";
                break;
            }
            case 1: {
                string = "torus2D";
                break;
            }
            default: {
                string = "lattice";
            }
        }
        return string;
    }

    public double TruncDec(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)((int)(d * d2 + 0.5)) / d2;
    }
}

