/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.ClusteringWindow;
import IslandNetworks.Edge.IslandEdge;
import IslandNetworks.io.FileLocation;
import IslandNetworks.islandNetwork;
import JavaNotes.TextReader;
import TimUtilities.Range;
import TimUtilities.StatisticalQuantity;
import TimUtilities.TimTime;
import TimUtilities.TimTiming;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class MultipleAnalysis {
    static String MAVERSION = "MA080429";
    static String SEP = "\t";
    static int NRUNS = 100;
    int nentries;
    int noprentries;
    static int nfixedparameters = 5;
    static int nsingleouputparameters = 1;
    final int noutputvariables;
    static int[] metricList = new int[]{1, 2, 3, 4};
    String endingMAStats;
    double[][] results;
    String firstLine = "";
    String[] parameterString = new String[100];
    int nargs = 0;
    Range j;
    Range mu;
    Range kappa;
    Range lambda;
    Range distScale;
    int repeat;
    int runOffset;
    boolean fileOutputStatisticsStarted = false;

    public MultipleAnalysis() {
        islandNetwork islandNetwork2 = new islandNetwork(1);
        this.noutputvariables = 5 + metricList.length;
        this.j = new Range(islandNetwork2.Hamiltonian.vertexSource);
        this.mu = new Range(islandNetwork2.Hamiltonian.edgeSource);
        this.kappa = new Range(islandNetwork2.Hamiltonian.kappa);
        this.lambda = new Range(islandNetwork2.Hamiltonian.lambda);
        this.distScale = new Range(islandNetwork2.Hamiltonian.distanceScale);
        this.repeat = 1;
        this.runOffset = islandNetwork2.outputFile.sequenceNumber;
        this.noprentries = nfixedparameters + nsingleouputparameters + 4 * this.noutputvariables;
        this.nentries = nfixedparameters + 5 * (nsingleouputparameters + this.noutputvariables);
        TimTime timTime = new TimTime("_");
        this.endingMAStats = "_MAstats" + timTime.fullString("_");
        this.fileOutputStatisticsStarted = false;
    }

    public static void main(String[] stringArray) {
        islandNetwork islandNetwork2 = new islandNetwork(1);
        islandNetwork2.inputFile.setNameRoot("aegean39S1L3a");
        islandNetwork2.outputFile.setNameRoot("aegean39S1L3a");
        islandNetwork2.outputMode.setAllOff();
        int n = islandNetwork2.Parse(stringArray);
        if (n > 0) {
            System.out.println("Command line argument failure - return code " + n);
            return;
        }
        n = islandNetwork2.getSiteData();
        System.out.println("Data reading OK, number of sites is " + islandNetwork2.numberSites);
        islandNetwork2.setInfomationLevel(-1);
        MultipleAnalysis multipleAnalysis = new MultipleAnalysis();
        multipleAnalysis.readVariableRanges(islandNetwork2.inputFile.getFullLocationFileRoot());
        islandNetwork2.outputFile.setParameterName("v" + islandNetwork2.modelNumber.major + "_" + islandNetwork2.modelNumber.minor);
        multipleAnalysis.calcRange(islandNetwork2);
    }

    public void calcRange(islandNetwork islandNetwork2) {
        int n;
        System.out.println("\n###  Multiple Analysis version " + MAVERSION + " using islandNetwork " + "iN110401");
        if (this.nargs > 0) {
            String[] stringArray = new String[this.nargs];
            for (n = 0; n < this.nargs; ++n) {
                stringArray[n] = this.parameterString[n];
            }
            if (islandNetwork2.Parse(stringArray) != 0) {
                System.out.println("\n***  Error in parameter parsing");
                return;
            }
        }
        this.runOffset = islandNetwork2.outputFile.sequenceNumber;
        System.out.println(" Using  " + nfixedparameters + " fixed parameters, " + this.noutputvariables + " output variables");
        int n2 = this.j.count() * this.mu.count() * this.kappa.count() * this.lambda.count() * this.distScale.count() + 1;
        System.out.println(" Doing " + n2 + " different data sets, each repeated " + this.repeat + " times");
        System.out.println("Variable" + SEP + "min" + SEP + "max" + SEP + "step" + SEP + "value" + SEP + "Type" + SEP + "count");
        System.out.println("j" + SEP + this.j.toString(SEP));
        System.out.println("mu" + SEP + this.mu.toString(SEP));
        System.out.println("kappa" + SEP + this.kappa.toString(SEP));
        System.out.println("lambda" + SEP + this.lambda.toString(SEP));
        System.out.println("distance scale" + SEP + this.distScale.toString(SEP));
        this.results = new double[NRUNS][this.nentries];
        int n3 = 0;
        n = 0;
        this.setLabelLine();
        islandNetwork2.autoSetOutputFileName = true;
        TimTiming timTiming = new TimTiming();
        this.j.value = this.j.min;
        while (this.j.value <= this.j.max) {
            islandNetwork2.Hamiltonian.vertexSource = this.j.value;
            this.mu.value = this.mu.min;
            while (this.mu.value <= this.mu.max) {
                islandNetwork2.Hamiltonian.edgeSource = this.mu.value;
                this.kappa.value = this.kappa.min;
                while (this.kappa.value <= this.kappa.max) {
                    islandNetwork2.Hamiltonian.kappa = this.kappa.value;
                    this.lambda.value = this.lambda.min;
                    while (this.lambda.value <= this.lambda.max) {
                        islandNetwork2.Hamiltonian.lambda = this.lambda.value;
                        this.distScale.value = this.distScale.min;
                        while (this.distScale.value <= this.distScale.max) {
                            islandNetwork2.Hamiltonian.distanceScale = this.distScale.value;
                            int n4 = n3 + n * NRUNS;
                            double d = ((double)n3 + (double)(n * NRUNS)) / (double)n2;
                            System.out.println("\n #####################################################");
                            System.out.println("--- Starting data set #" + n4 + ", fraction completed " + Math.round(d * 100.0) + "% , time remaining " + timTiming.estimateRemainingTimeString(d));
                            if (n3 >= NRUNS) {
                                this.j.value = this.j.max;
                                this.mu.value = this.mu.max;
                                this.kappa.value = this.kappa.max;
                                this.lambda.value = this.lambda.max;
                                this.distScale.value = this.distScale.max;
                                System.out.println(" Reached limit of number of runs");
                                break;
                            }
                            islandNetwork2.showHamiltonianParameters();
                            islandNetwork2.outputFile.setFirstFreeSequenceNumber(this.runOffset);
                            try {
                                double[] dArray = this.calcOneParameterSet(islandNetwork2, this.repeat);
                                for (int i = 0; i < dArray.length; ++i) {
                                    this.results[n3][i] = dArray[i];
                                }
                            }
                            catch (Exception exception) {
                                System.err.println("ERROR " + exception + SEP + " run number " + n3);
                            }
                            System.out.println("--- Finished data for data set #" + n3);
                            if (++n3 == NRUNS) {
                                this.FileOutputStatistics(islandNetwork2.outputFile, n3);
                                n3 = 0;
                                ++n;
                            }
                            this.distScale.nextValue();
                        }
                        this.lambda.nextValue();
                    }
                    this.kappa.nextValue();
                }
                this.mu.nextValue();
            }
            this.j.nextValue();
        }
        if (n3 % NRUNS != 0) {
            this.FileOutputStatistics(islandNetwork2.outputFile, n3);
        }
    }

    public String getLabelLine() {
        this.setLabelLine();
        return this.firstLine;
    }

    public void setLabelLine() {
        this.firstLine = "j" + SEP + "mu" + SEP + "kappa" + SEP + "lambda" + SEP + "dist.scale";
        this.firstLine = this.firstLine + this.variableLabel("En", SEP);
        this.firstLine = this.firstLine + this.variableLabel("SV", SEP);
        this.firstLine = this.firstLine + this.variableLabel("SW", SEP);
        this.firstLine = this.firstLine + this.variableLabel("SS", SEP);
        this.firstLine = this.firstLine + this.variableLabel("EV", SEP);
        this.firstLine = this.firstLine + this.variableLabel("EW", SEP);
        for (int i = 0; i < metricList.length; ++i) {
            this.firstLine = this.firstLine + this.variableLabel("D" + metricList[i], SEP);
        }
        this.firstLine = this.firstLine + SEP + "Version" + SEP + MAVERSION + "iN Version" + SEP + "iN110401";
    }

    public double[] calcOneParameterSet(islandNetwork islandNetwork2, int n) {
        int n2;
        int n3;
        double d = islandNetwork2.Hamiltonian.beta;
        StatisticalQuantity[] statisticalQuantityArray = new StatisticalQuantity[this.noprentries];
        for (n3 = 0; n3 < this.noprentries; ++n3) {
            statisticalQuantityArray[n3] = new StatisticalQuantity();
        }
        for (n3 = 0; n3 < n; ++n3) {
            System.out.println("--- Run #" + n3);
            islandNetwork2.Hamiltonian.beta = d;
            islandNetwork2.setOutputFileName();
            try {
                islandNetwork2.doMC();
                int n4 = 0;
                statisticalQuantityArray[n4++].add(islandNetwork2.Hamiltonian.vertexSource);
                statisticalQuantityArray[n4++].add(islandNetwork2.Hamiltonian.edgeSource);
                statisticalQuantityArray[n4++].add(islandNetwork2.Hamiltonian.kappa);
                statisticalQuantityArray[n4++].add(islandNetwork2.Hamiltonian.lambda);
                statisticalQuantityArray[n4++].add(islandNetwork2.Hamiltonian.distanceScale);
                if (n4 != nfixedparameters) {
                    System.out.println(" *** ERROR had " + n4 + " parameters when expected " + nfixedparameters);
                    return null;
                }
                statisticalQuantityArray[n4++].add(islandNetwork2.globalProperties.getEnergy());
                this.addToStatisticalQuantityArray(statisticalQuantityArray, n4, islandNetwork2.siteSet.siteValueStats);
                this.addToStatisticalQuantityArray(statisticalQuantityArray, n4, islandNetwork2.siteSet.siteWeightStats);
                this.addToStatisticalQuantityArray(statisticalQuantityArray, n4, islandNetwork2.siteSet.siteStrengthInStats);
                this.addToStatisticalQuantityArray(statisticalQuantityArray, n4, islandNetwork2.edgeSet.edgeStats[IslandEdge.valueINDEX]);
                this.addToStatisticalQuantityArray(statisticalQuantityArray, n4, islandNetwork2.edgeSet.edgeStats[IslandEdge.weightINDEX]);
                islandNetwork2.setEdgePotentials();
                for (n2 = 0; n2 < metricList.length; ++n2) {
                    islandNetwork2.edgeSet.metric.set(metricList[n2]);
                    islandNetwork2.calcNetworkSeparations();
                    this.addToStatisticalQuantityArray(statisticalQuantityArray, n4, islandNetwork2.siteDistanceStats);
                }
            }
            catch (Exception exception) {
                System.out.println("*** Problem with run " + n3 + " - exception " + exception);
            }
            try {
                if (n3 == 0) {
                    this.oneNetworkFileOutput(n3, islandNetwork2, true);
                    continue;
                }
                this.oneNetworkFileOutput(n3, islandNetwork2, false);
                continue;
            }
            catch (Exception exception) {
                System.out.println("*** Problem with general network file outputs, run " + n3 + " - exception " + exception);
            }
        }
        double[] dArray = new double[this.nentries];
        n3 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < nfixedparameters; ++n2) {
            try {
                dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("ERROR: " + n3 + " " + n5);
            }
        }
        dArray[n3++] = statisticalQuantityArray[n5].minimum;
        dArray[n3++] = statisticalQuantityArray[n5].maximum;
        dArray[n3++] = statisticalQuantityArray[n5].getAverage();
        dArray[n3++] = statisticalQuantityArray[n5].getError();
        dArray[n3++] = statisticalQuantityArray[n5++].getSigma();
        for (n2 = 1; n2 < 5; ++n2) {
            dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
            dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
            dArray[n3++] = statisticalQuantityArray[n5].getAverage();
            dArray[n3++] = statisticalQuantityArray[n5++].getError();
            dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
        }
        for (n2 = 0; n2 < metricList.length; ++n2) {
            islandNetwork2.edgeSet.metric.set(metricList[n2]);
            islandNetwork2.calcNetworkSeparations();
            dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
            dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
            dArray[n3++] = statisticalQuantityArray[n5].getAverage();
            dArray[n3++] = statisticalQuantityArray[n5++].getError();
            dArray[n3++] = statisticalQuantityArray[n5++].getAverage();
        }
        this.nentries = n3;
        return dArray;
    }

    private int addToStatisticalQuantityArray(StatisticalQuantity[] statisticalQuantityArray, int n, StatisticalQuantity statisticalQuantity) {
        statisticalQuantityArray[n++].add(statisticalQuantity.minimum);
        statisticalQuantityArray[n++].add(statisticalQuantity.maximum);
        statisticalQuantityArray[n++].add(statisticalQuantity.getAverage());
        statisticalQuantityArray[n++].add(statisticalQuantity.getSigma());
        return n;
    }

    public void FileOutputStatistics(FileLocation fileLocation, int n) {
        String string = fileLocation.getRootLocationSimpleFileName(this.endingMAStats, "dat");
        System.out.println("Attempting to write general information to " + string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, this.fileOutputStatisticsStarted);
            PrintStream printStream = new PrintStream(fileOutputStream);
            if (!this.fileOutputStatisticsStarted) {
                printStream.println(this.firstLine);
            }
            this.printStatistics(printStream, n);
            try {
                fileOutputStream.close();
                System.out.println("Finished writing to " + string);
            }
            catch (IOException iOException) {
                System.out.println("File Error" + iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string + "  Error" + fileNotFoundException);
            return;
        }
        this.fileOutputStatisticsStarted = true;
    }

    public void printStatistics(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.nentries; ++j) {
                printStream.print((float)this.results[i][j] + SEP);
            }
            printStream.println();
        }
    }

    public void printOneParameterStatistics(PrintStream printStream, String string, double[] dArray) {
        printStream.println(this.getLabelLine());
        for (int i = 0; i < dArray.length; ++i) {
            printStream.print((float)dArray[i] + string);
        }
        printStream.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readVariableRanges(String string) {
        TextReader textReader;
        String string2 = new String();
        string2 = string + "_maranges.dat";
        System.out.println("Starting to read ranges of parameters data from " + string2);
        String string3 = "";
        String string4 = "Unknown";
        int n = 0;
        double[] dArray = new double[100];
        try {
            textReader = new TextReader(new FileReader(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't find file " + string2);
            return 1;
        }
        try {
            while (!textReader.eof()) {
                ++n;
                string4 = textReader.getWord();
                if (string4.startsWith("#")) {
                    string3 = string4 + textReader.getln();
                    System.out.println("Comment: " + string3);
                    continue;
                }
                if (string4.startsWith("*param")) {
                    this.nargs = 0;
                    while (!textReader.eoln()) {
                        this.parameterString[this.nargs++] = textReader.getWord();
                    }
                    System.out.print("Parameter string: ");
                    for (int i = 0; i < this.nargs; ++i) {
                        System.out.print(SEP + this.parameterString[i]);
                    }
                    System.out.println();
                    continue;
                }
                if (string4.startsWith("*rep")) {
                    this.repeat = textReader.getlnInt();
                    System.out.println("Repeating " + this.repeat + " times");
                    continue;
                }
                Range range = new Range();
                range.min = textReader.getDouble();
                range.max = textReader.getDouble();
                range.step = textReader.getDouble();
                range.type = textReader.getInt();
                if (range.min > range.max || range.step < 0.0) {
                    double d = range.min;
                    range = new Range(d);
                }
                if (string4.startsWith("*j")) {
                    this.j = new Range(range);
                }
                if (string4.startsWith("*mu")) {
                    this.mu = new Range(range);
                }
                if (string4.startsWith("*kap")) {
                    this.kappa = new Range(range);
                }
                if (string4.startsWith("*lam")) {
                    this.lambda = new Range(range);
                }
                if (!string4.startsWith("*dist")) continue;
                this.distScale = new Range(range);
            }
            System.out.println("Finished reading from " + string2);
        }
        catch (TextReader.Error error) {
            System.out.println("Input Error: " + error.getMessage());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Too many numbers in data file" + string2);
            System.out.println("Processing has been aborted.");
        }
        finally {
            textReader.close();
        }
        return 0;
    }

    public void oneNetworkFileOutput(int n, islandNetwork islandNetwork2, boolean bl) {
        if (bl) {
            System.out.println("Attempting to write general information to " + islandNetwork2.outputFile.getNameRoot());
            islandNetwork2.FileOutputNetworkParam(SEP, n);
        }
        int n2 = 20;
        int n3 = 10;
        double d = 0.2;
        double d2 = 0.1;
        boolean bl2 = false;
        System.out.println("Attempting to write basic network to " + islandNetwork2.outputFile.getFullFileRoot());
        islandNetwork2.FileOutputNetworkForData("#", 5);
        islandNetwork2.FileOutputNetwork("#", n2, n3, d, d2, 0);
        String[] stringArray = new String[]{"Value", "Weight", "Ranking", "Strength", "StrengthIn", "StrengthOut"};
        for (int i = 0; i < stringArray.length; ++i) {
            islandNetwork2.FileOutputPajekSiteFiles(stringArray[i]);
        }
    }

    public void oneNetworkJpegOutput(int n, islandNetwork islandNetwork2) {
        ClusteringWindow clusteringWindow = new ClusteringWindow();
        clusteringWindow.initialiseClusteringWindow(islandNetwork2, 600);
        clusteringWindow.setUpPrintableView(600, 600);
        clusteringWindow.writeJPEGImage();
    }

    private String variableLabel(String string, String string2) {
        return string2 + string + " min" + string2 + string + " max" + string2 + string + " av" + string2 + string + " av +/-" + string2 + string + " sigma";
    }
}

