/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MonteCarloHistory {
    DoubleArrayList beta;
    DoubleArrayList energy;
    DoubleArrayList vupdates;
    DoubleArrayList eupdates;

    public MonteCarloHistory(int n) {
        this.beta = new DoubleArrayList(n);
        this.energy = new DoubleArrayList(n);
        this.vupdates = new DoubleArrayList(n);
        this.eupdates = new DoubleArrayList(n);
    }

    public void add(double d, double d2, double d3, double d4) {
        this.beta.add(d);
        this.energy.add(d2);
        this.vupdates.add(d3);
        this.eupdates.add(d4);
    }

    public void printTimeEvolution(PrintStream printStream, String string) {
        double d = this.getMax(this.energy);
        double d2 = this.getMax(this.vupdates);
        double d3 = this.getMax(this.eupdates);
        printStream.println("sweep" + string + "beta" + string + "energy" + string + "V.updates" + string + "E.updates" + string + "energy/max" + string + "V.up.frac" + string + "E.up.frac");
        for (int i = 0; i < this.beta.size(); ++i) {
            printStream.println(i + string + this.beta.getQuick(i) + string + this.energy.getQuick(i) + string + this.vupdates.getQuick(i) + string + this.eupdates.getQuick(i) + string + this.energy.getQuick(i) / d + string + this.vupdates.getQuick(i) / d2 + string + this.eupdates.getQuick(i) / d3);
        }
    }

    public double getMax(DoubleArrayList doubleArrayList) {
        double d = doubleArrayList.get(0);
        for (int i = 0; i < this.beta.size(); ++i) {
            if (!(d < doubleArrayList.get(i))) continue;
            d = doubleArrayList.get(i);
        }
        return d;
    }

    public int getMax(IntArrayList intArrayList) {
        int n = intArrayList.get(0);
        for (int i = 0; i < this.beta.size(); ++i) {
            if (n >= intArrayList.get(i)) continue;
            n = intArrayList.get(i);
        }
        return n;
    }

    public void FileOutputMonteCarloHistory(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintStream printStream = new PrintStream(fileOutputStream);
            this.printTimeEvolution(printStream, "\t");
            try {
                fileOutputStream.close();
                System.out.println("Finished writing to " + string);
            }
            catch (IOException iOException) {
                System.out.println("File Error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error opening output file " + string);
            return;
        }
    }
}

