/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

public class ModelNumber {
    double number;
    int major;
    int minor;
    String majorString;
    String minorString;
    boolean bit0;
    boolean bit1;
    boolean bit2;

    public ModelNumber() {
        this.set(5.2);
    }

    public ModelNumber(double d) {
        this.set(d);
    }

    public ModelNumber(ModelNumber modelNumber) {
        this.set(modelNumber.number);
    }

    public void set(double d) {
        this.number = d;
        this.major = (int)d;
        this.minor = (int)((d - (double)this.major) * 10.0 + 0.5);
        this.bit0 = (this.minor & 1) > 0;
        this.bit1 = (this.minor & 2) > 0;
        this.bit2 = (this.minor & 4) > 0;
        this.setMajorString();
        this.setMinorString();
    }

    public void set(double d, double d2) {
        this.set(d + d2 / 10.0);
    }

    public void set(String string) {
        this.set(Double.parseDouble(string));
    }

    public void setMajorString() {
        String string = "unknown";
        switch (this.major) {
            case 1: {
                string = "Standard Hamiltonian";
                break;
            }
            case 5: {
                string = "Standard Hamiltonian with power site term and separate land/sea populations";
                break;
            }
            case 6: {
                string = "Gravity Model";
                break;
            }
            default: {
                string = "*** Major Model number" + this.major + "NOT OPERATIONAL";
            }
        }
        this.majorString = string;
    }

    public void setMinorString() {
        String string = "unknown";
        switch (this.minor & 3) {
            case 0: {
                string = "no site terms in trade term";
                break;
            }
            case 1: {
                string = "Supply Side (source site in trade term)";
                break;
            }
            case 2: {
                string = "Demand Side (target site in trade term)";
                break;
            }
            case 3: {
                string = "Gravity (source and target site in trade term)";
            }
        }
        if (this.major == 3) {
            switch (this.minor & 4) {
                case 0: {
                    string = string + "physical distance used in potential";
                    break;
                }
                case 4: {
                    string = string + "edge potential used in potential";
                }
            }
        }
        this.minorString = string;
    }
}

