/*
 * Decompiled with CFR 0.152.
 */
package IslandNetworks;

import IslandNetworks.islandNetwork;
import TimUtilities.Permutation;
import TimUtilities.UpdateRecord;
import java.io.PrintStream;

public class LouvainCommunity {
    private static int TEMPCOMMUNITYLABEL = -97531;
    private static int MAXSWEEPS = 5;
    private islandNetwork in;
    private double[] outVector;
    private double[] inVector;
    private double outNormalisation;
    private double inNormalisation;
    private double[][] influenceQ;
    private int[] communityOfSite;
    private int[] numberInCommunity;
    private int numberOfCommunities;
    private Permutation perm;
    private UpdateRecord updateRecord;

    public LouvainCommunity(islandNetwork islandNetwork2) {
        this.in = islandNetwork2;
        this.inVector = new double[this.in.numberSites];
        this.outVector = new double[this.in.numberSites];
        this.communityOfSite = new int[this.in.numberSites];
        this.numberInCommunity = new int[this.in.numberSites];
        for (int i = 0; i < this.in.numberSites; ++i) {
            this.outVector[i] = this.in.siteSet.getWeight(i);
            this.inVector[i] = this.in.siteSet.getStrengthIn(i);
            this.communityOfSite[i] = i;
            this.numberInCommunity[i] = 1;
        }
        this.numberOfCommunities = this.in.numberSites;
        this.inNormalisation = this.normalise(this.inVector);
        this.outNormalisation = this.normalise(this.outVector);
    }

    private double normalise(double[] dArray) {
        int n;
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray[n];
        }
        if (Math.abs(d) > 1.0E-10) {
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = dArray[n] / d;
            }
        }
        return d;
    }

    public void calcCommunity(double d) {
        int n;
        int n2;
        int n3;
        this.in.transferMatrix.calcInfluenceMatrix(d);
        int n4 = this.in.transferMatrix.checkInfluenceSubMarkovian(1.0E-6);
        if (n4 >= 0) {
            System.err.println("!!! Influence is no subMarkovian in column " + n4);
        }
        if ((n3 = this.in.transferMatrix.checkInfluenceNonNegative(1.0E-6)) >= 0) {
            System.err.println("!!! Influence is no subMarkovian in row*dimension+ column " + n3);
        }
        if ((n2 = this.in.transferMatrix.checkDecomposition(0.001)) < 0) {
            System.err.println("*** in calcCommunity, transfer matrix decomposition check failed, result =" + n2);
        }
        this.in.transferMatrix.printEigenValueList("", "   ", System.out, 4, true);
        this.in.transferMatrix.printTransferMatrix("", "   ", System.out, 4, true);
        this.in.transferMatrix.printInfluenceMatrix("", "   ", System.out, 4, true);
        this.influenceQ = new double[this.in.numberSites][this.in.numberSites];
        for (n = 0; n < this.in.numberSites; ++n) {
            for (int i = 0; i < this.in.numberSites; ++i) {
                this.influenceQ[n][i] = this.in.transferMatrix.getInfluence(n, i) * this.outVector[i];
            }
        }
        this.perm = new Permutation(this.in.numberSites);
        this.updateRecord = new UpdateRecord();
        System.out.println("Initial Quality " + this.calcQuality() + ", number of communities " + this.numberOfCommunities);
        for (n = 0; n < MAXSWEEPS; ++n) {
            double d2 = this.oneSweep();
            System.out.println("Quality " + this.calcQuality() + ", number of communities " + this.numberOfCommunities + ", Quality change " + d2 + ", " + this.updateRecord.toString());
            if (this.updateRecord.getMade() == 0) break;
        }
    }

    private double oneSweep() {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        double d2 = 0.0;
        int n3 = -1;
        this.perm.newPermutation();
        int n4 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n5 = -1;
        for (int i = 0; i < this.in.numberSites; ++i) {
            n4 = this.perm.next();
            int n6 = n3 = this.communityOfSite[n4];
            this.numberInCommunity[n6] = this.numberInCommunity[n6] - 1;
            int n7 = this.numberInCommunity[n6];
            if (n7 == 0) {
                --this.numberOfCommunities;
            }
            this.communityOfSite[n4] = TEMPCOMMUNITYLABEL;
            d2 = -this.deltaQuality(n4, n3);
            d4 = -d2;
            n5 = d2 > 0.0 ? this.in.numberSites : TEMPCOMMUNITYLABEL;
            for (int j = 0; j < this.numberInCommunity.length; ++j) {
                if (this.numberInCommunity[j] == 0 || j == n3 || (d3 = this.deltaQuality(n4, j)) < d4) continue;
                n5 = j;
                d4 = d3;
            }
            ++n;
            if (n5 > 0) {
                d += d2;
                if (n5 == this.in.numberSites) {
                    n5 = this.getEmptyCommunity();
                } else {
                    d += d3;
                }
                this.communityOfSite[n4] = n5;
                int n8 = n5;
                this.numberInCommunity[n8] = this.numberInCommunity[n8] + 1;
                if (this.numberInCommunity[n5] == 1) {
                    ++this.numberOfCommunities;
                }
                ++n2;
                continue;
            }
            this.communityOfSite[n4] = n3;
            int n9 = n3;
            this.numberInCommunity[n9] = this.numberInCommunity[n9] + 1;
        }
        this.updateRecord.update(n, n2);
        return d;
    }

    public double deltaQuality(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.in.numberSites; ++i) {
            if (this.communityOfSite[i] != n2 || n == i) continue;
            d += this.influenceQ[n][i] - this.inVector[n] * this.outVector[i];
            d += this.influenceQ[i][n] - this.inVector[i] * this.outVector[n];
        }
        return d;
    }

    public double calcQuality() {
        double d = 0.0;
        for (int i = 0; i < this.in.numberSites; ++i) {
            int n = this.communityOfSite[i];
            for (int j = 0; j < this.in.numberSites; ++j) {
                if (this.communityOfSite[j] != n || i == j) continue;
                d += this.influenceQ[i][j] - this.inVector[i] * this.outVector[j];
            }
        }
        return d;
    }

    private int getEmptyCommunity() {
        for (int i = 0; i < this.numberInCommunity.length; ++i) {
            if (this.numberInCommunity[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public void printCommunities(PrintStream printStream, String string, String string2) {
        int n;
        printStream.println(string + "Number of Communities" + string2 + this.numberOfCommunities);
        int n2 = this.numberOfCommunities;
        printStream.println(string + "Count" + string2 + "Label" + string2 + " Number");
        for (n = 0; n < this.numberInCommunity.length; ++n) {
            if (this.numberInCommunity[n] <= 0) continue;
            printStream.println(string + n2-- + string2 + n + string2 + this.numberInCommunity[n]);
        }
        printStream.println(string + "Site" + string2 + "Label");
        for (n = 0; n < this.in.numberSites; ++n) {
            printStream.println(string + n + string2 + this.communityOfSite[n]);
        }
    }
}

